/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.jdbc.MonetDriver;
import nl.cwi.monetdb.jdbc.MonetWrapper;

public class MonetDatabaseMetaData
extends MonetWrapper
implements DatabaseMetaData {
    private Connection con;
    private String env_current_user;
    private String env_monet_version;
    private String env_max_clients;
    private static final String FunctionsSelect = "SELECT DISTINCT \"name\" FROM \"sys\".\"functions\" ";
    private static final String FunctionsWhere = "WHERE \"id\" IN (SELECT \"func_id\" FROM \"sys\".\"args\" WHERE \"number\" = 1 AND \"name\" = 'arg_1' AND \"type\" IN ";
    private static final String AddFunctionsMaxMin = " UNION SELECT 'sql_max' UNION SELECT 'sql_min'";
    private static final String FunctionsOrderBy1 = " ORDER BY 1";
    private static final String keyQuery = "SELECT cast(null AS char(1)) AS \"PKTABLE_CAT\", \"pkschema\".\"name\" AS \"PKTABLE_SCHEM\", \"pktable\".\"name\" AS \"PKTABLE_NAME\", \"pkkeycol\".\"name\" AS \"PKCOLUMN_NAME\", cast(null AS char(1)) AS \"FKTABLE_CAT\", \"fkschema\".\"name\" AS \"FKTABLE_SCHEM\", \"fktable\".\"name\" AS \"FKTABLE_NAME\", \"fkkeycol\".\"name\" AS \"FKCOLUMN_NAME\", cast(1 + \"pkkeycol\".\"nr\" AS smallint) AS \"KEY_SEQ\", 3 AS \"UPDATE_RULE\", 3 AS \"DELETE_RULE\", \"fkkey\".\"name\" AS \"FK_NAME\", \"pkkey\".\"name\" AS \"PK_NAME\", 7 AS \"DEFERRABILITY\" FROM \"sys\".\"keys\" AS \"fkkey\", \"sys\".\"keys\" AS \"pkkey\", \"sys\".\"objects\" AS \"fkkeycol\", \"sys\".\"objects\" AS \"pkkeycol\", \"sys\".\"tables\" AS \"fktable\", \"sys\".\"tables\" AS \"pktable\", \"sys\".\"schemas\" AS \"fkschema\", \"sys\".\"schemas\" AS \"pkschema\" WHERE \"fktable\".\"id\" = \"fkkey\".\"table_id\" AND \"pktable\".\"id\" = \"pkkey\".\"table_id\" AND \"fkkey\".\"id\" = \"fkkeycol\".\"id\" AND \"pkkey\".\"id\" = \"pkkeycol\".\"id\" AND \"fkschema\".\"id\" = \"fktable\".\"schema_id\" AND \"pkschema\".\"id\" = \"pktable\".\"schema_id\" AND \"fkkey\".\"rkey\" > -1 AND \"fkkey\".\"rkey\" = \"pkkey\".\"id\" AND \"fkkeycol\".\"nr\" = \"pkkeycol\".\"nr\"";

    public MonetDatabaseMetaData(Connection connection) {
        this.con = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void getEnvValues() throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.con.createStatement();
            resultSet = statement.executeQuery("SELECT \"name\", \"value\" FROM \"sys\".\"env\"() WHERE \"name\" IN ('monet_version', 'max_clients') UNION SELECT 'current_user' as \"name\", current_user as \"value\"");
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string = resultSet.getString("name");
                    String string2 = resultSet.getString("value");
                    if ("current_user".equals(string)) {
                        this.env_current_user = string2;
                        continue;
                    }
                    if ("monet_version".equals(string)) {
                        this.env_monet_version = string2;
                        continue;
                    }
                    if (!"max_clients".equals(string)) continue;
                    this.env_max_clients = string2;
                }
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private ResultSet executeMetaDataQuery(String string) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        statement = this.con.createStatement(1004, 1007);
        if (statement != null) {
            resultSet = statement.executeQuery(string);
            if (resultSet != null) {
                statement.closeOnCompletion();
            } else {
                statement.close();
            }
        }
        return resultSet;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return ((MonetConnection)this.con).getJDBCURL();
    }

    @Override
    public String getUserName() throws SQLException {
        if (this.env_current_user == null) {
            this.getEnvValues();
        }
        return this.env_current_user;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public String getDatabaseProductName() {
        return "MonetDB";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        if (this.env_monet_version == null) {
            this.getEnvValues();
        }
        return this.env_monet_version != null ? this.env_monet_version : "";
    }

    @Override
    public String getDriverName() {
        return "MonetDB Native Driver";
    }

    @Override
    public String getDriverVersion() {
        return MonetDriver.getDriverVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return MonetDriver.getDriverMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return MonetDriver.getDriverMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String getSQLKeywords() {
        String string = this.getConcatenatedStringFromQuery("SELECT \"keyword\" FROM \"sys\".\"keywords\" ORDER BY 1");
        return string.isEmpty() ? "ADMIN,AFTER,AGGREGATE,ALWAYS,ASYMMETRIC,ATOMIC,AUTO_INCREMENT,BEFORE,BIGINT,BIGSERIAL,BINARY,BLOB,CALL,CHAIN,CLOB,COMMITTED,COPY,CORR,CUME_DIST,CURRENT_ROLE,CYCLE,DATABASE,DELIMITERS,DENSE_RANK,DO,EACH,ELSEIF,ENCRYPTED,EVERY,EXCLUDE,FOLLOWING,FUNCTION,GENERATED,IF,ILIKE,INCREMENT,LAG,LEAD,LIMIT,LOCALTIME,LOCALTIMESTAMP,LOCKED,MAXVALUE,MEDIAN,MEDIUMINT,MERGE,MINVALUE,NEW,NOCYCLE,NOMAXVALUE,NOMINVALUE,NOW,OFFSET,OLD,OTHERS,OVER,PARTITION,PERCENT_RANK,PLAN,PRECEDING,PROD,QUANTILE,RANGE,RANK,RECORDS,REFERENCING,REMOTE,RENAME,REPEATABLE,REPLICA,RESTART,RETURN,RETURNS,ROW_NUMBER,ROWS,SAMPLE,SAVEPOINT,SCHEMA,SEQUENCE,SERIAL,SERIALIZABLE,SIMPLE,START,STATEMENT,STDIN,STDOUT,STREAM,STRING,SYMMETRIC,TIES,TINYINT,TRIGGER,UNBOUNDED,UNCOMMITTED,UNENCRYPTED,WHILE,XMLAGG,XMLATTRIBUTES,XMLCOMMENT,XMLCONCAT,XMLDOCUMENT,XMLELEMENT,XMLFOREST,XMLNAMESPACES,XMLPARSE,XMLPI,XMLQUERY,XMLSCHEMA,XMLTEXT,XMLVALIDATE" : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getConcatenatedStringFromQuery(String string) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.con.createStatement();
            resultSet = statement.executeQuery(string);
            boolean bl = true;
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                if (string2 == null) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string2);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String getNumericFunctions() {
        String string = "('tinyint', 'smallint', 'int', 'bigint', 'hugeint', 'decimal', 'double', 'real') ) AND \"mod\" <> 'str'";
        return this.getConcatenatedStringFromQuery("SELECT DISTINCT \"name\" FROM \"sys\".\"functions\" WHERE \"id\" IN (SELECT \"func_id\" FROM \"sys\".\"args\" WHERE \"number\" = 1 AND \"name\" = 'arg_1' AND \"type\" IN " + string + AddFunctionsMaxMin + FunctionsOrderBy1);
    }

    @Override
    public String getStringFunctions() {
        String string = "('char', 'varchar', 'clob', 'json') ) OR \"mod\" = 'str'";
        return this.getConcatenatedStringFromQuery("SELECT DISTINCT \"name\" FROM \"sys\".\"functions\" WHERE \"id\" IN (SELECT \"func_id\" FROM \"sys\".\"args\" WHERE \"number\" = 1 AND \"name\" = 'arg_1' AND \"type\" IN " + string + AddFunctionsMaxMin + FunctionsOrderBy1);
    }

    @Override
    public String getSystemFunctions() {
        String string = "WHERE \"id\" NOT IN (SELECT \"func_id\" FROM \"sys\".\"args\" WHERE \"number\" = 1) AND \"id\" IN (SELECT \"function_id\" FROM \"sys\".\"systemfunctions\") AND \"type\" = 1 AND \"mod\" <> 'mtime' AND \"name\" NOT IN ('localtime', 'localtimestamp') UNION SELECT 'cast' UNION SELECT 'convert' UNION SELECT 'coalesce' UNION SELECT 'extract' UNION SELECT 'ifthenelse' UNION SELECT 'isnull' UNION SELECT 'nullif'";
        return this.getConcatenatedStringFromQuery(FunctionsSelect + string + FunctionsOrderBy1);
    }

    @Override
    public String getTimeDateFunctions() {
        String string = "WHERE \"mod\" = 'mtime' OR \"name\" IN ('localtime', 'localtimestamp') UNION SELECT 'extract' UNION SELECT 'now'";
        return this.getConcatenatedStringFromQuery(FunctionsSelect + string + AddFunctionsMaxMin + FunctionsOrderBy1);
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return true;
    }

    @Override
    public boolean supportsConvert(int n, int n2) {
        switch (n) {
            case 16: {
                switch (n2) {
                    case -6: 
                    case -5: 
                    case 1: 
                    case 4: 
                    case 5: 
                    case 12: 
                    case 16: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case 2004: {
                switch (n2) {
                    case 12: 
                    case 2004: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                switch (n2) {
                    case -6: 
                    case -5: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case 1: 
            case 12: 
            case 2005: {
                switch (n2) {
                    case -6: 
                    case -5: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2004: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                switch (n2) {
                    case 1: 
                    case 12: 
                    case 91: 
                    case 93: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case 92: {
                switch (n2) {
                    case 1: 
                    case 12: 
                    case 92: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case 93: {
                switch (n2) {
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return false;
    }

    @Override
    public String getSchemaTerm() {
        return "schema";
    }

    @Override
    public String getProcedureTerm() {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() {
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public String getCatalogSeparator() {
        return null;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0x7FFFFFFE;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0x7FFFFFFE;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 1024;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 100000;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        if (this.env_max_clients == null) {
            this.getEnvValues();
        }
        int n = 16;
        if (this.env_max_clients != null) {
            try {
                n = Integer.parseInt(this.env_max_clients);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 1024;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 256;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    @Override
    public int getMaxStatementLength() {
        return 0x7FFFFFFE;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 1024;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 1024;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 8;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n) {
        return n == 8;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        boolean bl = ((MonetConnection)this.con).commentsTableExists();
        StringBuilder stringBuilder = new StringBuilder(980);
        stringBuilder.append("SELECT cast(null as char(1)) AS \"PROCEDURE_CAT\", \"schemas\".\"name\" AS \"PROCEDURE_SCHEM\", \"functions\".\"name\" AS \"PROCEDURE_NAME\", cast(null as char(1)) AS \"Field4\", cast(null as char(1)) AS \"Field5\", cast(null as char(1)) AS \"Field6\", ").append(bl ? "COALESCE(\"comments\".\"remark\", cast(\"functions\".\"func\" as varchar(9999)))" : "cast(\"functions\".\"func\" as varchar(9999))").append(" AS \"REMARKS\", cast(").append(1).append(" AS smallint) AS \"PROCEDURE_TYPE\", cast(\"functions\".\"id\" as varchar(10)) AS \"SPECIFIC_NAME\" FROM \"sys\".\"functions\" JOIN \"sys\".\"schemas\" ON (\"functions\".\"schema_id\" = \"schemas\".\"id\") ");
        if (bl) {
            stringBuilder.append("LEFT OUTER JOIN \"sys\".\"comments\" ON (\"functions\".\"id\" = \"comments\".\"id\") ");
        }
        stringBuilder.append("WHERE \"functions\".\"type\" = 2");
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1 = 0");
        } else {
            if (string2 != null) {
                stringBuilder.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string2));
            }
            if (string3 != null) {
                stringBuilder.append(" AND \"functions\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string3));
            }
        }
        stringBuilder.append(" ORDER BY \"PROCEDURE_SCHEM\", \"PROCEDURE_NAME\", \"SPECIFIC_NAME\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(2900);
        stringBuilder.append("SELECT cast(null as char(1)) AS \"PROCEDURE_CAT\", \"schemas\".\"name\" AS \"PROCEDURE_SCHEM\", \"functions\".\"name\" AS \"PROCEDURE_NAME\", \"args\".\"name\" AS \"COLUMN_NAME\", cast(CASE \"args\".\"inout\" WHEN 0 THEN (CASE \"args\".\"number\" WHEN 0 THEN ").append(5).append(" ELSE ").append(4).append(" END) WHEN 1 THEN ").append(1).append(" ELSE ").append(0).append(" END AS smallint) AS \"COLUMN_TYPE\", cast(").append(MonetDriver.getSQLTypeMap("\"args\".\"type\"")).append(" AS int) AS \"DATA_TYPE\", \"args\".\"type\" AS \"TYPE_NAME\", CASE \"args\".\"type\" WHEN 'tinyint' THEN 3 WHEN 'smallint' THEN 5 WHEN 'int' THEN 10 WHEN 'bigint' THEN 19 WHEN 'hugeint' THEN 38 WHEN 'oid' THEN 19 WHEN 'wrd' THEN 19 ELSE \"args\".\"type_digits\" END AS \"PRECISION\", CASE \"args\".\"type\" WHEN 'tinyint' THEN 1 WHEN 'smallint' THEN 2 WHEN 'int' THEN 4 WHEN 'bigint' THEN 8 WHEN 'hugeint' THEN 16 WHEN 'oid' THEN 8 WHEN 'wrd' THEN 8 ELSE \"args\".\"type_digits\" END AS \"LENGTH\", cast(CASE WHEN \"args\".\"type\" IN ('tinyint','smallint','int','bigint','hugeint','oid','wrd','decimal','numeric','time','timetz','timestamp','timestamptz','sec_interval') THEN \"args\".\"type_scale\" ELSE NULL END AS smallint) AS \"SCALE\", cast(CASE WHEN \"args\".\"type\" IN ('tinyint','smallint','int','bigint','hugeint','oid','wrd','decimal','numeric') THEN 10 WHEN \"args\".\"type\" IN ('real','float','double') THEN 2 ELSE NULL END AS smallint) AS \"RADIX\", cast(").append(2).append(" AS smallint) AS \"NULLABLE\", cast(null as char(1)) AS \"REMARKS\", cast(null as char(1)) AS \"COLUMN_DEF\", cast(0 as int) AS \"SQL_DATA_TYPE\", cast(0 as int) AS \"SQL_DATETIME_SUB\", cast(CASE WHEN \"args\".\"type\" IN ('char','varchar','clob') THEN \"args\".\"type_digits\" ELSE NULL END as int) AS \"CHAR_OCTET_LENGTH\", cast(\"args\".\"number\" + 1 as int) AS \"ORDINAL_POSITION\", cast('' as varchar(3)) AS \"IS_NULLABLE\", cast(\"functions\".\"id\" as varchar(10)) AS \"SPECIFIC_NAME\" FROM \"sys\".\"args\" JOIN \"sys\".\"functions\" ON (\"args\".\"func_id\" = \"functions\".\"id\") JOIN \"sys\".\"schemas\" ON (\"functions\".\"schema_id\" = \"schemas\".\"id\") WHERE \"functions\".\"type\" = 2");
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1 = 0");
        } else {
            if (string2 != null) {
                stringBuilder.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string2));
            }
            if (string3 != null) {
                stringBuilder.append(" AND \"functions\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string3));
            }
            if (string4 != null) {
                stringBuilder.append(" AND \"args\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string4));
            }
        }
        stringBuilder.append(" ORDER BY \"PROCEDURE_SCHEM\", \"PROCEDURE_NAME\", \"SPECIFIC_NAME\", \"ORDINAL_POSITION\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    private static final String composeMatchPart(String string) {
        if (string == null) {
            return "IS NULL";
        }
        String string2 = "= '";
        if (string.contains("%") || string.contains("_")) {
            string2 = "LIKE '";
        }
        String string3 = string.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'");
        return string2 + string3 + "'";
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        boolean bl = "11.19.15".compareTo(this.getDatabaseProductVersion()) >= 0;
        boolean bl2 = ((MonetConnection)this.con).commentsTableExists();
        StringBuilder stringBuilder = new StringBuilder(1600);
        if (bl && stringArray != null && stringArray.length > 0) {
            stringBuilder.append("SELECT * FROM (");
        }
        stringBuilder.append("SELECT cast(null as char(1)) AS \"TABLE_CAT\", \"schemas\".\"name\" AS \"TABLE_SCHEM\", \"tables\".\"name\" AS \"TABLE_NAME\", ");
        if (bl) {
            stringBuilder.append("CASE WHEN \"tables\".\"system\" = true AND \"tables\".\"type\" IN (0, 10) AND \"tables\".\"temporary\" = 0 THEN 'SYSTEM TABLE' WHEN \"tables\".\"system\" = true AND \"tables\".\"type\" IN (1, 11) AND \"tables\".\"temporary\" = 0 THEN 'SYSTEM VIEW' WHEN \"tables\".\"system\" = false AND \"tables\".\"type\" = 0 AND \"tables\".\"temporary\" = 0 THEN 'TABLE' WHEN \"tables\".\"system\" = false AND \"tables\".\"type\" = 1 AND \"tables\".\"temporary\" = 0 THEN 'VIEW' WHEN \"tables\".\"system\" = true AND \"tables\".\"type\" IN (0, 20) AND \"tables\".\"temporary\" = 1 THEN 'SYSTEM SESSION TABLE' WHEN \"tables\".\"system\" = true AND \"tables\".\"type\" IN (1, 21) AND \"tables\".\"temporary\" = 1 THEN 'SYSTEM SESSION VIEW' WHEN \"tables\".\"system\" = false AND \"tables\".\"type\" IN (0, 30) AND \"tables\".\"temporary\" = 1 THEN 'SESSION TABLE' WHEN \"tables\".\"system\" = false AND \"tables\".\"type\" IN (1, 31) AND \"tables\".\"temporary\" = 1 THEN 'SESSION VIEW' END AS \"TABLE_TYPE\", ");
        } else {
            stringBuilder.append("\"table_types\".\"table_type_name\" AS \"TABLE_TYPE\", ");
        }
        stringBuilder.append(bl2 ? "COALESCE(\"comments\".\"remark\", \"tables\".\"query\")" : "\"tables\".\"query\"").append(" AS \"REMARKS\", cast(null as char(1)) AS \"TYPE_CAT\", cast(null as char(1)) AS \"TYPE_SCHEM\", cast(null as char(1)) AS \"TYPE_NAME\", cast(null as char(1)) AS \"SELF_REFERENCING_COL_NAME\", cast(null as char(1)) AS \"REF_GENERATION\" FROM \"sys\".\"tables\"");
        if (bl2) {
            stringBuilder.append(" LEFT OUTER JOIN \"sys\".\"comments\" ON (\"tables\".\"id\" = \"comments\".\"id\")");
        }
        stringBuilder.append(", \"sys\".\"schemas\"");
        if (!bl) {
            stringBuilder.append(", \"sys\".\"table_types\"");
        }
        stringBuilder.append(" WHERE \"tables\".\"schema_id\" = \"schemas\".\"id\"");
        if (!bl) {
            stringBuilder.append(" AND \"tables\".\"type\" = \"table_types\".\"table_type_id\"");
        }
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1 = 0");
        } else {
            if (string2 != null) {
                stringBuilder.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string2));
            }
            if (string3 != null) {
                stringBuilder.append(" AND \"tables\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string3));
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            if (bl) {
                stringBuilder.append(") AS \"getTables\" WHERE \"TABLE_TYPE\" IN (");
            } else {
                stringBuilder.append(" AND \"table_types\".\"table_type_name\" IN (");
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("'").append(stringArray[i]).append("'");
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(" ORDER BY \"TABLE_TYPE\", \"TABLE_SCHEM\", \"TABLE_NAME\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(170);
        stringBuilder.append("SELECT \"name\" AS \"TABLE_SCHEM\", cast(null as char(1)) AS \"TABLE_CATALOG\" FROM \"sys\".\"schemas\"");
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" WHERE 1 = 0");
        } else if (string2 != null) {
            stringBuilder.append(" WHERE \"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string2));
        }
        stringBuilder.append(" ORDER BY \"TABLE_SCHEM\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.executeMetaDataQuery("SELECT cast(null as char(1)) AS \"TABLE_CAT\" WHERE 1 = 0");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        boolean bl;
        String string = "SELECT \"table_type_name\" AS \"TABLE_TYPE\" FROM \"sys\".\"table_types\" ORDER BY 1";
        boolean bl2 = bl = "11.19.15".compareTo(this.getDatabaseProductVersion()) >= 0;
        if (bl) {
            string = "SELECT 'SESSION TABLE' AS \"TABLE_TYPE\" UNION ALL SELECT 'SESSION VIEW' UNION ALL SELECT 'SYSTEM SESSION TABLE' UNION ALL SELECT 'SYSTEM SESSION VIEW' UNION ALL SELECT 'SYSTEM TABLE' UNION ALL SELECT 'SYSTEM VIEW' UNION ALL SELECT 'TABLE' UNION ALL SELECT 'VIEW' ORDER BY 1";
        }
        return this.executeMetaDataQuery(string);
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        boolean bl = ((MonetConnection)this.con).commentsTableExists();
        StringBuilder stringBuilder = new StringBuilder(2450);
        stringBuilder.append("SELECT cast(null as char(1)) AS \"TABLE_CAT\", \"schemas\".\"name\" AS \"TABLE_SCHEM\", \"tables\".\"name\" AS \"TABLE_NAME\", \"columns\".\"name\" AS \"COLUMN_NAME\", cast(").append(MonetDriver.getSQLTypeMap("\"columns\".\"type\"")).append(" AS int) AS \"DATA_TYPE\", \"columns\".\"type\" AS \"TYPE_NAME\", \"columns\".\"type_digits\" AS \"COLUMN_SIZE\", 0 AS \"BUFFER_LENGTH\", \"columns\".\"type_scale\" AS \"DECIMAL_DIGITS\", cast(CASE WHEN \"columns\".\"type\" IN ('decimal', 'numeric', 'sec_interval') THEN 10 WHEN \"columns\".\"type\" IN ('int', 'smallint', 'tinyint', 'bigint', 'hugeint', 'float', 'real', 'double', 'oid', 'wrd') THEN 2 ELSE 0 END AS int) AS \"NUM_PREC_RADIX\", cast(CASE \"null\" WHEN true THEN ").append(1).append(" WHEN false THEN ").append(0).append(" END AS int) AS \"NULLABLE\", ").append(bl ? "\"comments\".\"remark\"" : "cast(null AS varchar(9999))").append(" AS \"REMARKS\", \"columns\".\"default\" AS \"COLUMN_DEF\", cast(0 as int) AS \"SQL_DATA_TYPE\", cast(0 as int) AS \"SQL_DATETIME_SUB\", cast(CASE WHEN \"columns\".\"type\" IN ('char','varchar','clob') THEN \"columns\".\"type_digits\" ELSE NULL END as int) AS \"CHAR_OCTET_LENGTH\", cast(\"columns\".\"number\" + 1 as int) AS \"ORDINAL_POSITION\", cast(CASE \"null\" WHEN true THEN 'YES' WHEN false THEN 'NO' ELSE '' END AS varchar(3)) AS \"IS_NULLABLE\", cast(null AS char(1)) AS \"SCOPE_CATALOG\", cast(null AS char(1)) AS \"SCOPE_SCHEMA\", cast(null AS char(1)) AS \"SCOPE_TABLE\", cast(null AS smallint) AS \"SOURCE_DATA_TYPE\", cast(CASE WHEN \"columns\".\"default\" IS NOT NULL AND \"columns\".\"default\" LIKE 'next value for %' THEN 'YES' ELSE 'NO' END AS varchar(3)) AS \"IS_AUTOINCREMENT\", cast('NO' AS varchar(3)) AS \"IS_GENERATEDCOLUMN\" FROM \"sys\".\"columns\"");
        if (bl) {
            stringBuilder.append(" LEFT OUTER JOIN \"sys\".\"comments\" ON (\"columns\".\"id\" = \"comments\".\"id\")");
        }
        stringBuilder.append(", \"sys\".\"tables\", \"sys\".\"schemas\" WHERE \"columns\".\"table_id\" = \"tables\".\"id\"  AND \"tables\".\"schema_id\" = \"schemas\".\"id\"");
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1 = 0");
        } else {
            if (string2 != null) {
                stringBuilder.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string2));
            }
            if (string3 != null) {
                stringBuilder.append(" AND \"tables\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string3));
            }
            if (string4 != null) {
                stringBuilder.append(" AND \"columns\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string4));
            }
        }
        stringBuilder.append(" ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"ORDINAL_POSITION\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        boolean bl = ((MonetConnection)this.con).privilege_codesTableExists();
        StringBuilder stringBuilder = new StringBuilder(1100);
        stringBuilder.append("SELECT cast(null as char(1)) AS \"TABLE_CAT\", \"schemas\".\"name\" AS \"TABLE_SCHEM\", \"tables\".\"name\" AS \"TABLE_NAME\", \"columns\".\"name\" AS \"COLUMN_NAME\", \"grantors\".\"name\" AS \"GRANTOR\", \"grantees\".\"name\" AS \"GRANTEE\", ").append(bl ? "\"privilege_codes\".\"privilege_code_name\"" : "cast(CASE \"privileges\".\"privileges\" WHEN 1 THEN 'SELECT' WHEN 2 THEN 'UPDATE' WHEN 4 THEN 'INSERT' WHEN 8 THEN 'DELETE' WHEN 16 THEN 'EXECUTE' WHEN 32 THEN 'GRANT' ELSE NULL END AS varchar(7))").append(" AS \"PRIVILEGE\", cast(CASE \"privileges\".\"grantable\" WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END AS varchar(3)) AS \"IS_GRANTABLE\" FROM \"sys\".\"privileges\", \"sys\".\"tables\", \"sys\".\"schemas\", \"sys\".\"columns\", \"sys\".\"auths\" AS \"grantors\", \"sys\".\"auths\" AS \"grantees\" ");
        if (bl) {
            stringBuilder.append(", \"sys\".\"privilege_codes\" ");
        }
        stringBuilder.append("WHERE \"privileges\".\"obj_id\" = \"columns\".\"id\" AND \"columns\".\"table_id\" = \"tables\".\"id\" AND \"tables\".\"schema_id\" = \"schemas\".\"id\" AND \"privileges\".\"auth_id\" = \"grantees\".\"id\" AND \"privileges\".\"grantor\" = \"grantors\".\"id\"");
        if (bl) {
            stringBuilder.append(" AND \"privileges\".\"privileges\" = \"privilege_codes\".\"privilege_code_id\"");
        }
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1 = 0");
        } else {
            if (string2 != null) {
                stringBuilder.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string2));
            }
            if (string3 != null) {
                stringBuilder.append(" AND \"tables\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string3));
            }
            if (string4 != null) {
                stringBuilder.append(" AND \"columns\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string4));
            }
        }
        stringBuilder.append(" ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"COLUMN_NAME\", \"PRIVILEGE\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        boolean bl = ((MonetConnection)this.con).privilege_codesTableExists();
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append("SELECT cast(null as char(1)) AS \"TABLE_CAT\", \"schemas\".\"name\" AS \"TABLE_SCHEM\", \"tables\".\"name\" AS \"TABLE_NAME\", \"grantors\".\"name\" AS \"GRANTOR\", \"grantees\".\"name\" AS \"GRANTEE\", ").append(bl ? "\"privilege_codes\".\"privilege_code_name\"" : "cast(CASE \"privileges\".\"privileges\" WHEN 1 THEN 'SELECT' WHEN 2 THEN 'UPDATE' WHEN 4 THEN 'INSERT' WHEN 8 THEN 'DELETE' WHEN 16 THEN 'EXECUTE' WHEN 32 THEN 'GRANT' ELSE NULL END AS varchar(7))").append(" AS \"PRIVILEGE\", cast(CASE \"privileges\".\"grantable\" WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END AS varchar(3)) AS \"IS_GRANTABLE\" FROM \"sys\".\"privileges\", \"sys\".\"tables\", \"sys\".\"schemas\", \"sys\".\"auths\" AS \"grantors\", \"sys\".\"auths\" AS \"grantees\" ");
        if (bl) {
            stringBuilder.append(", \"sys\".\"privilege_codes\" ");
        }
        stringBuilder.append("WHERE \"privileges\".\"obj_id\" = \"tables\".\"id\" AND \"tables\".\"schema_id\" = \"schemas\".\"id\" AND \"privileges\".\"auth_id\" = \"grantees\".\"id\" AND \"privileges\".\"grantor\" = \"grantors\".\"id\"");
        if (bl) {
            stringBuilder.append(" AND \"privileges\".\"privileges\" = \"privilege_codes\".\"privilege_code_id\"");
        }
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1 = 0");
        } else {
            if (string2 != null) {
                stringBuilder.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string2));
            }
            if (string3 != null) {
                stringBuilder.append(" AND \"tables\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string3));
            }
        }
        stringBuilder.append(" ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"PRIVILEGE\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(1500);
        stringBuilder.append("SELECT cast(").append(2).append(" AS smallint) AS \"SCOPE\", \"columns\".\"name\" AS \"COLUMN_NAME\", cast(").append(MonetDriver.getSQLTypeMap("\"columns\".\"type\"")).append(" AS int) AS \"DATA_TYPE\", \"columns\".\"type\" AS \"TYPE_NAME\", \"columns\".\"type_digits\" AS \"COLUMN_SIZE\", cast(0 as int) AS \"BUFFER_LENGTH\", cast(\"columns\".\"type_scale\" AS smallint) AS \"DECIMAL_DIGITS\", cast(").append(1).append(" AS smallint) AS \"PSEUDO_COLUMN\" FROM \"sys\".\"keys\", \"sys\".\"objects\", \"sys\".\"columns\", \"sys\".\"tables\", \"sys\".\"schemas\" WHERE \"keys\".\"id\" = \"objects\".\"id\" AND \"keys\".\"table_id\" = \"tables\".\"id\" AND \"keys\".\"table_id\" = \"columns\".\"table_id\" AND \"objects\".\"name\" = \"columns\".\"name\" AND \"tables\".\"schema_id\" = \"schemas\".\"id\" AND \"keys\".\"type\" IN (0, 1)");
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1 = 0");
        } else if (n != 2 && n != 1 && n != 0) {
            stringBuilder.append(" AND 1 = 0");
        } else {
            if (string2 != null) {
                stringBuilder.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string2));
            }
            if (string3 != null) {
                stringBuilder.append(" AND \"tables\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string3));
            }
            if (!bl) {
                stringBuilder.append(" AND \"columns\".\"null\" = false");
            }
        }
        stringBuilder.append(" ORDER BY \"keys\".\"type\", \"columns\".\"name\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        String string4 = "SELECT cast(0 as smallint) AS \"SCOPE\", cast(null as char(1)) AS \"COLUMN_NAME\", cast(0 as int) AS \"DATA_TYPE\", cast(null as char(1)) AS \"TYPE_NAME\", cast(0 as int) AS \"COLUMN_SIZE\", cast(0 as int) AS \"BUFFER_LENGTH\", cast(0 as smallint) AS \"DECIMAL_DIGITS\", cast(0 as smallint) AS \"PSEUDO_COLUMN\" WHERE 1 = 0";
        return this.executeMetaDataQuery(string4);
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(600);
        stringBuilder.append("SELECT cast(null AS char(1)) AS \"TABLE_CAT\", \"schemas\".\"name\" AS \"TABLE_SCHEM\", \"tables\".\"name\" AS \"TABLE_NAME\", \"objects\".\"name\" AS \"COLUMN_NAME\", cast(1 + \"objects\".\"nr\" AS smallint) AS \"KEY_SEQ\",  \"keys\".\"name\" AS \"PK_NAME\" FROM \"sys\".\"keys\", \"sys\".\"objects\", \"sys\".\"tables\", \"sys\".\"schemas\" WHERE \"keys\".\"id\" = \"objects\".\"id\" AND \"keys\".\"table_id\" = \"tables\".\"id\" AND \"tables\".\"schema_id\" = \"schemas\".\"id\" AND \"keys\".\"type\" = 0");
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1 = 0");
        } else {
            if (string2 != null) {
                stringBuilder.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string2));
            }
            if (string3 != null) {
                stringBuilder.append(" AND \"tables\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string3));
            }
        }
        stringBuilder.append(" ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"COLUMN_NAME\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(keyQuery.length() + 250);
        stringBuilder.append(keyQuery);
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1 = 0");
        } else {
            if (string2 != null) {
                stringBuilder.append(" AND \"fkschema\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string2));
            }
            if (string3 != null) {
                stringBuilder.append(" AND \"fktable\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string3));
            }
        }
        stringBuilder.append(" ORDER BY \"PKTABLE_SCHEM\", \"PKTABLE_NAME\", \"PK_NAME\", \"KEY_SEQ\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(keyQuery.length() + 250);
        stringBuilder.append(keyQuery);
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1 = 0");
        } else {
            if (string2 != null) {
                stringBuilder.append(" AND \"pkschema\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string2));
            }
            if (string3 != null) {
                stringBuilder.append(" AND \"pktable\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string3));
            }
        }
        stringBuilder.append(" ORDER BY \"FKTABLE_SCHEM\", \"FKTABLE_NAME\", \"FK_NAME\", \"KEY_SEQ\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(keyQuery.length() + 350);
        stringBuilder.append(keyQuery);
        if (string != null && !string.isEmpty() || string4 != null && !string4.isEmpty()) {
            stringBuilder.append(" AND 1 = 0");
        } else {
            if (string2 != null) {
                stringBuilder.append(" AND \"pkschema\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string2));
            }
            if (string3 != null) {
                stringBuilder.append(" AND \"pktable\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string3));
            }
            if (string5 != null) {
                stringBuilder.append(" AND \"fkschema\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string5));
            }
            if (string6 != null) {
                stringBuilder.append(" AND \"fktable\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string6));
            }
        }
        stringBuilder.append(" ORDER BY \"FKTABLE_SCHEM\", \"FKTABLE_NAME\", \"FK_NAME\", \"KEY_SEQ\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(2300);
        stringBuilder.append("SELECT \"sqlname\" AS \"TYPE_NAME\", cast(").append(MonetDriver.getSQLTypeMap("\"sqlname\"")).append(" AS int) AS \"DATA_TYPE\", \"digits\" AS \"PRECISION\", cast(CASE WHEN \"systemname\" IN ('str', 'inet', 'json', 'url', 'uuid') THEN '''' ELSE NULL END AS varchar(2)) AS \"LITERAL_PREFIX\", cast(CASE WHEN \"systemname\" IN ('str', 'inet', 'json', 'url', 'uuid') THEN '''' ELSE NULL END AS varchar(2)) AS \"LITERAL_SUFFIX\", CASE WHEN \"sqlname\" IN ('char', 'varchar') THEN 'max length' WHEN \"sqlname\" = 'decimal' THEN 'precision, scale' WHEN \"sqlname\" IN ('time', 'timetz', 'timestamp', 'timestamptz', 'sec_interval') THEN 'precision' ELSE NULL END AS \"CREATE_PARAMS\", cast(CASE WHEN \"systemname\" = 'oid' THEN ").append(0).append(" ELSE ").append(1).append(" END AS smallint) AS \"NULLABLE\", CASE WHEN \"systemname\" IN ('str', 'json', 'url') THEN true ELSE false END AS \"CASE_SENSITIVE\", cast(CASE \"systemname\" WHEN 'table' THEN ").append(0).append(" WHEN 'str' THEN ").append(1).append(" WHEN 'sqlblob' THEN ").append(1).append(" ELSE ").append(2).append(" END AS smallint) AS \"SEARCHABLE\", CASE WHEN \"sqlname\" IN ('tinyint','smallint','int','bigint','hugeint','decimal','real','double','sec_interval','month_interval') THEN false ELSE true END AS \"UNSIGNED_ATTRIBUTE\", CASE \"sqlname\" WHEN 'decimal' THEN true ELSE false END AS \"FIXED_PREC_SCALE\", CASE WHEN \"sqlname\" IN ('tinyint','smallint','int','bigint','hugeint','decimal','oid','wrd') THEN true ELSE false END AS \"AUTO_INCREMENT\", \"systemname\" AS \"LOCAL_TYPE_NAME\", cast(0 AS smallint) AS \"MINIMUM_SCALE\", cast(CASE WHEN \"sqlname\" = 'decimal' THEN (CASE \"systemname\" WHEN 'lng' THEN 18 WHEN 'hge' THEN 38 WHEN 'int' THEN 9 WHEN 'sht' THEN 4 WHEN 'bte' THEN 2 ELSE 0 END) WHEN \"sqlname\" IN ('time', 'timetz', 'timestamp', 'timestamptz', 'sec_interval') THEN 6 ELSE 0 END AS smallint) AS \"MAXIMUM_SCALE\", cast(0 AS int) AS \"SQL_DATA_TYPE\", cast(0 AS int) AS \"SQL_DATETIME_SUB\", cast(\"radix\" as int) AS \"NUM_PREC_RADIX\" FROM \"sys\".\"types\" ORDER BY \"DATA_TYPE\", \"sqlname\", \"id\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        Object object;
        String string4 = "0";
        if (!(bl2 || string2 == null || string3 == null || string2.isEmpty() || string3.isEmpty())) {
            object = null;
            try {
                String string5;
                object = this.executeMetaDataQuery("SELECT COUNT(*) FROM \"" + string2 + "\".\"" + string3 + "\"");
                if (object != null && object.next() && (string5 = object.getString(1)) != null && !string5.isEmpty()) {
                    string4 = string5;
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        object = new StringBuilder(1250);
        ((StringBuilder)object).append("SELECT cast(null AS char(1)) AS \"TABLE_CAT\", \"schemas\".\"name\" AS \"TABLE_SCHEM\", \"tables\".\"name\" AS \"TABLE_NAME\", CASE WHEN \"keys\".\"name\" IS NULL THEN true ELSE false END AS \"NON_UNIQUE\", cast(null AS char(1)) AS \"INDEX_QUALIFIER\", \"idxs\".\"name\" AS \"INDEX_NAME\", CASE \"idxs\".\"type\" WHEN 0 THEN ").append(2).append(" ELSE ").append(3).append(" END AS \"TYPE\", cast(\"objects\".\"nr\" +1 AS smallint) AS \"ORDINAL_POSITION\", \"columns\".\"name\" AS \"COLUMN_NAME\", cast(null AS char(1)) AS \"ASC_OR_DESC\", cast(").append(string4).append(" AS int) AS \"CARDINALITY\", cast(0 AS int) AS \"PAGES\", cast(null AS char(1)) AS \"FILTER_CONDITION\" FROM \"sys\".\"idxs\" LEFT JOIN \"sys\".\"keys\" ON \"idxs\".\"name\" = \"keys\".\"name\", \"sys\".\"schemas\", \"sys\".\"objects\", \"sys\".\"columns\", \"sys\".\"tables\" WHERE \"idxs\".\"table_id\" = \"tables\".\"id\" AND \"tables\".\"schema_id\" = \"schemas\".\"id\" AND \"idxs\".\"id\" = \"objects\".\"id\" AND \"tables\".\"id\" = \"columns\".\"table_id\" AND \"objects\".\"name\" = \"columns\".\"name\" AND (\"keys\".\"type\" IS NULL OR \"keys\".\"type\" = 1)");
        if (string != null && !string.isEmpty()) {
            ((StringBuilder)object).append(" AND 1 = 0");
        } else {
            if (string2 != null) {
                ((StringBuilder)object).append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string2));
            }
            if (string3 != null) {
                ((StringBuilder)object).append(" AND \"tables\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string3));
            }
            if (bl) {
                ((StringBuilder)object).append(" AND \"keys\".\"name\" IS NOT NULL");
            }
        }
        ((StringBuilder)object).append(" ORDER BY \"NON_UNIQUE\", \"TYPE\", \"INDEX_NAME\", \"ORDINAL_POSITION\"");
        return this.executeMetaDataQuery(((StringBuilder)object).toString());
    }

    @Override
    public boolean supportsResultSetType(int n) throws SQLException {
        return n != 1005;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        if (n == 1005) {
            return false;
        }
        return n2 == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int n) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int n) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int n) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int n) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int n) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int n) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int n) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(990);
        if (nArray != null && nArray.length > 0) {
            stringBuilder.append("SELECT * FROM (");
        }
        stringBuilder.append("SELECT cast(null as char(1)) AS \"TYPE_CAT\", \"schemas\".\"name\" AS \"TYPE_SCHEM\", \"types\".\"sqlname\" AS \"TYPE_NAME\", CASE \"types\".\"sqlname\" WHEN 'inet' THEN 'nl.cwi.monetdb.jdbc.types.INET' WHEN 'json' THEN 'java.lang.String' WHEN 'url'  THEN 'nl.cwi.monetdb.jdbc.types.URL' WHEN 'uuid' THEN 'java.lang.String' ELSE 'java.lang.Object' END AS \"CLASS_NAME\", cast(CASE WHEN \"types\".\"sqlname\" IN ('inet', 'json', 'url', 'uuid') THEN ").append(2000).append(" ELSE ").append(2002).append(" END AS int) AS \"DATA_TYPE\", \"types\".\"systemname\" AS \"REMARKS\", cast(null as smallint) AS \"BASE_TYPE\" FROM \"sys\".\"types\" JOIN \"sys\".\"schemas\" ON \"types\".\"schema_id\" = \"schemas\".\"id\" WHERE \"types\".\"id\" > 99 AND \"types\".\"eclass\" >= 15");
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1 = 0");
        } else {
            if (string2 != null) {
                stringBuilder.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string2));
            }
            if (string3 != null) {
                stringBuilder.append(" AND \"types\".\"sqlname\" ").append(MonetDatabaseMetaData.composeMatchPart(string3));
            }
        }
        if (nArray != null && nArray.length > 0) {
            stringBuilder.append(") AS getUDTs WHERE \"DATA_TYPE\" IN (");
            for (int i = 0; i < nArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(nArray[i]);
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(" ORDER BY \"DATA_TYPE\", \"TYPE_SCHEM\", \"TYPE_NAME\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public Connection getConnection() {
        return this.con;
    }

    public boolean rowChangesAreDetected(int n) {
        return false;
    }

    public boolean rowChangesAreVisible(int n) {
        return false;
    }

    @Override
    public boolean supportsSavepoints() {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        String string4 = "SELECT cast(null as char(1)) AS \"TYPE_CAT\", '' AS \"TYPE_SCHEM\", '' AS \"TYPE_NAME\", cast(null as char(1)) AS \"SUPERTYPE_CAT\", '' AS \"SUPERTYPE_SCHEM\", '' AS \"SUPERTYPE_NAME\" WHERE 1 = 0";
        return this.executeMetaDataQuery(string4);
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        String string4 = "SELECT cast(null as char(1)) AS \"TABLE_CAT\", '' AS \"TABLE_SCHEM\", '' AS \"TABLE_NAME\", '' AS \"SUPERTABLE_NAME\" WHERE 1 = 0";
        return this.executeMetaDataQuery(string4);
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = "SELECT cast(null as char(1)) AS \"TYPE_CAT\", '' AS \"TYPE_SCHEM\", '' AS \"TYPE_NAME\", '' AS \"ATTR_NAME\", cast(0 as int) AS \"DATA_TYPE\", '' AS \"ATTR_TYPE_NAME\", cast(0 as int) AS \"ATTR_SIZE\", cast(0 as int) AS \"DECIMAL_DIGITS\", cast(0 as int) AS \"NUM_PREC_RADIX\", cast(0 as int) AS \"NULLABLE\", '' AS \"REMARKS\", '' AS \"ATTR_DEF\", cast(0 as int) AS \"SQL_DATA_TYPE\", cast(0 as int) AS \"SQL_DATETIME_SUB\", cast(0 as int) AS \"CHAR_OCTET_LENGTH\", cast(0 as int) AS \"ORDINAL_POSITION\", 'YES' AS \"IS_NULLABLE\", '' AS \"SCOPE_CATALOG\", '' AS \"SCOPE_SCHEMA\", '' AS \"SCOPE_TABLE\", cast(0 as smallint) AS \"SOURCE_DATA_TYPE\" WHERE 1 = 0";
        return this.executeMetaDataQuery(string5);
    }

    @Override
    public boolean supportsResultSetHoldability(int n) {
        return n == 1;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        if (this.env_monet_version == null) {
            this.getEnvValues();
        }
        int n = 0;
        if (this.env_monet_version != null) {
            try {
                int n2 = this.env_monet_version.indexOf(46);
                n = Integer.parseInt(n2 >= 0 ? this.env_monet_version.substring(0, n2) : this.env_monet_version);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        if (this.env_monet_version == null) {
            this.getEnvValues();
        }
        int n = 0;
        if (this.env_monet_version != null) {
            try {
                int n2 = this.env_monet_version.indexOf(46);
                if (n2 >= 0) {
                    int n3;
                    n = Integer.parseInt((n3 = this.env_monet_version.indexOf(46, ++n2)) > 0 ? this.env_monet_version.substring(n2, n3) : this.env_monet_version.substring(n2));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 1;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        String string = "SELECT 'host' AS \"NAME\", cast(1024 as int) AS \"MAX_LEN\", 'localhost' AS \"DEFAULT_VALUE\", 'DSN or IP-address of machine running MonetDB' AS \"DESCRIPTION\" UNION ALL SELECT 'port', 5, '50000', 'communication port number of MonetDB server process' UNION ALL SELECT 'user', 1024, '', 'user name to login to MonetDB server' UNION ALL SELECT 'password', 128, '', 'password for user name to login to MonetDB server' UNION ALL SELECT 'language', 16, 'sql', 'language (sql or mal) used to parse commands in MonetDB server' UNION ALL SELECT 'database', 1024, 'demo', 'name of database. It matches the dbfarm subdirectory name' UNION ALL SELECT 'debug', 5, 'false', 'boolean flag true or false' UNION ALL SELECT 'logfile', 1024, 'monet_######.log', 'name of logfile used when debug is enabled' UNION ALL SELECT 'hash', 128, '', 'hash methods list to use in server connection. Supported are SHA512, SHA384, SHA256, SHA1 and MD5' UNION ALL SELECT 'treat_blob_as_binary', 5, 'false', 'should blob columns be mapped to Types.VARBINARY instead of default Types.BLOB in ResultSets and PreparedStatements' UNION ALL SELECT 'treat_clob_as_varchar', 5, 'false', 'should clob columns be mapped to Types.VARCHAR instead of default Types.CLOB in ResultSets and PreparedStatements' UNION ALL SELECT 'so_timeout', 10, '0', 'timeout (in milliseconds) of communication socket. 0 means no timeout is set' ORDER BY \"NAME\"";
        return this.executeMetaDataQuery(string);
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        boolean bl = ((MonetConnection)this.con).commentsTableExists();
        StringBuilder stringBuilder = new StringBuilder(800);
        stringBuilder.append("SELECT cast(null as char(1)) AS \"FUNCTION_CAT\", \"schemas\".\"name\" AS \"FUNCTION_SCHEM\", \"functions\".\"name\" AS \"FUNCTION_NAME\", ").append(bl ? "COALESCE(\"comments\".\"remark\", cast(\"functions\".\"func\" as varchar(9999)))" : "cast(\"functions\".\"func\" as varchar(9999))").append(" AS \"REMARKS\", CASE \"functions\".\"type\" WHEN 1 THEN ").append(1).append(" WHEN 2 THEN ").append(1).append(" WHEN 3 THEN ").append(1).append(" WHEN 4 THEN ").append(1).append(" WHEN 5 THEN ").append(2).append(" WHEN 6 THEN ").append(1).append(" WHEN 7 THEN ").append(2).append(" ELSE ").append(0).append(" END AS \"FUNCTION_TYPE\", cast(\"functions\".\"id\" as varchar(10)) AS \"SPECIFIC_NAME\" FROM \"sys\".\"functions\" JOIN \"sys\".\"schemas\" ON (\"functions\".\"schema_id\" = \"schemas\".\"id\") ");
        if (bl) {
            stringBuilder.append("LEFT OUTER JOIN \"sys\".\"comments\" ON (\"functions\".\"id\" = \"comments\".\"id\") ");
        }
        stringBuilder.append("WHERE \"functions\".\"type\" <> 2");
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1 = 0");
        } else {
            if (string2 != null) {
                stringBuilder.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string2));
            }
            if (string3 != null) {
                stringBuilder.append(" AND \"functions\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string3));
            }
        }
        stringBuilder.append(" ORDER BY \"FUNCTION_SCHEM\", \"FUNCTION_NAME\", \"SPECIFIC_NAME\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(2600);
        stringBuilder.append("SELECT cast(null as char(1)) AS \"FUNCTION_CAT\", \"schemas\".\"name\" AS \"FUNCTION_SCHEM\", \"functions\".\"name\" AS \"FUNCTION_NAME\", \"args\".\"name\" AS \"COLUMN_NAME\", cast(CASE \"args\".\"inout\" WHEN 0 THEN (CASE \"args\".\"number\" WHEN 0 THEN ").append(4).append(" ELSE ").append(3).append(" END) WHEN 1 THEN ").append(1).append(" ELSE ").append(0).append(" END AS smallint) AS \"COLUMN_TYPE\", cast(").append(MonetDriver.getSQLTypeMap("\"args\".\"type\"")).append(" AS int) AS \"DATA_TYPE\", \"args\".\"type\" AS \"TYPE_NAME\", CASE \"args\".\"type\" WHEN 'tinyint' THEN 3 WHEN 'smallint' THEN 5 WHEN 'int' THEN 10 WHEN 'bigint' THEN 19 WHEN 'hugeint' THEN 38 WHEN 'oid' THEN 19 WHEN 'wrd' THEN 19 ELSE \"args\".\"type_digits\" END AS \"PRECISION\", CASE \"args\".\"type\" WHEN 'tinyint' THEN 1 WHEN 'smallint' THEN 2 WHEN 'int' THEN 4 WHEN 'bigint' THEN 8 WHEN 'hugeint' THEN 16 WHEN 'oid' THEN 8 WHEN 'wrd' THEN 8 ELSE \"args\".\"type_digits\" END AS \"LENGTH\", cast(CASE WHEN \"args\".\"type\" IN ('tinyint','smallint','int','bigint','hugeint','oid','wrd','decimal','numeric','time','timetz','timestamp','timestamptz','sec_interval') THEN \"args\".\"type_scale\" ELSE NULL END AS smallint) AS \"SCALE\", cast(CASE WHEN \"args\".\"type\" IN ('tinyint','smallint','int','bigint','hugeint','oid','wrd','decimal','numeric') THEN 10 WHEN \"args\".\"type\" IN ('real','float','double') THEN 2 ELSE NULL END AS smallint) AS \"RADIX\", cast(").append(2).append(" AS smallint) AS \"NULLABLE\", cast(null as char(1)) AS \"REMARKS\", cast(CASE WHEN \"args\".\"type\" IN ('char','varchar','clob') THEN \"args\".\"type_digits\" ELSE NULL END as int) AS \"CHAR_OCTET_LENGTH\", cast(\"args\".\"number\" as int) AS \"ORDINAL_POSITION\", cast('' as varchar(3)) AS \"IS_NULLABLE\", cast(\"functions\".\"id\" as varchar(10)) AS \"SPECIFIC_NAME\" FROM \"sys\".\"args\" JOIN \"sys\".\"functions\" ON (\"args\".\"func_id\" = \"functions\".\"id\") JOIN \"sys\".\"schemas\" ON (\"functions\".\"schema_id\" = \"schemas\".\"id\") WHERE \"functions\".\"type\" <> 2");
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1 = 0");
        } else {
            if (string2 != null) {
                stringBuilder.append(" AND \"schemas\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string2));
            }
            if (string3 != null) {
                stringBuilder.append(" AND \"functions\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string3));
            }
            if (string4 != null) {
                stringBuilder.append(" AND \"args\".\"name\" ").append(MonetDatabaseMetaData.composeMatchPart(string4));
            }
        }
        stringBuilder.append(" ORDER BY \"FUNCTION_SCHEM\", \"FUNCTION_NAME\", \"SPECIFIC_NAME\", \"ORDINAL_POSITION\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = "SELECT cast(null as char(1)) AS \"TABLE_CAT\", '' AS \"TABLE_SCHEM\", '' AS \"TABLE_NAME\", '' AS \"COLUMN_NAME\", cast(0 as int) AS \"DATA_TYPE\", cast(0 as int) AS \"COLUMN_SIZE\", cast(0 as int) AS \"DECIMAL_DIGITS\", cast(0 as int) AS \"NUM_PREC_RADIX\", '' AS \"COLUMN_USAGE\", '' AS \"REMARKS\", cast(0 as int) AS \"CHAR_OCTET_LENGTH\", '' AS \"IS_NULLABLE\" WHERE 1 = 0";
        return this.executeMetaDataQuery(string5);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return true;
    }
}

