/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import nl.cwi.monetdb.jdbc.MonetConnection;

public final class MonetDriver
implements Driver {
    static final String MONETURL = "jdbc:monetdb://";
    private static final int DRIVERMAJOR = 2;
    private static final int DRIVERMINOR = 28;
    private static final String DRIVERVERSIONSUFFIX = "Liberica 20180524 based on MCL v1.17";
    private static final boolean MONETJDBCCOMPLIANT = false;
    private static final String PORT = "50000";
    private static Map<String, Integer> typeMap;
    private static String TypeMapppingSQL;

    @Override
    public boolean acceptsURL(String string) {
        return string != null && string.startsWith(MONETURL);
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        String string2;
        String string3;
        URI uRI;
        if (!this.acceptsURL(string)) {
            throw new SQLNonTransientConnectionException("Invalid URL: it does not start with: jdbc:monetdb://", "08M26");
        }
        Properties properties2 = new Properties();
        properties2.put("port", PORT);
        properties2.put("debug", "false");
        properties2.put("language", "sql");
        properties2.put("so_timeout", "0");
        if (properties != null) {
            properties2.putAll((Map<?, ?>)properties);
        }
        properties = properties2;
        try {
            uRI = new URI(string.substring(5));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SQLNonTransientConnectionException(uRISyntaxException.toString(), "08M26");
        }
        String string4 = uRI.getHost();
        if (string4 == null) {
            throw new SQLNonTransientConnectionException("Invalid URL: no hostname given or unparsable in '" + string + "'", "08M26");
        }
        properties.put("host", string4);
        int n = uRI.getPort();
        if (n > 0) {
            properties.put("port", Integer.toString(n));
        }
        if ((string3 = uRI.getPath()) != null && !string3.isEmpty() && !(string3 = string3.substring(1).trim()).isEmpty()) {
            properties.put("database", string3);
        }
        if ((string2 = uRI.getQuery()) != null) {
            String[] stringArray = string2.split("&");
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = stringArray[i].indexOf(61);
                if (n2 <= 0) continue;
                properties.put(stringArray[i].substring(0, n2), stringArray[i].substring(n2 + 1));
            }
        }
        return new MonetConnection(properties);
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 28;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        if (!this.acceptsURL(string)) {
            return null;
        }
        String[] stringArray = new String[]{"true", "false"};
        String[] stringArray2 = new String[]{"sql", "mal"};
        String[] stringArray3 = new String[]{"SHA512", "SHA384", "SHA256", "SHA1", "MD5"};
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[9];
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("user", properties != null ? properties.getProperty("user") : null);
        driverPropertyInfo.required = true;
        driverPropertyInfo.description = "The user loginname to use when authenticating on the database server";
        driverPropertyInfoArray[0] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("password", properties != null ? properties.getProperty("password") : null);
        driverPropertyInfo.required = true;
        driverPropertyInfo.description = "The password to use when authenticating on the database server";
        driverPropertyInfoArray[1] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("debug", "false");
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Whether or not to create a log file for debugging purposes";
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[2] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("logfile", null);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "The filename to write the debug log to. Only takes effect if debug is set to true. If the file exists, an incrementing number is added, till the filename is unique.";
        driverPropertyInfoArray[3] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("language", "sql");
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "What language to use for MonetDB conversations (experts only)";
        driverPropertyInfo.choices = stringArray2;
        driverPropertyInfoArray[4] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("hash", null);
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Force the use of the given hash algorithm during challenge response (one of SHA1, MD5, plain)";
        driverPropertyInfo.choices = stringArray3;
        driverPropertyInfoArray[5] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("treat_blob_as_binary", "false");
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Should blob columns be mapped to Types.VARBINARY instead of default Types.BLOB in ResultSets and PreparedStatements";
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[6] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("treat_clob_as_varchar", "false");
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Should clob columns be mapped to Types.VARCHAR instead of default Types.CLOB in ResultSets and PreparedStatements";
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[7] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("so_timeout", "0");
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Defines the maximum time to wait in milliseconds on a blocking read socket call";
        driverPropertyInfoArray[8] = driverPropertyInfo;
        return driverPropertyInfoArray;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("java.util.logging not in use", "0A000");
    }

    static int getJdbcSQLType(String string) {
        Integer n = typeMap.get(string);
        if (n != null) {
            return n;
        }
        return 1111;
    }

    static String getSQLTypeMap(String string) {
        if (TypeMapppingSQL == null) {
            StringBuilder stringBuilder = new StringBuilder(typeMap.size() * 25 + 14);
            for (Map.Entry<String, Integer> entry : typeMap.entrySet()) {
                stringBuilder.append(" WHEN '").append(entry.getKey()).append("' THEN ").append(entry.getValue().toString());
            }
            stringBuilder.append(" ELSE ").append(1111).append(" END");
            TypeMapppingSQL = stringBuilder.toString();
        }
        return "CASE " + string + TypeMapppingSQL;
    }

    public static String getDriverVersion() {
        return "2.28 (Liberica 20180524 based on MCL v1.17)";
    }

    static int getDriverMajorVersion() {
        return 2;
    }

    static int getDriverMinorVersion() {
        return 28;
    }

    static {
        try {
            DriverManager.registerDriver(new MonetDriver());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        typeMap = new HashMap<String, Integer>();
        typeMap.put("bigint", -5);
        typeMap.put("blob", 2004);
        typeMap.put("boolean", 16);
        typeMap.put("char", 1);
        typeMap.put("clob", 2005);
        typeMap.put("date", 91);
        typeMap.put("decimal", 3);
        typeMap.put("double", 8);
        typeMap.put("hugeint", 2);
        typeMap.put("inet", 12);
        typeMap.put("int", 4);
        typeMap.put("json", 12);
        typeMap.put("month_interval", 4);
        typeMap.put("oid", -5);
        typeMap.put("real", 7);
        typeMap.put("sec_interval", 3);
        typeMap.put("smallint", 5);
        typeMap.put("time", 92);
        typeMap.put("timestamp", 93);
        typeMap.put("timestamptz", 93);
        typeMap.put("timetz", 92);
        typeMap.put("tinyint", -6);
        typeMap.put("url", 12);
        typeMap.put("uuid", 12);
        typeMap.put("varchar", 12);
        typeMap.put("wrd", -5);
        TypeMapppingSQL = null;
    }
}

