/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.jdbc.MonetResultSet;
import nl.cwi.monetdb.jdbc.MonetVirtualResultSet;
import nl.cwi.monetdb.jdbc.MonetWrapper;

public class MonetStatement
extends MonetWrapper
implements Statement,
AutoCloseable {
    static final int DEF_MAXROWS = 0;
    private MonetConnection connection;
    private MonetConnection.ResponseList lastResponseList;
    MonetConnection.Response header;
    private SQLWarning warnings;
    protected boolean closed;
    protected boolean poolable;
    private boolean closeOnCompletion = false;
    private int fetchSize = 0;
    private int maxRows = 0;
    private int fetchDirection = 1000;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private List<String> batch = new ArrayList<String>();
    Lock batchLock = new ReentrantLock();

    MonetStatement(MonetConnection monetConnection, int n, int n2, int n3) throws SQLException, IllegalArgumentException {
        if (monetConnection == null) {
            throw new IllegalArgumentException("No Connection given!");
        }
        this.connection = monetConnection;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        if (n2 != 1007) {
            this.addWarning("No concurrency mode other then read only is supported, continuing with concurrency level READ_ONLY", "01M13");
            n2 = 1007;
        }
        if (n == 1005) {
            this.addWarning("Change sensitive scrolling ResultSet objects are not supported, continuing with a change non-sensitive scrollable cursor.", "01M14");
            n = 1004;
        }
        if (n3 != 1) {
            this.addWarning("Close cursors at commit not supported, continuing with holdability to hold open cursors over commit.", "01M15");
        }
        this.closed = false;
        this.poolable = false;
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.batch.add(string);
    }

    @Override
    public void clearBatch() {
        this.batch.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.batchLock.lock();
        try {
            if (this.batch.isEmpty()) {
                int[] nArray = new int[]{};
                return nArray;
            }
            int[] nArray = new int[this.batch.size()];
            int n = 0;
            boolean bl = true;
            boolean bl2 = false;
            BatchUpdateException batchUpdateException = new BatchUpdateException("Error(s) occurred while executing the batch, see next SQLExceptions for details", "22000", nArray);
            StringBuilder stringBuilder = new StringBuilder(8190);
            String string = this.connection.queryTempl[2];
            for (int i = 0; i < this.batch.size(); ++i) {
                String string2 = this.batch.get(i);
                if (string.length() + string2.length() > 8190) {
                    if (!bl) {
                        stringBuilder.append(string);
                    }
                    stringBuilder.append(string2);
                    bl2 |= this.internalBatch(stringBuilder.toString(), nArray, n, i + 1, batchUpdateException);
                    n = i;
                    stringBuilder.delete(0, stringBuilder.length());
                    bl = true;
                    continue;
                }
                if (stringBuilder.length() + string.length() + string2.length() >= 8190) {
                    bl2 |= this.internalBatch(stringBuilder.toString(), nArray, n, i + 1, batchUpdateException);
                    n = i;
                    stringBuilder.delete(0, stringBuilder.length());
                    bl = true;
                }
                if (!bl) {
                    stringBuilder.append(string);
                }
                bl = false;
                stringBuilder.append(string2);
            }
            if (bl2 |= this.internalBatch(stringBuilder.toString(), nArray, n, nArray.length, batchUpdateException)) {
                throw batchUpdateException;
            }
            int[] nArray2 = nArray;
            return nArray2;
        }
        finally {
            this.batchLock.unlock();
        }
    }

    private boolean internalBatch(String string, int[] nArray, int n, int n2, BatchUpdateException batchUpdateException) throws BatchUpdateException {
        try {
            boolean bl = this.internalExecute(string);
            int n3 = -1;
            if (!bl) {
                n3 = this.getUpdateCount();
            }
            do {
                if (n >= n2) {
                    throw new SQLException("Overflow: don't use multi statements when batching (" + n2 + ")", "M1M16");
                }
                if (bl) {
                    batchUpdateException.setNextException(new SQLException("Batch query produced a ResultSet! Ignoring and setting update count to value -3", "M1M17"));
                    nArray[n] = -3;
                } else if (n3 >= 0) {
                    nArray[n] = n3;
                }
                ++n;
            } while ((bl = this.getMoreResults()) || (n3 = this.getUpdateCount()) != -1);
        }
        catch (SQLException sQLException) {
            batchUpdateException.setNextException(sQLException);
            while (n < n2) {
                nArray[n] = -3;
                ++n;
            }
            return true;
        }
        return false;
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException("Query cancelling is currently not supported by the driver.", "0A000");
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public void close() {
        if (this.lastResponseList != null) {
            this.lastResponseList.close();
            this.lastResponseList = null;
        }
        this.closed = true;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        return this.internalExecute(string);
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        if (n != 1 && n != 2) {
            throw new SQLException("Invalid argument, expected RETURN_GENERATED_KEYS or NO_GENERATED_KEYS", "M1M05");
        }
        return this.internalExecute(string);
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        this.addWarning("execute: generated keys for fixed set of columns not supported", "01M18");
        return this.execute(string, 1);
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.addWarning("execute: generated keys for fixed set of columns not supported", "01M18");
        return this.execute(string, 1);
    }

    private boolean internalExecute(String string) throws SQLException {
        if (this.lastResponseList != null) {
            this.lastResponseList.close();
            this.lastResponseList = null;
        }
        MonetConnection monetConnection = this.connection;
        monetConnection.getClass();
        this.lastResponseList = monetConnection.new MonetConnection.ResponseList(this.fetchSize, this.maxRows, this.resultSetType, this.resultSetConcurrency);
        this.lastResponseList.processQuery(string);
        return this.getMoreResults();
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        if (!this.execute(string)) {
            throw new SQLException("Query did not produce a result set", "M1M19");
        }
        return this.getResultSet();
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        if (this.execute(string)) {
            throw new SQLException("Query produced a result set", "M1M17");
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        if (n != 1 && n != 2) {
            throw new SQLException("Invalid argument, expected RETURN_GENERATED_KEYS or NO_GENERATED_KEYS", "M1M05");
        }
        if (this.execute(string)) {
            throw new SQLException("Query produced a result set", "M1M17");
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.addWarning("executeUpdate: generated keys for fixed set of columns not supported", "01M18");
        return this.executeUpdate(string, 1);
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.addWarning("executeUpdate: generated keys for fixed set of columns not supported", "01M18");
        return this.executeUpdate(string, 1);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        String[][] stringArray;
        String[] stringArray2 = new String[1];
        String[] stringArray3 = new String[1];
        stringArray2[0] = "GENERATED_KEY";
        stringArray3[0] = "BIGINT";
        if (this.header instanceof MonetConnection.UpdateResponse) {
            String string = ((MonetConnection.UpdateResponse)this.header).lastid;
            if (string.equals("-1")) {
                stringArray = new String[0][1];
            } else {
                stringArray = new String[1][1];
                stringArray[0][0] = string;
            }
        } else {
            stringArray = new String[0][1];
        }
        try {
            return new MonetVirtualResultSet((Statement)this, stringArray2, stringArray3, stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException("Internal driver error: " + illegalArgumentException.getMessage(), "M0M03");
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0x7FFFFFFE;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        if (this.lastResponseList == null) {
            this.header = null;
            return false;
        }
        if (n == 1) {
            this.lastResponseList.closeCurrentResponse();
        } else if (n == 3) {
            this.lastResponseList.closeCurOldResponses();
        }
        this.header = this.lastResponseList.getNextResponse();
        return this.header instanceof MonetConnection.ResultSetResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQueryTimeout() throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.connection.createStatement();
            resultSet = statement.executeQuery("SELECT \"querytimeout\" FROM \"sys\".\"sessions\"() WHERE \"active\"");
            if (resultSet != null && resultSet.next()) {
                long l = resultSet.getLong(1);
                int n = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
                return n;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.header instanceof MonetConnection.ResultSetResponse ? new MonetResultSet(this, (MonetConnection.ResultSetResponse)this.header) : null;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        int n = -1;
        if (this.header instanceof MonetConnection.UpdateResponse) {
            n = ((MonetConnection.UpdateResponse)this.header).count;
        } else if (this.header instanceof MonetConnection.SchemaResponse) {
            n = ((MonetConnection.SchemaResponse)this.header).state;
        }
        return n;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Statement", "M1M20");
        }
        return this.warnings;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.addWarning("setCursorName: positioned updates/deletes not supported", "01M21");
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (bl) {
            this.addWarning("setEscapeProcessing: JDBC escape syntax is not supported by this driver", "01M22");
        }
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000 && n != 1001 && n != 1002) {
            throw new SQLException("Illegal direction: " + n, "M1M05");
        }
        this.fetchDirection = n;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (n < 0 || this.getMaxRows() != 0 && n > this.getMaxRows()) {
            throw new SQLException("Illegal fetch size value: " + n, "M1M05");
        }
        this.fetchSize = n;
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Illegal max value: " + n, "M1M05");
        }
        if (n > 0) {
            this.addWarning("setMaxFieldSize: field size limitation not supported", "01M23");
        }
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Illegal max value: " + n, "M1M05");
        }
        this.maxRows = n;
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Illegal timeout value: " + n, "M1M05");
        }
        try (Statement statement = null;){
            statement = this.connection.createStatement();
            statement.execute("CALL \"sys\".\"settimeout\"(" + n + ")");
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean bl) {
        this.poolable = bl;
    }

    @Override
    public boolean isPoolable() {
        return this.poolable;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Statement", "M1M20");
        }
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Statement", "M1M20");
        }
        return this.closeOnCompletion;
    }

    private void addWarning(String string, String string2) {
        SQLWarning sQLWarning = new SQLWarning(string, string2);
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    void closeIfCompletion() {
        if (!this.closeOnCompletion || this.lastResponseList == null) {
            return;
        }
        if (!this.lastResponseList.hasUnclosedResponses()) {
            this.close();
        }
    }
}

