/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import nl.cwi.monetdb.jdbc.MonetBlob;
import nl.cwi.monetdb.jdbc.MonetCallableStatement;
import nl.cwi.monetdb.jdbc.MonetClob;
import nl.cwi.monetdb.jdbc.MonetDatabaseMetaData;
import nl.cwi.monetdb.jdbc.MonetPreparedStatement;
import nl.cwi.monetdb.jdbc.MonetSavepoint;
import nl.cwi.monetdb.jdbc.MonetStatement;
import nl.cwi.monetdb.jdbc.MonetWrapper;
import nl.cwi.monetdb.jdbc.types.INET;
import nl.cwi.monetdb.jdbc.types.URL;
import nl.cwi.monetdb.mcl.MCLException;
import nl.cwi.monetdb.mcl.io.BufferedMCLReader;
import nl.cwi.monetdb.mcl.io.BufferedMCLWriter;
import nl.cwi.monetdb.mcl.net.MapiSocket;
import nl.cwi.monetdb.mcl.parser.HeaderLineParser;
import nl.cwi.monetdb.mcl.parser.MCLParseException;
import nl.cwi.monetdb.mcl.parser.StartOfHeaderParser;

public class MonetConnection
extends MonetWrapper
implements Connection,
AutoCloseable {
    private final Properties conn_props = new Properties();
    private final String hostname;
    private int port = 0;
    private final String database;
    private final String username;
    private final String password;
    private final MapiSocket server;
    private final BufferedMCLReader in;
    private final BufferedMCLWriter out;
    private StartOfHeaderParser sohp = new StartOfHeaderParser();
    private boolean closed;
    private boolean autoCommit = true;
    private SQLWarning warnings = null;
    private Map<String, Class<?>> typeMap = new HashMap<String, Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("inet", INET.class);
            this.put("url", URL.class);
        }
    };
    private WeakHashMap<Statement, ?> statements = new WeakHashMap();
    private int curReplySize = -1;
    final String[] queryTempl = new String[3];
    private final String[] commandTempl = new String[2];
    private static final int LANG_SQL = 0;
    private static final int LANG_MAL = 3;
    private static final int LANG_UNKNOWN = -1;
    private final int lang;
    private boolean treatBlobAsVarBinary = false;
    private boolean treatClobAsVarChar = false;
    protected int lastSetQueryTimeout = 0;
    private String env_current_user = null;
    private String env_monet_version = null;
    private String env_max_clients = null;
    private boolean queriedPrivilege_codesTable = false;
    private boolean hasPrivilege_codesTable = false;
    private boolean queriedCommentsTable = false;
    private boolean hasCommentsTable = false;
    private static final int DEF_FETCHSIZE = 250;
    private static int seqCounter = 0;

    MonetConnection(Properties properties) throws SQLException, IllegalArgumentException {
        Object object;
        Object object2;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        this.hostname = properties.getProperty("host");
        if (this.hostname != null) {
            this.conn_props.setProperty("host", this.hostname);
        }
        if ((string5 = properties.getProperty("port")) != null) {
            try {
                this.port = Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                this.addWarning("Unable to parse port number from: " + string5, "M1M05");
            }
            this.conn_props.setProperty("port", Integer.toString(this.port));
        }
        this.database = properties.getProperty("database");
        if (this.database != null) {
            this.conn_props.setProperty("database", this.database);
        }
        this.username = properties.getProperty("user");
        if (this.username != null) {
            this.conn_props.setProperty("user", this.username);
        }
        this.password = properties.getProperty("password");
        if (this.password != null) {
            this.conn_props.setProperty("password", this.password);
        }
        if ((string4 = properties.getProperty("language")) != null) {
            this.conn_props.setProperty("language", string4);
        }
        boolean bl = false;
        String string6 = properties.getProperty("debug");
        if (string6 != null) {
            bl = Boolean.parseBoolean(string6);
            this.conn_props.setProperty("debug", Boolean.toString(bl));
        }
        if ((string3 = properties.getProperty("hash")) != null) {
            this.conn_props.setProperty("hash", string3);
        }
        if ((string2 = properties.getProperty("treat_blob_as_binary")) != null) {
            this.treatBlobAsVarBinary = Boolean.parseBoolean(string2);
            this.conn_props.setProperty("treat_blob_as_binary", Boolean.toString(this.treatBlobAsVarBinary));
            if (this.treatBlobAsVarBinary) {
                this.typeMap.put("blob", Byte[].class);
            }
        }
        if ((string = properties.getProperty("treat_clob_as_varchar")) != null) {
            this.treatClobAsVarChar = Boolean.parseBoolean(string);
            this.conn_props.setProperty("treat_clob_as_varchar", Boolean.toString(this.treatClobAsVarChar));
            if (this.treatClobAsVarChar) {
                this.typeMap.put("clob", String.class);
            }
        }
        int n = 0;
        String string7 = properties.getProperty("so_timeout");
        if (string7 != null) {
            try {
                n = Integer.parseInt(string7);
                if (n < 0) {
                    this.addWarning("Negative socket timeout not allowed. Value ignored", "M1M05");
                    n = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.addWarning("Unable to parse socket timeout number from: " + string7, "M1M05");
            }
            this.conn_props.setProperty("so_timeout", Integer.toString(n));
        }
        if (this.hostname == null || this.hostname.isEmpty()) {
            throw new IllegalArgumentException("Missing or empty host name");
        }
        if (this.port <= 0 || this.port > 65535) {
            throw new IllegalArgumentException("Invalid port number: " + this.port + ". It should not be " + (this.port < 0 ? "negative" : (this.port > 65535 ? "larger than 65535" : "0")));
        }
        if (this.username == null || this.username.isEmpty()) {
            throw new IllegalArgumentException("Missing or empty user name");
        }
        if (this.password == null || this.password.isEmpty()) {
            throw new IllegalArgumentException("Missing or empty password");
        }
        if (string4 == null || string4.isEmpty()) {
            string4 = "sql";
            this.addWarning("No language specified, defaulting to 'sql'", "M1M05");
        }
        this.server = new MapiSocket();
        if (string3 != null) {
            this.server.setHash(string3);
        }
        if (this.database != null) {
            this.server.setDatabase(this.database);
        }
        this.server.setLanguage(string4);
        if (bl) {
            try {
                object2 = properties.getProperty("logfile", "monet_" + System.currentTimeMillis() + ".log");
                object = new File((String)object2);
                int n2 = ((String)object2).lastIndexOf(46);
                if (n2 < 0) {
                    n2 = ((String)object2).length();
                }
                String string8 = ((String)object2).substring(0, n2);
                String string9 = ((String)object2).substring(n2);
                int n3 = 1;
                while (((File)object).exists()) {
                    object = new File(string8 + "-" + n3 + string9);
                    ++n3;
                }
                this.server.debug(((File)object).getAbsolutePath());
            }
            catch (IOException iOException) {
                throw new SQLNonTransientConnectionException("Opening logfile failed: " + iOException.getMessage(), "08M01");
            }
        }
        try {
            object2 = this.server.connect(this.hostname, this.port, this.username, this.password);
            object = object2.iterator();
            while (object.hasNext()) {
                String string10 = (String)object.next();
                this.addWarning(string10, "01M02");
            }
            this.server.setSoTimeout(n);
            this.in = this.server.getReader();
            this.out = this.server.getWriter();
            object = this.in.waitForPrompt();
            if (object != null) {
                throw new SQLNonTransientConnectionException((String)(((String)object).length() > 6 ? ((String)object).substring(6) : object), "08001");
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new SQLNonTransientConnectionException("Unknown Host (" + this.hostname + "): " + unknownHostException.getMessage(), "08006");
        }
        catch (IOException iOException) {
            throw new SQLNonTransientConnectionException("Unable to connect (" + this.hostname + ":" + this.port + "): " + iOException.getMessage(), "08006");
        }
        catch (MCLParseException mCLParseException) {
            throw new SQLNonTransientConnectionException(mCLParseException.getMessage(), "08001");
        }
        catch (MCLException mCLException) {
            object = mCLException.getMessage().split("\n");
            SQLNonTransientConnectionException sQLNonTransientConnectionException = new SQLNonTransientConnectionException(object[0], "08001", mCLException);
            for (int i = 1; i < ((Object)object).length; ++i) {
                sQLNonTransientConnectionException.setNextException(new SQLNonTransientConnectionException((String)object[1], "08001"));
            }
            throw sQLNonTransientConnectionException;
        }
        if ("sql".equals(string4)) {
            this.lang = 0;
            this.queryTempl[0] = "s";
            this.queryTempl[1] = "\n;";
            this.queryTempl[2] = "\n;\n";
            this.commandTempl[0] = "X";
            this.commandTempl[1] = "";
        } else if ("mal".equals(string4)) {
            this.lang = 3;
            this.queryTempl[0] = "";
            this.queryTempl[1] = ";\n";
            this.queryTempl[2] = ";\n";
            this.commandTempl[0] = "";
            this.commandTempl[1] = "";
        } else {
            this.lang = -1;
        }
        if (this.lang == 0) {
            this.setAutoCommit(true);
            object2 = Calendar.getInstance();
            int n4 = ((Calendar)object2).get(15) + ((Calendar)object2).get(16);
            String string11 = (n4 /= 60000) < 0 ? "-" : "+";
            string11 = string11 + (Math.abs(n4) / 60 < 10 ? "0" : "") + Math.abs(n4) / 60 + ":";
            n4 -= n4 / 60 * 60;
            string11 = string11 + (n4 < 10 ? "0" : "") + n4;
            this.sendIndependentCommand("SET TIME ZONE INTERVAL '" + string11 + "' HOUR TO MINUTE");
        }
        this.closed = false;
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        MapiSocket mapiSocket = this.server;
        synchronized (mapiSocket) {
            for (Statement statement : this.statements.keySet()) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            this.server.close();
            this.closed = true;
        }
    }

    @Override
    public void commit() throws SQLException {
        this.sendTransactionCommand("COMMIT");
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 1);
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement(n, n2, 1);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        try {
            MonetStatement monetStatement = new MonetStatement(this, n, n2, n3);
            this.statements.put(monetStatement, null);
            return monetStatement;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException.toString(), "M0M03");
        }
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public int getHoldability() {
        return 1;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.lang != 0) {
            throw new SQLException("This method is only supported in SQL mode", "M0M04");
        }
        return new MonetDatabaseMetaData(this);
    }

    @Override
    public int getTransactionIsolation() {
        return 8;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return this.typeMap;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Connection", "M1M20");
        }
        return this.warnings;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String nativeSQL(String string) {
        return string;
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007, 1);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string, n, n2, 1);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        try {
            MonetCallableStatement monetCallableStatement = new MonetCallableStatement(this, n, n2, n3, string);
            this.statements.put(monetCallableStatement, null);
            return monetCallableStatement;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException.toString(), "M0M03");
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string, n, n2, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        try {
            MonetPreparedStatement monetPreparedStatement = new MonetPreparedStatement(this, n, n2, n3, string);
            this.statements.put(monetPreparedStatement, null);
            return monetPreparedStatement;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException.toString(), "M0M03");
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (n != 1 && n != 2) {
            throw new SQLException("Invalid argument, expected RETURN_GENERATED_KEYS or NO_GENERATED_KEYS", "M1M05");
        }
        return this.prepareStatement(string, 1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw MonetConnection.newSQLFeatureNotSupportedException("prepareStatement(String sql, int[] columnIndexes)");
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw MonetConnection.newSQLFeatureNotSupportedException("prepareStatement(String sql, String[] columnNames)");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (!(savepoint instanceof MonetSavepoint)) {
            throw new SQLException("This driver can only handle savepoints it created itself", "M0M06");
        }
        MonetSavepoint monetSavepoint = (MonetSavepoint)savepoint;
        this.sendTransactionCommand("RELEASE SAVEPOINT " + monetSavepoint.getName());
    }

    @Override
    public void rollback() throws SQLException {
        this.sendTransactionCommand("ROLLBACK");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (!(savepoint instanceof MonetSavepoint)) {
            throw new SQLException("This driver can only handle savepoints it created itself", "M0M06");
        }
        MonetSavepoint monetSavepoint = (MonetSavepoint)savepoint;
        this.sendTransactionCommand("ROLLBACK TO SAVEPOINT " + monetSavepoint.getName());
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.autoCommit != bl) {
            this.sendControlCommand("auto_commit " + (bl ? "1" : "0"));
            this.autoCommit = bl;
        }
    }

    @Override
    public void setCatalog(String string) {
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        if (n != 1) {
            throw MonetConnection.newSQLFeatureNotSupportedException("setHoldability(CLOSE_CURSORS_AT_COMMIT)");
        }
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        if (bl) {
            this.addWarning("cannot setReadOnly(true): read-only Connection mode not supported", "01M08");
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        MonetSavepoint monetSavepoint = new MonetSavepoint();
        this.sendTransactionCommand("SAVEPOINT " + monetSavepoint.getName());
        return monetSavepoint;
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        MonetSavepoint monetSavepoint;
        try {
            monetSavepoint = new MonetSavepoint(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException.getMessage(), "M0M03");
        }
        this.sendTransactionCommand("SAVEPOINT " + monetSavepoint.getName());
        return monetSavepoint;
    }

    @Override
    public void setTransactionIsolation(int n) {
        if (n != 8) {
            this.addWarning("MonetDB only supports fully serializable transactions, continuing with transaction level raised to TRANSACTION_SERIALIZABLE", "01M09");
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) {
        this.typeMap = map;
    }

    public String toString() {
        return "MonetDB Connection (" + this.getJDBCURL() + ") " + (this.closed ? "disconnected" : "connected");
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw MonetConnection.newSQLFeatureNotSupportedException("createArrayOf");
    }

    @Override
    public Clob createClob() throws SQLException {
        return new MonetClob("");
    }

    @Override
    public Blob createBlob() throws SQLException {
        return new MonetBlob(new byte[1]);
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw MonetConnection.newSQLFeatureNotSupportedException("createNClob");
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw MonetConnection.newSQLFeatureNotSupportedException("createStruct");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw MonetConnection.newSQLFeatureNotSupportedException("createSQLXML");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("timeout is less than 0", "M1M05");
        }
        if (this.closed) {
            return false;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            statement = this.createStatement();
            if (statement != null) {
                int n2 = statement.getQueryTimeout();
                if (n > 0 && n2 != n) {
                    statement.setQueryTimeout(n);
                }
                if ((resultSet = statement.executeQuery("SELECT 1")) != null && resultSet.next()) {
                    bl = true;
                }
                if (n > 0 && n2 != n) {
                    statement.setQueryTimeout(n2);
                }
            }
        }
        catch (SQLException sQLException) {
            String string = sQLException.getMessage();
            if (string != null && string.equalsIgnoreCase("Current transaction is aborted (please ROLLBACK)")) {
                bl = true;
            }
        }
        finally {
            MonetConnection.closeResultsetStatement(resultSet, statement);
        }
        return bl;
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        return this.conn_props.getProperty(string);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return new Properties(this.conn_props);
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        if (string == null || string.isEmpty()) {
            this.addWarning("setClientInfo: missing property name", "01M07");
            return;
        }
        if (string2 == null) {
            if (this.conn_props.containsKey(string)) {
                this.conn_props.remove(string);
            }
            return;
        }
        if (string.equals("host") || string.equals("port") || string.equals("user") || string.equals("password") || string.equals("database") || string.equals("language") || string.equals("so_timeout") || string.equals("debug") || string.equals("hash") || string.equals("treat_blob_as_binary") || string.equals("treat_clob_as_varchar")) {
            this.conn_props.setProperty(string, string2);
        } else {
            this.addWarning("setClientInfo: " + string + "is not a recognised property", "01M07");
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.setClientInfo(entry.getKey().toString(), entry.getValue().toString());
            }
        }
    }

    @Override
    public void setSchema(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Connection", "M1M20");
        }
        if (string == null || string.isEmpty()) {
            throw new SQLException("Missing schema name", "M1M05");
        }
        Statement statement = null;
        try {
            statement = this.createStatement();
            if (statement != null) {
                statement.execute("SET SCHEMA \"" + string + "\"");
            }
        }
        finally {
            MonetConnection.closeResultsetStatement(null, statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Connection", "M1M20");
        }
        String string = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.createStatement();
            if (statement != null && (resultSet = statement.executeQuery("SELECT CURRENT_SCHEMA")) != null && resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        finally {
            MonetConnection.closeResultsetStatement(resultSet, statement);
        }
        if (string == null) {
            throw new SQLException("Failed to fetch schema name", "02000");
        }
        return string;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.closed) {
            return;
        }
        if (executor == null) {
            throw new SQLException("executor is null", "M1M05");
        }
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Connection", "M1M20");
        }
        if (executor == null) {
            throw new SQLException("executor is null", "M1M05");
        }
        if (n < 0) {
            throw new SQLException("milliseconds is less than zero", "M1M05");
        }
        try {
            this.server.setSoTimeout(n);
        }
        catch (SocketException socketException) {
            throw new SQLNonTransientConnectionException(socketException.getMessage(), "08000");
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Connection", "M1M20");
        }
        try {
            return this.server.getSoTimeout();
        }
        catch (SocketException socketException) {
            throw new SQLNonTransientConnectionException(socketException.getMessage(), "08000");
        }
    }

    boolean mapBlobAsVarBinary() {
        return this.treatBlobAsVarBinary;
    }

    boolean mapClobAsVarChar() {
        return this.treatClobAsVarChar;
    }

    String getJDBCURL() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("jdbc:monetdb://").append(this.hostname).append(':').append(this.port).append('/').append(this.database);
        if (this.lang == 3) {
            stringBuilder.append("?language=mal");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void getEnvValues() throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.createStatement();
            if (statement != null && (resultSet = statement.executeQuery("SELECT \"name\", \"value\" FROM \"sys\".\"env\"() WHERE \"name\" IN ('monet_version', 'max_clients') UNION SELECT 'current_user' as \"name\", current_user as \"value\"")) != null) {
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    if ("current_user".equals(string)) {
                        this.env_current_user = string2;
                        continue;
                    }
                    if ("monet_version".equals(string)) {
                        this.env_monet_version = string2;
                        continue;
                    }
                    if (!"max_clients".equals(string)) continue;
                    this.env_max_clients = string2;
                }
            }
        }
        finally {
            MonetConnection.closeResultsetStatement(resultSet, statement);
        }
    }

    String getUserName() throws SQLException {
        if (this.env_current_user == null) {
            this.getEnvValues();
        }
        return this.env_current_user;
    }

    String getDatabaseProductVersion() throws SQLException {
        if (this.env_monet_version == null) {
            this.getEnvValues();
        }
        if (this.env_monet_version != null) {
            return this.env_monet_version;
        }
        return "";
    }

    int getDatabaseMajorVersion() throws SQLException {
        if (this.env_monet_version == null) {
            this.getEnvValues();
        }
        if (this.env_monet_version != null) {
            try {
                int n = this.env_monet_version.indexOf(46);
                return Integer.parseInt(n >= 0 ? this.env_monet_version.substring(0, n) : this.env_monet_version);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    int getDatabaseMinorVersion() throws SQLException {
        if (this.env_monet_version == null) {
            this.getEnvValues();
        }
        if (this.env_monet_version != null) {
            try {
                int n = this.env_monet_version.indexOf(46);
                if (n >= 0) {
                    int n2;
                    return Integer.parseInt((n2 = this.env_monet_version.indexOf(46, ++n)) > 0 ? this.env_monet_version.substring(n, n2) : this.env_monet_version.substring(n));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    int getMaxConnections() throws SQLException {
        if (this.env_max_clients == null) {
            this.getEnvValues();
        }
        if (this.env_max_clients != null) {
            try {
                return Integer.parseInt(this.env_max_clients);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    boolean privilege_codesTableExists() {
        if (!this.queriedPrivilege_codesTable) {
            this.hasPrivilege_codesTable = this.existsSysTable("privilege_codes");
            this.queriedPrivilege_codesTable = true;
        }
        return this.hasPrivilege_codesTable;
    }

    boolean commentsTableExists() {
        if (!this.queriedCommentsTable) {
            this.hasCommentsTable = this.existsSysTable("comments");
            this.queriedCommentsTable = true;
        }
        return this.hasCommentsTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsSysTable(String string) {
        boolean bl = false;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.createStatement();
            if (statement != null && (resultSet = statement.executeQuery("SELECT id FROM sys._tables WHERE name = '" + string + "' AND schema_id IN (SELECT id FROM sys.schemas WHERE name = 'sys')")) != null) {
                bl = resultSet.next();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            MonetConnection.closeResultsetStatement(resultSet, statement);
        }
        return bl;
    }

    static final void closeResultsetStatement(ResultSet resultSet, Statement statement) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void sendTransactionCommand(String string) throws SQLException {
        try (ResponseList responseList = new ResponseList(0, 0, 1000, 1007);){
            responseList.processQuery(string);
        }
    }

    private void sendIndependentCommand(String string) throws SQLException {
        this.sendCommand(string, true);
    }

    void sendControlCommand(String string) throws SQLException {
        this.sendCommand(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(String string, boolean bl) throws SQLException {
        MapiSocket mapiSocket = this.server;
        synchronized (mapiSocket) {
            try {
                this.out.writeLine(bl ? this.queryTempl[0] + string + this.queryTempl[1] : this.commandTempl[0] + string + this.commandTempl[1]);
                String string2 = this.in.waitForPrompt();
                if (string2 != null) {
                    throw new SQLException(string2.substring(6), string2.substring(0, 5));
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.close();
                throw new SQLNonTransientConnectionException("connection timed out", "08M33");
            }
            catch (IOException iOException) {
                throw new SQLNonTransientConnectionException(iOException.getMessage(), "08000");
            }
        }
    }

    private final void addWarning(String string, String string2) {
        SQLWarning sQLWarning = new SQLWarning(string, string2);
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    final class ResponseList {
        private final int cachesize;
        private final int maxrows;
        private final int rstype;
        private final int rsconcur;
        private final int seqnr;
        private final ArrayList<Response> responses;
        private HashMap<Integer, ResultSetResponse> rsresponses;
        private int curResponse;

        ResponseList(int n, int n2, int n3, int n4) throws SQLException {
            this.cachesize = n;
            this.maxrows = n2;
            this.rstype = n3;
            this.rsconcur = n4;
            this.responses = new ArrayList();
            this.curResponse = -1;
            this.seqnr = seqCounter++;
        }

        Response getNextResponse() throws SQLException {
            if (this.rstype == 1003 && this.curResponse >= 0 && this.curResponse < this.responses.size()) {
                Response response = this.responses.get(this.curResponse);
                if (response != null) {
                    response.close();
                }
                this.responses.set(this.curResponse, null);
            }
            ++this.curResponse;
            if (this.curResponse >= this.responses.size()) {
                return null;
            }
            return this.responses.get(this.curResponse);
        }

        void closeResponse(int n) {
            if (n < 0 || n >= this.responses.size()) {
                return;
            }
            Response response = this.responses.set(n, null);
            if (response != null) {
                response.close();
            }
        }

        void closeCurrentResponse() {
            this.closeResponse(this.curResponse);
        }

        void closeCurOldResponses() {
            for (int i = this.curResponse; i >= 0; --i) {
                this.closeResponse(i);
            }
        }

        void close() {
            for (int i = 0; i < this.responses.size(); ++i) {
                this.closeResponse(i);
            }
        }

        boolean hasUnclosedResponses() {
            for (Response response : this.responses) {
                if (response == null) continue;
                return true;
            }
            return false;
        }

        void processQuery(String string) throws SQLException {
            this.executeQuery(MonetConnection.this.queryTempl, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void executeQuery(String[] stringArray, String string) throws SQLException {
            String string2 = null;
            try {
                Object object = MonetConnection.this.server;
                synchronized (object) {
                    int n;
                    MonetConnection.this.in.waitForPrompt();
                    int n2 = n = this.cachesize == 0 ? 250 : this.cachesize;
                    if (this.maxrows > 0 && this.maxrows < n) {
                        n = this.maxrows;
                    }
                    if (MonetConnection.this.lang == 0 && n != MonetConnection.this.curReplySize && stringArray != MonetConnection.this.commandTempl) {
                        MonetConnection.this.sendControlCommand("reply_size " + n);
                        MonetConnection.this.curReplySize = n;
                    }
                    MonetConnection.this.out.writeLine((stringArray[0] == null ? "" : stringArray[0]) + string + (stringArray[1] == null ? "" : stringArray[1]));
                    String string3 = MonetConnection.this.in.readLine();
                    int n3 = MonetConnection.this.in.getLineType();
                    Response response = null;
                    block21: while (n3 != 46) {
                        switch (n3) {
                            case 38: {
                                try {
                                    switch (MonetConnection.this.sohp.parse(string3)) {
                                        case 48: {
                                            throw new MCLParseException("Q_PARSE header not allowed here", 1);
                                        }
                                        case 49: 
                                        case 53: {
                                            int n4 = MonetConnection.this.sohp.getNextAsInt();
                                            int n5 = MonetConnection.this.sohp.getNextAsInt();
                                            int n6 = MonetConnection.this.sohp.getNextAsInt();
                                            int n7 = MonetConnection.this.sohp.getNextAsInt();
                                            if (this.maxrows != 0 && n5 > this.maxrows) {
                                                n5 = this.maxrows;
                                            }
                                            response = new ResultSetResponse(n4, n5, n6, n7, this, this.seqnr);
                                            if (n7 < n5) {
                                                if (this.rsresponses == null) {
                                                    this.rsresponses = new HashMap();
                                                }
                                                this.rsresponses.put(n4, (ResultSetResponse)response);
                                            }
                                            break;
                                        }
                                        case 50: {
                                            response = new UpdateResponse(MonetConnection.this.sohp.getNextAsInt(), MonetConnection.this.sohp.getNextAsString());
                                            break;
                                        }
                                        case 51: {
                                            response = new SchemaResponse();
                                            break;
                                        }
                                        case 52: {
                                            boolean bl;
                                            boolean bl2 = bl = MonetConnection.this.sohp.getNextAsString().equals("t");
                                            if (MonetConnection.this.autoCommit && bl) {
                                                MonetConnection.this.addWarning("Server enabled auto commit mode while local state already was auto commit.", "01M11");
                                            }
                                            MonetConnection.this.autoCommit = bl;
                                            response = new AutoCommitResponse(bl);
                                            break;
                                        }
                                        case 54: {
                                            ResultSetResponse resultSetResponse;
                                            int n5 = MonetConnection.this.sohp.getNextAsInt();
                                            MonetConnection.this.sohp.getNextAsInt();
                                            int n6 = MonetConnection.this.sohp.getNextAsInt();
                                            int n7 = MonetConnection.this.sohp.getNextAsInt();
                                            ResultSetResponse resultSetResponse2 = resultSetResponse = this.rsresponses != null ? this.rsresponses.get(n5) : null;
                                            if (resultSetResponse == null) {
                                                string2 = "M0M12!no ResultSetResponse with id " + n5 + " found";
                                                break;
                                            }
                                            DataBlockResponse dataBlockResponse = new DataBlockResponse(n6, resultSetResponse.getRSType() == 1003);
                                            resultSetResponse.addDataBlockResponse(n7, dataBlockResponse);
                                            response = dataBlockResponse;
                                        }
                                    }
                                }
                                catch (MCLParseException mCLParseException) {
                                    string2 = "M0M10!error while parsing start of header:\n" + mCLParseException.getMessage() + " found: '" + string3.charAt(mCLParseException.getErrorOffset()) + "' in: \"" + string3 + "\" at pos: " + mCLParseException.getErrorOffset();
                                    MonetConnection.this.in.waitForPrompt();
                                    n3 = MonetConnection.this.in.getLineType();
                                    continue block21;
                                }
                                if (string2 != null) {
                                    MonetConnection.this.in.waitForPrompt();
                                    n3 = MonetConnection.this.in.getLineType();
                                    continue block21;
                                }
                                while (response.wantsMore()) {
                                    string2 = response.addLine(MonetConnection.this.in.readLine(), MonetConnection.this.in.getLineType());
                                    if (string2 == null) continue;
                                    string2 = "M0M10!" + string2;
                                    MonetConnection.this.in.waitForPrompt();
                                    n3 = MonetConnection.this.in.getLineType();
                                    break;
                                }
                                if (string2 != null) continue block21;
                                if (!(response instanceof DataBlockResponse)) {
                                    this.responses.add(response);
                                }
                                string3 = MonetConnection.this.in.readLine();
                                n3 = MonetConnection.this.in.getLineType();
                                continue block21;
                            }
                            case 35: {
                                MonetConnection.this.addWarning(string3.substring(1), "01000");
                                string3 = MonetConnection.this.in.readLine();
                                n3 = MonetConnection.this.in.getLineType();
                                continue block21;
                            }
                            default: {
                                string3 = "!M0M10!protocol violation, unexpected line: " + string3;
                            }
                            case 33: 
                        }
                        string2 = MonetConnection.this.in.waitForPrompt();
                        n3 = MonetConnection.this.in.getLineType();
                        if (string2 != null) {
                            string2 = string3.substring(1) + "\n" + string2;
                            continue;
                        }
                        string2 = string3.substring(1);
                    }
                }
                if (string2 != null) {
                    object = null;
                    String[] stringArray2 = string2.split("\n");
                    for (int i = 0; i < stringArray2.length; ++i) {
                        SQLException sQLException = stringArray2[i].length() >= 6 ? new SQLException(stringArray2[i].substring(6), stringArray2[i].substring(0, 5)) : new SQLNonTransientConnectionException(stringArray2[i], "08000");
                        if (object == null) {
                            object = sQLException;
                            continue;
                        }
                        ((SQLException)object).setNextException(sQLException);
                    }
                    throw object;
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.close();
                throw new SQLNonTransientConnectionException("connection timed out", "08M33");
            }
            catch (IOException iOException) {
                MonetConnection.this.closed = true;
                throw new SQLNonTransientConnectionException(iOException.getMessage() + " (mserver5 still alive?)", "08006");
            }
        }
    }

    private final class AutoCommitResponse
    extends SchemaResponse {
        public final boolean autocommit;

        public AutoCommitResponse(boolean bl) {
            this.autocommit = bl;
        }
    }

    class SchemaResponse
    implements Response {
        public final int state = -2;

        SchemaResponse() {
        }

        @Override
        public String addLine(String string, int n) {
            return "Header lines are not supported for a SchemaResponse";
        }

        @Override
        public boolean wantsMore() {
            return false;
        }

        @Override
        public void close() {
        }
    }

    static final class UpdateResponse
    implements Response {
        public final int count;
        public final String lastid;

        public UpdateResponse(int n, String string) {
            this.count = n;
            this.lastid = string;
        }

        @Override
        public String addLine(String string, int n) {
            return "Header lines are not supported for an UpdateResponse";
        }

        @Override
        public boolean wantsMore() {
            return false;
        }

        @Override
        public void close() {
        }
    }

    private static final class DataBlockResponse
    implements Response {
        private final String[] data;
        private int pos = -1;
        private final boolean forwardOnly;

        DataBlockResponse(int n, boolean bl) {
            this.data = new String[n];
            this.forwardOnly = bl;
        }

        @Override
        public String addLine(String string, int n) {
            if (n != 91) {
                return "protocol violation: unexpected line in data block: " + string;
            }
            this.data[++this.pos] = string;
            return null;
        }

        @Override
        public boolean wantsMore() {
            return this.pos + 1 < this.data.length;
        }

        @Override
        public void close() {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = null;
            }
        }

        String getRow(int n) {
            if (this.forwardOnly) {
                String string = this.data[n];
                this.data[n] = null;
                return string;
            }
            return this.data[n];
        }
    }

    final class ResultSetResponse
    implements Response {
        public final int columncount;
        public final int tuplecount;
        private int cacheSize;
        public final int id;
        private String[] name;
        private String[] type;
        private int[] columnLengths;
        private String[] tableNames;
        private final int seqnr;
        private DataBlockResponse[] resultBlocks;
        private boolean closed;
        private final ResponseList parent;
        private final boolean cacheSizeSetExplicitly;
        private boolean destroyOnClose;
        private int blockOffset = 0;
        private final HeaderLineParser hlp;
        private final boolean[] isSet = new boolean[4];
        private static final int NAMES = 0;
        private static final int TYPES = 1;
        private static final int TABLES = 2;
        private static final int LENS = 3;

        ResultSetResponse(int n, int n2, int n3, int n4, ResponseList responseList, int n5) throws SQLException {
            this.parent = responseList;
            if (responseList.cachesize == 0) {
                this.cacheSize = 250;
                this.cacheSizeSetExplicitly = false;
            } else {
                this.cacheSize = responseList.cachesize;
                this.cacheSizeSetExplicitly = true;
            }
            if (n4 > this.cacheSize) {
                this.cacheSize = n4;
            }
            this.seqnr = n5;
            this.closed = false;
            this.destroyOnClose = n > 0 && n2 > n4;
            this.id = n;
            this.tuplecount = n2;
            this.columncount = n3;
            this.resultBlocks = new DataBlockResponse[n2 / this.cacheSize + 1];
            this.hlp = new HeaderLineParser(n3);
            this.resultBlocks[0] = new DataBlockResponse(n4, responseList.rstype == 1003);
        }

        @Override
        public String addLine(String string, int n) {
            if (this.isSet[3] && this.isSet[1] && this.isSet[2] && this.isSet[0]) {
                return this.resultBlocks[0].addLine(string, n);
            }
            if (n != 37) {
                return "header expected, got: " + string;
            }
            try {
                switch (this.hlp.parse(string)) {
                    case 1: {
                        this.name = (String[])this.hlp.values.clone();
                        this.isSet[0] = true;
                        break;
                    }
                    case 2: {
                        this.columnLengths = (int[])this.hlp.intValues.clone();
                        this.isSet[3] = true;
                        break;
                    }
                    case 4: {
                        this.type = (String[])this.hlp.values.clone();
                        this.isSet[1] = true;
                        break;
                    }
                    case 3: {
                        this.tableNames = (String[])this.hlp.values.clone();
                        this.isSet[2] = true;
                    }
                }
            }
            catch (MCLParseException mCLParseException) {
                return mCLParseException.getMessage();
            }
            return null;
        }

        @Override
        public boolean wantsMore() {
            if (this.isSet[3] && this.isSet[1] && this.isSet[2] && this.isSet[0]) {
                return this.resultBlocks[0].wantsMore();
            }
            return true;
        }

        private final String[] getValues(char[] cArray, int n, int n2) {
            int n3 = 0;
            String[] stringArray = new String[this.columncount];
            for (int i = n; i < n2; ++i) {
                if (cArray[i] != '\t' || cArray[i - 1] != ',') continue;
                stringArray[n3++] = new String(cArray, n, i - 1 - n);
                n = i + 1;
            }
            stringArray[n3++] = new String(cArray, n, n2 - n);
            return stringArray;
        }

        void addDataBlockResponse(int n, DataBlockResponse dataBlockResponse) {
            int n2 = (n - this.blockOffset) / this.cacheSize;
            this.resultBlocks[n2] = dataBlockResponse;
        }

        String[] getNames() {
            return this.name;
        }

        String[] getTypes() {
            return this.type;
        }

        String[] getTableNames() {
            return this.tableNames;
        }

        int[] getColumnLengths() {
            return this.columnLengths;
        }

        int getCacheSize() {
            return this.cacheSize;
        }

        int getBlockOffset() {
            return this.blockOffset;
        }

        int getRSType() {
            return this.parent.rstype;
        }

        int getRSConcur() {
            return this.parent.rsconcur;
        }

        String getLine(int n) throws SQLException {
            if (n >= this.tuplecount || n < 0) {
                return null;
            }
            int n2 = (n - this.blockOffset) / this.cacheSize;
            int n3 = (n - this.blockOffset) % this.cacheSize;
            DataBlockResponse dataBlockResponse = this.resultBlocks[n2];
            if (dataBlockResponse == null) {
                if (this.parent.rstype == 1003) {
                    for (int i = 0; i < n2; ++i) {
                        this.resultBlocks[i] = null;
                    }
                    if (seqCounter - 1 == this.seqnr && !this.cacheSizeSetExplicitly && this.tuplecount - n > this.cacheSize && this.cacheSize < 2500) {
                        this.blockOffset += this.cacheSize;
                        this.cacheSize *= 10;
                        n2 = (n - this.blockOffset) / this.cacheSize;
                        n3 = (n - this.blockOffset) % this.cacheSize;
                    }
                }
                this.parent.executeQuery(MonetConnection.this.commandTempl, "export " + this.id + " " + (n2 * this.cacheSize + this.blockOffset) + " " + this.cacheSize);
                dataBlockResponse = this.resultBlocks[n2];
                if (dataBlockResponse == null) {
                    throw new SQLException("resultBlocks[" + n2 + "] should have been fetched by now", "M0M10");
                }
            }
            return dataBlockResponse.getRow(n3);
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            try {
                if (this.destroyOnClose) {
                    MonetConnection.this.sendControlCommand("close " + this.id);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            for (int i = 1; i < this.resultBlocks.length; ++i) {
                DataBlockResponse dataBlockResponse = this.resultBlocks[i];
                if (dataBlockResponse == null) continue;
                dataBlockResponse.close();
            }
            this.closed = true;
        }

        boolean isClosed() {
            return this.closed;
        }
    }

    static interface Response {
        public String addLine(String var1, int var2);

        public boolean wantsMore();

        public void close();
    }
}

