/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.concurrent.atomic.AtomicInteger;

public final class MonetSavepoint
implements Savepoint {
    private static final AtomicInteger highestId = new AtomicInteger(0);
    private final String name;
    private final int id;

    public MonetSavepoint(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Missing savepoint name");
        }
        this.id = MonetSavepoint.getNextId();
        this.name = string;
    }

    public MonetSavepoint() {
        this.id = MonetSavepoint.getNextId();
        this.name = null;
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (this.name != null) {
            throw new SQLException("Cannot get ID of named savepoint", "3B000");
        }
        return this.id;
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (this.name == null) {
            throw new SQLException("Cannot get name of un-named savepoint", "3B000");
        }
        return this.name;
    }

    final int getId() {
        return this.id;
    }

    final String getName() {
        return "JDBCSP" + this.id;
    }

    private static final int getNextId() {
        return highestId.incrementAndGet();
    }
}

