/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import nl.cwi.monetdb.jdbc.MonetResultSet;

final class MonetVirtualResultSet
extends MonetResultSet {
    private String[][] results;
    private boolean closed;

    MonetVirtualResultSet(Statement statement, String[] stringArray, String[] stringArray2, String[][] stringArray3) throws IllegalArgumentException {
        super(statement, stringArray, stringArray2, stringArray3.length);
        this.results = stringArray3;
        this.closed = false;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet is closed!", "M1M20");
        }
        if (n < 0) {
            n = this.tupleCount + n + 1;
        }
        if (n < 0) {
            n = 0;
        } else if (n > this.tupleCount + 1) {
            n = this.tupleCount + 1;
        }
        this.curRow = n;
        if (n < 1 || n > this.tupleCount) {
            return false;
        }
        for (int i = 0; i < this.results[n - 1].length; ++i) {
            this.tlp.values[i] = this.results[n - 1][i];
        }
        return true;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.results = null;
        }
    }
}

