/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public final class BufferedMCLReader
extends BufferedReader {
    public static final int UNKNOWN = 0;
    public static final int ERROR = 33;
    public static final int HEADER = 37;
    public static final int RESULT = 91;
    public static final int PROMPT = 46;
    public static final int MORE = 44;
    public static final int SOHEADER = 38;
    public static final int REDIRECT = 94;
    public static final int INFO = 35;
    private int lineType = 0;

    public BufferedMCLReader(Reader reader) {
        super(reader);
    }

    public BufferedMCLReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
        super(new InputStreamReader(inputStream, string));
    }

    @Override
    public String readLine() throws IOException {
        String string = super.readLine();
        this.setLineType(string);
        if (this.lineType == 33 && string != null && !string.matches("^![0-9A-Z]{5}!.+")) {
            string = "!22000!" + string.substring(1);
        }
        return string;
    }

    public void setLineType(String string) {
        if (string == null || string.isEmpty()) {
            this.lineType = 0;
            return;
        }
        switch (string.charAt(0)) {
            case '.': {
                this.lineType = 46;
                break;
            }
            case ',': {
                this.lineType = 44;
                break;
            }
            case '=': 
            case '[': {
                this.lineType = 91;
                break;
            }
            case '%': {
                this.lineType = 37;
                break;
            }
            case '&': {
                this.lineType = 38;
                break;
            }
            case '#': {
                this.lineType = 35;
                break;
            }
            case '!': {
                this.lineType = 33;
                break;
            }
            case '^': {
                this.lineType = 94;
                break;
            }
            default: {
                this.lineType = 0;
            }
        }
    }

    public int getLineType() {
        return this.lineType;
    }

    public final synchronized String waitForPrompt() throws IOException {
        StringBuilder stringBuilder = new StringBuilder(128);
        while (this.lineType != 46) {
            String string = this.readLine();
            if (string == null) {
                throw new IOException("Connection to server lost!");
            }
            if (this.lineType != 33) continue;
            stringBuilder.append('\n').append(string.substring(1));
        }
        return stringBuilder.length() == 0 ? null : stringBuilder.toString().trim();
    }
}

