/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import nl.cwi.monetdb.mcl.MCLException;
import nl.cwi.monetdb.mcl.io.BufferedMCLReader;
import nl.cwi.monetdb.mcl.io.BufferedMCLWriter;
import nl.cwi.monetdb.mcl.parser.MCLParseException;

public final class MapiSocket {
    private Socket con = null;
    private int soTimeout = 0;
    private InputStream fromMonet;
    private OutputStream toMonet;
    private BufferedMCLReader reader;
    private BufferedMCLWriter writer;
    private int version;
    private String database = null;
    private String language = "sql";
    private String hash = null;
    private boolean followRedirects = true;
    private int ttl = 10;
    private boolean debug = false;
    private Writer log;
    public static final int BLOCK = 8190;
    private final byte[] blklen = new byte[2];

    public void setDatabase(String string) {
        this.database = string;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public void setHash(String string) {
        this.hash = string;
    }

    public void setFollowRedirects(boolean bl) {
        this.followRedirects = bl;
    }

    public void setTTL(int n) {
        this.ttl = n;
    }

    public void setSoTimeout(int n) throws SocketException {
        if (n < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.soTimeout = n;
        if (this.con != null) {
            this.con.setSoTimeout(n);
        }
    }

    public int getSoTimeout() throws SocketException {
        if (this.con != null) {
            this.soTimeout = this.con.getSoTimeout();
        }
        return this.soTimeout;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public List<String> connect(String string, int n, String string2, String string3) throws IOException, SocketException, UnknownHostException, MCLParseException, MCLException {
        return this.connect(string, n, string2, string3, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> connect(String string, int n, String string2, String string3, boolean bl) throws IOException, SocketException, UnknownHostException, MCLParseException, MCLException {
        String string4;
        int n2;
        if (this.ttl-- <= 0) {
            throw new MCLException("Maximum number of redirects reached, aborting connection attempt.");
        }
        if (bl) {
            this.con = new Socket(string, n);
            this.con.setSoTimeout(this.soTimeout);
            this.con.setTcpNoDelay(true);
            this.con.setKeepAlive(true);
            this.fromMonet = new BlockInputStream(this.con.getInputStream());
            this.toMonet = new BlockOutputStream(this.con.getOutputStream());
            try {
                this.reader = new BufferedMCLReader(this.fromMonet, "UTF-8");
                this.writer = new BufferedMCLWriter(this.toMonet, "UTF-8");
                this.writer.registerReader(this.reader);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new MCLException(unsupportedEncodingException.toString());
            }
        }
        String string5 = this.reader.readLine();
        this.reader.waitForPrompt();
        this.writer.writeLine(this.getChallengeResponse(string5, string2, string3, this.language, this.database, this.hash));
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string6 = "";
        do {
            if ((string4 = this.reader.readLine()) == null) {
                throw new IOException("Read from " + this.con.getInetAddress().getHostName() + ":" + this.con.getPort() + ": End of stream reached");
            }
            n2 = this.reader.getLineType();
            if (n2 == 33) {
                string6 = string6 + "\n" + string4.substring(7);
                continue;
            }
            if (n2 == 35) {
                arrayList2.add(string4.substring(1));
                continue;
            }
            if (n2 != 94) continue;
            arrayList.add(string4.substring(1));
        } while (n2 != 46);
        if (string6.length() > 0) {
            this.close();
            throw new MCLException(string6);
        }
        if (arrayList.isEmpty()) return arrayList2;
        if (this.followRedirects) {
            URI uRI;
            String string7 = ((String)arrayList.get(0)).toString();
            if (!string7.startsWith("mapi:")) {
                throw new MCLException("unsupported redirect: " + string7);
            }
            try {
                uRI = new URI(string7.substring(5));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new MCLParseException(uRISyntaxException.toString());
            }
            string4 = uRI.getQuery();
            if (string4 != null) {
                String[] stringArray = string4.split("&");
                for (int i = 0; i < stringArray.length; ++i) {
                    int n3 = stringArray[i].indexOf("=");
                    if (n3 > 0) {
                        string4 = stringArray[i].substring(0, n3);
                        if (string4.equals("database")) {
                            string4 = stringArray[i].substring(n3 + 1);
                            if (string4.equals(this.database)) continue;
                            arrayList2.add("redirect points to different database: " + string4);
                            this.setDatabase(string4);
                            continue;
                        }
                        if (string4.equals("language")) {
                            string4 = stringArray[i].substring(n3 + 1);
                            arrayList2.add("redirect specifies use of different language: " + string4);
                            this.setLanguage(string4);
                            continue;
                        }
                        if (string4.equals("user")) {
                            string4 = stringArray[i].substring(n3 + 1);
                            if (string4.equals(string2)) continue;
                            arrayList2.add("ignoring different username '" + string4 + "' set by redirect, what are the security implications?");
                            continue;
                        }
                        if (string4.equals("password")) {
                            arrayList2.add("ignoring different password set by redirect, what are the security implications?");
                            continue;
                        }
                        arrayList2.add("ignoring unknown argument '" + string4 + "' from redirect");
                        continue;
                    }
                    arrayList2.add("ignoring illegal argument from redirect: " + stringArray[i]);
                }
            }
            if (uRI.getScheme().equals("monetdb")) {
                if (this.debug) {
                    this.debug = false;
                    this.close();
                    this.debug = true;
                } else {
                    this.close();
                }
                string4 = uRI.getPath();
                if (string4 != null && string4.length() > 0 && !(string4 = string4.substring(1).trim()).isEmpty() && !string4.equals(this.database)) {
                    arrayList2.add("redirect points to different database: " + string4);
                    this.setDatabase(string4);
                }
                int n4 = uRI.getPort();
                arrayList2.addAll(this.connect(uRI.getHost(), n4 == -1 ? n : n4, string2, string3, true));
                arrayList2.add("Redirect by " + string + ":" + n + " to " + string7);
                return arrayList2;
            } else {
                if (!uRI.getScheme().equals("merovingian")) throw new MCLException("unsupported scheme in redirect: " + string7);
                arrayList2.addAll(this.connect(string, n, string2, string3, false));
            }
            return arrayList2;
        }
        StringBuilder stringBuilder = new StringBuilder("The server sent a redirect for this connection:");
        for (String string8 : arrayList) {
            stringBuilder.append(" [" + string8 + "]");
        }
        throw new MCLException(stringBuilder.toString());
    }

    private String getChallengeResponse(String string, String string2, String string3, String string4, String string5, String string6) throws MCLParseException, MCLException, IOException {
        String[] stringArray = string.split(":");
        if (stringArray.length <= 5) {
            throw new MCLParseException("Server challenge string unusable! It contains too few (" + stringArray.length + ") tokens: " + string);
        }
        try {
            this.version = Integer.parseInt(stringArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MCLParseException("Protocol version (" + stringArray[2] + ") unparseable as integer.");
        }
        switch (this.version) {
            case 9: {
                Object object;
                String string7;
                String string8 = stringArray[5];
                if (string8.equals("SHA512")) {
                    string7 = "SHA-512";
                } else if (string8.equals("SHA384")) {
                    string7 = "SHA-384";
                } else if (string8.equals("SHA256")) {
                    string7 = "SHA-256";
                } else if (string8.equals("SHA1")) {
                    string7 = "SHA-1";
                } else if (string8.equals("MD5")) {
                    string7 = "MD5";
                } else {
                    throw new MCLException("Unsupported password hash: " + string8);
                }
                try {
                    object = MessageDigest.getInstance(string7);
                    ((MessageDigest)object).update(string3.getBytes("UTF-8"));
                    string3 = MapiSocket.toHex(((MessageDigest)object).digest());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new MCLException("This JVM does not support password hash: " + string8 + "\n" + noSuchAlgorithmException.toString());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new MCLException("This JVM does not support UTF-8 encoding\n" + unsupportedEncodingException.toString());
                }
                object = string6 == null || string6.isEmpty() ? stringArray[3] : string6;
                HashSet<String> hashSet = new HashSet<String>(Arrays.asList(((String)object).toUpperCase().split("[, ]")));
                if (stringArray[1].equals("merovingian") && !string4.equals("control")) {
                    string2 = "merovingian";
                    string3 = "merovingian";
                }
                string7 = null;
                string8 = null;
                if (hashSet.contains("SHA512")) {
                    string7 = "SHA-512";
                    string8 = "{SHA512}";
                } else if (hashSet.contains("SHA384")) {
                    string7 = "SHA-384";
                    string8 = "{SHA384}";
                } else if (hashSet.contains("SHA256")) {
                    string7 = "SHA-256";
                    string8 = "{SHA256}";
                } else if (hashSet.contains("SHA1")) {
                    string7 = "SHA-1";
                    string8 = "{SHA1}";
                } else if (hashSet.contains("MD5")) {
                    string7 = "MD5";
                    string8 = "{MD5}";
                } else {
                    throw new MCLException("no supported hash algorithms found in " + (String)object);
                }
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance(string7);
                    messageDigest.update(string3.getBytes("UTF-8"));
                    messageDigest.update(stringArray[0].getBytes("UTF-8"));
                    string8 = string8 + MapiSocket.toHex(messageDigest.digest());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new MCLException("This JVM does not support password hash: " + string8 + "\n" + noSuchAlgorithmException.toString());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new MCLException("This JVM does not support UTF-8 encoding\n" + unsupportedEncodingException.toString());
                }
                if (!stringArray[4].equals("BIG") && !stringArray[4].equals("LIT")) {
                    throw new MCLParseException("Invalid byte-order: " + stringArray[4]);
                }
                return "BIG:" + string2 + ":" + string8 + ":" + string4 + ":" + (string5 == null ? "" : string5) + ":";
            }
        }
        throw new MCLException("Unsupported protocol version: " + this.version);
    }

    private static final String toHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            cArray[n++] = MapiSocket.hexChar((byArray[i] & 0xF0) >> 4);
            cArray[n++] = MapiSocket.hexChar(byArray[i] & 0xF);
        }
        return new String(cArray);
    }

    private static final char hexChar(int n) {
        return n > 9 ? (char)(97 + (n - 10)) : (char)(48 + n);
    }

    public InputStream getInputStream() {
        return this.fromMonet;
    }

    public OutputStream getOutputStream() {
        return this.toMonet;
    }

    public BufferedMCLReader getReader() {
        return this.reader;
    }

    public BufferedMCLWriter getWriter() {
        return this.writer;
    }

    public int getProtocolVersion() {
        return this.version;
    }

    public void debug(String string) throws IOException {
        this.debug(new FileWriter(string));
    }

    public void debug(Writer writer) {
        this.log = writer;
        this.debug = true;
    }

    public Writer getLogWriter() {
        return this.log;
    }

    private final void log(String string, String string2, boolean bl) throws IOException {
        this.log.write(string + System.currentTimeMillis() + ": " + string2 + "\n");
        if (bl) {
            this.log.flush();
        }
    }

    public synchronized void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.reader != null) {
            try {
                this.reader.close();
                this.reader = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.toMonet != null) {
            try {
                this.toMonet.close();
                this.toMonet = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.fromMonet != null) {
            try {
                this.fromMonet.close();
                this.fromMonet = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.con != null) {
            try {
                this.con.close();
                this.con = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.debug && this.log != null && this.log instanceof FileWriter) {
            try {
                this.log.close();
                this.log = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Deprecated
    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    final class BlockInputStream
    extends FilterInputStream {
        private int readPos;
        private int blockLen;
        private final byte[] block;

        public BlockInputStream(InputStream inputStream) {
            super(new BufferedInputStream(inputStream));
            this.readPos = 0;
            this.blockLen = 0;
            this.block = new byte[8193];
        }

        @Override
        public int available() {
            return this.blockLen - this.readPos;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void mark(int n) {
            throw new AssertionError((Object)"Not implemented!");
        }

        @Override
        public void reset() {
            throw new AssertionError((Object)"Not implemented!");
        }

        private boolean _read(byte[] byArray, int n) throws IOException {
            int n2 = 0;
            while (n > 0) {
                int n3 = this.in.read(byArray, n2, n);
                if (n3 == -1) {
                    if (n2 > 0) {
                        if (MapiSocket.this.debug) {
                            MapiSocket.this.log("RD ", "the following incomplete block was received:", false);
                            MapiSocket.this.log("RX ", new String(byArray, 0, n2, "UTF-8"), true);
                        }
                        throw new IOException("Read from " + MapiSocket.this.con.getInetAddress().getHostName() + ":" + MapiSocket.this.con.getPort() + ": Incomplete block read from stream");
                    }
                    if (MapiSocket.this.debug) {
                        MapiSocket.this.log("RD ", "server closed the connection (EOF)", true);
                    }
                    return false;
                }
                n -= n3;
                n2 += n3;
            }
            return true;
        }

        private int readBlock() throws IOException {
            if (!this._read(MapiSocket.this.blklen, 2)) {
                return -1;
            }
            this.blockLen = (short)((MapiSocket.this.blklen[0] & 0xFF) >> 1 | (MapiSocket.this.blklen[1] & 0xFF) << 7);
            this.readPos = 0;
            if (MapiSocket.this.debug) {
                if ((MapiSocket.this.blklen[0] & 1) == 1) {
                    MapiSocket.this.log("RD ", "read final block: " + this.blockLen + " bytes", false);
                } else {
                    MapiSocket.this.log("RD ", "read new block: " + this.blockLen + " bytes", false);
                }
            }
            if (this.blockLen > this.block.length) {
                throw new IOException("Server sent a block larger than BLOCKsize: " + this.blockLen + " > " + this.block.length);
            }
            if (!this._read(this.block, this.blockLen)) {
                return -1;
            }
            if (MapiSocket.this.debug) {
                MapiSocket.this.log("RX ", new String(this.block, 0, this.blockLen, "UTF-8"), true);
            }
            if ((MapiSocket.this.blklen[0] & 1) == 1) {
                if (this.blockLen > 0 && this.block[this.blockLen - 1] != 10) {
                    this.block[this.blockLen++] = 10;
                }
                this.block[this.blockLen++] = 46;
                this.block[this.blockLen++] = 10;
                if (MapiSocket.this.debug) {
                    MapiSocket.this.log("RD ", "inserting prompt", true);
                }
            }
            return this.blockLen;
        }

        @Override
        public int read() throws IOException {
            if (this.available() == 0 && this.readBlock() == -1) {
                return -1;
            }
            if (MapiSocket.this.debug) {
                MapiSocket.this.log("RX ", new String(this.block, this.readPos, 1, "UTF-8"), true);
            }
            return this.block[this.readPos++];
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            int n4;
            for (n3 = 0; n3 < n2; n3 += n4) {
                n4 = this.available();
                if (n4 == 0) {
                    if (n3 != 0) break;
                    if (this.readBlock() == -1) {
                        if (n3 != 0) break;
                        n3 = -1;
                        break;
                    }
                    n4 = this.available();
                }
                if (n2 > n4) {
                    System.arraycopy(this.block, this.readPos, byArray, n, n4);
                    n += n4;
                    n2 -= n4;
                    this.readPos += n4;
                    continue;
                }
                System.arraycopy(this.block, this.readPos, byArray, n, n2);
                this.readPos += n2;
                n3 += n2;
                break;
            }
            return n3;
        }

        @Override
        public long skip(long l) throws IOException {
            long l2 = l;
            int n = 0;
            while (l2 > 0L) {
                n = this.available();
                if (l2 > (long)n) {
                    l2 -= (long)n;
                    this.readPos += n;
                    this.readBlock();
                    continue;
                }
                this.readPos = (int)((long)this.readPos + l2);
                break;
            }
            return l;
        }
    }

    final class BlockOutputStream
    extends FilterOutputStream {
        private int writePos;
        private int blocksize;
        private final byte[] block;

        public BlockOutputStream(OutputStream outputStream) {
            super(new BufferedOutputStream(outputStream));
            this.writePos = 0;
            this.blocksize = 0;
            this.block = new byte[8190];
        }

        @Override
        public void flush() throws IOException {
            this.writeBlock(true);
            this.out.flush();
            if (MapiSocket.this.debug) {
                MapiSocket.this.log.flush();
            }
        }

        public void writeBlock(boolean bl) throws IOException {
            if (bl) {
                this.blocksize = (short)this.writePos;
                ((MapiSocket)MapiSocket.this).blklen[0] = (byte)(this.blocksize << 1 & 0xFF | 1);
                ((MapiSocket)MapiSocket.this).blklen[1] = (byte)(this.blocksize >> 7);
            } else {
                this.blocksize = 8190;
                ((MapiSocket)MapiSocket.this).blklen[0] = (byte)(this.blocksize << 1 & 0xFF);
                ((MapiSocket)MapiSocket.this).blklen[1] = (byte)(this.blocksize >> 7);
            }
            this.out.write(MapiSocket.this.blklen);
            this.out.write(this.block, 0, this.writePos);
            if (MapiSocket.this.debug) {
                if (bl) {
                    MapiSocket.this.log("TD ", "write final block: " + this.writePos + " bytes", false);
                } else {
                    MapiSocket.this.log("TD ", "write block: " + this.writePos + " bytes", false);
                }
                MapiSocket.this.log("TX ", new String(this.block, 0, this.writePos, "UTF-8"), true);
            }
            this.writePos = 0;
        }

        @Override
        public void write(int n) throws IOException {
            if (this.writePos == 8190) {
                this.writeBlock(false);
            }
            this.block[this.writePos++] = (byte)n;
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n2 > 0) {
                n3 = 8190 - this.writePos;
                if (n2 > n3) {
                    System.arraycopy(byArray, n, this.block, this.writePos, n3);
                    n += n3;
                    n2 -= n3;
                    this.writePos += n3;
                    this.writeBlock(false);
                    continue;
                }
                System.arraycopy(byArray, n, this.block, this.writePos, n2);
                this.writePos += n2;
                break;
            }
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

