/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.jdbc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import org.monetdb.jdbc.MonetBlob;
import org.monetdb.jdbc.MonetCallableStatement;
import org.monetdb.jdbc.MonetClob;
import org.monetdb.jdbc.MonetDatabaseMetaData;
import org.monetdb.jdbc.MonetPreparedStatement;
import org.monetdb.jdbc.MonetSavepoint;
import org.monetdb.jdbc.MonetStatement;
import org.monetdb.jdbc.MonetWrapper;
import org.monetdb.jdbc.types.INET;
import org.monetdb.jdbc.types.URL;
import org.monetdb.mcl.MCLException;
import org.monetdb.mcl.io.BufferedMCLReader;
import org.monetdb.mcl.io.BufferedMCLWriter;
import org.monetdb.mcl.io.LineType;
import org.monetdb.mcl.net.HandshakeOptions;
import org.monetdb.mcl.net.MapiSocket;
import org.monetdb.mcl.parser.HeaderLineParser;
import org.monetdb.mcl.parser.MCLParseException;
import org.monetdb.mcl.parser.StartOfHeaderParser;

public class MonetConnection
extends MonetWrapper
implements Connection,
AutoCloseable {
    private final Properties conn_props = new Properties();
    private final String hostname;
    private int port;
    private final String database;
    private final String username;
    private final String password;
    private final MapiSocket server;
    private final BufferedMCLReader in;
    private final BufferedMCLWriter out;
    private final StartOfHeaderParser sohp = new StartOfHeaderParser();
    private boolean closed;
    private boolean autoCommit = true;
    private SQLWarning warnings;
    private Map<String, Class<?>> typeMap = new HashMap<String, Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("inet", INET.class);
            this.put("url", URL.class);
        }
    };
    private final WeakHashMap<Statement, ?> statements = new WeakHashMap();
    private int curReplySize = 100;
    final String[] queryTempl = new String[3];
    private final String[] commandTempl = new String[2];
    private static final int LANG_SQL = 0;
    private static final int LANG_MAL = 3;
    private static final int LANG_UNKNOWN = -1;
    private final int lang;
    private boolean treatBlobAsVarBinary = true;
    private boolean treatClobAsVarChar = true;
    protected int lastSetQueryTimeout;
    private DatabaseMetaData dbmd;
    private UploadHandler uploadHandler;
    private DownloadHandler downloadHandler;
    private String env_current_user;
    private String env_monet_version;
    private int maxConnections;
    private int databaseMajorVersion;
    private int databaseMinorVersion;
    private boolean queriedPrivilege_codesTable = false;
    private boolean hasPrivilege_codesTable = false;
    private boolean queriedCommentsTable = false;
    private boolean hasCommentsTable = false;
    private static final int DEF_FETCHSIZE = 250;
    private int defaultFetchSize = 250;
    private static int seqCounter = 0;

    MonetConnection(Properties properties) throws SQLException, IllegalArgumentException {
        Object object;
        Object object2;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        this.hostname = properties.getProperty("host");
        if (this.hostname != null) {
            this.conn_props.setProperty("host", this.hostname);
        }
        if ((string6 = properties.getProperty("port")) != null) {
            try {
                this.port = Integer.parseInt(string6);
            }
            catch (NumberFormatException numberFormatException) {
                this.addWarning("Unable to parse port number from: " + string6, "M1M05");
            }
            this.conn_props.setProperty("port", Integer.toString(this.port));
        }
        this.database = properties.getProperty("database");
        if (this.database != null) {
            this.conn_props.setProperty("database", this.database);
        }
        this.username = properties.getProperty("user");
        if (this.username != null) {
            this.conn_props.setProperty("user", this.username);
        }
        this.password = properties.getProperty("password");
        if (this.password != null) {
            this.conn_props.setProperty("password", this.password);
        }
        if ((string5 = properties.getProperty("language")) != null) {
            this.conn_props.setProperty("language", string5);
        }
        boolean bl = false;
        String string7 = properties.getProperty("debug");
        if (string7 != null) {
            bl = Boolean.parseBoolean(string7);
            this.conn_props.setProperty("debug", Boolean.toString(bl));
        }
        if ((string4 = properties.getProperty("hash")) != null) {
            this.conn_props.setProperty("hash", string4);
        }
        if ((string3 = properties.getProperty("fetchsize")) != null) {
            try {
                int n = Integer.parseInt(string3);
                if (n > 0 || n == -1) {
                    this.defaultFetchSize = n;
                    this.conn_props.setProperty("fetchsize", string3);
                } else {
                    this.addWarning("Fetch size must either be positive or -1. Value " + n + " ignored", "M1M05");
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.addWarning("Unable to parse fetch size number from: " + string3, "M1M05");
            }
        }
        if ((string2 = properties.getProperty("treat_blob_as_binary")) != null) {
            this.treatBlobAsVarBinary = Boolean.parseBoolean(string2);
            this.conn_props.setProperty("treat_blob_as_binary", Boolean.toString(this.treatBlobAsVarBinary));
            if (this.treatBlobAsVarBinary) {
                this.typeMap.put("blob", Byte[].class);
            }
        }
        if ((string = properties.getProperty("treat_clob_as_varchar")) != null) {
            this.treatClobAsVarChar = Boolean.parseBoolean(string);
            this.conn_props.setProperty("treat_clob_as_varchar", Boolean.toString(this.treatClobAsVarChar));
            if (this.treatClobAsVarChar) {
                this.typeMap.put("clob", String.class);
            }
        }
        int n = 0;
        String string8 = properties.getProperty("so_timeout");
        if (string8 != null) {
            try {
                n = Integer.parseInt(string8);
                if (n < 0) {
                    this.addWarning("Negative socket timeout not allowed. Value ignored", "M1M05");
                    n = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.addWarning("Unable to parse socket timeout number from: " + string8, "M1M05");
            }
            this.conn_props.setProperty("so_timeout", Integer.toString(n));
        }
        if (this.hostname == null || this.hostname.isEmpty()) {
            throw new IllegalArgumentException("Missing or empty host name");
        }
        if (this.port <= 0 || this.port > 65535) {
            throw new IllegalArgumentException("Invalid port number: " + this.port + ". It should not be " + (this.port < 0 ? "negative" : (this.port > 65535 ? "larger than 65535" : "0")));
        }
        if (this.username == null || this.username.isEmpty()) {
            throw new IllegalArgumentException("Missing or empty user name");
        }
        if (this.password == null || this.password.isEmpty()) {
            throw new IllegalArgumentException("Missing or empty password");
        }
        if (string5 == null || string5.isEmpty()) {
            string5 = "sql";
            this.addWarning("No language specified, defaulting to 'sql'", "M1M05");
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.checkValidProperty(entry.getKey().toString(), "MonetConnection");
        }
        this.server = new MapiSocket();
        if (string4 != null) {
            this.server.setHash(string4);
        }
        if (this.database != null) {
            this.server.setDatabase(this.database);
        }
        this.server.setLanguage(string5);
        Calendar calendar = Calendar.getInstance();
        int n2 = calendar.get(15) + calendar.get(16);
        int n3 = n2 / 1000;
        HandshakeOptions handshakeOptions = new HandshakeOptions();
        handshakeOptions.setTimeZone(n3);
        handshakeOptions.setReplySize(this.defaultFetchSize);
        this.server.setHandshakeOptions(handshakeOptions);
        if (bl) {
            try {
                object2 = properties.getProperty("logfile", "monet_" + System.currentTimeMillis() + ".log");
                object = new File((String)object2);
                int n4 = ((String)object2).lastIndexOf(46);
                if (n4 < 0) {
                    n4 = ((String)object2).length();
                }
                String string9 = ((String)object2).substring(0, n4);
                String string10 = ((String)object2).substring(n4);
                int n5 = 1;
                while (((File)object).exists()) {
                    object = new File(string9 + "-" + n5 + string10);
                    ++n5;
                }
                this.server.debug(((File)object).getAbsolutePath());
            }
            catch (IOException iOException) {
                throw new SQLNonTransientConnectionException("Opening logfile failed: " + iOException.getMessage(), "08M01");
            }
        }
        try {
            object2 = this.server.connect(this.hostname, this.port, this.username, this.password);
            object = object2.iterator();
            while (object.hasNext()) {
                String string11 = (String)object.next();
                this.addWarning(string11, "01M02");
            }
            this.server.setSoTimeout(n);
            this.in = this.server.getReader();
            this.out = this.server.getWriter();
            object = this.in.waitForPrompt();
            if (object != null) {
                throw new SQLNonTransientConnectionException((String)(((String)object).length() > 6 ? ((String)object).substring(6) : object), "08001");
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new SQLNonTransientConnectionException("Unknown Host (" + this.hostname + "): " + unknownHostException.getMessage(), "08006");
        }
        catch (IOException iOException) {
            throw new SQLNonTransientConnectionException("Unable to connect (" + this.hostname + ":" + this.port + "): " + iOException.getMessage(), "08006");
        }
        catch (MCLParseException mCLParseException) {
            throw new SQLNonTransientConnectionException(mCLParseException.getMessage(), "08001");
        }
        catch (MCLException mCLException) {
            object = mCLException.getMessage().split("\n");
            SQLNonTransientConnectionException sQLNonTransientConnectionException = new SQLNonTransientConnectionException(object[0], "08001", mCLException);
            for (int i = 1; i < ((Object)object).length; ++i) {
                sQLNonTransientConnectionException.setNextException(new SQLNonTransientConnectionException((String)object[1], "08001"));
            }
            throw sQLNonTransientConnectionException;
        }
        if ("sql".equals(string5)) {
            this.lang = 0;
            this.queryTempl[0] = "s";
            this.queryTempl[1] = "\n;";
            this.queryTempl[2] = "\n;\n";
            this.commandTempl[0] = "X";
            this.commandTempl[1] = "";
        } else if ("mal".equals(string5)) {
            this.lang = 3;
            this.queryTempl[0] = "";
            this.queryTempl[1] = ";\n";
            this.queryTempl[2] = ";\n";
            this.commandTempl[0] = "";
            this.commandTempl[1] = "";
        } else {
            this.lang = -1;
        }
        if (!handshakeOptions.mustSendReplySize()) {
            this.curReplySize = handshakeOptions.getReplySize();
        }
        if (this.lang == 0) {
            this.setAutoCommit(true);
            if (handshakeOptions.mustSendTimeZone()) {
                object2 = new StringBuilder(64);
                ((StringBuilder)object2).append("SET TIME ZONE INTERVAL '");
                int n6 = handshakeOptions.getTimeZone() / 60;
                if (n6 < 0) {
                    ((StringBuilder)object2).append('-');
                    n6 = -n6;
                } else {
                    ((StringBuilder)object2).append('+');
                }
                int n7 = n6 / 60;
                if (n7 < 10) {
                    ((StringBuilder)object2).append('0');
                }
                ((StringBuilder)object2).append(n7).append(':');
                if ((n6 -= n7 * 60) < 10) {
                    ((StringBuilder)object2).append('0');
                }
                ((StringBuilder)object2).append(n6).append("' HOUR TO MINUTE");
                this.sendIndependentCommand(((StringBuilder)object2).toString());
            }
        }
        this.closed = false;
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.clearWarnings();
        this.dbmd = null;
        MapiSocket mapiSocket = this.server;
        synchronized (mapiSocket) {
            for (Statement statement : this.statements.keySet()) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            this.server.close();
            this.closed = true;
        }
    }

    @Override
    public void commit() throws SQLException {
        this.sendTransactionCommand("COMMIT");
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 1);
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement(n, n2, 1);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        try {
            MonetStatement monetStatement = new MonetStatement(this, n, n2, n3);
            this.statements.put(monetStatement, null);
            return monetStatement;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException.toString(), "M0M03");
        }
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public int getHoldability() {
        return 1;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.lang != 0) {
            throw new SQLException("This method is only supported in SQL mode", "M0M04");
        }
        if (this.dbmd == null) {
            this.dbmd = new MonetDatabaseMetaData(this);
        }
        return this.dbmd;
    }

    @Override
    public int getTransactionIsolation() {
        return 8;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return this.typeMap;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return this.warnings;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String nativeSQL(String string) {
        return string;
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007, 1);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string, n, n2, 1);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkNotClosed();
        try {
            MonetCallableStatement monetCallableStatement = new MonetCallableStatement(this, n, n2, n3, string);
            this.statements.put(monetCallableStatement, null);
            return monetCallableStatement;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException.toString(), "M0M03");
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string, n, n2, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkNotClosed();
        try {
            MonetPreparedStatement monetPreparedStatement = new MonetPreparedStatement(this, n, n2, n3, string);
            this.statements.put(monetPreparedStatement, null);
            return monetPreparedStatement;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException.toString(), "M0M03");
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (n != 1 && n != 2) {
            throw new SQLException("Invalid argument, expected RETURN_GENERATED_KEYS or NO_GENERATED_KEYS", "M1M05");
        }
        return this.prepareStatement(string, 1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw MonetConnection.newSQLFeatureNotSupportedException("prepareStatement(String sql, int[] columnIndexes)");
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw MonetConnection.newSQLFeatureNotSupportedException("prepareStatement(String sql, String[] columnNames)");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkNotClosed();
        if (!(savepoint instanceof MonetSavepoint)) {
            throw new SQLException("This driver can only handle savepoints it created itself", "M0M06");
        }
        MonetSavepoint monetSavepoint = (MonetSavepoint)savepoint;
        this.sendTransactionCommand("RELEASE SAVEPOINT " + monetSavepoint.getName());
    }

    @Override
    public void rollback() throws SQLException {
        this.checkNotClosed();
        this.sendTransactionCommand("ROLLBACK");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkNotClosed();
        if (!(savepoint instanceof MonetSavepoint)) {
            throw new SQLException("This driver can only handle savepoints it created itself", "M0M06");
        }
        MonetSavepoint monetSavepoint = (MonetSavepoint)savepoint;
        this.sendTransactionCommand("ROLLBACK TO SAVEPOINT " + monetSavepoint.getName());
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkNotClosed();
        if (this.autoCommit != bl) {
            this.sendControlCommand(bl ? "auto_commit 1" : "auto_commit 0");
            this.autoCommit = bl;
        }
    }

    @Override
    public void setCatalog(String string) {
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        if (n != 1) {
            throw MonetConnection.newSQLFeatureNotSupportedException("setHoldability(CLOSE_CURSORS_AT_COMMIT)");
        }
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        if (bl) {
            this.addWarning("cannot setReadOnly(true): read-only Connection mode not supported", "01M08");
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint(null);
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        MonetSavepoint monetSavepoint;
        this.checkNotClosed();
        try {
            monetSavepoint = string != null ? new MonetSavepoint(string) : new MonetSavepoint();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException.getMessage(), "M0M03");
        }
        this.sendTransactionCommand("SAVEPOINT " + monetSavepoint.getName());
        return monetSavepoint;
    }

    @Override
    public void setTransactionIsolation(int n) {
        if (n != 8) {
            this.addWarning("MonetDB only supports fully serializable transactions, continuing with transaction level raised to TRANSACTION_SERIALIZABLE", "01M09");
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) {
        this.typeMap = map;
    }

    public String toString() {
        return "MonetDB Connection (" + this.getJDBCURL() + (this.closed ? ") disconnected" : ") connected");
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw MonetConnection.newSQLFeatureNotSupportedException("createArrayOf");
    }

    @Override
    public Clob createClob() throws SQLException {
        return new MonetClob("");
    }

    @Override
    public Blob createBlob() throws SQLException {
        return new MonetBlob(new byte[1]);
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw MonetConnection.newSQLFeatureNotSupportedException("createNClob");
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw MonetConnection.newSQLFeatureNotSupportedException("createStruct");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw MonetConnection.newSQLFeatureNotSupportedException("createSQLXML");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int n) throws SQLException {
        int n2;
        boolean bl;
        ResultSet resultSet;
        Statement statement;
        block16: {
            if (n < 0) {
                throw new SQLException("timeout is less than 0", "M1M05");
            }
            if (this.closed) {
                return false;
            }
            statement = null;
            resultSet = null;
            bl = false;
            n2 = this.lastSetQueryTimeout;
            try {
                statement = this.createStatement();
                if (statement == null) break block16;
                if (n > 0 && n2 != n) {
                    statement.setQueryTimeout(n);
                }
                if ((resultSet = statement.executeQuery("SELECT 1")) == null || !resultSet.next()) break block16;
                bl = true;
            }
            catch (SQLException sQLException) {
                block17: {
                    try {
                        String string = sQLException.getMessage();
                        if (string == null || !string.equalsIgnoreCase("Current transaction is aborted (please ROLLBACK)")) break block17;
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        MonetConnection.closeResultsetStatement(resultSet, statement);
                        if (n > 0 && n2 != this.lastSetQueryTimeout) {
                            this.lastSetQueryTimeout = n2;
                            try {
                                this.setQueryTimeout(n2);
                            }
                            catch (SQLException sQLException2) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                MonetConnection.closeResultsetStatement(resultSet, statement);
                if (n > 0 && n2 != this.lastSetQueryTimeout) {
                    this.lastSetQueryTimeout = n2;
                    try {
                        this.setQueryTimeout(n2);
                    }
                    catch (SQLException sQLException3) {}
                }
            }
        }
        MonetConnection.closeResultsetStatement(resultSet, statement);
        if (n > 0 && n2 != this.lastSetQueryTimeout) {
            this.lastSetQueryTimeout = n2;
            try {
                this.setQueryTimeout(n2);
            }
            catch (SQLException sQLException) {}
        }
        return bl;
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        this.checkNotClosed();
        return this.conn_props.getProperty(string);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkNotClosed();
        return new Properties(this.conn_props);
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        if (string == null || string.isEmpty()) {
            this.addWarning("setClientInfo: missing property name", "01M07");
            return;
        }
        if (string2 == null) {
            if (this.conn_props.containsKey(string)) {
                this.conn_props.remove(string);
            }
            return;
        }
        if (this.checkValidProperty(string, "setClientInfo")) {
            this.conn_props.setProperty(string, string2);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.setClientInfo(entry.getKey().toString(), entry.getValue().toString());
            }
        }
    }

    @Override
    public void setSchema(String string) throws SQLException {
        this.checkNotClosed();
        if (string == null || string.isEmpty()) {
            throw new SQLException("Missing schema name", "M1M05");
        }
        Statement statement = null;
        try {
            statement = this.createStatement();
            if (statement != null) {
                statement.execute("SET SCHEMA \"" + string + "\"");
            }
        }
        finally {
            MonetConnection.closeResultsetStatement(null, statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() throws SQLException {
        this.checkNotClosed();
        String string = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.createStatement();
            if (statement != null && (resultSet = statement.executeQuery("SELECT CURRENT_SCHEMA")) != null && resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        finally {
            MonetConnection.closeResultsetStatement(resultSet, statement);
        }
        if (string == null) {
            throw new SQLException("Failed to fetch schema name", "02000");
        }
        return string;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.closed) {
            return;
        }
        if (executor == null) {
            throw new SQLException("executor is null", "M1M05");
        }
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        this.checkNotClosed();
        if (n < 0) {
            throw new SQLException("milliseconds is less than zero", "M1M05");
        }
        try {
            this.server.setSoTimeout(n);
        }
        catch (SocketException socketException) {
            throw new SQLNonTransientConnectionException(socketException.getMessage(), "08000");
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkNotClosed();
        try {
            return this.server.getSoTimeout();
        }
        catch (SocketException socketException) {
            throw new SQLNonTransientConnectionException(socketException.getMessage(), "08000");
        }
    }

    public void setUploadHandler(UploadHandler uploadHandler) {
        this.uploadHandler = uploadHandler;
    }

    public UploadHandler getUploadHandler() {
        return this.uploadHandler;
    }

    public void setDownloadHandler(DownloadHandler downloadHandler) {
        this.downloadHandler = downloadHandler;
    }

    public DownloadHandler getDownloadHandler() {
        return this.downloadHandler;
    }

    private void checkNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection is closed", "M1M20");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setQueryTimeout(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("query timeout milliseconds is less than zero", "M1M05");
        }
        this.checkNotClosed();
        Statement statement = null;
        try {
            String string = this.getDatabaseMajorVersion() == 11 && this.getDatabaseMinorVersion() < 37 ? "CALL sys.\"settimeout\"(" + n + ")" : "CALL sys.\"setquerytimeout\"(" + n + ")";
            statement = this.createStatement();
            statement.execute(string);
            this.lastSetQueryTimeout = n;
        }
        catch (Throwable throwable) {
            MonetConnection.closeResultsetStatement(null, statement);
            throw throwable;
        }
        MonetConnection.closeResultsetStatement(null, statement);
    }

    boolean mapBlobAsVarBinary() {
        return this.treatBlobAsVarBinary;
    }

    boolean mapClobAsVarChar() {
        return this.treatClobAsVarChar;
    }

    String getJDBCURL() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("jdbc:monetdb://").append(this.hostname).append(':').append(this.port).append('/').append(this.database);
        if (this.lang == 3) {
            stringBuilder.append("?language=mal");
        }
        return stringBuilder.toString();
    }

    private boolean checkValidProperty(String string, String string2) {
        if (this.isValidProperty(string)) {
            return true;
        }
        this.addWarning(string2 + ": '" + string + "' is not a recognised property", "01M07");
        return false;
    }

    private boolean isValidProperty(String string) {
        return string.equals("host") || string.equals("port") || string.equals("user") || string.equals("password") || string.equals("language") || string.equals("database") || string.equals("debug") || string.equals("logfile") || string.equals("hash") || string.equals("treat_blob_as_binary") || string.equals("treat_clob_as_varchar") || string.equals("so_timeout") || string.equals("fetchsize");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void getEnvValues() throws SQLException {
        block8: {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = this.createStatement();
                if (statement == null || (resultSet = statement.executeQuery("SELECT \"name\", \"value\" FROM \"sys\".\"env\"() WHERE \"name\" IN ('monet_version', 'max_clients') UNION SELECT 'current_user' as \"name\", current_user as \"value\"")) == null) break block8;
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    if ("current_user".equals(string)) {
                        this.env_current_user = string2;
                        continue;
                    }
                    if ("monet_version".equals(string)) {
                        this.env_monet_version = string2;
                        continue;
                    }
                    if (!"max_clients".equals(string) || string2 == null) continue;
                    try {
                        this.maxConnections = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (this.maxConnections > 0) continue;
                    this.maxConnections = 1;
                }
            }
            finally {
                MonetConnection.closeResultsetStatement(resultSet, statement);
            }
        }
    }

    String getUserName() throws SQLException {
        if (this.env_current_user == null) {
            this.getEnvValues();
        }
        return this.env_current_user;
    }

    int getMaxConnections() throws SQLException {
        if (this.maxConnections == 0) {
            this.getEnvValues();
        }
        return this.maxConnections;
    }

    String getDatabaseProductVersion() throws SQLException {
        if (this.env_monet_version == null) {
            this.getEnvValues();
        }
        if (this.env_monet_version != null) {
            return this.env_monet_version;
        }
        return "";
    }

    int getDatabaseMajorVersion() throws SQLException {
        if (this.databaseMajorVersion == 0) {
            if (this.env_monet_version == null) {
                this.getEnvValues();
            }
            if (this.env_monet_version != null) {
                try {
                    int n = this.env_monet_version.indexOf(46);
                    this.databaseMajorVersion = Integer.parseInt(n >= 0 ? this.env_monet_version.substring(0, n) : this.env_monet_version);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return this.databaseMajorVersion;
    }

    int getDatabaseMinorVersion() throws SQLException {
        if (this.databaseMinorVersion == 0) {
            if (this.env_monet_version == null) {
                this.getEnvValues();
            }
            if (this.env_monet_version != null) {
                try {
                    int n = this.env_monet_version.indexOf(46);
                    if (n >= 0) {
                        int n2;
                        this.databaseMinorVersion = Integer.parseInt((n2 = this.env_monet_version.indexOf(46, ++n)) > 0 ? this.env_monet_version.substring(n, n2) : this.env_monet_version.substring(n));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return this.databaseMinorVersion;
    }

    boolean privilege_codesTableExists() {
        if (!this.queriedPrivilege_codesTable) {
            this.hasPrivilege_codesTable = this.existsSysTable("privilege_codes");
            this.queriedPrivilege_codesTable = true;
        }
        return this.hasPrivilege_codesTable;
    }

    boolean commentsTableExists() {
        if (!this.queriedCommentsTable) {
            this.hasCommentsTable = this.existsSysTable("comments");
            this.queriedCommentsTable = true;
        }
        return this.hasCommentsTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsSysTable(String string) {
        boolean bl = false;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.createStatement();
            if (statement != null && (resultSet = statement.executeQuery("SELECT id FROM sys._tables WHERE name = '" + string + "' AND schema_id IN (SELECT id FROM sys.schemas WHERE name = 'sys')")) != null) {
                bl = resultSet.next();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            MonetConnection.closeResultsetStatement(resultSet, statement);
        }
        return bl;
    }

    static final void closeResultsetStatement(ResultSet resultSet, Statement statement) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void sendTransactionCommand(String string) throws SQLException {
        try (ResponseList responseList = new ResponseList(0, 0L, 1000, 1007);){
            responseList.processQuery(string);
        }
    }

    private void sendIndependentCommand(String string) throws SQLException {
        this.sendCommand(string, true);
    }

    void sendControlCommand(String string) throws SQLException {
        this.sendCommand(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(String string, boolean bl) throws SQLException {
        MapiSocket mapiSocket = this.server;
        synchronized (mapiSocket) {
            try {
                if (bl) {
                    this.out.writeLine(this.queryTempl[0] + string + this.queryTempl[1]);
                } else {
                    this.out.writeLine(this.commandTempl[0] + string + this.commandTempl[1]);
                }
                String string2 = this.in.waitForPrompt();
                if (string2 != null) {
                    throw new SQLException(string2.substring(6), string2.substring(0, 5));
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.close();
                throw new SQLNonTransientConnectionException("connection timed out", "08M33");
            }
            catch (IOException iOException) {
                throw new SQLNonTransientConnectionException(iOException.getMessage(), "08000");
            }
        }
    }

    private final void addWarning(String string, String string2) {
        SQLWarning sQLWarning = new SQLWarning(string, string2);
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    private String handleTransfer(String string) throws IOException {
        if (string.startsWith("r ")) {
            String[] stringArray = string.split(" ", 3);
            if (stringArray.length == 3) {
                long l;
                try {
                    l = Long.parseLong(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    return numberFormatException.toString();
                }
                return this.handleUpload(stringArray[2], true, l);
            }
        } else {
            if (string.startsWith("rb ")) {
                return this.handleUpload(string.substring(3), false, 0L);
            }
            if (string.startsWith("w ")) {
                return this.handleDownload(string.substring(2), true);
            }
            if (string.startsWith("wb ")) {
                return this.handleDownload(string.substring(3), false);
            }
        }
        return "JDBC does not support this file transfer yet: " + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleUpload(String string, boolean bl, long l) throws IOException {
        if (this.uploadHandler == null) {
            return "No file upload handler has been registered with the JDBC driver";
        }
        long l2 = l >= 1L ? l - 1L : 0L;
        Upload upload = new Upload(this.server, this.uploadHandler::uploadCancelled, bl);
        boolean bl2 = this.server.setInsertFakePrompts(false);
        try {
            this.uploadHandler.handleUpload(upload, string, bl, l2);
            if (!upload.hasBeenUsed()) {
                throw new IOException("Call to " + this.uploadHandler.getClass().getCanonicalName() + ".handleUpload for path '" + string + "' sent neither data nor an error message");
            }
        }
        finally {
            upload.close();
            this.server.setInsertFakePrompts(bl2);
        }
        return upload.getError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleDownload(String string, boolean bl) throws IOException {
        if (this.downloadHandler == null) {
            return "No file download handler has been registered with the JDBC driver";
        }
        try (Download download = new Download(this.server, bl);){
            this.downloadHandler.handleDownload(download, string, true);
            if (!download.hasBeenUsed()) {
                download.sendError("Call to " + this.downloadHandler.getClass().getSimpleName() + ".handleDownload sent neither data nor error");
            }
        }
        return download.getError();
    }

    public static class StripCrLfStream
    extends FilterOutputStream {
        private boolean crPending = false;

        public StripCrLfStream(OutputStream outputStream) {
            super(outputStream);
        }

        public boolean pending() {
            return this.crPending;
        }

        @Override
        public void write(int n) throws IOException {
            if (this.crPending && n != 10) {
                this.out.write(13);
            }
            if (n != 13) {
                this.out.write(n);
                this.crPending = false;
            } else {
                this.crPending = true;
            }
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (n2 == 0) {
                return;
            }
            if (this.crPending && byArray[0] != 10) {
                this.out.write(13);
            }
            if (byArray[n2 - 1] == 13) {
                this.crPending = true;
                --n2;
            } else {
                this.crPending = false;
            }
            for (int i = n; i < n + n2 - 1; ++i) {
                if (byArray[i] != 13 || byArray[i + 1] != 10) continue;
                int n3 = i - n;
                this.out.write(byArray, n, n3);
                n2 -= n3 + 1;
                n += n3 + 1;
                ++i;
            }
            this.out.write(byArray, n, n2);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.crPending) {
                this.out.write(13);
            }
            this.crPending = false;
            super.close();
        }
    }

    public static class Download {
        private final MapiSocket server;
        private boolean prependCr;
        private MapiSocket.DownloadStream stream = null;
        private String error = null;

        Download(MapiSocket mapiSocket, boolean bl) {
            this.server = mapiSocket;
            this.prependCr = false;
            if (bl) {
                this.setLineSeparator(System.lineSeparator());
            }
        }

        public void sendError(String string) throws IOException {
            if (this.error != null) {
                throw new IOException("another error has already been sent: " + this.error);
            }
            this.error = string;
        }

        public InputStream getStream() throws IOException {
            if (this.error != null) {
                throw new IOException("cannot receive data after error has been sent");
            }
            if (this.stream == null) {
                this.stream = this.server.downloadStream(this.prependCr);
                this.server.getOutputStream().flush();
            }
            return this.stream;
        }

        public void downloadTo(OutputStream outputStream) throws IOException {
            int n;
            InputStream inputStream = this.getStream();
            byte[] byArray = new byte[65536];
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
        }

        public void downloadTo(Writer writer) throws IOException {
            int n;
            InputStream inputStream = this.getStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            char[] cArray = new char[65536];
            while ((n = inputStreamReader.read(cArray)) >= 0) {
                writer.write(cArray, 0, n);
            }
        }

        public boolean hasBeenUsed() {
            return this.stream != null || this.error != null;
        }

        public String getError() {
            return this.error;
        }

        public void close() {
            if (this.stream != null) {
                try {
                    this.stream.close();
                    this.stream = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void setLineSeparator(String string) {
            if ("\n".equals(string)) {
                this.prependCr = false;
            } else if ("\r\n".equals(string)) {
                this.prependCr = true;
            } else {
                throw new IllegalArgumentException("sep must be \\n or \\r\\n");
            }
        }
    }

    public static class Upload {
        private final MapiSocket server;
        private final Runnable cancellationCallback;
        private final boolean textMode;
        private PrintStream print = null;
        private String error = null;
        private int customChunkSize = -1;

        Upload(MapiSocket mapiSocket, Runnable runnable, boolean bl) {
            this.server = mapiSocket;
            this.cancellationCallback = runnable;
            this.textMode = bl;
        }

        public void sendError(String string) throws IOException {
            if (this.error != null) {
                throw new IOException("another error has already been sent: " + this.error);
            }
            this.error = string;
        }

        public void setChunkSize(int n) {
            this.customChunkSize = n;
        }

        public PrintStream getStream() throws IOException {
            if (this.error != null) {
                throw new IOException("Cannot send data after an error has been sent");
            }
            if (this.print == null) {
                try {
                    MapiSocket.UploadStream uploadStream = this.customChunkSize >= 0 ? this.server.uploadStream(this.customChunkSize) : this.server.uploadStream();
                    uploadStream.setCancellationCallback(this.cancellationCallback);
                    this.print = new PrintStream((OutputStream)(this.textMode ? new StripCrLfStream(uploadStream) : uploadStream), false, "UTF-8");
                    uploadStream.write(10);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException("The system is guaranteed to support the UTF-8 encoding but apparently it doesn't", unsupportedEncodingException);
                }
            }
            return this.print;
        }

        public boolean hasBeenUsed() {
            return this.print != null || this.error != null;
        }

        public String getError() {
            return this.error;
        }

        public void uploadFrom(InputStream inputStream) throws IOException {
            int n;
            PrintStream printStream = this.getStream();
            byte[] byArray = new byte[65536];
            while ((n = inputStream.read(byArray)) >= 0) {
                ((OutputStream)printStream).write(byArray, 0, n);
            }
        }

        public void uploadFrom(BufferedReader bufferedReader, long l) throws IOException {
            int n = 0;
            while ((long)n < l) {
                String string = bufferedReader.readLine();
                if (string == null) {
                    return;
                }
                ++n;
            }
            this.uploadFrom(bufferedReader);
        }

        public void uploadFrom(Reader reader) throws IOException {
            int n;
            PrintStream printStream = this.getStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)printStream, StandardCharsets.UTF_8);
            char[] cArray = new char[65536];
            while ((n = reader.read(cArray, 0, cArray.length)) >= 0) {
                outputStreamWriter.write(cArray, 0, n);
            }
            outputStreamWriter.close();
        }

        public void close() {
            if (this.print != null) {
                this.print.close();
                this.print = null;
            }
        }
    }

    public static interface DownloadHandler {
        public void handleDownload(Download var1, String var2, boolean var3) throws IOException;
    }

    public static interface UploadHandler {
        public void handleUpload(Upload var1, String var2, boolean var3, long var4) throws IOException;

        default public void uploadCancelled() {
        }
    }

    final class ResponseList {
        private final int cachesize;
        private final long maxrows;
        private final int rstype;
        private final int rsconcur;
        private final int seqnr;
        private final ArrayList<Response> responses;
        private HashMap<Integer, ResultSetResponse> rsresponses;
        private int curResponse;

        ResponseList(int n, long l, int n2, int n3) throws SQLException {
            this.cachesize = n;
            this.maxrows = l;
            this.rstype = n2;
            this.rsconcur = n3;
            this.responses = new ArrayList();
            this.curResponse = -1;
            this.seqnr = seqCounter++;
        }

        Response getNextResponse() throws SQLException {
            if (this.rstype == 1003 && this.curResponse >= 0 && this.curResponse < this.responses.size()) {
                Response response = this.responses.get(this.curResponse);
                if (response != null) {
                    response.close();
                }
                this.responses.set(this.curResponse, null);
            }
            ++this.curResponse;
            if (this.curResponse >= this.responses.size()) {
                return null;
            }
            return this.responses.get(this.curResponse);
        }

        void closeResponse(int n) {
            if (n < 0 || n >= this.responses.size()) {
                return;
            }
            Response response = this.responses.set(n, null);
            if (response != null) {
                response.close();
            }
        }

        void closeCurrentResponse() {
            this.closeResponse(this.curResponse);
        }

        void closeCurOldResponses() {
            for (int i = this.curResponse; i >= 0; --i) {
                this.closeResponse(i);
            }
        }

        void close() {
            for (int i = 0; i < this.responses.size(); ++i) {
                this.closeResponse(i);
            }
        }

        boolean hasUnclosedResponses() {
            for (Response response : this.responses) {
                if (response == null) continue;
                return true;
            }
            return false;
        }

        void processQuery(String string) throws SQLException {
            this.executeQuery(MonetConnection.this.queryTempl, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void executeQuery(String[] stringArray, String string) throws SQLException {
            String string2 = null;
            try {
                Object object;
                Object object2 = MonetConnection.this.server;
                synchronized (object2) {
                    MonetConnection.this.in.waitForPrompt();
                    int n = this.cachesize;
                    if (n == 0) {
                        n = MonetConnection.this.defaultFetchSize;
                    }
                    if (this.maxrows > 0L && this.maxrows < (long)n) {
                        n = (int)this.maxrows;
                    }
                    if (MonetConnection.this.lang == 0 && n != MonetConnection.this.curReplySize && stringArray != MonetConnection.this.commandTempl) {
                        MonetConnection.this.sendControlCommand("reply_size " + n);
                        MonetConnection.this.curReplySize = n;
                    }
                    MonetConnection.this.out.writeLine(stringArray[0] + string + stringArray[1]);
                    String string3 = MonetConnection.this.in.readLine();
                    object = MonetConnection.this.in.getLineType();
                    Response response = null;
                    block22: while (object != LineType.PROMPT) {
                        switch (object) {
                            case SOHEADER: {
                                try {
                                    switch (MonetConnection.this.sohp.parse(string3)) {
                                        case 48: {
                                            throw new MCLParseException("Q_PARSE header not allowed here", 1);
                                        }
                                        case 49: 
                                        case 53: {
                                            int n2 = MonetConnection.this.sohp.getNextAsInt();
                                            long l = MonetConnection.this.sohp.getNextAsLong();
                                            int n3 = MonetConnection.this.sohp.getNextAsInt();
                                            int n4 = MonetConnection.this.sohp.getNextAsInt();
                                            if (this.maxrows != 0L && l > this.maxrows) {
                                                l = this.maxrows;
                                            }
                                            response = new ResultSetResponse(n2, l, n3, n4, this, this.seqnr);
                                            if ((long)n4 < l) {
                                                if (this.rsresponses == null) {
                                                    this.rsresponses = new HashMap();
                                                }
                                                this.rsresponses.put(n2, (ResultSetResponse)response);
                                            }
                                            break;
                                        }
                                        case 50: {
                                            response = new UpdateResponse(MonetConnection.this.sohp.getNextAsLong(), MonetConnection.this.sohp.getNextAsString());
                                            break;
                                        }
                                        case 51: {
                                            response = new SchemaResponse();
                                            break;
                                        }
                                        case 52: {
                                            boolean bl = MonetConnection.this.sohp.getNextAsString().equals("t");
                                            if (MonetConnection.this.autoCommit && bl) {
                                                MonetConnection.this.addWarning("Server enabled auto commit mode while local state already was auto commit.", "01M11");
                                            }
                                            MonetConnection.this.autoCommit = bl;
                                            response = new AutoCommitResponse(bl);
                                            break;
                                        }
                                        case 54: {
                                            int n5 = MonetConnection.this.sohp.getNextAsInt();
                                            MonetConnection.this.sohp.getNextAsInt();
                                            int n6 = MonetConnection.this.sohp.getNextAsInt();
                                            int n3 = MonetConnection.this.sohp.getNextAsInt();
                                            ResultSetResponse resultSetResponse = this.rsresponses != null ? this.rsresponses.get(n5) : null;
                                            if (resultSetResponse == null) {
                                                string2 = "M0M12!no ResultSetResponse with id " + n5 + " found";
                                                break;
                                            }
                                            DataBlockResponse dataBlockResponse = new DataBlockResponse(n6, resultSetResponse.getRSType() == 1003);
                                            resultSetResponse.addDataBlockResponse(n3, dataBlockResponse);
                                            response = dataBlockResponse;
                                        }
                                    }
                                }
                                catch (MCLParseException mCLParseException) {
                                    int n7 = mCLParseException.getErrorOffset();
                                    string2 = "M0M10!error while parsing start of header:\n" + mCLParseException.getMessage() + " found: '" + string3.charAt(n7) + "' in: \"" + string3 + "\" at pos: " + n7;
                                    MonetConnection.this.in.waitForPrompt();
                                    object = MonetConnection.this.in.getLineType();
                                    continue block22;
                                }
                                if (string2 != null) {
                                    MonetConnection.this.in.waitForPrompt();
                                    object = MonetConnection.this.in.getLineType();
                                    continue block22;
                                }
                                while (response.wantsMore()) {
                                    string2 = response.addLine(MonetConnection.this.in.readLine(), MonetConnection.this.in.getLineType());
                                    if (string2 == null) continue;
                                    string2 = "M0M10!" + string2;
                                    MonetConnection.this.in.waitForPrompt();
                                    object = MonetConnection.this.in.getLineType();
                                    break;
                                }
                                if (string2 != null) continue block22;
                                if (!(response instanceof DataBlockResponse)) {
                                    this.responses.add(response);
                                }
                                string3 = MonetConnection.this.in.readLine();
                                object = MonetConnection.this.in.getLineType();
                                continue block22;
                            }
                            case INFO: {
                                MonetConnection.this.addWarning(string3.substring(1), "01000");
                                string3 = MonetConnection.this.in.readLine();
                                object = MonetConnection.this.in.getLineType();
                                continue block22;
                            }
                            case FILETRANSFER: {
                                String string4 = MonetConnection.this.in.readLine();
                                MonetConnection.this.in.readLine();
                                string2 = string4 != null ? MonetConnection.this.handleTransfer(string4) : "Protocol violation, expected transfer command, got nothing";
                                if (string2 != null) {
                                    MonetConnection.this.out.writeLine(string2 + "\n");
                                    string2 = MonetConnection.this.in.waitForPrompt();
                                } else {
                                    string3 = MonetConnection.this.in.readLine();
                                }
                                object = MonetConnection.this.in.getLineType();
                                continue block22;
                            }
                            default: {
                                string3 = "!M0M10!protocol violation, unexpected " + (Object)object + " line: " + string3;
                            }
                            case ERROR: 
                        }
                        string2 = MonetConnection.this.in.waitForPrompt();
                        object = MonetConnection.this.in.getLineType();
                        if (string2 != null) {
                            string2 = string3.substring(1) + "\n" + string2;
                            continue;
                        }
                        string2 = string3.substring(1);
                    }
                }
                if (string2 != null) {
                    object2 = null;
                    String[] stringArray2 = string2.split("\n");
                    for (int i = 0; i < stringArray2.length; ++i) {
                        object = stringArray2[i].length() >= 6 ? new SQLException(stringArray2[i].substring(6), stringArray2[i].substring(0, 5)) : new SQLNonTransientConnectionException(stringArray2[i], "08000");
                        if (object2 == null) {
                            object2 = object;
                            continue;
                        }
                        ((SQLException)object2).setNextException((SQLException)object);
                    }
                    throw object2;
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.close();
                throw new SQLNonTransientConnectionException("connection timed out", "08M33");
            }
            catch (IOException iOException) {
                MonetConnection.this.closed = true;
                throw new SQLNonTransientConnectionException(iOException.getMessage() + " (mserver5 still alive?)", "08006");
            }
        }
    }

    private final class AutoCommitResponse
    extends SchemaResponse {
        public final boolean autocommit;

        public AutoCommitResponse(boolean bl) {
            this.autocommit = bl;
        }
    }

    class SchemaResponse
    implements Response {
        public final int state = -2;

        SchemaResponse() {
        }

        @Override
        public String addLine(String string, LineType lineType) {
            return "Header lines are not supported for a SchemaResponse";
        }

        @Override
        public boolean wantsMore() {
            return false;
        }

        @Override
        public void close() {
        }
    }

    static final class UpdateResponse
    implements Response {
        public final long count;
        public final String lastid;

        public UpdateResponse(long l, String string) {
            this.count = l;
            this.lastid = string;
        }

        @Override
        public String addLine(String string, LineType lineType) {
            return "Header lines are not supported for an UpdateResponse";
        }

        @Override
        public boolean wantsMore() {
            return false;
        }

        @Override
        public void close() {
        }
    }

    private static final class DataBlockResponse
    implements Response {
        private final String[] data;
        private int pos = -1;
        private final boolean forwardOnly;

        DataBlockResponse(int n, boolean bl) {
            this.data = new String[n];
            this.forwardOnly = bl;
        }

        @Override
        public String addLine(String string, LineType lineType) {
            if (lineType != LineType.RESULT) {
                return "protocol violation: unexpected line in data block: " + string;
            }
            this.data[++this.pos] = string;
            return null;
        }

        @Override
        public boolean wantsMore() {
            return this.pos + 1 < this.data.length;
        }

        @Override
        public void close() {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = null;
            }
        }

        String getRow(int n) {
            if (this.forwardOnly) {
                String string = this.data[n];
                this.data[n] = null;
                return string;
            }
            return this.data[n];
        }
    }

    final class ResultSetResponse
    implements Response {
        public final int columncount;
        public final long tuplecount;
        private int cacheSize;
        public final int id;
        private String[] name;
        private String[] type;
        private int[] columnLengths;
        private String[] tableNames;
        private String[] schemaNames;
        private final int seqnr;
        private DataBlockResponse[] resultBlocks;
        private boolean closed;
        private final ResponseList parent;
        private final boolean cacheSizeSetExplicitly;
        private boolean destroyOnClose;
        private int blockOffset;
        private final HeaderLineParser hlp;
        private final boolean[] isSet = new boolean[4];
        private static final int NAMES = 0;
        private static final int TYPES = 1;
        private static final int TABLES = 2;
        private static final int LENS = 3;

        ResultSetResponse(int n, long l, int n2, int n3, ResponseList responseList, int n4) throws SQLException {
            this.parent = responseList;
            if (responseList.cachesize == 0) {
                this.cacheSize = 250;
                this.cacheSizeSetExplicitly = false;
            } else {
                this.cacheSize = responseList.cachesize;
                this.cacheSizeSetExplicitly = true;
            }
            if (n3 > this.cacheSize) {
                this.cacheSize = n3;
            }
            this.seqnr = n4;
            this.closed = false;
            this.destroyOnClose = n > 0 && l > (long)n3;
            this.id = n;
            this.tuplecount = l;
            this.columncount = n2;
            this.resultBlocks = new DataBlockResponse[(int)(l / (long)this.cacheSize) + 1];
            this.hlp = new HeaderLineParser(n2);
            this.resultBlocks[0] = new DataBlockResponse(n3, responseList.rstype == 1003);
        }

        @Override
        public String addLine(String string, LineType lineType) {
            if (this.isSet[3] && this.isSet[1] && this.isSet[2] && this.isSet[0]) {
                return this.resultBlocks[0].addLine(string, lineType);
            }
            if (lineType != LineType.HEADER) {
                return "header expected, got: " + string;
            }
            try {
                switch (this.hlp.parse(string)) {
                    case 1: {
                        this.name = (String[])this.hlp.values.clone();
                        this.isSet[0] = true;
                        break;
                    }
                    case 2: {
                        this.columnLengths = (int[])this.hlp.intValues.clone();
                        this.isSet[3] = true;
                        break;
                    }
                    case 4: {
                        this.type = (String[])this.hlp.values.clone();
                        this.isSet[1] = true;
                        break;
                    }
                    case 3: {
                        this.tableNames = (String[])this.hlp.values.clone();
                        int n = this.tableNames.length;
                        this.schemaNames = new String[n];
                        for (int i = 0; i < n; ++i) {
                            String string2 = this.tableNames[i];
                            if (string2 != null) {
                                int n2 = string2.indexOf(46);
                                if (n2 >= 0) {
                                    this.schemaNames[i] = string2.substring(0, n2);
                                    this.tableNames[i] = string2.substring(n2 + 1);
                                    continue;
                                }
                                this.schemaNames[i] = "";
                                continue;
                            }
                            this.schemaNames[i] = "";
                            this.tableNames[i] = "";
                        }
                        this.isSet[2] = true;
                    }
                }
            }
            catch (MCLParseException mCLParseException) {
                return mCLParseException.getMessage();
            }
            return null;
        }

        @Override
        public boolean wantsMore() {
            if (this.isSet[3] && this.isSet[1] && this.isSet[2] && this.isSet[0]) {
                return this.resultBlocks[0].wantsMore();
            }
            return true;
        }

        private final String[] getValues(char[] cArray, int n, int n2) {
            int n3 = 0;
            String[] stringArray = new String[this.columncount];
            for (int i = n; i < n2; ++i) {
                if (cArray[i] != '\t' || cArray[i - 1] != ',') continue;
                stringArray[n3++] = new String(cArray, n, i - 1 - n);
                n = i + 1;
            }
            stringArray[n3++] = new String(cArray, n, n2 - n);
            return stringArray;
        }

        void addDataBlockResponse(int n, DataBlockResponse dataBlockResponse) {
            int n2 = (n - this.blockOffset) / this.cacheSize;
            this.resultBlocks[n2] = dataBlockResponse;
        }

        String[] getNames() {
            return this.name;
        }

        String[] getTypes() {
            return this.type;
        }

        String[] getTableNames() {
            return this.tableNames;
        }

        String[] getSchemaNames() {
            return this.schemaNames;
        }

        int[] getColumnLengths() {
            return this.columnLengths;
        }

        int getCacheSize() {
            return this.cacheSize;
        }

        int getBlockOffset() {
            return this.blockOffset;
        }

        int getRSType() {
            return this.parent.rstype;
        }

        int getRSConcur() {
            return this.parent.rsconcur;
        }

        String getLine(int n) throws SQLException {
            if ((long)n >= this.tuplecount || n < 0) {
                return null;
            }
            int n2 = (n - this.blockOffset) / this.cacheSize;
            int n3 = (n - this.blockOffset) % this.cacheSize;
            DataBlockResponse dataBlockResponse = this.resultBlocks[n2];
            if (dataBlockResponse == null) {
                if (this.parent.rstype == 1003) {
                    for (int i = 0; i < n2; ++i) {
                        this.resultBlocks[i] = null;
                    }
                    if (seqCounter - 1 == this.seqnr && !this.cacheSizeSetExplicitly && this.tuplecount - (long)n > (long)this.cacheSize && this.cacheSize < 2500) {
                        this.blockOffset += this.cacheSize;
                        this.cacheSize *= 10;
                        n2 = (n - this.blockOffset) / this.cacheSize;
                        n3 = (n - this.blockOffset) % this.cacheSize;
                    }
                }
                this.parent.executeQuery(MonetConnection.this.commandTempl, "export " + this.id + " " + (n2 * this.cacheSize + this.blockOffset) + " " + this.cacheSize);
                dataBlockResponse = this.resultBlocks[n2];
                if (dataBlockResponse == null) {
                    throw new SQLException("resultBlocks[" + n2 + "] should have been fetched by now", "M0M10");
                }
            }
            return dataBlockResponse.getRow(n3);
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            try {
                if (this.destroyOnClose) {
                    MonetConnection.this.sendControlCommand("close " + this.id);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            for (int i = 1; i < this.resultBlocks.length; ++i) {
                DataBlockResponse dataBlockResponse = this.resultBlocks[i];
                if (dataBlockResponse == null) continue;
                dataBlockResponse.close();
            }
            this.name = null;
            this.type = null;
            this.columnLengths = null;
            this.tableNames = null;
            this.schemaNames = null;
            this.resultBlocks = null;
            this.closed = true;
        }

        boolean isClosed() {
            return this.closed;
        }
    }

    static interface Response {
        public String addLine(String var1, LineType var2);

        public boolean wantsMore();

        public void close();
    }
}

