/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.monetdb.jdbc.MonetBlob;
import org.monetdb.jdbc.MonetClob;
import org.monetdb.jdbc.MonetConnection;
import org.monetdb.jdbc.MonetDriver;
import org.monetdb.jdbc.MonetStatement;
import org.monetdb.jdbc.MonetWrapper;
import org.monetdb.jdbc.types.INET;
import org.monetdb.jdbc.types.URL;
import org.monetdb.mcl.parser.MCLParseException;
import org.monetdb.mcl.parser.TupleLineParser;

public class MonetResultSet
extends MonetWrapper
implements ResultSet,
AutoCloseable {
    static final int DEF_RESULTSETTYPE = 1003;
    static final int DEF_FETCHDIRECTION = 1000;
    static final int DEF_CONCURRENCY = 1007;
    static final int DEF_HOLDABILITY = 1;
    private final Statement statement;
    private final MonetConnection.ResultSetResponse header;
    private final String[] columns;
    private final String[] types;
    private final int[] JdbcSQLTypes;
    protected final TupleLineParser tlp;
    protected final long tupleCount;
    protected int curRow;
    private int type = 1003;
    private int concurrency = 1007;
    private SQLWarning warnings;
    private boolean lastReadWasNull = true;
    private int fetchSize;
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat timeFormat;
    private SimpleDateFormat timestampFormat;

    MonetResultSet(Statement statement, MonetConnection.ResultSetResponse resultSetResponse) throws IllegalArgumentException {
        if (statement == null) {
            throw new IllegalArgumentException("Statement may not be null!");
        }
        if (resultSetResponse == null) {
            throw new IllegalArgumentException("Header may not be null!");
        }
        this.statement = statement;
        this.header = resultSetResponse;
        this.type = resultSetResponse.getRSType();
        this.concurrency = resultSetResponse.getRSConcur();
        this.fetchSize = resultSetResponse.getCacheSize();
        this.columns = resultSetResponse.getNames();
        this.types = resultSetResponse.getTypes();
        if (this.columns == null || this.types == null) {
            throw new IllegalArgumentException("Missing Header metadata");
        }
        if (this.columns.length != this.types.length) {
            throw new IllegalArgumentException("Inconsistent Header metadata");
        }
        this.tupleCount = resultSetResponse.tuplecount;
        this.tlp = new TupleLineParser(this.columns.length);
        this.JdbcSQLTypes = new int[this.types.length];
        this.populateJdbcSQLtypesArray();
    }

    MonetResultSet(Statement statement, String[] stringArray, String[] stringArray2, int n) throws IllegalArgumentException {
        if (statement == null || stringArray == null || stringArray2 == null) {
            throw new IllegalArgumentException("One of the given arguments is null");
        }
        if (stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("Given arrays are not the same size");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative rowcount not allowed");
        }
        this.statement = statement;
        this.header = null;
        this.fetchSize = 0;
        this.columns = stringArray;
        this.types = stringArray2;
        this.tupleCount = n;
        this.tlp = new TupleLineParser(stringArray.length);
        this.JdbcSQLTypes = new int[stringArray2.length];
        this.populateJdbcSQLtypesArray();
    }

    private final void populateJdbcSQLtypesArray() {
        MonetConnection monetConnection = null;
        try {
            monetConnection = (MonetConnection)this.statement.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        for (int i = 0; i < this.types.length; ++i) {
            int n = MonetDriver.getJdbcSQLType(this.types[i]);
            if (n == 2005) {
                if (monetConnection != null && monetConnection.mapClobAsVarChar()) {
                    n = 12;
                }
            } else if (n == 2004 && monetConnection != null && monetConnection.mapBlobAsVarBinary()) {
                n = -3;
            }
            this.JdbcSQLTypes[i] = n;
        }
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        this.checkNotClosed();
        if (n != this.curRow + 1 && this.type == 1003) {
            throw new SQLException("(Absolute) positioning not allowed on forward only result sets!", "M1M05");
        }
        if (n < 0) {
            n = (int)this.tupleCount + n + 1;
        }
        if (n < 0) {
            n = 0;
        } else if ((long)n > this.tupleCount + 1L) {
            n = (int)this.tupleCount + 1;
        }
        this.curRow = n;
        if (this.header == null) {
            return false;
        }
        String string = this.header.getLine(n - 1);
        if (string == null) {
            return false;
        }
        try {
            this.tlp.parse(string);
        }
        catch (MCLParseException mCLParseException) {
            throw new SQLException(mCLParseException.getMessage(), "M0M10");
        }
        return true;
    }

    @Override
    public void afterLast() throws SQLException {
        this.absolute((int)this.tupleCount + 1);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public void close() {
        this.clearWarnings();
        if (this.header != null && !this.header.isClosed()) {
            this.header.close();
        }
        if (this.statement instanceof MonetStatement) {
            ((MonetStatement)this.statement).closeIfCompletion();
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        this.checkNotClosed();
        if (string != null) {
            int n;
            int n2 = this.columns.length;
            for (n = 0; n < n2; ++n) {
                if (!string.equals(this.columns[n])) continue;
                return n + 1;
            }
            for (n = 0; n < n2; ++n) {
                if (!string.equalsIgnoreCase(this.columns[n])) continue;
                return n + 1;
            }
        }
        throw new SQLException("No such column name: " + string, "M1M05");
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getArray");
    }

    @Override
    public Array getArray(String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getArray");
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getAsciiStream");
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getAsciiStream");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getUnicodeStream");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        this.checkNotClosed();
        try {
            switch (this.JdbcSQLTypes[n - 1]) {
                case 2004: {
                    Blob blob = this.getBlob(n);
                    if (blob == null) {
                        return null;
                    }
                    return blob.getBinaryStream();
                }
                case -4: 
                case -3: 
                case -2: {
                    byte[] byArray = this.getBytes(n);
                    if (byArray == null) {
                        return null;
                    }
                    return new ByteArrayInputStream(byArray);
                }
            }
            throw new SQLException("Cannot operate on type: " + this.types[n - 1], "M1M05");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return new StringReader(string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return this.getCharacterStream(n);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return new MonetBlob(string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return new MonetClob(string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw MonetResultSet.newSQLNumberFormatException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return new BigDecimal(string).setScale(n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw MonetResultSet.newSQLNumberFormatException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return false;
            }
            this.lastReadWasNull = false;
            if ("false".equalsIgnoreCase(string) || "0".equals(string)) {
                return false;
            }
            if ("true".equalsIgnoreCase(string) || "1".equals(string)) {
                return true;
            }
            switch (this.JdbcSQLTypes[n - 1]) {
                case -1: 
                case 1: 
                case 12: 
                case 16: 
                case 2005: {
                    return Boolean.parseBoolean(string);
                }
                case -6: 
                case 4: 
                case 5: {
                    return this.getInt(n) != 0;
                }
                case -5: {
                    return this.getLong(n) != 0L;
                }
                case 6: 
                case 7: 
                case 8: {
                    return this.getDouble(n) != 0.0;
                }
                case 2: 
                case 3: {
                    return this.getBigDecimal(n).compareTo(BigDecimal.ZERO) != 0;
                }
            }
            throw new SQLException("Conversion from " + this.types[n - 1] + " to boolean type not supported", "M1M05");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return 0;
            }
            this.lastReadWasNull = false;
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw MonetResultSet.newSQLNumberFormatException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            switch (this.JdbcSQLTypes[n - 1]) {
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    return MonetBlob.hexStrToByteArray(string);
                }
            }
            throw new SQLException("Cannot operate on type: " + this.types[n - 1], "M1M05");
        }
        catch (NumberFormatException numberFormatException) {
            throw MonetResultSet.newSQLNumberFormatException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public int getConcurrency() {
        return this.concurrency;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("Positioned updates not supported for this cursor (" + (this.header != null ? this.header.id + ")" : ")"), "0AM21");
    }

    @Override
    public double getDouble(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return 0.0;
            }
            this.lastReadWasNull = false;
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw MonetResultSet.newSQLNumberFormatException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.getStatement().getConnection().getHoldability();
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        switch (n) {
            case 1000: {
                break;
            }
            case 1001: 
            case 1002: {
                throw new SQLException("Not supported direction: " + n, "0A000");
            }
            default: {
                throw new SQLException("Illegal direction: " + n, "M1M05");
            }
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Illegal fetch size value: " + n, "M1M05");
        }
        this.fetchSize = n;
    }

    @Override
    public float getFloat(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return 0.0f;
            }
            this.lastReadWasNull = false;
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw MonetResultSet.newSQLNumberFormatException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public int getInt(int n) throws SQLException {
        this.checkNotClosed();
        String string = "";
        try {
            string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return 0;
            }
            this.lastReadWasNull = false;
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if ("oid".equals(this.types[n - 1]) && string.endsWith("@0")) {
                try {
                    return Integer.parseInt(string.substring(0, string.length() - 2));
                }
                catch (NumberFormatException numberFormatException2) {
                    throw MonetResultSet.newSQLNumberFormatException(numberFormatException2);
                }
            }
            throw MonetResultSet.newSQLNumberFormatException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(int n) throws SQLException {
        this.checkNotClosed();
        String string = "";
        try {
            string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return 0L;
            }
            this.lastReadWasNull = false;
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            if ("oid".equals(this.types[n - 1]) && string.endsWith("@0")) {
                try {
                    return Long.parseLong(string.substring(0, string.length() - 2));
                }
                catch (NumberFormatException numberFormatException2) {
                    throw MonetResultSet.newSQLNumberFormatException(numberFormatException2);
                }
            }
            throw MonetResultSet.newSQLNumberFormatException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new rsmdw(){
            private final String[] schemas;
            private final String[] tables;
            private final MonetConnection conn;
            private final int array_size;
            private final boolean[] _is_queried;
            private final boolean[] _is_fetched;
            private final int[] _precision;
            private final int[] _scale;
            private final int[] _isNullable;
            private final boolean[] _isAutoincrement;
            {
                this.schemas = MonetResultSet.this.header != null ? MonetResultSet.this.header.getSchemaNames() : null;
                this.tables = MonetResultSet.this.header != null ? MonetResultSet.this.header.getTableNames() : null;
                this.conn = (MonetConnection)MonetResultSet.this.getStatement().getConnection();
                this.array_size = MonetResultSet.this.columns.length + 1;
                this._is_queried = new boolean[this.array_size];
                this._is_fetched = new boolean[this.array_size];
                this._precision = new int[this.array_size];
                this._scale = new int[this.array_size];
                this._isNullable = new int[this.array_size];
                this._isAutoincrement = new boolean[this.array_size];
            }

            private final void checkColumnIndexValidity(int n) throws SQLDataException {
                if (n < 1 || n > MonetResultSet.this.columns.length) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            private final void fetchColumnInfo(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                if (!this._is_fetched[n]) {
                    this.fetchManyColumnsInfo(1);
                    if (!this._is_fetched[n]) {
                        this.fetchManyColumnsInfo(n);
                    }
                }
                if (this._is_fetched[n]) {
                    return;
                }
                this._precision[n] = 0;
                this._scale[n] = 0;
                this._isNullable[n] = 2;
                this._isAutoincrement[n] = false;
            }

            private final void fetchManyColumnsInfo(int n) throws SQLException {
                StringBuilder stringBuilder = new StringBuilder(8100);
                stringBuilder.append("SELECT s.\"name\" AS schnm, t.\"name\" AS tblnm, c.\"name\" AS colnm, c.\"type_digits\", c.\"type_scale\", cast(CASE c.\"null\" WHEN true THEN ").append(1).append(" WHEN false THEN ").append(0).append(" ELSE ").append(2).append(" END AS int) AS nullable, ").append("cast(CASE WHEN c.\"default\" IS NOT NULL AND c.\"default\" LIKE 'next value for %' THEN true ELSE false END AS boolean) AS isautoincrement FROM \"sys\".\"columns\" c JOIN \"sys\".\"tables\" t ON c.\"table_id\" = t.\"id\" JOIN \"sys\".\"schemas\" s ON t.\"schema_id\" = s.\"id\" WHERE ");
                String string = null;
                String string2 = null;
                String string3 = null;
                int n2 = 0;
                for (int i = n; i < this.array_size && n2 < 50; ++i) {
                    if (this._is_fetched[i] || this._is_queried[i]) continue;
                    this._precision[i] = 0;
                    this._scale[i] = 0;
                    this._isNullable[i] = 2;
                    this._isAutoincrement[i] = false;
                    string = this.getSchemaName(i);
                    if (!(string == null || string.isEmpty() || (string2 = this.getTableName(i)) == null || string2.isEmpty() || (string3 = this.getColumnName(i)) == null || string3.isEmpty())) {
                        if (n2 > 0) {
                            stringBuilder.append(" OR ");
                        }
                        stringBuilder.append("(s.\"name\" = ").append(MonetWrapper.sq(string));
                        stringBuilder.append(" AND t.\"name\" = ").append(MonetWrapper.sq(string2));
                        stringBuilder.append(" AND c.\"name\" = ").append(MonetWrapper.sq(string3));
                        stringBuilder.append(")");
                        this._is_queried[i] = true;
                        ++n2;
                    }
                    if (this._is_queried[i]) continue;
                    this._is_fetched[i] = true;
                }
                if (n2 == 0) {
                    return;
                }
                Statement statement = this.conn.createStatement();
                if (statement != null) {
                    ResultSet resultSet = statement.executeQuery(stringBuilder.toString());
                    if (resultSet != null) {
                        String string4 = null;
                        String string5 = null;
                        String string6 = null;
                        while (resultSet.next()) {
                            string4 = resultSet.getString(1);
                            string5 = resultSet.getString(2);
                            string6 = resultSet.getString(3);
                            for (int i = 1; i < this.array_size; ++i) {
                                if (this._is_fetched[i] || !this._is_queried[i] || (string3 = this.getColumnName(i)) == null || !string3.equals(string6) || (string2 = this.getTableName(i)) == null || !string2.equals(string5) || (string = this.getSchemaName(i)) == null || !string.equals(string4)) continue;
                                this._precision[i] = resultSet.getInt(4);
                                this._scale[i] = resultSet.getInt(5);
                                this._isNullable[i] = resultSet.getInt(6);
                                this._isAutoincrement[i] = resultSet.getBoolean(7);
                                this._is_fetched[i] = true;
                                --n2;
                                i = this.array_size;
                            }
                        }
                        resultSet.close();
                    }
                    statement.close();
                }
                if (n2 != 0) {
                    for (int i = n; i < this.array_size; ++i) {
                        if (this._is_fetched[i] || !this._is_queried[i]) continue;
                        this._is_fetched[i] = true;
                    }
                }
            }

            @Override
            public int getColumnCount() {
                return MonetResultSet.this.columns.length;
            }

            @Override
            public boolean isAutoIncrement(int n) throws SQLException {
                switch (this.getColumnType(n)) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        try {
                            if (!this._is_fetched[n]) {
                                this.fetchColumnInfo(n);
                            }
                            return this._isAutoincrement[n];
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                        }
                    }
                }
                return false;
            }

            @Override
            public boolean isCaseSensitive(int n) throws SQLException {
                switch (this.getColumnType(n)) {
                    case -1: 
                    case 1: 
                    case 2005: {
                        return true;
                    }
                    case 12: {
                        String string = this.getColumnTypeName(n);
                        return string == null || string.length() != 4 || !"inet".equals(string) && !"uuid".equals(string);
                    }
                }
                return false;
            }

            @Override
            public boolean isSearchable(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                return true;
            }

            @Override
            public boolean isCurrency(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                return false;
            }

            @Override
            public boolean isSigned(int n) throws SQLException {
                switch (this.getColumnType(n)) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                    case -5: {
                        String string = this.getColumnTypeName(n);
                        return string == null || string.length() != 3 || !"oid".equals(string) && !"ptr".equals(string);
                    }
                }
                return false;
            }

            @Override
            public int getColumnDisplaySize(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                if (MonetResultSet.this.header != null) {
                    try {
                        return MonetResultSet.this.header.getColumnLengths()[n - 1];
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                    }
                }
                return 1;
            }

            @Override
            public String getSchemaName(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                if (this.schemas != null) {
                    try {
                        return this.schemas[n - 1];
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                    }
                }
                return "";
            }

            @Override
            public String getTableName(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                if (this.tables != null) {
                    try {
                        return this.tables[n - 1];
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                    }
                }
                return "";
            }

            @Override
            public int getPrecision(int n) throws SQLException {
                int n2 = this.getColumnType(n);
                switch (n2) {
                    case -5: {
                        return 19;
                    }
                    case 4: {
                        return 10;
                    }
                    case 5: {
                        return 5;
                    }
                    case -6: {
                        return 3;
                    }
                    case 7: {
                        return 7;
                    }
                    case 6: 
                    case 8: {
                        return 15;
                    }
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 12: 
                    case 2004: 
                    case 2005: {
                        try {
                            if (!this._is_fetched[n]) {
                                this.fetchColumnInfo(n);
                            }
                            if (this._precision[n] == 0) {
                                this._precision[n] = this.getColumnDisplaySize(n);
                                if (n2 == 2004 || n2 == -3 || n2 == -2) {
                                    this._precision[n] = this._precision[n] / 2 + 1;
                                }
                            }
                            return this._precision[n];
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                        }
                    }
                    case 91: {
                        return 10;
                    }
                    case 92: {
                        return 15;
                    }
                    case 2013: {
                        return 21;
                    }
                    case 93: {
                        return 26;
                    }
                    case 2014: {
                        return 32;
                    }
                    case 16: {
                        return 1;
                    }
                }
                return 0;
            }

            @Override
            public int getScale(int n) throws SQLException {
                switch (this.getColumnType(n)) {
                    case 2: 
                    case 3: {
                        String string = this.getColumnTypeName(n);
                        if ("day_interval".equals(string)) {
                            return 0;
                        }
                        if ("sec_interval".equals(string)) {
                            return 3;
                        }
                        try {
                            if (!this._is_fetched[n]) {
                                this.fetchColumnInfo(n);
                            }
                            return this._scale[n];
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                        }
                    }
                    case 92: 
                    case 93: 
                    case 2013: 
                    case 2014: {
                        return 6;
                    }
                }
                return 0;
            }

            @Override
            public int isNullable(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                try {
                    if (!this._is_fetched[n]) {
                        this.fetchColumnInfo(n);
                    }
                    return this._isNullable[n];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            @Override
            public String getCatalogName(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                return null;
            }

            @Override
            public boolean isReadOnly(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                return true;
            }

            @Override
            public boolean isWritable(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                return false;
            }

            @Override
            public boolean isDefinitelyWritable(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                return false;
            }

            @Override
            public String getColumnClassName(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                try {
                    Map<String, Class<?>> map;
                    String string = MonetResultSet.this.types[n - 1];
                    Class<?> clazz = null;
                    if (this.conn != null && (map = this.conn.getTypeMap()) != null && map.containsKey(string)) {
                        clazz = map.get(string);
                    }
                    if (clazz == null) {
                        clazz = MonetResultSet.getClassForType(MonetResultSet.this.JdbcSQLTypes[n - 1]);
                    }
                    if (clazz != null) {
                        return clazz.getName();
                    }
                    throw new SQLException("column type mapping null: " + string, "M0M03");
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            @Override
            public String getColumnLabel(int n) throws SQLException {
                return this.getColumnName(n);
            }

            @Override
            public String getColumnName(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                try {
                    return MonetResultSet.this.columns[n - 1];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            @Override
            public int getColumnType(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                try {
                    return MonetResultSet.this.JdbcSQLTypes[n - 1];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            @Override
            public String getColumnTypeName(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                try {
                    return MonetResultSet.this.types[n - 1];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }
        };
    }

    @Override
    public Object getObject(int n) throws SQLException {
        int n2;
        String string;
        this.checkNotClosed();
        try {
            string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            n2 = this.JdbcSQLTypes[n - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
        switch (n2) {
            case -6: 
            case 5: {
                try {
                    return Short.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return string;
                }
            }
            case 4: {
                try {
                    return Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return string;
                }
            }
            case -5: {
                try {
                    return Long.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return string;
                }
            }
            case 6: 
            case 8: {
                try {
                    return Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return string;
                }
            }
            case 7: {
                try {
                    return Float.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return string;
                }
            }
            case 2: 
            case 3: {
                try {
                    return new BigDecimal(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return string;
                }
            }
            case 16: {
                return Boolean.valueOf(string);
            }
            case 12: {
                String string2 = this.types[n - 1];
                switch (string2.length()) {
                    case 3: {
                        if (!"url".equals(string2)) break;
                        try {
                            URL uRL = new URL();
                            uRL.fromString(string);
                            return uRL;
                        }
                        catch (Exception exception) {
                            return string;
                        }
                    }
                    case 4: {
                        if ("inet".equals(string2)) {
                            try {
                                INET iNET = new INET();
                                iNET.fromString(string);
                                return iNET;
                            }
                            catch (Exception exception) {
                                return string;
                            }
                        }
                        if (!"uuid".equals(string2)) break;
                        try {
                            return UUID.fromString(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            return string;
                        }
                    }
                }
                return string;
            }
            case -1: 
            case 1: {
                return string;
            }
            case 2005: {
                return new MonetClob(string);
            }
            case 2004: {
                return new MonetBlob(string);
            }
            case 91: {
                return this.getDate(n, null);
            }
            case 92: 
            case 2013: {
                return this.getTime(n, null);
            }
            case 93: 
            case 2014: {
                return this.getTimestamp(n, null);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
        }
        return this.getObject(n, this.getStatement().getConnection().getTypeMap());
    }

    private final boolean classImplementsSQLData(Class<?> clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] != SQLData.class) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        String string;
        String string2;
        this.checkNotClosed();
        try {
            string2 = this.tlp.values[n - 1];
            if (string2 == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            string = this.types[n - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
        Class<?> clazz = null;
        if (map != null && map.containsKey(string)) {
            clazz = map.get(string);
        }
        if (clazz == null) {
            clazz = MonetResultSet.getClassForType(this.JdbcSQLTypes[n - 1]);
        }
        if (clazz == null || clazz == String.class) {
            return string2;
        }
        if (clazz == BigDecimal.class) {
            return this.getBigDecimal(n);
        }
        if (clazz == Boolean.class) {
            return this.getBoolean(n);
        }
        if (clazz == Short.class) {
            return this.getShort(n);
        }
        if (clazz == Integer.class) {
            return this.getInt(n);
        }
        if (clazz == Long.class) {
            return this.getLong(n);
        }
        if (clazz == Float.class) {
            return Float.valueOf(this.getFloat(n));
        }
        if (clazz == Double.class) {
            return this.getDouble(n);
        }
        if (clazz == byte[].class) {
            return this.getBytes(n);
        }
        if (clazz == Date.class) {
            return this.getDate(n, null);
        }
        if (clazz == Time.class) {
            return this.getTime(n, null);
        }
        if (clazz == Timestamp.class) {
            return this.getTimestamp(n, null);
        }
        if (clazz == Clob.class) {
            return this.getClob(n);
        }
        if (clazz == Blob.class) {
            return this.getBlob(n);
        }
        if (this.classImplementsSQLData(clazz)) {
            SQLData sQLData;
            try {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                sQLData = (SQLData)constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new SQLException(noSuchMethodException.getMessage(), "M0M27");
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException(instantiationException.getMessage(), "M0M27");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SQLException(illegalAccessException.getMessage(), "M0M27");
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SQLException(invocationTargetException.getMessage(), "M0M27");
            }
            catch (SecurityException securityException) {
                throw new SQLException(securityException.getMessage(), "M0M27");
            }
            final int n2 = n;
            final boolean bl = this.wasNull();
            SQLInput sQLInput = new SQLInput(){

                @Override
                public String readString() throws SQLException {
                    return MonetResultSet.this.getString(n2);
                }

                @Override
                public boolean readBoolean() throws SQLException {
                    return MonetResultSet.this.getBoolean(n2);
                }

                @Override
                public byte readByte() throws SQLException {
                    return MonetResultSet.this.getByte(n2);
                }

                @Override
                public short readShort() throws SQLException {
                    return MonetResultSet.this.getShort(n2);
                }

                @Override
                public int readInt() throws SQLException {
                    return MonetResultSet.this.getInt(n2);
                }

                @Override
                public long readLong() throws SQLException {
                    return MonetResultSet.this.getLong(n2);
                }

                @Override
                public float readFloat() throws SQLException {
                    return MonetResultSet.this.getFloat(n2);
                }

                @Override
                public double readDouble() throws SQLException {
                    return MonetResultSet.this.getDouble(n2);
                }

                @Override
                public BigDecimal readBigDecimal() throws SQLException {
                    return MonetResultSet.this.getBigDecimal(n2);
                }

                @Override
                public byte[] readBytes() throws SQLException {
                    return MonetResultSet.this.getBytes(n2);
                }

                @Override
                public Date readDate() throws SQLException {
                    return MonetResultSet.this.getDate(n2, null);
                }

                @Override
                public Time readTime() throws SQLException {
                    return MonetResultSet.this.getTime(n2, null);
                }

                @Override
                public Timestamp readTimestamp() throws SQLException {
                    return MonetResultSet.this.getTimestamp(n2, null);
                }

                @Override
                public Reader readCharacterStream() throws SQLException {
                    return MonetResultSet.this.getCharacterStream(n2);
                }

                @Override
                public InputStream readAsciiStream() throws SQLException {
                    return MonetResultSet.this.getAsciiStream(n2);
                }

                @Override
                public InputStream readBinaryStream() throws SQLException {
                    return MonetResultSet.this.getBinaryStream(n2);
                }

                @Override
                public Object readObject() throws SQLException {
                    return MonetResultSet.this.getObject(n2);
                }

                @Override
                public Ref readRef() throws SQLException {
                    return MonetResultSet.this.getRef(n2);
                }

                @Override
                public Blob readBlob() throws SQLException {
                    return MonetResultSet.this.getBlob(n2);
                }

                @Override
                public Clob readClob() throws SQLException {
                    return MonetResultSet.this.getClob(n2);
                }

                @Override
                public Array readArray() throws SQLException {
                    return MonetResultSet.this.getArray(n2);
                }

                @Override
                public boolean wasNull() throws SQLException {
                    return bl;
                }

                @Override
                public java.net.URL readURL() throws SQLException {
                    return MonetResultSet.this.getURL(n2);
                }

                @Override
                public NClob readNClob() throws SQLException {
                    return MonetResultSet.this.getNClob(n2);
                }

                @Override
                public String readNString() throws SQLException {
                    return MonetResultSet.this.getNString(n2);
                }

                @Override
                public SQLXML readSQLXML() throws SQLException {
                    return MonetResultSet.this.getSQLXML(n2);
                }

                @Override
                public RowId readRowId() throws SQLException {
                    return MonetResultSet.this.getRowId(n2);
                }
            };
            sQLData.readSQL(sQLInput, string);
            return sQLData;
        }
        return string2;
    }

    static final Class<?> getClassForType(int n) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 16: {
                return Boolean.class;
            }
            case -6: 
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 7: {
                return Float.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case -4: 
            case -3: 
            case -2: {
                return byte[].class;
            }
            case 91: {
                return Date.class;
            }
            case 92: 
            case 2013: {
                return Time.class;
            }
            case 93: 
            case 2014: {
                return Timestamp.class;
            }
            case 2005: {
                return Clob.class;
            }
            case 2004: {
                return Blob.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getRef");
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getRef");
    }

    @Override
    public int getRow() {
        return this.curRow;
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getRowId");
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getRowId");
    }

    @Override
    public short getShort(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return 0;
            }
            this.lastReadWasNull = false;
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw MonetResultSet.newSQLNumberFormatException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public String getString(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return string;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public String getNString(int n) throws SQLException {
        return this.getString(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getSQLXML");
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getSQLXML");
    }

    private final int getJavaDate(Calendar calendar, int n, int n2) throws SQLException {
        int n3;
        String string;
        int n4;
        String string2;
        String string3;
        this.checkNotClosed();
        if (calendar == null) {
            throw new IllegalArgumentException("No Calendar object given!");
        }
        boolean bl = false;
        try {
            string3 = this.tlp.values[n - 1];
            if (string3 == null) {
                this.lastReadWasNull = true;
                return -1;
            }
            this.lastReadWasNull = false;
            string2 = this.types[n - 1];
            n4 = this.JdbcSQLTypes[n - 1];
            if (n4 == 1 || n4 == 12 || n4 == -1 || n4 == 2005) {
                n4 = n2;
            }
            if ((n4 == 91 || n4 == 93 || n4 == 2014) && string3.startsWith("-")) {
                bl = true;
                string = string3.substring(1);
            } else {
                string = string3;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
        TimeZone timeZone = calendar.getTimeZone();
        if (string2 != null && ("timetz".equals(string2) || "timestamptz".equals(string2)) && (n3 = string.length()) >= 6) {
            timeZone = TimeZone.getTimeZone("GMT" + string.substring(n3 - 6, n3));
        }
        java.util.Date date = null;
        ParsePosition parsePosition = new ParsePosition(0);
        switch (n4) {
            case 91: {
                if (this.dateFormat == null) {
                    this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                }
                this.dateFormat.setTimeZone(timeZone);
                date = this.dateFormat.parse(string, parsePosition);
                break;
            }
            case 92: 
            case 2013: {
                if (this.timeFormat == null) {
                    this.timeFormat = new SimpleDateFormat("HH:mm:ss");
                }
                this.timeFormat.setTimeZone(timeZone);
                date = this.timeFormat.parse(string, parsePosition);
                break;
            }
            case 93: 
            case 2014: {
                if (this.timestampFormat == null) {
                    this.timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                }
                this.timestampFormat.setTimeZone(timeZone);
                date = this.timestampFormat.parse(string, parsePosition);
                if (date != null || string.length() > 10 || !string.contains("-")) break;
                if (this.dateFormat == null) {
                    this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                }
                this.dateFormat.setTimeZone(timeZone);
                date = this.dateFormat.parse(string, parsePosition);
                break;
            }
            default: {
                throw new SQLException("Internal error, unsupported data type: " + n2, "01M03");
            }
        }
        if (date == null) {
            StringBuilder stringBuilder = new StringBuilder(128);
            int n5 = parsePosition.getErrorIndex();
            if (n5 == -1) {
                stringBuilder.append("parsing '").append(string3).append("' failed");
            } else if (n5 < string.length()) {
                stringBuilder.append("parsing failed at pos ").append(n5 + (bl ? 2 : 1)).append(" found: '").append(string.charAt(n5)).append("' in '").append(string3).append("'");
            } else {
                stringBuilder.append("parsing failed, expected more data after '").append(string3).append("'");
            }
            throw new SQLException(stringBuilder.toString(), "01M10");
        }
        calendar.setTime(date);
        if (bl) {
            calendar.set(0, 0);
        }
        if (n4 == 92 || n4 == 2013 || n4 == 93 || n4 == 2014) {
            char[] cArray;
            int n6 = 0;
            int n7 = parsePosition.getIndex();
            if (n7 < (cArray = string.toCharArray()).length && cArray[n7] == '.') {
                ++n7;
                try {
                    n6 = MonetResultSet.getIntrinsicValue(cArray[n7], n7++);
                    int n8 = 1;
                    while (n7 < cArray.length && cArray[n7] >= '0' && cArray[n7] <= '9') {
                        if (n8 < 9) {
                            n6 *= 10;
                            n6 += MonetResultSet.getIntrinsicValue(cArray[n7], n7);
                        }
                        if (n8 == 2) {
                            calendar.set(14, n6);
                        }
                        ++n7;
                        ++n8;
                    }
                    while (n8++ < 9) {
                        n6 *= 10;
                    }
                }
                catch (MCLParseException mCLParseException) {
                    int n9 = mCLParseException.getErrorOffset();
                    this.addWarning(mCLParseException.getMessage() + " found: '" + cArray[n9] + "' in: \"" + string + "\" at pos: " + n9, "01M10");
                    n6 = 0;
                }
            }
            return n6;
        }
        return 0;
    }

    private static final int getIntrinsicValue(char c, int n) throws MCLParseException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        throw new MCLParseException("Expected a digit", n);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        return this.getDate(n, null);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            if (calendar == null) {
                try {
                    return Date.valueOf(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    calendar = Calendar.getInstance();
                }
            }
            if (this.getJavaDate(calendar, n, 91) == -1) {
                return null;
            }
            return new Date(calendar.getTimeInMillis());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string), null);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        return this.getTime(n, null);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            if (calendar == null) {
                try {
                    return Time.valueOf(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    calendar = Calendar.getInstance();
                }
            }
            if (this.getJavaDate(calendar, n, 92) == -1) {
                return null;
            }
            return new Time(calendar.getTimeInMillis());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string), null);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, null);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.checkNotClosed();
        try {
            int n2;
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            if (calendar == null) {
                try {
                    return Timestamp.valueOf(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    calendar = Calendar.getInstance();
                }
            }
            if ((n2 = this.getJavaDate(calendar, n, 93)) == -1) {
                return null;
            }
            Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
            timestamp.setNanos(n2);
            return timestamp;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string), null);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public java.net.URL getURL(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            try {
                return new java.net.URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new SQLException(malformedURLException.getMessage(), "M1M05");
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public java.net.URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return this.warnings;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkNotClosed();
        return (long)this.curRow == this.tupleCount + 1L;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkNotClosed();
        return this.curRow == 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.header != null && this.header.isClosed();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkNotClosed();
        return this.curRow == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkNotClosed();
        return (long)this.curRow == this.tupleCount;
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    @Override
    public boolean next() throws SQLException {
        return this.relative(1);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.relative(-1);
    }

    @Override
    public boolean relative(int n) throws SQLException {
        return this.absolute(this.curRow + n);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("cancelRowUpdates");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("deleteRow");
    }

    @Override
    public void insertRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("insertRow");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("moveToCurrentRow");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("moveToInsertRow");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("refreshRow");
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateArray");
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateArray");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBigDecimal");
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBigDecimal");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBoolean");
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBoolean");
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateByte");
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateByte");
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBytes");
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBytes");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateDate");
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateDate");
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateDouble");
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateDouble");
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateFloat");
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateFloat");
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateInt");
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateInt");
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateLong");
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateLong");
    }

    @Override
    public void updateNull(int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNull");
    }

    @Override
    public void updateNull(String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNull");
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public void updateRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRow");
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRowId");
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRowId");
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateShort");
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateShort");
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateString");
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateString");
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNString");
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNString");
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateSQLXML");
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateSQLXML");
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateTime");
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateTime");
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateTimestamp");
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateTimestamp");
    }

    @Override
    public boolean wasNull() {
        return this.lastReadWasNull;
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        this.checkNotClosed();
        if (clazz == null) {
            throw new SQLException("type is null", "M1M05");
        }
        throw MonetResultSet.newSQLFeatureNotSupportedException("getObject(column, Class<T> type)");
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        return this.getObject(this.findColumn(string), clazz);
    }

    @Override
    public void updateObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(String string, Object object, SQLType sQLType, int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(int n, Object object, SQLType sQLType) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(String string, Object object, SQLType sQLType) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    private void addWarning(String string, String string2) {
        SQLWarning sQLWarning = new SQLWarning(string, string2);
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    private void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet is closed", "M1M20");
        }
    }

    public static final SQLDataException newSQLInvalidColumnIndexException(int n) {
        return new SQLDataException("Invalid Column Index number: " + n, "22010");
    }

    private static final SQLDataException newSQLNumberFormatException(NumberFormatException numberFormatException) {
        return new SQLDataException("Could not convert value to a number. " + numberFormatException.getMessage(), "22003");
    }

    private abstract class rsmdw
    extends MonetWrapper
    implements ResultSetMetaData {
        private rsmdw() {
        }
    }
}

