/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.mcl.parser;

import java.nio.Buffer;
import java.nio.CharBuffer;
import org.monetdb.mcl.parser.MCLParseException;

public final class StartOfHeaderParser {
    private CharBuffer soh = null;
    private int len;
    private int pos;
    public static final int Q_PARSE = 48;
    public static final int Q_TABLE = 49;
    public static final int Q_UPDATE = 50;
    public static final int Q_SCHEMA = 51;
    public static final int Q_TRANS = 52;
    public static final int Q_PREPARE = 53;
    public static final int Q_BLOCK = 54;

    public final int parse(String string) throws MCLParseException {
        this.soh = CharBuffer.wrap(string);
        this.soh.get();
        char c = this.soh.get();
        switch (c) {
            case '0': 
            case '3': {
                this.len = 0;
                break;
            }
            case '1': 
            case '5': {
                this.len = 4;
                this.soh.get();
                break;
            }
            case '2': {
                this.len = 2;
                this.soh.get();
                break;
            }
            case '4': {
                this.len = 1;
                this.soh.get();
                break;
            }
            case '6': {
                this.len = 3;
                this.soh.get();
                break;
            }
            default: {
                throw new MCLParseException("invalid or unknown header", 1);
            }
        }
        this.pos = 0;
        return c;
    }

    public final int getNextAsInt() throws MCLParseException {
        return (int)this.getNextAsLong();
    }

    public final long getNextAsLong() throws MCLParseException {
        ++this.pos;
        if (!this.soh.hasRemaining()) {
            throw new MCLParseException("unexpected end of string", this.soh.position() - 1);
        }
        boolean bl = true;
        char c = this.soh.get();
        if (c == '-') {
            bl = false;
            if (!this.soh.hasRemaining()) {
                throw new MCLParseException("unexpected end of string", this.soh.position() - 1);
            }
            c = this.soh.get();
        }
        long l = 0L;
        if (c >= '0' && c <= '9') {
            l = c - 48;
        } else {
            throw new MCLParseException("expected a digit", this.soh.position() - 1);
        }
        while (this.soh.hasRemaining() && (c = this.soh.get()) != ' ') {
            if (c >= '0' && c <= '9') {
                l *= 10L;
                l += (long)(c - 48);
                continue;
            }
            throw new MCLParseException("expected a digit", this.soh.position() - 1);
        }
        return bl ? l : -l;
    }

    public final String getNextAsString() throws MCLParseException {
        ++this.pos;
        if (!this.soh.hasRemaining()) {
            throw new MCLParseException("unexpected end of string", this.soh.position() - 1);
        }
        int n = 0;
        ((Buffer)this.soh).mark();
        while (this.soh.hasRemaining() && this.soh.get() != ' ') {
            ++n;
        }
        ((Buffer)this.soh).reset();
        return this.soh.subSequence(0, n).toString();
    }
}

