(ns {{name}}.utils
  (:require [ring.util.response :as response]
            [cemerick.friend :as friend]))

(defmacro wrap-if [handler predicate & body]
  `(if ~predicate
     (-> ~handler
         ~@body)))

(defn respond-with-file [filename]
  (response/file-response filename {:root "resources/public"}))

(defn get-id-from-request [request]
  (Integer. (:id (:route-params request))))

(defn current-user-id []
  (:id (friend/current-authentication)))