(ns {{name}}.routes
  (:require [compojure.route :as route]
            [compojure.core :as compojure]
            [{{name}}.authentication :as authentication]
            [{{name}}.utils :as utils]
            [{{name}}.home :as home]
            [cemerick.friend :as friend]
            (cemerick.friend [workflows :as workflows])))

(compojure/defroutes app-routes
  home/home-routes
  (route/resources "/")
  (route/not-found "Not Found"))

(def secured-routes
  (-> app-routes
      (friend/authenticate {:login-uri "/sign_in"
                            :credential-fn authentication/credential-fn
                            :workflows [(workflows/interactive-form)]})))
