(ns leiningen.new.monolith
  (:use [leiningen.new.templates :only [renderer name-to-path ->files]]))

(def render (renderer "monolith"))

(defn monolith
  "FIXME: write documentation"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (->files data
             [".gitignore" (render "gitignore")]
             ["project.clj" (render "project.clj" data)]
             ["src/{{sanitized}}/authentication.clj" (render "authentication.clj")]
             ["src/{{sanitized}}/core.clj" (render "core.clj")]
             ["src/{{sanitized}}/database.clj" (render "database.clj")]
             ["src/{{sanitized}}/home.clj" (render "home.clj")]
             ["src/{{sanitized}}/models.clj" (render "models.clj")]
             ["src/{{sanitized}}/routes.clj" (render "routes.clj")]
             ["src/{{sanitized}}/utils.clj" (render "utils.clj")]
             ["src/{{sanitized}}/views/layouts.clj" (render "layouts.clj")]
             "test/{{sanitized}}/test"
             "resources/public"
)))
