(ns morri.append-reports.readers
  (:require [clojure.string :as string]
            [morri.meth450k.common
             [utils :as utils]]
            [morri.meth-bed.col-fns :as col-fns]))

(def always (constantly true))

(defn identity-template [db-col]
  {:col (keyword db-col)
   :db-cols (keyword db-col)
   :transform-fn identity
   :valid? always})

(defn rename-template [[db-col new-col]]
  {:col (keyword new-col)
   :db-cols (keyword db-col)
   :transform-fn identity
   :valid? always})

(defn cpg-ucsc-template [[chr mapinfo]]
  {:col :ucsc
   :db-cols [chr mapinfo]
   :transform-fn col-fns/ucsc-from-chr-start
   :valid? always})

(defn avg-template [[db-cols col-name]]
  {:col col-name
   :db-cols db-cols
   :transform-fn (comp utils/average col-fns/only-numbers)
   :valid? always})

(defn std-dev-template [[db-cols col-name]]
  {:col col-name
   :db-cols db-cols
   :transform-fn (comp utils/std-dev col-fns/only-numbers)
   :valid? always})

(defn diff-template [[[treat-cols control-cols] col-name]]
  {:col col-name
   :db-cols [treat-cols control-cols]
   :transform-fn col-fns/diff-avg
   :valid? always})

(defn refseq-base [s]
  (first (re-seq #"^[^.]*" s)))

(defn refseq [[db-col new-col]]
  {:col (keyword new-col)
   :db-cols (keyword db-col)
   :transform-fn refseq-base
   :valid? always})

(def edn-readers {'templates/identity #'identity-template
                  'templates/avg #'avg-template
                  'templates/std-dev #'std-dev-template
                  'templates/diff #'diff-template
                  'templates/cpg-ucsc #'cpg-ucsc-template
                  'templates/rename #'rename-template
                  'templates/refseq #'refseq})
