(ns morri.cpg-lookup
  (:require
   [morri.meth450k.common
    [command-line :as cli]
    [illumina450k-db :as i450k-db]
    [utils :as utils]]
   [honeysql.core :as sql]
   [honeysql.helpers :refer :all]
   [snipsnap.core :as clip])
  (:gen-class))

(def options-config [["-h" "--help" "Generate ucsc tracks for 450K data" :default false :flag true]
                     ["--spread" "Compute ucsc coord +/- spread" :default 2000]])

(defn lookup-a-cpg [cpg]
  (first (i450k-db/i450k-query (sql/format (-> (select :mapinfo :chr)
                                                 (from i450k-db/i450k-table)
                                                 (where [:= :name cpg]))))))

(defn get-input [prompt]
  (println prompt)
  (read-line))

(defn -main  [& args]
  (let [options (cli/parse-command-line args options-config)]
    (lookup-a-cpg "cg11425201"); this realizes the delayed pool
    (loop []
      (let [input (get-input "Which cg to lookup or Ctrl-c to kill?")
            {:keys [chr mapinfo]} (lookup-a-cpg input)
            spread (:spread options)
            start (- mapinfo spread)
            stop (+ mapinfo spread)
            ucsc (utils/ucsc chr start stop)]
        (clip/set-text! ucsc)
        (println ucsc "(now in the clipboard)"))
      (recur))))
