(ns morri.lib
  (:require [clojure.java.io :as io]))

(defn index-of [e coll] (first (keep-indexed #(if (= e %2) %1) coll)))

(defmacro def-delay "Combination of (def def-name (delay body))" [def-name body]
  `(def ~def-name (delay ~body)))

(defn tprn [x]
  (do (prn x)
      x))

(defn write-list [a-file a-list]
  (with-open [wrtr (io/writer (io/file a-file))]
    (doseq [e a-list]
      (.write wrtr (str e \newline)))))

(defn which-is-better
  "Compare a and b according to criteria.  Criteria can return a
  number or be a pred."
  [a b criteria & {:keys [larger-is-better?] :or {larger-is-better? true}}]
  (let [result-a (criteria a)
        result-b (criteria b)]
    (when-not (= result-a result-b)
      (cond
       (nil? result-a) b
       (nil? result-b) a
       (or
        (number? result-a)
        (number? result-b)) (case larger-is-better?
                              true (if (> result-a result-b) a b)
                              false (if (< result-a result-b) a b))
        :else (if result-a a b)))))  ; Compare as booleans
