(ns morri.meth-bed.col-fns
  (:require [morri.meth450k.common
             [utils :as utils]]))

(def not-nil? (complement nil?))

(defn not-nan? [x]
  (not (Double/isNaN x)))
;; tested

(defn is-number? [x]
  (and
   (not-nil? x)
   (number? x)
   (not-nan? x)))

(def always (constantly true))

(def only-numbers (partial filter is-number?))

(defn diff-avg [cols]
  "Expect that cols is a nested array e.g. [[c1,c2,c3][c4,c5]]
with treated cols, then control cols. Result is Treated Cols minus Control Cols"
  (let [averages (map (comp utils/average only-numbers) cols)]
    (apply - averages)))

(defn ucsc-from-chr-start [[chr mapinfo]]
  (when mapinfo
    (utils/ucsc chr (dec mapinfo) (inc mapinfo))))

(defn ttest-wrapper [[coll1 coll2]]
  (utils/ttest (only-numbers coll1) (only-numbers coll2)))

(defn equal-var-ttest-wrapper [[coll1 coll2]]
  (utils/ttest (only-numbers coll1) (only-numbers coll2)))
