(ns morri.meth-bed.bed-templates
  (:require
   [morri.meth-bed.col-fns :as col-fns]
   [clojure.string :as string]
   [morri.meth450k.common
    [utils :as utils]]))

(def default-bedgraph-options
  {:type "bedGraph"
   :name ""
   :description ""
   :visibility "full"
   :color "0,0,0"
   :altColor "127,127,127"
   :autoScale "on"
   :alwaysZero "on"
   :viewLimits "-1:1"
   :graphType "bar"
   :yLineMark "0.0"
   :yLineOnOff "on"
   :windowingFunction "mean"
   :smoothingWindow "8"
   :maxHeightPixels "64:64:8"})

(defn make-bed-header [bed-name bed-description & opts]
  (let [opts-name-and-desc (assoc (apply hash-map opts) :name (utils/quoted bed-name)
                                  :description (utils/quoted bed-description))
        combined-options (for [[opt val] opts-name-and-desc]
                           (str (name opt) "=" val))
        options-string (string/join " " combined-options)]
    (str "track " options-string \newline)))

(defn make-bedgraph-header [graph-name description & opts]
  (let [bedgraph-options (merge default-bedgraph-options (apply hash-map opts))]
    (apply make-bed-header graph-name description (flatten (seq bedgraph-options)))))
;; tested

(def bedgraph-template-base
  [{:col :chr
   :db-cols :chr
   :transform-fn utils/require-chr
   :valid? identity}
  {:col :start
   :db-cols :mapinfo
   :transform-fn #(if (number? %) (dec %))
   :valid? col-fns/is-number?}
  {:col :stop
   :db-cols :mapinfo
   :transform-fn #(if (number? %) (inc %))
   :valid? col-fns/is-number?}])

(defn avg-bedgraph-template [db-cols]
  (conj bedgraph-template-base
        {:col :avg
         :db-cols db-cols
         :transform-fn (comp utils/average col-fns/only-numbers)
         :valid? col-fns/is-number?}))

(defn std-dev-bedgraph-template [db-cols]
  (conj bedgraph-template-base
        {:col :std-dev
         :db-cols db-cols
         :transform-fn (comp utils/std-dev col-fns/only-numbers)
         :valid? col-fns/is-number?}))

(defn diff-bedgraph-template [[treat-cols control-cols]]
  (conj bedgraph-template-base
        {:col :diff
         :db-cols [treat-cols control-cols] ; we flatten and use
                                        ; postwalk-replace below so OK!
         :transform-fn col-fns/diff-avg
         :valid? col-fns/is-number?}))
