(ns morri.meth450k.common.ucsc-db
  (:require [clojure.java.jdbc :as jdbc]
            [morri.meth450k.common.db-utils :as db-utils]))

(def ucsc-db (db-utils/mysql-db "ucsc"))

;; using a delay so that the c3p0 pool is not initailized when compiling
(def ucsc-db-pool (db-utils/make-delayed-db-pool ucsc-db))

(defn ucsc-query [sql-query]
  (jdbc/query @ucsc-db-pool sql-query :identifiers identity))

(def kg-table :knownGene)

(defn kg-count []
  (db-utils/count-rows ucsc-db kg-table))
