# seria

Seria is a schema-based serialization library for Clojure / ClojureScript.

## Features

* Good performance
* Extremely concise serialization
* Simple [hiccup](https://github.com/weavejester/hiccup)-like DSL for schema definitions
* Cross platform
* Supports all clojure primitives and data structures
* ... and some more: optionals, enums, multis: see docs

## Dependencies

project.clj:

    [moxaj/seria x.x.x]

ns declaration:

    (:require ...
              [seria.core :as seria]
              ...)

## Examples

Let's define a new config:

    (defconfig my-config {:foo [:list :bar]
                          :bar [:record {:baz [:tuple [:int :int]]
                                         :qux [:set :float]}]})

Prepare some stuff:

    (def data-1 [{:baz [1 1] :qux #{0.0 1.1 2.2}}
                 {:baz [2 2] :qux #{0.6 3.9 3.1 2.2 4.8}}])

Serialize it:

    (def bytes (serialize data-1 :foo my-config))
     => #object["[B" 0x63481323 "[B@63481323"] ; byte[]

Deserialize it:

    (let [[schema data-2] (deserialize bytes my-config)]
      (println schema)
      (println data-2))
     => :foo
     => ({:baz [1 1], :qux #{0.0 2.2 1.1}} {:baz [2 2], :qux #{3.1 2.2 3.9 4.8 0.6}})

Yay!

### What just happened?

First off, we made a new config, which defines our schemas: ```foo``` and ```bar```.
```foo``` is a list of ```bar```-s and ```bar``` is a record with two fields: ```baz```,
an (int, int) tuple, and ```qux```, a set of floats.

Then we made some data and serialized it as a ```foo``` and then immediately deserialized
it, returning the original schema ```foo``` and the actual data.

For further information, please check out the docs.

## See also

* [Buffy](https://github.com/clojurewerkz/buffy)
* [Gloss](https://github.com/ztellman/gloss)

## License

Copyright  2015 Viktor Magyari. Distributed under the Eclipse Public License, the same as Clojure.