(ns org.hellodata.crypto
  (:require [buddy.core.dsa :as dsa]
            [buddy.core.keys :as keys]
            [base64-clj.core :as base64]
            [clojure.string :as str]
            [clojure.java.io :as io])
  (:import [java.security Signature]
           [javax.crypto Cipher]))

(defn- sha1-signer
  []
  (Signature/getInstance "Sha1withRSA" "BC"))

(defn path->private-key
  [path]
  (keys/private-key path))

(defn str->private-key
  [str]
  #_(when (= 128 (Cipher/getMaxAllowedKeyLength "Sha1withRSA"))
    (throw (ex-info "Cannot use keys because of legal restrictions.
Use OpenJDK or if you want to use the Oracle JDK, please install the
Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction
Policy Files.

See
 - http://stackoverflow.com/questions/25844026/key-length-limit-with-java-cryptography-extension
 - Java 7: http://www.oracle.com/technetwork/java/javase/downloads/jce-7-download-432124.html
 - Java 8: http://www.oracle.com/technetwork/java/javase/downloads/jce8-download-2133166.html
" {})))
  
  (keys/str->private-key str))

(defn sign-string
  [private-key s]
  (String. (base64/encode-bytes (dsa/sign s {:key private-key :alg sha1-signer}))))
