(ns org.hellodata.api-client
  (:require [org.hellodata.api.oauth :as api.oauth]
            [org.hellodata.api.spa :as api.spa]
            [clojure.string :as string]
            [org.hellodata.api.request :as request]
            [clj-http.client :as http.client]
            [cheshire.core :as json]))

(defn sources-authentication
  ([config tags]
   (sources-authentication config tags false))
  ([config tags history?]
   (-> config
       (api.spa/sources-authentication tags history?)
       http.client/request
       api.oauth/response->token)))

(defn access-token
  [config request-token verifier]
  (-> config
      (api.oauth/access-token-request request-token verifier)
      http.client/request
      api.oauth/response->token))

(defn sources
  [config access-token]
  (-> config
      (api.spa/sources access-token)
      http.client/request
      :body))

(defn subscribe
  [config access-token sources]
  (-> config
      (api.spa/subscribe access-token sources)
      http.client/request))

(defn subscriptions
  [config access-token]
  (-> config
      (api.spa/subscriptions access-token)
      http.client/request
      :body))

(defn batch-data-request
  [config subscription-identifiers from to]
  (-> config
      (api.spa/batch-data-request subscription-identifiers from to)
      http.client/request))

(defn neartime-data-request
  [config subscription-identifiers interval]
  (-> config
      (api.spa/neartime-data-request subscription-identifiers interval)
      http.client/request))





