/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmpjct.mysql.proto;

import com.github.jmpjct.mysql.proto.Packet;
import com.github.jmpjct.mysql.proto.Proto;
import java.util.ArrayList;

public class Auth_Response
extends Packet {
    public long capabilityFlags = 512L;
    public long maxPacketSize = 0L;
    public long characterSet = 0L;
    public String username = "";
    public String authResponse = "";
    public String schema = "";

    public void setCapabilityFlag(long l) {
        this.capabilityFlags |= l;
    }

    public void removeCapabilityFlag(long l) {
        this.capabilityFlags &= l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void toggleCapabilityFlag(long l) {
        this.capabilityFlags ^= l;
    }

    public boolean hasCapabilityFlag(long l) {
        return (this.capabilityFlags & l) == l;
    }

    @Override
    public ArrayList<byte[]> getPayload() {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        if ((this.capabilityFlags & 0x200L) != 0L) {
            arrayList.add(Proto.build_fixed_int(4, this.capabilityFlags));
            arrayList.add(Proto.build_fixed_int(4, this.maxPacketSize));
            arrayList.add(Proto.build_fixed_int(1, this.characterSet));
            arrayList.add(Proto.build_fixed_str(23, ""));
            arrayList.add(Proto.build_null_str(this.username));
            if (this.hasCapabilityFlag(32768L)) {
                arrayList.add(Proto.build_lenenc_str(this.authResponse));
            } else {
                arrayList.add(Proto.build_null_str(this.authResponse));
            }
            arrayList.add(Proto.build_fixed_str(this.schema.length(), this.schema));
        } else {
            arrayList.add(Proto.build_fixed_int(2, this.capabilityFlags));
            arrayList.add(Proto.build_fixed_int(3, this.maxPacketSize));
            arrayList.add(Proto.build_null_str(this.username));
            arrayList.add(Proto.build_null_str(this.authResponse));
        }
        return arrayList;
    }

    public static Auth_Response loadFromPacket(byte[] byArray) {
        Auth_Response auth_Response = new Auth_Response();
        Proto proto = new Proto(byArray, 3);
        auth_Response.sequenceId = proto.get_fixed_int(1);
        auth_Response.capabilityFlags = proto.get_fixed_int(2);
        proto.offset -= 2;
        if (auth_Response.hasCapabilityFlag(512L)) {
            auth_Response.capabilityFlags = proto.get_fixed_int(4);
            auth_Response.maxPacketSize = proto.get_fixed_int(4);
            auth_Response.characterSet = proto.get_fixed_int(1);
            proto.get_fixed_str(23);
            auth_Response.username = proto.get_null_str();
            auth_Response.authResponse = auth_Response.hasCapabilityFlag(32768L) ? proto.get_lenenc_str() : proto.get_null_str();
            auth_Response.schema = proto.get_eop_str();
        } else {
            auth_Response.capabilityFlags = proto.get_fixed_int(2);
            auth_Response.maxPacketSize = proto.get_fixed_int(3);
            auth_Response.username = proto.get_null_str();
            auth_Response.schema = proto.get_null_str();
        }
        return auth_Response;
    }
}

