/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmpjct.mysql.proto;

import com.github.jmpjct.mysql.proto.ColCount;
import com.github.jmpjct.mysql.proto.EOF;
import com.github.jmpjct.mysql.proto.Proto;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.io.HexDump;
import org.apache.log4j.Logger;

public abstract class Packet {
    public long sequenceId = 0L;

    public abstract ArrayList<byte[]> getPayload();

    public byte[] toPacket() {
        ArrayList<byte[]> arrayList = this.getPayload();
        int n = 0;
        for (byte[] byArray : arrayList) {
            n += byArray.length;
        }
        Object object = new byte[n + 4];
        System.arraycopy(Proto.build_fixed_int(3, n), 0, object, 0, 3);
        System.arraycopy(Proto.build_fixed_int(1, this.sequenceId), 0, object, 3, 1);
        int n2 = 4;
        for (byte[] byArray : arrayList) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    public static int getSize(byte[] byArray) {
        int n = (int)new Proto(byArray).get_fixed_int(3);
        return n;
    }

    public static byte getType(byte[] byArray) {
        return byArray[4];
    }

    public static long getSequenceId(byte[] byArray) {
        return new Proto(byArray, 3).get_fixed_int(1);
    }

    public static final void dump(byte[] byArray) {
        Logger logger = Logger.getLogger((String)"MySQL.Packet");
        if (!logger.isTraceEnabled()) {
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            HexDump.dump((byte[])byArray, (long)0L, (OutputStream)byteArrayOutputStream, (int)0);
            logger.trace((Object)("Dumping packet\n" + byteArrayOutputStream.toString()));
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static byte[] read_packet(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        byte[] byArray = new byte[3];
        int n3 = 0;
        int n4 = 3;
        do {
            if ((n = inputStream.read(byArray, n3, n4 - n3)) != -1) continue;
            throw new IOException();
        } while ((n3 += n) != n4);
        n2 = Packet.getSize(byArray);
        byte[] byArray2 = new byte[n2 + 4];
        System.arraycopy(byArray, 0, byArray2, 0, 3);
        byArray = byArray2;
        byArray2 = null;
        n4 = byArray.length;
        do {
            if ((n = inputStream.read(byArray, n3, n4 - n3)) != -1) continue;
            throw new IOException();
        } while ((n3 += n) != n4);
        return byArray;
    }

    public static ArrayList<byte[]> read_full_result_set(InputStream inputStream, OutputStream outputStream, ArrayList<byte[]> arrayList, boolean bl) throws IOException {
        byte[] byArray = arrayList.get(arrayList.size() - 1);
        long l = ColCount.loadFromPacket((byte[])byArray).colCount;
        int n = 0;
        while ((long)n < l + 1L) {
            byArray = Packet.read_packet(inputStream);
            if (byArray == null) {
                throw new IOException();
            }
            arrayList.add(byArray);
            if (!bl) {
                Packet.write(outputStream, arrayList);
                outputStream.flush();
                arrayList.clear();
            }
            ++n;
        }
        n = 65535;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        while (true) {
            if ((byArray = Packet.read_packet(inputStream)) == null) {
                throw new IOException();
            }
            byte by = Packet.getType(byArray);
            if (by == -2 || by == -1) break;
            if (n2 + byArray.length > n) {
                int n3 = n - n2;
                System.arraycopy(byArray, 0, byArray2, n2, n3);
                arrayList.add(byArray2);
                if (!bl) {
                    Packet.write(outputStream, arrayList);
                    outputStream.flush();
                    arrayList.clear();
                }
                byArray2 = new byte[n];
                n2 = 0;
                System.arraycopy(byArray, n3, byArray2, n2, byArray.length - n3);
                n2 += byArray.length - n3;
                continue;
            }
            System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
            n2 += byArray.length;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        arrayList.add(byArray3);
        byArray2 = byArray;
        arrayList.add(byArray2);
        if (!bl) {
            Packet.write(outputStream, arrayList);
            arrayList.clear();
            outputStream.flush();
        }
        if (Packet.getType(byArray) == -1) {
            return arrayList;
        }
        if (EOF.loadFromPacket(byArray).hasStatusFlag(8L)) {
            arrayList.add(Packet.read_packet(inputStream));
            arrayList = Packet.read_full_result_set(inputStream, outputStream, arrayList, bl);
        }
        return arrayList;
    }

    public static void write(OutputStream outputStream, ArrayList<byte[]> arrayList) throws IOException {
        for (byte[] byArray : arrayList) {
            outputStream.write(byArray);
        }
    }
}

