/*
 * Decompiled with CFR 0.152.
 */
package com.github.mpjct.jmpjct.mysql.proto;

import com.github.mpjct.jmpjct.mysql.proto.Packet;
import com.github.mpjct.jmpjct.mysql.proto.Proto;
import java.util.ArrayList;

public class HandshakeResponse
extends Packet {
    public long capabilityFlags = 512L;
    public long maxPacketSize = 0L;
    public long characterSet = 0L;
    public String username = "";
    public long authResponseLen = 0L;
    public String authResponse = "";
    public String schema = "";
    public String pluginName = "";
    public long clientAttributesLen = 0L;
    public String clientAttributes = "";

    public void setCapabilityFlag(long l) {
        this.capabilityFlags |= l;
    }

    public void removeCapabilityFlag(long l) {
        this.capabilityFlags &= l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void toggleCapabilityFlag(long l) {
        this.capabilityFlags ^= l;
    }

    public boolean hasCapabilityFlag(long l) {
        return (this.capabilityFlags & l) == l;
    }

    @Override
    public ArrayList<byte[]> getPayload() {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        if ((this.capabilityFlags & 0x200L) != 0L) {
            arrayList.add(Proto.build_fixed_int(4, this.capabilityFlags));
            arrayList.add(Proto.build_fixed_int(4, this.maxPacketSize));
            arrayList.add(Proto.build_fixed_int(1, this.characterSet));
            arrayList.add(Proto.build_filler(23));
            arrayList.add(Proto.build_null_str(this.username));
            if (this.hasCapabilityFlag(0x200000L)) {
                arrayList.add(Proto.build_lenenc_int(this.authResponseLen));
                arrayList.add(Proto.build_fixed_str(this.authResponseLen, this.authResponse, true));
            } else if (this.hasCapabilityFlag(32768L)) {
                arrayList.add(Proto.build_fixed_int(1, this.authResponseLen));
                arrayList.add(Proto.build_fixed_str(this.authResponseLen, this.authResponse, true));
            } else {
                arrayList.add(Proto.build_null_str(this.authResponse));
            }
            if (this.hasCapabilityFlag(8L)) {
                arrayList.add(Proto.build_null_str(this.schema));
            }
            if (this.hasCapabilityFlag(524288L)) {
                arrayList.add(Proto.build_null_str(this.pluginName));
            }
            if (this.hasCapabilityFlag(0x100000L)) {
                arrayList.add(Proto.build_lenenc_int(this.clientAttributesLen));
                arrayList.add(Proto.build_eop_str(this.clientAttributes));
            }
        } else {
            arrayList.add(Proto.build_fixed_int(2, this.capabilityFlags));
            arrayList.add(Proto.build_fixed_int(3, this.maxPacketSize));
            arrayList.add(Proto.build_null_str(this.username));
            if (this.hasCapabilityFlag(8L)) {
                arrayList.add(Proto.build_null_str(this.authResponse));
                arrayList.add(Proto.build_null_str(this.schema));
            } else {
                arrayList.add(Proto.build_eop_str(this.authResponse));
            }
        }
        return arrayList;
    }

    public static HandshakeResponse loadFromPacket(byte[] byArray) {
        HandshakeResponse handshakeResponse = new HandshakeResponse();
        Proto proto = new Proto(byArray, 3);
        handshakeResponse.sequenceId = proto.get_fixed_int(1);
        handshakeResponse.capabilityFlags = proto.get_fixed_int(2);
        proto.offset -= 2;
        if (handshakeResponse.hasCapabilityFlag(512L)) {
            handshakeResponse.capabilityFlags = proto.get_fixed_int(4);
            handshakeResponse.maxPacketSize = proto.get_fixed_int(4);
            handshakeResponse.characterSet = proto.get_fixed_int(1);
            proto.get_filler(23);
            handshakeResponse.username = proto.get_null_str();
            if (handshakeResponse.hasCapabilityFlag(0x200000L)) {
                handshakeResponse.authResponseLen = proto.get_lenenc_int();
                handshakeResponse.authResponse = proto.get_fixed_str(handshakeResponse.authResponseLen, true);
            } else if (handshakeResponse.hasCapabilityFlag(32768L)) {
                handshakeResponse.authResponseLen = proto.get_fixed_int(1);
                handshakeResponse.authResponse = proto.get_fixed_str(handshakeResponse.authResponseLen, true);
            } else {
                handshakeResponse.authResponse = proto.get_null_str();
            }
            if (handshakeResponse.hasCapabilityFlag(8L)) {
                handshakeResponse.schema = proto.get_null_str();
            }
            if (handshakeResponse.hasCapabilityFlag(524288L)) {
                handshakeResponse.pluginName = proto.get_null_str();
            }
            if (handshakeResponse.hasCapabilityFlag(0x100000L)) {
                handshakeResponse.clientAttributesLen = proto.get_lenenc_int();
                handshakeResponse.clientAttributes = proto.get_eop_str();
            }
        } else {
            handshakeResponse.capabilityFlags = proto.get_fixed_int(2);
            handshakeResponse.maxPacketSize = proto.get_fixed_int(3);
            handshakeResponse.username = proto.get_null_str();
            if (handshakeResponse.hasCapabilityFlag(8L)) {
                handshakeResponse.authResponse = proto.get_null_str();
                handshakeResponse.schema = proto.get_null_str();
            } else {
                handshakeResponse.authResponse = proto.get_eop_str();
            }
        }
        return handshakeResponse;
    }
}

