/*
 * Decompiled with CFR 0.152.
 */
package com.github.mpjct.jmpjct.mysql.proto;

import java.util.ArrayList;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

public class Proto {
    public byte[] packet = null;
    public int offset = 0;

    public Proto(byte[] byArray) {
        this.packet = byArray;
    }

    public Proto(byte[] byArray, int n) {
        this.packet = byArray;
        this.offset = n;
    }

    public boolean has_remaining_data() {
        return this.packet.length - this.offset > 0;
    }

    public static byte[] build_fixed_int(int n, long l) {
        byte[] byArray = new byte[n];
        if (n == 8) {
            byArray[0] = (byte)(l >> 0 & 0xFFL);
            byArray[1] = (byte)(l >> 8 & 0xFFL);
            byArray[2] = (byte)(l >> 16 & 0xFFL);
            byArray[3] = (byte)(l >> 24 & 0xFFL);
            byArray[4] = (byte)(l >> 32 & 0xFFL);
            byArray[5] = (byte)(l >> 40 & 0xFFL);
            byArray[6] = (byte)(l >> 48 & 0xFFL);
            byArray[7] = (byte)(l >> 56 & 0xFFL);
        } else if (n == 6) {
            byArray[0] = (byte)(l >> 0 & 0xFFL);
            byArray[1] = (byte)(l >> 8 & 0xFFL);
            byArray[2] = (byte)(l >> 16 & 0xFFL);
            byArray[3] = (byte)(l >> 24 & 0xFFL);
            byArray[4] = (byte)(l >> 32 & 0xFFL);
            byArray[5] = (byte)(l >> 40 & 0xFFL);
        } else if (n == 4) {
            byArray[0] = (byte)(l >> 0 & 0xFFL);
            byArray[1] = (byte)(l >> 8 & 0xFFL);
            byArray[2] = (byte)(l >> 16 & 0xFFL);
            byArray[3] = (byte)(l >> 24 & 0xFFL);
        } else if (n == 3) {
            byArray[0] = (byte)(l >> 0 & 0xFFL);
            byArray[1] = (byte)(l >> 8 & 0xFFL);
            byArray[2] = (byte)(l >> 16 & 0xFFL);
        } else if (n == 2) {
            byArray[0] = (byte)(l >> 0 & 0xFFL);
            byArray[1] = (byte)(l >> 8 & 0xFFL);
        } else if (n == 1) {
            byArray[0] = (byte)(l >> 0 & 0xFFL);
        } else {
            Logger.getLogger((String)"MySQL.Proto").fatal((Object)("Encoding int[" + n + "] " + l + " failed!"));
            return null;
        }
        return byArray;
    }

    public static byte[] build_lenenc_int(long l) {
        byte[] byArray = null;
        byArray = l < 251L ? new byte[]{(byte)(l >> 0 & 0xFFL)} : (l < 65535L ? new byte[]{-4, (byte)(l >> 0 & 0xFFL), (byte)(l >> 8 & 0xFFL)} : (l < 0xFFFFFFL ? new byte[]{-3, (byte)(l >> 0 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL)} : new byte[]{-2, (byte)(l >> 0 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 56 & 0xFFL)}));
        return byArray;
    }

    public static byte[] build_lenenc_str(String string) {
        return Proto.build_lenenc_str(string, false);
    }

    public static byte[] build_lenenc_str(String string, boolean bl) {
        if (string.equals("")) {
            byte[] byArray = new byte[]{0};
            return byArray;
        }
        int n = string.length();
        if (bl) {
            n = Base64.decodeBase64((String)string).length;
        }
        byte[] byArray = Proto.build_lenenc_int(n);
        byte[] byArray2 = Proto.build_fixed_str(n, string, bl);
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static byte[] build_null_str(String string) {
        return Proto.build_null_str(string, false);
    }

    public static byte[] build_null_str(String string, boolean bl) {
        int n = string.length() + 1;
        if (bl) {
            n = Base64.decodeBase64((String)string).length + 1;
        }
        return Proto.build_fixed_str(string.length() + 1, string, bl);
    }

    public static byte[] build_fixed_str(long l, String string) {
        return Proto.build_fixed_str((int)l, string);
    }

    public static byte[] build_fixed_str(long l, String string, boolean bl) {
        return Proto.build_fixed_str((int)l, string, bl);
    }

    public static byte[] build_fixed_str(int n, String string) {
        return Proto.build_fixed_str(n, string, false);
    }

    public static byte[] build_fixed_str(int n, String string, boolean bl) {
        byte[] byArray = new byte[n];
        byte[] byArray2 = null;
        byArray2 = bl ? Base64.decodeBase64((String)string) : string.getBytes();
        if (byArray2.length < byArray.length) {
            n = byArray2.length;
        }
        System.arraycopy(byArray2, 0, byArray, 0, n);
        return byArray;
    }

    public static byte[] build_eop_str(String string) {
        return Proto.build_eop_str(string, false);
    }

    public static byte[] build_eop_str(String string, boolean bl) {
        int n = string.length();
        if (bl) {
            n = Base64.decodeBase64((String)string).length;
        }
        return Proto.build_fixed_str(n, string, bl);
    }

    public static byte[] build_filler(int n) {
        return Proto.build_filler(n, (byte)0);
    }

    public static byte[] build_filler(int n, int n2) {
        return Proto.build_filler(n, (byte)n2);
    }

    public static byte[] build_filler(int n, byte by) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = by;
        }
        return byArray;
    }

    public static byte[] build_byte(byte by) {
        byte[] byArray = new byte[]{by};
        return byArray;
    }

    public static char int2char(byte by) {
        return (char)by;
    }

    public static byte char2int(char c) {
        return (byte)c;
    }

    public long get_fixed_int(int n) {
        byte[] byArray = null;
        if (this.packet.length < n + this.offset) {
            return -1L;
        }
        byArray = new byte[n];
        System.arraycopy(this.packet, this.offset, byArray, 0, n);
        this.offset += n;
        return Proto.get_fixed_int(byArray);
    }

    public static long get_fixed_int(byte[] byArray) {
        long l = 0L;
        for (int i = byArray.length - 1; i > 0; --i) {
            l |= (long)(byArray[i] & 0xFF);
            l <<= 8;
        }
        return l |= (long)(byArray[0] & 0xFF);
    }

    public void get_filler(int n) {
        this.offset += n;
    }

    public long get_lenenc_int() {
        int n = 0;
        if (this.packet[this.offset] < 251) {
            n = 1;
        } else if (this.packet[this.offset] == 252) {
            ++this.offset;
            n = 2;
        } else if (this.packet[this.offset] == 253) {
            ++this.offset;
            n = 3;
        } else if (this.packet[this.offset] == 254) {
            ++this.offset;
            n = 8;
        }
        if (n == 0) {
            Logger.getLogger((String)"MySQL.Proto").fatal((Object)("Decoding int at offset " + this.offset + " failed!"));
            return -1L;
        }
        return this.get_fixed_int(n);
    }

    public String get_fixed_str(long l) {
        return this.get_fixed_str((int)l);
    }

    public String get_fixed_str(long l, boolean bl) {
        return this.get_fixed_str((int)l, bl);
    }

    public String get_fixed_str(int n) {
        int n2 = this.offset;
        int n3 = this.offset + n;
        if (n3 > this.packet.length) {
            n3 = this.packet.length;
            n = n3 - n2;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = n2; i < n3; ++i) {
            stringBuilder.append(Proto.int2char(this.packet[i]));
            ++this.offset;
        }
        return stringBuilder.toString();
    }

    public String get_fixed_str(int n, boolean bl) {
        int n2 = this.offset;
        int n3 = this.offset + n;
        if (n3 > this.packet.length) {
            n3 = this.packet.length;
            n = n3 - n2;
        }
        if (!bl) {
            return this.get_fixed_str(n);
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.packet, n2, byArray, 0, n);
        this.offset += n;
        return Base64.encodeBase64String((byte[])byArray);
    }

    public String get_null_str() {
        return this.get_null_str(false);
    }

    public String get_null_str(boolean bl) {
        int n = 0;
        for (int i = this.offset; i < this.packet.length && this.packet[i] != 0; ++i) {
            ++n;
        }
        String string = this.get_fixed_str(n, bl);
        ++this.offset;
        return string;
    }

    public String get_eop_str() {
        return this.get_eop_str(false);
    }

    public String get_eop_str(boolean bl) {
        int n = this.packet.length - this.offset;
        return this.get_fixed_str(n, bl);
    }

    public String get_lenenc_str() {
        return this.get_lenenc_str(false);
    }

    public String get_lenenc_str(boolean bl) {
        int n = (int)this.get_lenenc_int();
        return this.get_fixed_str(n, bl);
    }

    public static byte[] arraylist_to_array(ArrayList<byte[]> arrayList) {
        int n = 0;
        for (byte[] byArray : arrayList) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : arrayList) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    public static byte[] packet_string_to_bytes(String string) {
        byte[] byArray = null;
        string = string.replaceAll("\\s", "").toUpperCase();
        try {
            byArray = Hex.decodeHex((char[])string.toCharArray());
        }
        catch (DecoderException decoderException) {
            // empty catch block
        }
        return byArray;
    }
}

