/*
 * Decompiled with CFR 0.152.
 */
package com.github.mpjct.jmpjct.mysql.proto;

import com.github.mpjct.jmpjct.mysql.proto.Proto;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class ProtoTest {
    @Test
    public void test_all_byte_values() {
        int n;
        byte[] byArray = new byte[256];
        int n2 = 0;
        for (n = 0; n <= 126; n = (int)((byte)(n + 1))) {
            byArray[n2] = n;
            ++n2;
        }
        byArray[n2] = 127;
        ++n2;
        for (n = -128; n <= -1; n = (int)((byte)(n + 1))) {
            byArray[n2] = n;
            ++n2;
        }
        Proto proto = new Proto(byArray);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(Proto.build_fixed_str(byArray.length, proto.get_fixed_str(byArray.length, true), true));
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.arraylist_to_array(arrayList));
    }

    @Test
    public void test1() {
        byte[] byArray = new byte[]{0};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_fixed_int(1, 0L));
    }

    @Test
    public void test2() {
        byte[] byArray = new byte[]{-1};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_fixed_int(1, 255L));
    }

    @Test
    public void test3() {
        byte[] byArray = new byte[]{0, 0};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_fixed_int(2, 0L));
    }

    @Test
    public void test4() {
        byte[] byArray = new byte[]{-1, -1};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_fixed_int(2, 65535L));
    }

    @Test
    public void test5() {
        byte[] byArray = new byte[]{0, 0, 0};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_fixed_int(3, 0L));
    }

    @Test
    public void test6() {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_fixed_int(4, 0L));
    }

    @Test
    public void test7() {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_fixed_int(8, 0L));
    }

    @Test
    public void test8() {
        byte[] byArray = new byte[]{-1, 0, 0, 0, 0, 0, 0, 0};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_fixed_int(8, 255L));
    }

    @Test
    public void test9() {
        byte[] byArray = new byte[]{0};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_lenenc_int(0L));
    }

    @Test
    public void test10() {
        byte[] byArray = new byte[]{-4, -5, 0};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_lenenc_int(251L));
    }

    @Test
    public void test11() {
        byte[] byArray = new byte[]{-4, -4, 0};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_lenenc_int(252L));
    }

    @Test
    public void test12() {
        byte[] byArray = new byte[]{-3, 0, 0, 1};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_lenenc_int(65536L));
    }

    @Test
    public void test13() {
        byte[] byArray = new byte[]{-2, 0, 0, 0, 1, 0, 0, 0, 0};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_lenenc_int(0x1000000L));
    }

    @Test
    public void test14() {
        byte[] byArray = new byte[]{-2, 0, 0, 0, 2, 0, 0, 0, 0};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_lenenc_int(0x2000000L));
    }

    @Test
    public void test15() {
        byte[] byArray = new byte[]{3, 97, 98, 99};
        String string = new String("abc");
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_lenenc_str(string));
    }

    @Test
    public void test16() {
        byte[] byArray = new byte[]{0};
        String string = new String("");
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_lenenc_str(string));
    }

    @Test
    public void test17() {
        byte[] byArray = new byte[]{-4, 36, 9, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51, 97, 98, 99, 49, 50, 51};
        String string = "abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123abc123";
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_lenenc_str(string));
    }

    @Test
    public void test18() {
        byte[] byArray = new byte[]{0};
        String string = new String("");
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_null_str(string));
    }

    @Test
    public void test19() {
        byte[] byArray = new byte[]{97, 98, 99, 0};
        String string = new String("abc");
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_null_str(string));
    }

    @Test
    public void test20() {
        byte[] byArray = new byte[]{0, 0, 0};
        String string = new String("");
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_fixed_str(3, string));
    }

    @Test
    public void test21() {
        byte[] byArray = new byte[]{97, 98, 99};
        String string = new String("abc");
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_fixed_str(3, string));
    }

    @Test
    public void test22() {
        byte[] byArray = new byte[]{97, 98};
        String string = new String("abc");
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_fixed_str(2, string));
    }

    @Test
    public void test23() {
        byte[] byArray = new byte[]{97, 98};
        String string = new String("ab");
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_eop_str(string));
    }

    @Test
    public void test24() {
        byte[] byArray = new byte[]{0};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_filler(1));
    }

    @Test
    public void test25() {
        byte[] byArray = new byte[]{0, 0};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_filler(2));
    }

    @Test
    public void test26() {
        byte[] byArray = new byte[]{28, 28};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_filler(2, (byte)28));
    }

    @Test
    public void test27() {
        byte[] byArray = new byte[]{-1, -1};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_filler(2, (byte)-1));
    }

    @Test
    public void test28() {
        byte[] byArray = new byte[]{0};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_byte((byte)0));
    }

    @Test
    public void test29() {
        byte[] byArray = new byte[]{1};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_byte((byte)1));
    }

    @Test
    public void test30() {
        byte[] byArray = new byte[]{-1};
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.build_byte((byte)-1));
    }

    @Test
    public void test31() {
        byte[] byArray = new byte[]{-1};
        Proto proto = new Proto(byArray);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(Proto.build_fixed_str(byArray.length, proto.get_fixed_str(byArray.length, true), true));
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.arraylist_to_array(arrayList));
    }

    @Test
    public void test32() {
        byte[] byArray = new byte[]{-1, -1};
        Proto proto = new Proto(byArray);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(Proto.build_fixed_str(byArray.length, proto.get_fixed_str(byArray.length, true), true));
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.arraylist_to_array(arrayList));
    }

    @Test
    public void test33() {
        byte[] byArray = new byte[]{-1, -1, -1};
        Proto proto = new Proto(byArray);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(Proto.build_fixed_str(byArray.length, proto.get_fixed_str(byArray.length, true), true));
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.arraylist_to_array(arrayList));
    }

    @Test
    public void test34() {
        byte[] byArray = new byte[]{-1, -1, -1, -1};
        Proto proto = new Proto(byArray);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(Proto.build_fixed_str(byArray.length, proto.get_fixed_str(byArray.length, true), true));
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.arraylist_to_array(arrayList));
    }

    @Test
    public void test35() {
        byte[] byArray = new byte[]{-1, -1, -1, -1, -1};
        Proto proto = new Proto(byArray);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(Proto.build_fixed_str(byArray.length, proto.get_fixed_str(byArray.length, true), true));
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.arraylist_to_array(arrayList));
    }

    @Test
    public void test36() {
        byte[] byArray = Proto.packet_string_to_bytes("5C 49 4D 5E 4E 58 4F 47 00");
        Proto proto = new Proto(byArray);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(Proto.build_eop_str(proto.get_eop_str(true), true));
        Assert.assertArrayEquals((byte[])byArray, (byte[])Proto.arraylist_to_array(arrayList));
    }
}

