/*
 * Decompiled with CFR 0.152.
 */
package com.github.mpjct.jmpjct.plugin.debug;

import com.github.mpjct.jmpjct.Engine;
import com.github.mpjct.jmpjct.mysql.proto.Packet;
import com.github.mpjct.jmpjct.plugin.Base;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class Debug
extends Base {
    public Logger logger = Logger.getLogger((String)"Plugin.Debug");

    @Override
    public void read_handshake(Engine engine) {
        this.logger.debug((Object)"<- HandshakePacket");
        this.logger.debug((Object)("   Server Version: " + engine.handshake.serverVersion));
        this.logger.debug((Object)("   Connection Id: " + engine.handshake.connectionId));
        this.logger.debug((Object)("   Server Capability Flags: " + Debug.dump_capability_flags(engine.handshake.capabilityFlags)));
    }

    @Override
    public void read_auth(Engine engine) {
        this.logger.debug((Object)"-> AuthResponsePacket");
        this.logger.debug((Object)("   Max Packet Size: " + engine.authReply.maxPacketSize));
        this.logger.debug((Object)("   User: " + engine.authReply.username));
        this.logger.debug((Object)("   Schema: " + engine.authReply.schema));
        this.logger.debug((Object)("   Client Capability Flags: " + Debug.dump_capability_flags(engine.authReply.capabilityFlags)));
    }

    @Override
    public void read_query(Engine engine) {
        switch (Packet.getType(engine.buffer.get(engine.buffer.size() - 1))) {
            case 1: {
                this.logger.info((Object)"-> COM_QUIT");
                break;
            }
            case 2: {
                this.logger.info((Object)("-> USE " + engine.schema));
                break;
            }
            case 3: {
                this.logger.info((Object)("-> " + engine.query));
                break;
            }
            default: {
                this.logger.debug((Object)("Packet is " + Packet.getType(engine.buffer.get(engine.buffer.size() - 1)) + " type."));
                Debug.dump_buffer(engine);
            }
        }
        engine.buffer_result_set();
    }

    @Override
    public void read_query_result(Engine engine) {
        if (!engine.bufferResultSet) {
            return;
        }
        switch (Packet.getType(engine.buffer.get(engine.buffer.size() - 1))) {
            case 0: {
                this.logger.info((Object)"<- OK");
                break;
            }
            case -1: {
                this.logger.info((Object)"<- ERR");
                break;
            }
            default: {
                this.logger.debug((Object)("Result set or Packet is " + Packet.getType(engine.buffer.get(engine.buffer.size() - 1)) + " type."));
            }
        }
    }

    public static final void dump_buffer(ArrayList<byte[]> arrayList) {
        Logger logger = Logger.getLogger((String)"Plugin.Debug");
        if (!logger.isTraceEnabled()) {
            return;
        }
        for (byte[] byArray : arrayList) {
            Packet.dump(byArray);
        }
    }

    public static final void dump_buffer(Engine engine) {
        Logger logger = Logger.getLogger((String)"Plugin.Debug");
        if (!logger.isTraceEnabled()) {
            return;
        }
        for (byte[] byArray : engine.buffer) {
            Packet.dump(byArray);
        }
    }

    public static final String dump_capability_flags(long l) {
        String string = "";
        if ((l & 1L) != 0L) {
            string = string + " CLIENT_LONG_PASSWORD";
        }
        if ((l & 2L) != 0L) {
            string = string + " CLIENT_FOUND_ROWS";
        }
        if ((l & 4L) != 0L) {
            string = string + " CLIENT_LONG_FLAG";
        }
        if ((l & 8L) != 0L) {
            string = string + " CLIENT_CONNECT_WITH_DB";
        }
        if ((l & 0x10L) != 0L) {
            string = string + " CLIENT_NO_SCHEMA";
        }
        if ((l & 0x20L) != 0L) {
            string = string + " CLIENT_COMPRESS";
        }
        if ((l & 0x40L) != 0L) {
            string = string + " CLIENT_ODBC";
        }
        if ((l & 0x80L) != 0L) {
            string = string + " CLIENT_LOCAL_FILES";
        }
        if ((l & 0x100L) != 0L) {
            string = string + " CLIENT_IGNORE_SPACE";
        }
        if ((l & 0x200L) != 0L) {
            string = string + " CLIENT_PROTOCOL_41";
        }
        if ((l & 0x400L) != 0L) {
            string = string + " CLIENT_INTERACTIVE";
        }
        if ((l & 0x800L) != 0L) {
            string = string + " CLIENT_SSL";
        }
        if ((l & 0x1000L) != 0L) {
            string = string + " CLIENT_IGNORE_SIGPIPE";
        }
        if ((l & 0x2000L) != 0L) {
            string = string + " CLIENT_TRANSACTIONS";
        }
        if ((l & 0x4000L) != 0L) {
            string = string + " CLIENT_RESERVED";
        }
        if ((l & 0x8000L) != 0L) {
            string = string + " CLIENT_SECURE_CONNECTION";
        }
        return string;
    }

    public static final String dump_status_flags(long l) {
        String string = "";
        if ((l & 1L) != 0L) {
            string = string + " SERVER_STATUS_IN_TRANS";
        }
        if ((l & 2L) != 0L) {
            string = string + " SERVER_STATUS_AUTOCOMMIT";
        }
        if ((l & 8L) != 0L) {
            string = string + " SERVER_MORE_RESULTS_EXISTS";
        }
        if ((l & 0x10L) != 0L) {
            string = string + " SERVER_STATUS_NO_GOOD_INDEX_USED";
        }
        if ((l & 0x20L) != 0L) {
            string = string + " SERVER_STATUS_NO_INDEX_USED";
        }
        if ((l & 0x40L) != 0L) {
            string = string + " SERVER_STATUS_CURSOR_EXISTS";
        }
        if ((l & 0x80L) != 0L) {
            string = string + " SERVER_STATUS_LAST_ROW_SENT";
        }
        if ((l & 0x80L) != 0L) {
            string = string + " SERVER_STATUS_LAST_ROW_SENT";
        }
        if ((l & 0x100L) != 0L) {
            string = string + " SERVER_STATUS_DB_DROPPED";
        }
        if ((l & 0x200L) != 0L) {
            string = string + " SERVER_STATUS_NO_BACKSLASH_ESCAPES";
        }
        if ((l & 0x400L) != 0L) {
            string = string + " SERVER_STATUS_METADATA_CHANGED";
        }
        if ((l & 0x800L) != 0L) {
            string = string + " SERVER_QUERY_WAS_SLOW";
        }
        if ((l & 0x1000L) != 0L) {
            string = string + " SERVER_PS_OUT_PARAMS";
        }
        return string;
    }
}

