/*
 * Decompiled with CFR 0.152.
 */
package com.github.mpjct.jmpjct.plugin.proxy;

import com.github.mpjct.jmpjct.Engine;
import com.github.mpjct.jmpjct.JMP;
import com.github.mpjct.jmpjct.mysql.proto.Com_Initdb;
import com.github.mpjct.jmpjct.mysql.proto.Com_Query;
import com.github.mpjct.jmpjct.mysql.proto.Handshake;
import com.github.mpjct.jmpjct.mysql.proto.HandshakeResponse;
import com.github.mpjct.jmpjct.mysql.proto.Packet;
import com.github.mpjct.jmpjct.mysql.proto.ResultSet;
import com.github.mpjct.jmpjct.plugin.Base;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class Proxy
extends Base {
    public Logger logger = Logger.getLogger((String)"Plugin.Proxy");
    public String mysqlHost = "";
    public int mysqlPort = 0;
    public Socket mysqlSocket = null;
    public InputStream mysqlIn = null;
    public OutputStream mysqlOut = null;

    @Override
    public void init(Engine engine) throws IOException, UnknownHostException {
        String[] stringArray;
        this.logger.trace((Object)"init");
        for (String string : stringArray = JMP.config.getProperty("proxyHosts").split(",")) {
            String[] stringArray2 = string.split(":");
            if (engine.port != Integer.parseInt(stringArray2[0].trim())) continue;
            this.mysqlHost = stringArray2[1].trim();
            this.mysqlPort = Integer.parseInt(stringArray2[2].trim());
            break;
        }
        this.mysqlSocket = new Socket(this.mysqlHost, this.mysqlPort);
        this.mysqlSocket.setPerformancePreferences(0, 2, 1);
        this.mysqlSocket.setTcpNoDelay(true);
        this.mysqlSocket.setTrafficClass(16);
        this.mysqlSocket.setKeepAlive(true);
        this.logger.info((Object)("Connected to mysql server at " + this.mysqlHost + ":" + this.mysqlPort));
        this.mysqlIn = new BufferedInputStream(this.mysqlSocket.getInputStream(), 16384);
        this.mysqlOut = this.mysqlSocket.getOutputStream();
    }

    @Override
    public void read_handshake(Engine engine) throws IOException {
        this.logger.trace((Object)"read_handshake");
        byte[] byArray = Packet.read_packet(this.mysqlIn);
        engine.handshake = Handshake.loadFromPacket(byArray);
        engine.handshake.removeCapabilityFlag(32L);
        engine.handshake.removeCapabilityFlag(2048L);
        engine.handshake.removeCapabilityFlag(128L);
        ResultSet.characterSet = engine.handshake.characterSet;
        engine.buffer.add(engine.handshake.toPacket());
    }

    @Override
    public void send_handshake(Engine engine) throws IOException {
        this.logger.trace((Object)"send_handshake");
        Packet.write(engine.clientOut, engine.buffer);
        engine.clear_buffer();
    }

    @Override
    public void read_auth(Engine engine) throws IOException {
        this.logger.trace((Object)"read_auth");
        byte[] byArray = Packet.read_packet(engine.clientIn);
        engine.buffer.add(byArray);
        engine.authReply = HandshakeResponse.loadFromPacket(byArray);
        if (!engine.authReply.hasCapabilityFlag(512L)) {
            this.logger.fatal((Object)"We do not support Protocols under 4.1");
            engine.halt();
            return;
        }
        engine.authReply.removeCapabilityFlag(32L);
        engine.authReply.removeCapabilityFlag(2048L);
        engine.authReply.removeCapabilityFlag(128L);
        engine.schema = engine.authReply.schema;
    }

    @Override
    public void send_auth(Engine engine) throws IOException {
        this.logger.trace((Object)"send_auth");
        Packet.write(this.mysqlOut, engine.buffer);
        engine.clear_buffer();
    }

    @Override
    public void read_auth_result(Engine engine) throws IOException {
        this.logger.trace((Object)"read_auth_result");
        byte[] byArray = Packet.read_packet(this.mysqlIn);
        engine.buffer.add(byArray);
        if (Packet.getType(byArray) != 0) {
            this.logger.fatal((Object)"Auth is not okay!");
        }
    }

    @Override
    public void send_auth_result(Engine engine) throws IOException {
        this.logger.trace((Object)"read_auth_result");
        Packet.write(engine.clientOut, engine.buffer);
        engine.clear_buffer();
    }

    @Override
    public void read_query(Engine engine) throws IOException {
        this.logger.trace((Object)"read_query");
        engine.bufferResultSet = false;
        byte[] byArray = Packet.read_packet(engine.clientIn);
        engine.buffer.add(byArray);
        engine.sequenceId = Packet.getSequenceId(byArray);
        this.logger.trace((Object)("Client sequenceId: " + engine.sequenceId));
        switch (Packet.getType(byArray)) {
            case 1: {
                this.logger.trace((Object)"COM_QUIT");
                engine.halt();
                break;
            }
            case 2: {
                this.logger.trace((Object)"COM_INIT_DB");
                engine.schema = Com_Initdb.loadFromPacket((byte[])byArray).schema;
                break;
            }
            case 3: {
                this.logger.trace((Object)"COM_QUERY");
                engine.query = Com_Query.loadFromPacket((byte[])byArray).query;
                break;
            }
        }
    }

    @Override
    public void send_query(Engine engine) throws IOException {
        this.logger.trace((Object)"send_query");
        Packet.write(this.mysqlOut, engine.buffer);
        engine.clear_buffer();
    }

    @Override
    public void read_query_result(Engine engine) throws IOException {
        this.logger.trace((Object)"read_query_result");
        byte[] byArray = Packet.read_packet(this.mysqlIn);
        engine.buffer.add(byArray);
        engine.sequenceId = Packet.getSequenceId(byArray);
        switch (Packet.getType(byArray)) {
            case -1: 
            case 0: {
                break;
            }
            default: {
                engine.buffer = Packet.read_full_result_set(this.mysqlIn, engine.clientOut, engine.buffer, engine.bufferResultSet);
            }
        }
    }

    @Override
    public void send_query_result(Engine engine) throws IOException {
        this.logger.trace((Object)"send_query_result");
        Packet.write(engine.clientOut, engine.buffer);
        engine.clear_buffer();
    }

    @Override
    public void cleanup(Engine engine) {
        this.logger.trace((Object)"cleanup");
        if (this.mysqlSocket == null) {
            return;
        }
        try {
            this.mysqlSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

