
(ns respo.component.todolist
  (:require [clojure.string :as string]
            [hsl.core :refer [hsl]]
            [respo.component.task :refer [task-component]]))

(def style-root
 {:line-height "24px",
  :color "black",
  :font-size "16px",
  :background-color (hsl 120 20 93),
  :padding "10px"})

(def style-list {:color "black", :background-color (hsl 120 20 96)})

(def style-input
 {:line-height "24px",
  :min-width "300px",
  :font-size "16px",
  :padding "0px 8px",
  :outline "none"})

(def style-toolbar
 {:width "300px",
  :padding "4px 0",
  :justify-content "center",
  :display "flex",
  :flex-direction "row"})

(def style-button
 {:margin-left "8px",
  :cursor "pointer",
  :padding "0 6px 0 6px",
  :display "inline-block",
  :border-radius "4px",
  :font-family "Verdana"})

(def style-panel {:display "flex"})

(defn clear-done [props state]
  (fn [event intent set-state]
    (.log js/console "intent clear-done")
    (intent :clear nil)))

(defn on-focus [props state]
  (fn [event intent set-state] (.log js/console "Just focused~")))

(defn on-text-change [props state]
  (fn [simple-event intent set-state]
    (set-state {:draft (:value simple-event)})))

(defn handle-add [props state]
  (.log js/console "state built inside:" (pr-str props) (pr-str state))
  (fn [event intent set-state]
    (.log js/console "click add!" (pr-str props) (pr-str state))
    (intent :add (:draft state))
    (set-state {:draft ""})))

(def todolist-component
 {:name :todolist,
  :render
  (fn [props state]
    (let [tasks (:tasks props)]
      (.log js/console "tasks:" (pr-str tasks))
      [:div
       {:style style-root}
       [:div
        {:style style-panel}
        [:input
         {:placeholder "Task",
          :on-focus (on-focus props state),
          :value (:draft state),
          :style style-input,
          :on-input (on-text-change props state)}]
        [:div
         {:style style-button}
         [:span
          {:inner-text "Add", :on-click (handle-add props state)}]]
        [:div
         {:inner-text "Clear",
          :on-click (clear-done props state),
          :style style-button}]]
       [:div
        {:style style-list, :class-name "task-list"}
        (into
          {}
          (->>
            tasks
            (map
              (fn [task] [(:id task)
                          [task-component {:task task}]]))))]
       (if (> (count tasks) 0)
         [:div
          {:style style-toolbar, :spell-check true}
          [:div
           {:inner-text "Clear",
            :on-click (clear-done props state),
            :style style-button}]])])),
  :initial-state {:draft ""}})
