
(ns respo.component.task
  (:require [clojure.string :as string] [hsl.core :refer [hsl]]))

(def style-input
 {:line-height "24px",
  :min-width "300px",
  :font-size "16px",
  :padding "0px 8px",
  :outline "none"})

(def style-button
 {:color (hsl 40 80 100),
  :margin-left "8px",
  :background-color (hsl 200 80 50),
  :cursor "pointer",
  :padding "0 6px",
  :display "inline-block",
  :border-radius "4px",
  :font-family "Verdana"})

(defn on-click [props state]
  (fn [event intent set-state] (.log js/console "clicked")))

(defn handle-remove [props state]
  (fn [event intent set-state] (intent :remove (:id (:task props)))))

(defn on-text-change [props state]
  (fn [event intent set-state]
    (let [task-id (:id (:task props)) text (:value event)]
      (intent :update {:id task-id, :text text}))))

(def task-component
 {:name :task,
  :render
  (fn [props state]
    (comment .log js/console "task args" props state)
    (let [task (:task props)]
      [:div
       {}
       [:input
        {:value (:text task),
         :style style-input,
         :on-input (on-text-change props state)}]
       [:span
        {:inner-text "Remove",
         :on-click (handle-remove props state),
         :style style-button}]])),
  :initial-state {}})
