/*
 * Decompiled with CFR 0.152.
 */
package alphabase.codec;

import java.util.Arrays;

public class Base32 {
    private static final char[] RFC_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".toCharArray();
    private static final char[] HEX_ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUV".toCharArray();
    private static final byte[] RFC_LOOKUP = new byte[91];
    private static final byte[] HEX_LOOKUP;

    private Base32() {
    }

    public static String encode(byte[] byArray, boolean bl, boolean bl2) {
        int n;
        char[] cArray;
        int n2 = 0;
        int n3 = byArray.length;
        int n4 = (int)Math.ceil(1.6 * (double)n3);
        int n5 = bl2 && n4 % 8 > 0 ? 8 - n4 % 8 : 0;
        char[] cArray2 = new char[n4 + n5];
        int n6 = 0;
        char[] cArray3 = cArray = bl ? HEX_ALPHABET : RFC_ALPHABET;
        while (n2 < n3) {
            int n7;
            n = Math.min(5, n3 - n2);
            int n8 = n == 5 ? 8 : (int)Math.ceil(1.6 * (double)n);
            long l = 0L;
            for (n7 = 0; n7 < n; ++n7) {
                l = l << 8 | (long)(byArray[n2] & 0xFF);
                ++n2;
            }
            if (n != 5) {
                n7 = 5 - 8 * n % 5;
                l <<= n7;
            }
            for (n7 = n8 - 1; n7 >= 0; --n7) {
                char c;
                cArray2[n6 + n7] = c = cArray[(int)(l & 0x1FL)];
                l >>>= 5;
            }
            n6 += n8;
        }
        for (n = 0; n < n5; ++n) {
            cArray2[n6] = 61;
            ++n6;
        }
        if (n6 != cArray2.length) {
            throw new IllegalStateException("Expected to encode " + n3 + " byte array into " + cArray2.length + " characters, but only got " + n6);
        }
        return new String(cArray2);
    }

    public static byte[] decode(String string, boolean bl) {
        byte[] byArray = bl ? HEX_LOOKUP : RFC_LOOKUP;
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        for (int i = n - 1; i >= 0 && string.charAt(i) == '='; --i) {
            ++n3;
        }
        byte[] byArray2 = new byte[(int)Math.floor((double)(n -= n3) * 0.625)];
        int n4 = 0;
        while (n2 < n) {
            int n5;
            int n6;
            int n7 = Math.min(8, n - n2);
            long l = 0L;
            for (n6 = 0; n6 < n7; ++n6) {
                int n8;
                n5 = string.charAt(n2);
                char c = Character.toUpperCase((char)n5);
                int n9 = n8 = c < byArray.length ? byArray[c] : -1;
                if (n8 < 0) {
                    throw new IllegalArgumentException("Character '" + (char)n5 + "' at index " + n2 + " is not a valid Base32 digit");
                }
                l = l << 5 | (long)(n8 & 0x1F);
                ++n2;
            }
            int n10 = n6 = n7 == 8 ? 5 : (int)Math.floor((double)n7 * 0.625);
            if (n6 != 5) {
                n5 = 5 - 8 * n6 % 5;
                l >>>= n5;
            }
            for (n5 = n6 - 1; n5 >= 0; --n5) {
                byArray2[n4 + n5] = (byte)(l & 0xFFL);
                l >>>= 8;
            }
            n4 += n6;
        }
        if (n4 != byArray2.length) {
            throw new IllegalStateException("Expected to decode " + n + " digit string into " + byArray2.length + " bytes, but only got " + n4);
        }
        return byArray2;
    }

    static {
        Arrays.fill(RFC_LOOKUP, (byte)-1);
        HEX_LOOKUP = new byte[91];
        Arrays.fill(HEX_LOOKUP, (byte)-1);
        for (int n = 0; n < 32; n = (int)((byte)(n + 1))) {
            Base32.RFC_LOOKUP[Base32.RFC_ALPHABET[n]] = n;
            Base32.HEX_LOOKUP[Base32.HEX_ALPHABET[n]] = n;
        }
    }
}

