(ns mx.interware.caudal.template.main
  (:require [mx.interware.arp.core.starter]
            [mx.interware.arp.streams.stateful :refer [counter]]
            [mx.interware.arp.streams.stateless :refer [by printe default time-stampit to-file where with]]
            [mx.interware.caudal.template.custom :refer [adjust-value]])
  (:import  (java.util Date)))

(def streams
  (default :path "A good one"
           (where :customer
                  (printe "MAIN - Customer    : "
                              (counter ::customer-counter :count
                                       (adjust-value :cost * 1.16
                                                     (printe "MAIN - Adjusted    : ")
                                                     (to-file "/tmp/customer-events.edn" :all)))))
           (where :employee
                  (printe "MAIN - Employee    : "
                          (by [:id]
                              (counter ::employee-counter :count
                                       (printe "MAIN - Counting    : ")
                                       (to-file "/tmp/employee-events.edn" :all)))))
           (time-stampit :time
                         (printe "MAIN - Timestamped : "))))


(def test-streams
  (with :millis (.getTime (new Date))
           (printe "TEST - Testing     : ")))

