(ns mx.interware.arp.core.main
  (:require
    [clojure.pprint :as pp]
    [clojure.string :as str])              
  (:import 
    (java.net 
      InetAddress URL)))
           
    


;(comment origin    
;  #(= "expired" (:state %))    
;  (mailer :expired {:to fgerard@... ...})    
;  
;  (default :new :ttl 60        
;    (counter :all-evts :metric            
;      (store :total :metric)        
;      (by :tx-selector [:tx]            
;        (ewma :r0.1 0.1 :metric                
;          (when #(> (:metric %) 350)                   
;            (mailer :warning0.1 {:to ....})))            
;        (ewma :r0.3 0.3 :metric                
;          (when #(> (:metric %) 350)                   
;            (mailer :warning0.3 {:to ....}))))

;en esta ruta se almacena el ewma para r 0.3
;[:origin :new :tx-selector :thread-5 :r0.3]

;en esta ruta está el contador de todos los evts
;[:origin :new :all-evts]

;Va invocando la funcion child con el state anterior y el evento y generando
;el nuevo state que es pasado a los child siguientes.
(defn state-reduce [state e children]
  (loop [[child & children] children
         state state]
    (if child
      (recur children (if-let [n-state (child state e)]
                        n-state
                        state))
      state)))

;implementación de counter
;origin es un macro que valida que no existan
; keywords repetidos en el mismo nivel y
; modifica la forma de entrado cambiando el
; primer parámetro de las funciones 
; "anidadas" del keyword declarado a un 
; vector de keywords que representa el path 

(defn counter [path metric-kwd & children]
  (fn [state evt]
    (println :state state evt)
    (let [cntr (get-in state path 0)
          metric (metric-kwd evt)
          new-c (+ cntr metric)
          new-state (assoc-in state path new-c)]
      (println :new-state new-state)
      (state-reduce
        new-state
        (assoc evt metric-kwd new-c)
        children))))

(defn pprint [path & children]
  (fn [state e]
    (println "STATE:")
    (clojure.pprint/pprint state)
    (println "e:" (pr-str e))
    (state-reduce state e children)))

(defn default [path kwd val & children]
  (fn [state e]
    (state-reduce
      state
      (assoc e kwd (kwd e val))
      children)))

(defn with [path kwd val & children]
  (fn [state e]
    (state-reduce
      state
      (assoc e kwd val)
      children)))
      

;saca del estado en número almacenado    
; en path y lo incrementa con:    
; (metric-fn evt)

;(def c (counter [:cta] :metric (fn [state e] (println state e))))
       
;(c {:cta 123} {:a 1 :metric 5})

(def A (atom {}))
@A

(comment origin
  (default :default :ttl 60
    (counter :s-met :metric
      (pprint :pprint))
    (with :uno :x 1 [/ .. .. 3 :metric]
      (counter :e-cnt :x
        (pprint :final)))))

(def c 
  (default [:default] :ttl 60
    (counter [:default :s-met] :metric
      (pprint [:default :s-met :pprint]))
    (with [:default :uno] :x 1
      (counter [:default :uno :e-cnt] :x
        (pprint [:default :uno :e-cnt :final])))))
(swap! A c {:a 1 :metric 5})
(swap! A c {:a 1 :metric 5})
(swap! A c {:a 1 :metric 5})
(swap! A c {:a 1 :metric 5})
(swap! A c {:a 1 :metric 3})

(swap! A c {:a 1 :metric 3})

(defprotocol Countable
  (cnt [x]))
(class "Felipe")
(extend-type java.lang.String
  Countable
  (cnt [this] (count this)))



