(ns mx.interware.arp.io.rest-server
  (:require [clojure.tools.logging :as log]
            [bidi.ring :refer [make-handler]]
            [ring.middleware.json :refer [wrap-json-response]]
            [ring.middleware.session :refer [wrap-session]]
            [immutant.web :refer [run stop]]
            [mx.interware.arp.streams.common :refer [start-listener]]
            [mx.interware.arp.web.rest-handle :as handle]))

(defn create-routes [sink states]
  ["/" {"index.html"            handle/index-handler
        ["item/" :id "/" :name] handle/item-handler
        ["events/put"]          (partial handle/event-handler sink)
        ["state/" :id]          (partial handle/state-handler states)
        }
   ])

(defn create-handler [sink states]
  (let [routes (create-routes sink states)]
    (make-handler routes)))

(defn create-app [sink states]
  (-> (create-handler sink states)
      wrap-session
      wrap-json-response))

(defn start-server [app host port]
  (let [x 0]
    (run app {:host host :port port})))

(defmethod start-listener 'mx.interware.arp.io.rest-server
  [sink config]
  (let [host   (get-in config [:parameters :host])
        port   (get-in config [:parameters :port])
        states (get-in config [:states])
        app    (create-app sink states)]
    (start-server app host port)))
