/*
 * Decompiled with CFR 0.152.
 */
package com.edlio.emailreplyparser;

import com.edlio.emailreplyparser.Email;
import com.edlio.emailreplyparser.Fragment;
import com.edlio.emailreplyparser.FragmentDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class EmailParser {
    static final Pattern SIG_PATTERN = Pattern.compile("((^Sent from my (\\s*\\w+){1,3}$)|(^-\\w|^\\s?__|^\\s?--|^\u2013|^\u2014))", 32);
    static final Pattern QUOTE_PATTERN = Pattern.compile("(^>+)", 32);
    private static List<Pattern> compiledQuoteHeaderPatterns;
    private List<String> quoteHeadersRegex = new ArrayList<String>();
    private List<FragmentDTO> fragments = new ArrayList<FragmentDTO>();
    private int maxParagraphLines;
    private int maxNumCharsEachLine;

    public EmailParser() {
        compiledQuoteHeaderPatterns = new ArrayList<Pattern>();
        this.quoteHeadersRegex.add("^(On\\s(.{1,500})wrote:)");
        this.quoteHeadersRegex.add("From:[^\\n]+\\n?([^\\n]+\\n?){0,2}To:[^\\n]+\\n?([^\\n]+\\n?){0,2}Subject:[^\\n]+");
        this.quoteHeadersRegex.add("To:[^\\n]+\\n?([^\\n]+\\n?){0,2}From:[^\\n]+\\n?([^\\n]+\\n?){0,2}Subject:[^\\n]+");
        this.maxParagraphLines = 6;
        this.maxNumCharsEachLine = 200;
    }

    public Email parse(String emailText) {
        this.compileQuoteHeaderRegexes();
        emailText.replace("\r\n", "\n");
        FragmentDTO fragment = null;
        Object[] lines = emailText.split("\n");
        ArrayUtils.reverse((Object[])lines);
        ArrayList<String> paragraph = new ArrayList<String>();
        for (Object line : lines) {
            line = StringUtils.stripEnd((String)line, (String)"\n");
            line = StringUtils.stripEnd((String)line, null);
            if (fragment != null && ((String)line).isEmpty()) {
                String last = fragment.lines.get(fragment.lines.size() - 1);
                if (this.isSignature(last)) {
                    fragment.isSignature = true;
                    this.addFragment(fragment);
                    fragment = null;
                } else if (this.isQuoteHeader(paragraph)) {
                    fragment.isQuoted = true;
                    this.addFragment(fragment);
                    fragment = null;
                }
                paragraph.clear();
            }
            boolean isQuoted = this.isQuote((String)line);
            if (fragment == null || !this.isFragmentLine(fragment, (String)line, isQuoted)) {
                if (fragment != null) {
                    this.addFragment(fragment);
                }
                fragment = new FragmentDTO();
                fragment.isQuoted = isQuoted;
                fragment.lines = new ArrayList<String>();
            }
            fragment.lines.add((String)line);
            if (((String)line).isEmpty()) continue;
            paragraph.add((String)line);
        }
        if (fragment != null) {
            this.addFragment(fragment);
        }
        return this.createEmail(this.fragments);
    }

    public List<String> getQuoteHeadersRegex() {
        return this.quoteHeadersRegex;
    }

    public void setQuoteHeadersRegex(List<String> newRegex) {
        this.quoteHeadersRegex = newRegex;
    }

    public int getMaxParagraphLines() {
        return this.maxParagraphLines;
    }

    public void setMaxParagraphLines(int maxParagraphLines) {
        this.maxParagraphLines = maxParagraphLines;
    }

    public int getMaxNumCharsEachLine() {
        return this.maxNumCharsEachLine;
    }

    public void setMaxNumCharsEachLine(int maxNumCharsEachLine) {
        this.maxNumCharsEachLine = maxNumCharsEachLine;
    }

    protected Email createEmail(List<FragmentDTO> fragmentDTOs) {
        ArrayList<Fragment> fs = new ArrayList<Fragment>();
        Collections.reverse(fragmentDTOs);
        for (FragmentDTO f : fragmentDTOs) {
            Collections.reverse(f.lines);
            String content = StringUtils.join(f.lines, (String)"\n");
            Fragment fr = new Fragment(content, f.isHidden, f.isSignature, f.isQuoted);
            fs.add(fr);
        }
        return new Email(fs);
    }

    private void compileQuoteHeaderRegexes() {
        for (String regex : this.quoteHeadersRegex) {
            compiledQuoteHeaderPatterns.add(Pattern.compile(regex, 40));
        }
    }

    private boolean isSignature(String line) {
        boolean find = SIG_PATTERN.matcher(line).find();
        return find;
    }

    private boolean isQuote(String line) {
        return QUOTE_PATTERN.matcher(line).find();
    }

    private boolean isEmpty(FragmentDTO fragment) {
        return StringUtils.join(fragment.lines, (String)"").isEmpty();
    }

    private boolean isFragmentLine(FragmentDTO fragment, String line, boolean isQuoted) {
        return fragment.isQuoted == isQuoted || fragment.isQuoted && (this.isQuoteHeader(Arrays.asList(line)) || line.isEmpty());
    }

    private void addFragment(FragmentDTO fragment) {
        if (fragment.isQuoted || fragment.isSignature || this.isEmpty(fragment)) {
            fragment.isHidden = true;
        }
        this.fragments.add(fragment);
    }

    private boolean isQuoteHeader(List<String> paragraph) {
        if (paragraph.size() > this.maxParagraphLines) {
            return false;
        }
        for (String line : paragraph) {
            if (line.length() <= this.maxNumCharsEachLine) continue;
            return false;
        }
        Collections.reverse(paragraph);
        String content = StringUtils.join(paragraph, (String)"\n");
        for (Pattern p : compiledQuoteHeaderPatterns) {
            if (!p.matcher(content).find()) continue;
            return true;
        }
        return false;
    }
}

