(ns n01se.ins
  "Initialization namespace support. Add ability to define a namespace and
  initialize that namespace with parameters. Defines the make-ns function and a
  pair of convenience macros: def-ns and load-ns.

  ;; Example using just make-ns
  (ns a)
  (defn init! [x]
    (defn foo [y] (+ x y)))

  (ns b)
  (make-ns 'a a/init! 1)
  (a/foo 1) ;=> 2

  ;; Similar example using def-ns and load-ns
  (def-ns a [x]
    (defn foo [y] (+ x y)))

  (ns b)
  (load-ns a :init [1])
  (a/foo 1) ;=> 2
  ")

;; API
(defn make-ns
  "Create the namespace specified by name and run f and args within that
  namespace."
  [name f & args]
  (binding [*ns* (create-ns name)]
    (apply f args)))

(defmacro def-ns [name args & body])
(defmacro load-ns [ns & args])
