(ns clojure-potrubi.traces.diagnostics)

;; Internal diagnostics and testing

;; *******************
;; BEG: atom functions
;; *******************

(defn atom-swapper-one-arg [current-value new-value] new-value)

(defn update-atom-one-arg
  [atom-instance new-value]
  (swap! atom-instance
         atom-swapper-one-arg
         new-value))

(defn maybe-update-atom-one-arg
  [atom-instance new-value]
  (if new-value (update-atom-one-arg atom-instance new-value)))

;; *******************
;; BEG: atom functions
;; *******************

;; *************************
;; BEG: internal diagnostics
;; *************************
(def carp-diagnostics-status (atom false))

(defn set-diagnostics [value] (swap! carp-diagnostics-status atom-swapper-one-arg value))

(defmacro macro-set-diagnostics [value] (set-diagnostics value) nil)

(defn carp-diagnostic-format-value [value] (format ">%s< >%s<" (class value) value))

(defn carp-diagnostic
  [& args]
  (if @carp-diagnostics-status (doall (apply println args))))

;; *************************
;; FIN: internal diagnostics
;; *************************
