(ns clojure-potrubi.utils.collections)

;; *************************
;; BEG: collection functions
;; *************************

(defn to-collection
  [any]
  (cond
   (coll? any) any
   (nil? any) (list)
   :else (list any)))

(defn to-vector
  [any]
  (cond
   (vector? any) any
   (nil? any) []
   :else [any]))

;; *************************
;; BEG: collection functions
;; *************************

;; ****************************
;; BEG: collection verification
;; ****************************

(defn is-lazyseq?
  [any]
  (instance? clojure.lang.LazySeq))

;; ****************************
;; FIN: collection verification
;; ****************************
