(ns clojure-potrubi.utils.names
  (:require [clojure.string :as str]
            [clojure-carp :as carp :refer (surprise-exception)]))

;; *********************
;; BEG: naming functions
;; *********************

(defn resolve-name-from-keyword
  [name-keyword]
  {:pre [(keyword? name-keyword)] :post [(string? %)]}
  (name name-keyword))

(defn resolve-name-from-args
  [& args]
  {:post [(string? %)]}
  (apply str (flatten args)))

(defn resolve-name-from-any
  "create a name from anything
   names are strings
   e.g. for keywords stringifies but removes leading colon"
  [any]
  (cond
   (nil? any) (surprise-exception :any "resolve-name-from-any" "any is nil")
   (keyword? any) (resolve-name-from-keyword any)
   :else (str any)))

(defn resolve-symbol-from-any
  [any]
  {:post [(symbol? %)]}
  (cond
   (symbol? any) any
   :else (symbol (resolve-name-from-any any))))

(defn resolve-any-class-telltale
  [any]
  (cond
   (nil? any) "nil"
   :else (first  (re-find #"(\p{Upper}\S+)?+$" (str (class any))))))

(defn resolve-symbol-from-args
  [& args]
  {:post [(symbol? %)]}
  (symbol (resolve-name-from-args args)))

;; ***************************
;; FIN: misc support functions
;; ***************************

