(ns navaratine.xlsx.shared-strings-test
  (:require [clojure.test :as t]
            [clojure.java.io :as io]
            [clojure.data.xml :as xml]
            [navaratine.xlsx.utils :as u]
            [com.rpl.specter :as sr]
            [navaratine.xlsx.shared-strings :as sut]))


(def ss
  {"0"  "First name"
   "1"  "Last name"
   "10" "Example"
   "2"  "Group"
   "3"  "Presence"
   "4"  "Food"
   "5"  "Other"
   "6"  "Total"
   "7"  "Paid"
   "8"  "Jon"
   "9"  "Snow"})

(t/deftest parse-shared-strings-xml-test
  (with-open [rdr (io/reader (io/resource "data/template/sharedStrings.xml"))]
    (t/is (= ss (sut/parse-shared-strings-xml (xml/parse rdr))))))


(t/deftest generate-shared-strings-xml-test
  (with-open [rdr (io/reader (io/resource "data/template/sharedStrings.xml"))]
    (t/is (= (xml/sexp-as-element
              [(u/resolve :X/sst)
               {:count       "4"
                :uniqueCount "2"}
               [(u/resolve :X/si) {} [(u/resolve :X/t) {} "Test"]]
               [(u/resolve :X/si) {} [(u/resolve :X/t) {} "Other"]]])
             (sut/generate-shared-strings-xml
              (xml/parse rdr)
              (volatile! {"Test" 0 "Other" 1})
              (volatile! 4))))))


(t/deftest transducer-test
  (with-open [rdr (io/reader (io/resource "data/template/sheet1.xml"))]
    (let [decoder           (sut/decoder ss)
          [encoder mapping] (sut/encoder)
          [counter cnt]     (sut/counter)]
      (t/testing "initial state"
                 (t/is (volatile? mapping))
                 (t/is (volatile? cnt))
                 (t/is (= {} @mapping))
                 (t/is (= 0 @cnt)))
      (into []
            (comp decoder encoder counter)
            (sr/select
             [(u/tag= :X/worksheet)
              u/children
              (u/tag= :X/sheetData)
              u/children
              (u/tag= :X/row)]
             (xml/parse rdr)))
      (t/testing "after transducing the sheet"
                 (t/is (= {"Example"    10
                           "First name" 0
                           "Food"       4
                           "Group"      2
                           "Jon"        8
                           "Last name"  1
                           "Other"      5
                           "Paid"       7
                           "Presence"   3
                           "Snow"       9
                           "Total"      6}
                          @mapping))
                 (t/is (= 12 @cnt))))))
