(ns navaratine.xlsx.workbook
  (:require [navaratine.xlsx.utils :as u]
            [com.rpl.specter :as sr]))


(defn parse-workbook-xml
  "Parse xl/workbook.xml and create a sheet->name map."
  [workbook-xml]
  (into {}
        (sr/select
         [(u/tag= :X/workbook)
          u/children
          (u/tag= :X/sheets)
          u/children
          (u/tag= :X/sheet)
          u/attributes
          (sr/view (fn [{:keys [name sheetId]}]
                     [(str "xl/worksheets/sheet" sheetId ".xml") name]))]
         workbook-xml)))
