(ns untangled.client.devcards)

(defmacro untangled-cardapp
  "Generate an untangled app that can be embedded in a devcard.

  (dc/defcard card-name (untanged-cardapp Root ..args..) { ..init app state.. } {:inspect-data true})"
  [root-ui & args]
  (let [varname (gensym)]
    `(devcards.core/dom-node
       (fn [state-atom# node#]
         (defonce ~varname (atom (untangled.client.core/new-untangled-client :initial-state state-atom# ~@args)))
         (reset! ~varname (untangled.client.core/mount @~varname ~root-ui node#))
         ; ensures shows app state immediately if you're using inspect data and InitialAppState:
         (js/setTimeout (fn [] (swap! state-atom# assoc :ui/react-key 0)) 100)))))

