// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args61641 = [];
var len__28496__auto___61647 = arguments.length;
var i__28497__auto___61648 = (0);
while(true){
if((i__28497__auto___61648 < len__28496__auto___61647)){
args61641.push((arguments[i__28497__auto___61648]));

var G__61649 = (i__28497__auto___61648 + (1));
i__28497__auto___61648 = G__61649;
continue;
} else {
}
break;
}

var G__61643 = args61641.length;
switch (G__61643) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args61641.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async61644 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async61644 = (function (f,blockable,meta61645){
this.f = f;
this.blockable = blockable;
this.meta61645 = meta61645;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async61644.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_61646,meta61645__$1){
var self__ = this;
var _61646__$1 = this;
return (new cljs.core.async.t_cljs$core$async61644(self__.f,self__.blockable,meta61645__$1));
});


cljs.core.async.t_cljs$core$async61644.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_61646){
var self__ = this;
var _61646__$1 = this;
return self__.meta61645;
});


cljs.core.async.t_cljs$core$async61644.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async61644.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async61644.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});


cljs.core.async.t_cljs$core$async61644.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async61644.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta61645","meta61645",1833669853,null)], null);
});

cljs.core.async.t_cljs$core$async61644.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async61644.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async61644";

cljs.core.async.t_cljs$core$async61644.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async61644");
});

cljs.core.async.__GT_t_cljs$core$async61644 = (function cljs$core$async$__GT_t_cljs$core$async61644(f__$1,blockable__$1,meta61645){
return (new cljs.core.async.t_cljs$core$async61644(f__$1,blockable__$1,meta61645));
});

}

return (new cljs.core.async.t_cljs$core$async61644(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args61653 = [];
var len__28496__auto___61656 = arguments.length;
var i__28497__auto___61657 = (0);
while(true){
if((i__28497__auto___61657 < len__28496__auto___61656)){
args61653.push((arguments[i__28497__auto___61657]));

var G__61658 = (i__28497__auto___61657 + (1));
i__28497__auto___61657 = G__61658;
continue;
} else {
}
break;
}

var G__61655 = args61653.length;
switch (G__61655) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args61653.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args61660 = [];
var len__28496__auto___61663 = arguments.length;
var i__28497__auto___61664 = (0);
while(true){
if((i__28497__auto___61664 < len__28496__auto___61663)){
args61660.push((arguments[i__28497__auto___61664]));

var G__61665 = (i__28497__auto___61664 + (1));
i__28497__auto___61664 = G__61665;
continue;
} else {
}
break;
}

var G__61662 = args61660.length;
switch (G__61662) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args61660.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args61667 = [];
var len__28496__auto___61670 = arguments.length;
var i__28497__auto___61671 = (0);
while(true){
if((i__28497__auto___61671 < len__28496__auto___61670)){
args61667.push((arguments[i__28497__auto___61671]));

var G__61672 = (i__28497__auto___61671 + (1));
i__28497__auto___61671 = G__61672;
continue;
} else {
}
break;
}

var G__61669 = args61667.length;
switch (G__61669) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args61667.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_61674 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_61674);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_61674,ret){
return (function (){
return fn1.call(null,val_61674);
});})(val_61674,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args61675 = [];
var len__28496__auto___61678 = arguments.length;
var i__28497__auto___61679 = (0);
while(true){
if((i__28497__auto___61679 < len__28496__auto___61678)){
args61675.push((arguments[i__28497__auto___61679]));

var G__61680 = (i__28497__auto___61679 + (1));
i__28497__auto___61679 = G__61680;
continue;
} else {
}
break;
}

var G__61677 = args61675.length;
switch (G__61677) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args61675.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6751__auto__)){
var ret = temp__6751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6751__auto__)){
var retb = temp__6751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6751__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6751__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__28296__auto___61682 = n;
var x_61683 = (0);
while(true){
if((x_61683 < n__28296__auto___61682)){
(a[x_61683] = (0));

var G__61684 = (x_61683 + (1));
x_61683 = G__61684;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__61685 = (i + (1));
i = G__61685;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async61689 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async61689 = (function (flag,meta61690){
this.flag = flag;
this.meta61690 = meta61690;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async61689.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_61691,meta61690__$1){
var self__ = this;
var _61691__$1 = this;
return (new cljs.core.async.t_cljs$core$async61689(self__.flag,meta61690__$1));
});})(flag))
;


cljs.core.async.t_cljs$core$async61689.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_61691){
var self__ = this;
var _61691__$1 = this;
return self__.meta61690;
});})(flag))
;


cljs.core.async.t_cljs$core$async61689.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async61689.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;


cljs.core.async.t_cljs$core$async61689.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;


cljs.core.async.t_cljs$core$async61689.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async61689.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta61690","meta61690",1303452929,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async61689.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async61689.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async61689";

cljs.core.async.t_cljs$core$async61689.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async61689");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async61689 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async61689(flag__$1,meta61690){
return (new cljs.core.async.t_cljs$core$async61689(flag__$1,meta61690));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async61689(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async61695 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async61695 = (function (flag,cb,meta61696){
this.flag = flag;
this.cb = cb;
this.meta61696 = meta61696;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async61695.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_61697,meta61696__$1){
var self__ = this;
var _61697__$1 = this;
return (new cljs.core.async.t_cljs$core$async61695(self__.flag,self__.cb,meta61696__$1));
});


cljs.core.async.t_cljs$core$async61695.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_61697){
var self__ = this;
var _61697__$1 = this;
return self__.meta61696;
});


cljs.core.async.t_cljs$core$async61695.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async61695.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});


cljs.core.async.t_cljs$core$async61695.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async61695.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async61695.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta61696","meta61696",1824348512,null)], null);
});

cljs.core.async.t_cljs$core$async61695.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async61695.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async61695";

cljs.core.async.t_cljs$core$async61695.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async61695");
});

cljs.core.async.__GT_t_cljs$core$async61695 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async61695(flag__$1,cb__$1,meta61696){
return (new cljs.core.async.t_cljs$core$async61695(flag__$1,cb__$1,meta61696));
});

}

return (new cljs.core.async.t_cljs$core$async61695(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__61698_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__61698_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__61699_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__61699_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__27280__auto__ = wport;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return port;
}
})()], null));
} else {
var G__61700 = (i + (1));
i = G__61700;
continue;
}
} else {
return null;
}
break;
}
})();
var or__27280__auto__ = ret;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6753__auto__ = (function (){var and__27268__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__27268__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__27268__auto__;
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var got = temp__6753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__28503__auto__ = [];
var len__28496__auto___61706 = arguments.length;
var i__28497__auto___61707 = (0);
while(true){
if((i__28497__auto___61707 < len__28496__auto___61706)){
args__28503__auto__.push((arguments[i__28497__auto___61707]));

var G__61708 = (i__28497__auto___61707 + (1));
i__28497__auto___61707 = G__61708;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((1) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28504__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__61703){
var map__61704 = p__61703;
var map__61704__$1 = ((((!((map__61704 == null)))?((((map__61704.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__61704.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__61704):map__61704);
var opts = map__61704__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq61701){
var G__61702 = cljs.core.first.call(null,seq61701);
var seq61701__$1 = cljs.core.next.call(null,seq61701);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__61702,seq61701__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args61709 = [];
var len__28496__auto___61759 = arguments.length;
var i__28497__auto___61760 = (0);
while(true){
if((i__28497__auto___61760 < len__28496__auto___61759)){
args61709.push((arguments[i__28497__auto___61760]));

var G__61761 = (i__28497__auto___61760 + (1));
i__28497__auto___61760 = G__61761;
continue;
} else {
}
break;
}

var G__61711 = args61709.length;
switch (G__61711) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args61709.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__41822__auto___61763 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___61763){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___61763){
return (function (state_61735){
var state_val_61736 = (state_61735[(1)]);
if((state_val_61736 === (7))){
var inst_61731 = (state_61735[(2)]);
var state_61735__$1 = state_61735;
var statearr_61737_61764 = state_61735__$1;
(statearr_61737_61764[(2)] = inst_61731);

(statearr_61737_61764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61736 === (1))){
var state_61735__$1 = state_61735;
var statearr_61738_61765 = state_61735__$1;
(statearr_61738_61765[(2)] = null);

(statearr_61738_61765[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61736 === (4))){
var inst_61714 = (state_61735[(7)]);
var inst_61714__$1 = (state_61735[(2)]);
var inst_61715 = (inst_61714__$1 == null);
var state_61735__$1 = (function (){var statearr_61739 = state_61735;
(statearr_61739[(7)] = inst_61714__$1);

return statearr_61739;
})();
if(cljs.core.truth_(inst_61715)){
var statearr_61740_61766 = state_61735__$1;
(statearr_61740_61766[(1)] = (5));

} else {
var statearr_61741_61767 = state_61735__$1;
(statearr_61741_61767[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61736 === (13))){
var state_61735__$1 = state_61735;
var statearr_61742_61768 = state_61735__$1;
(statearr_61742_61768[(2)] = null);

(statearr_61742_61768[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61736 === (6))){
var inst_61714 = (state_61735[(7)]);
var state_61735__$1 = state_61735;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_61735__$1,(11),to,inst_61714);
} else {
if((state_val_61736 === (3))){
var inst_61733 = (state_61735[(2)]);
var state_61735__$1 = state_61735;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61735__$1,inst_61733);
} else {
if((state_val_61736 === (12))){
var state_61735__$1 = state_61735;
var statearr_61743_61769 = state_61735__$1;
(statearr_61743_61769[(2)] = null);

(statearr_61743_61769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61736 === (2))){
var state_61735__$1 = state_61735;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61735__$1,(4),from);
} else {
if((state_val_61736 === (11))){
var inst_61724 = (state_61735[(2)]);
var state_61735__$1 = state_61735;
if(cljs.core.truth_(inst_61724)){
var statearr_61744_61770 = state_61735__$1;
(statearr_61744_61770[(1)] = (12));

} else {
var statearr_61745_61771 = state_61735__$1;
(statearr_61745_61771[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61736 === (9))){
var state_61735__$1 = state_61735;
var statearr_61746_61772 = state_61735__$1;
(statearr_61746_61772[(2)] = null);

(statearr_61746_61772[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61736 === (5))){
var state_61735__$1 = state_61735;
if(cljs.core.truth_(close_QMARK_)){
var statearr_61747_61773 = state_61735__$1;
(statearr_61747_61773[(1)] = (8));

} else {
var statearr_61748_61774 = state_61735__$1;
(statearr_61748_61774[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61736 === (14))){
var inst_61729 = (state_61735[(2)]);
var state_61735__$1 = state_61735;
var statearr_61749_61775 = state_61735__$1;
(statearr_61749_61775[(2)] = inst_61729);

(statearr_61749_61775[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61736 === (10))){
var inst_61721 = (state_61735[(2)]);
var state_61735__$1 = state_61735;
var statearr_61750_61776 = state_61735__$1;
(statearr_61750_61776[(2)] = inst_61721);

(statearr_61750_61776[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61736 === (8))){
var inst_61718 = cljs.core.async.close_BANG_.call(null,to);
var state_61735__$1 = state_61735;
var statearr_61751_61777 = state_61735__$1;
(statearr_61751_61777[(2)] = inst_61718);

(statearr_61751_61777[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___61763))
;
return ((function (switch__41805__auto__,c__41822__auto___61763){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_61755 = [null,null,null,null,null,null,null,null];
(statearr_61755[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_61755[(1)] = (1));

return statearr_61755;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_61735){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_61735);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e61756){if((e61756 instanceof Object)){
var ex__41809__auto__ = e61756;
var statearr_61757_61778 = state_61735;
(statearr_61757_61778[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61735);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e61756;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61779 = state_61735;
state_61735 = G__61779;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_61735){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_61735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___61763))
})();
var state__41824__auto__ = (function (){var statearr_61758 = f__41823__auto__.call(null);
(statearr_61758[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___61763);

return statearr_61758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___61763))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__61967){
var vec__61968 = p__61967;
var v = cljs.core.nth.call(null,vec__61968,(0),null);
var p = cljs.core.nth.call(null,vec__61968,(1),null);
var job = vec__61968;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__41822__auto___62154 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___62154,res,vec__61968,v,p,job,jobs,results){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___62154,res,vec__61968,v,p,job,jobs,results){
return (function (state_61975){
var state_val_61976 = (state_61975[(1)]);
if((state_val_61976 === (1))){
var state_61975__$1 = state_61975;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_61975__$1,(2),res,v);
} else {
if((state_val_61976 === (2))){
var inst_61972 = (state_61975[(2)]);
var inst_61973 = cljs.core.async.close_BANG_.call(null,res);
var state_61975__$1 = (function (){var statearr_61977 = state_61975;
(statearr_61977[(7)] = inst_61972);

return statearr_61977;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61975__$1,inst_61973);
} else {
return null;
}
}
});})(c__41822__auto___62154,res,vec__61968,v,p,job,jobs,results))
;
return ((function (switch__41805__auto__,c__41822__auto___62154,res,vec__61968,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0 = (function (){
var statearr_61981 = [null,null,null,null,null,null,null,null];
(statearr_61981[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__);

(statearr_61981[(1)] = (1));

return statearr_61981;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1 = (function (state_61975){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_61975);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e61982){if((e61982 instanceof Object)){
var ex__41809__auto__ = e61982;
var statearr_61983_62155 = state_61975;
(statearr_61983_62155[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_61975);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e61982;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62156 = state_61975;
state_61975 = G__62156;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = function(state_61975){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1.call(this,state_61975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___62154,res,vec__61968,v,p,job,jobs,results))
})();
var state__41824__auto__ = (function (){var statearr_61984 = f__41823__auto__.call(null);
(statearr_61984[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___62154);

return statearr_61984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___62154,res,vec__61968,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__61985){
var vec__61986 = p__61985;
var v = cljs.core.nth.call(null,vec__61986,(0),null);
var p = cljs.core.nth.call(null,vec__61986,(1),null);
var job = vec__61986;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__28296__auto___62157 = n;
var __62158 = (0);
while(true){
if((__62158 < n__28296__auto___62157)){
var G__61989_62159 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__61989_62159) {
case "compute":
var c__41822__auto___62161 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__62158,c__41822__auto___62161,G__61989_62159,n__28296__auto___62157,jobs,results,process,async){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (__62158,c__41822__auto___62161,G__61989_62159,n__28296__auto___62157,jobs,results,process,async){
return (function (state_62002){
var state_val_62003 = (state_62002[(1)]);
if((state_val_62003 === (1))){
var state_62002__$1 = state_62002;
var statearr_62004_62162 = state_62002__$1;
(statearr_62004_62162[(2)] = null);

(statearr_62004_62162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62003 === (2))){
var state_62002__$1 = state_62002;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62002__$1,(4),jobs);
} else {
if((state_val_62003 === (3))){
var inst_62000 = (state_62002[(2)]);
var state_62002__$1 = state_62002;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62002__$1,inst_62000);
} else {
if((state_val_62003 === (4))){
var inst_61992 = (state_62002[(2)]);
var inst_61993 = process.call(null,inst_61992);
var state_62002__$1 = state_62002;
if(cljs.core.truth_(inst_61993)){
var statearr_62005_62163 = state_62002__$1;
(statearr_62005_62163[(1)] = (5));

} else {
var statearr_62006_62164 = state_62002__$1;
(statearr_62006_62164[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62003 === (5))){
var state_62002__$1 = state_62002;
var statearr_62007_62165 = state_62002__$1;
(statearr_62007_62165[(2)] = null);

(statearr_62007_62165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62003 === (6))){
var state_62002__$1 = state_62002;
var statearr_62008_62166 = state_62002__$1;
(statearr_62008_62166[(2)] = null);

(statearr_62008_62166[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62003 === (7))){
var inst_61998 = (state_62002[(2)]);
var state_62002__$1 = state_62002;
var statearr_62009_62167 = state_62002__$1;
(statearr_62009_62167[(2)] = inst_61998);

(statearr_62009_62167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__62158,c__41822__auto___62161,G__61989_62159,n__28296__auto___62157,jobs,results,process,async))
;
return ((function (__62158,switch__41805__auto__,c__41822__auto___62161,G__61989_62159,n__28296__auto___62157,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0 = (function (){
var statearr_62013 = [null,null,null,null,null,null,null];
(statearr_62013[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__);

(statearr_62013[(1)] = (1));

return statearr_62013;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1 = (function (state_62002){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_62002);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e62014){if((e62014 instanceof Object)){
var ex__41809__auto__ = e62014;
var statearr_62015_62168 = state_62002;
(statearr_62015_62168[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62002);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62014;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62169 = state_62002;
state_62002 = G__62169;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = function(state_62002){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1.call(this,state_62002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__;
})()
;})(__62158,switch__41805__auto__,c__41822__auto___62161,G__61989_62159,n__28296__auto___62157,jobs,results,process,async))
})();
var state__41824__auto__ = (function (){var statearr_62016 = f__41823__auto__.call(null);
(statearr_62016[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___62161);

return statearr_62016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(__62158,c__41822__auto___62161,G__61989_62159,n__28296__auto___62157,jobs,results,process,async))
);


break;
case "async":
var c__41822__auto___62170 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__62158,c__41822__auto___62170,G__61989_62159,n__28296__auto___62157,jobs,results,process,async){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (__62158,c__41822__auto___62170,G__61989_62159,n__28296__auto___62157,jobs,results,process,async){
return (function (state_62029){
var state_val_62030 = (state_62029[(1)]);
if((state_val_62030 === (1))){
var state_62029__$1 = state_62029;
var statearr_62031_62171 = state_62029__$1;
(statearr_62031_62171[(2)] = null);

(statearr_62031_62171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62030 === (2))){
var state_62029__$1 = state_62029;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62029__$1,(4),jobs);
} else {
if((state_val_62030 === (3))){
var inst_62027 = (state_62029[(2)]);
var state_62029__$1 = state_62029;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62029__$1,inst_62027);
} else {
if((state_val_62030 === (4))){
var inst_62019 = (state_62029[(2)]);
var inst_62020 = async.call(null,inst_62019);
var state_62029__$1 = state_62029;
if(cljs.core.truth_(inst_62020)){
var statearr_62032_62172 = state_62029__$1;
(statearr_62032_62172[(1)] = (5));

} else {
var statearr_62033_62173 = state_62029__$1;
(statearr_62033_62173[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62030 === (5))){
var state_62029__$1 = state_62029;
var statearr_62034_62174 = state_62029__$1;
(statearr_62034_62174[(2)] = null);

(statearr_62034_62174[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62030 === (6))){
var state_62029__$1 = state_62029;
var statearr_62035_62175 = state_62029__$1;
(statearr_62035_62175[(2)] = null);

(statearr_62035_62175[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62030 === (7))){
var inst_62025 = (state_62029[(2)]);
var state_62029__$1 = state_62029;
var statearr_62036_62176 = state_62029__$1;
(statearr_62036_62176[(2)] = inst_62025);

(statearr_62036_62176[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__62158,c__41822__auto___62170,G__61989_62159,n__28296__auto___62157,jobs,results,process,async))
;
return ((function (__62158,switch__41805__auto__,c__41822__auto___62170,G__61989_62159,n__28296__auto___62157,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0 = (function (){
var statearr_62040 = [null,null,null,null,null,null,null];
(statearr_62040[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__);

(statearr_62040[(1)] = (1));

return statearr_62040;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1 = (function (state_62029){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_62029);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e62041){if((e62041 instanceof Object)){
var ex__41809__auto__ = e62041;
var statearr_62042_62177 = state_62029;
(statearr_62042_62177[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62029);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62041;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62178 = state_62029;
state_62029 = G__62178;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = function(state_62029){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1.call(this,state_62029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__;
})()
;})(__62158,switch__41805__auto__,c__41822__auto___62170,G__61989_62159,n__28296__auto___62157,jobs,results,process,async))
})();
var state__41824__auto__ = (function (){var statearr_62043 = f__41823__auto__.call(null);
(statearr_62043[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___62170);

return statearr_62043;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(__62158,c__41822__auto___62170,G__61989_62159,n__28296__auto___62157,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__62179 = (__62158 + (1));
__62158 = G__62179;
continue;
} else {
}
break;
}

var c__41822__auto___62180 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___62180,jobs,results,process,async){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___62180,jobs,results,process,async){
return (function (state_62065){
var state_val_62066 = (state_62065[(1)]);
if((state_val_62066 === (1))){
var state_62065__$1 = state_62065;
var statearr_62067_62181 = state_62065__$1;
(statearr_62067_62181[(2)] = null);

(statearr_62067_62181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62066 === (2))){
var state_62065__$1 = state_62065;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62065__$1,(4),from);
} else {
if((state_val_62066 === (3))){
var inst_62063 = (state_62065[(2)]);
var state_62065__$1 = state_62065;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62065__$1,inst_62063);
} else {
if((state_val_62066 === (4))){
var inst_62046 = (state_62065[(7)]);
var inst_62046__$1 = (state_62065[(2)]);
var inst_62047 = (inst_62046__$1 == null);
var state_62065__$1 = (function (){var statearr_62068 = state_62065;
(statearr_62068[(7)] = inst_62046__$1);

return statearr_62068;
})();
if(cljs.core.truth_(inst_62047)){
var statearr_62069_62182 = state_62065__$1;
(statearr_62069_62182[(1)] = (5));

} else {
var statearr_62070_62183 = state_62065__$1;
(statearr_62070_62183[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62066 === (5))){
var inst_62049 = cljs.core.async.close_BANG_.call(null,jobs);
var state_62065__$1 = state_62065;
var statearr_62071_62184 = state_62065__$1;
(statearr_62071_62184[(2)] = inst_62049);

(statearr_62071_62184[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62066 === (6))){
var inst_62046 = (state_62065[(7)]);
var inst_62051 = (state_62065[(8)]);
var inst_62051__$1 = cljs.core.async.chan.call(null,(1));
var inst_62052 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62053 = [inst_62046,inst_62051__$1];
var inst_62054 = (new cljs.core.PersistentVector(null,2,(5),inst_62052,inst_62053,null));
var state_62065__$1 = (function (){var statearr_62072 = state_62065;
(statearr_62072[(8)] = inst_62051__$1);

return statearr_62072;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_62065__$1,(8),jobs,inst_62054);
} else {
if((state_val_62066 === (7))){
var inst_62061 = (state_62065[(2)]);
var state_62065__$1 = state_62065;
var statearr_62073_62185 = state_62065__$1;
(statearr_62073_62185[(2)] = inst_62061);

(statearr_62073_62185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62066 === (8))){
var inst_62051 = (state_62065[(8)]);
var inst_62056 = (state_62065[(2)]);
var state_62065__$1 = (function (){var statearr_62074 = state_62065;
(statearr_62074[(9)] = inst_62056);

return statearr_62074;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_62065__$1,(9),results,inst_62051);
} else {
if((state_val_62066 === (9))){
var inst_62058 = (state_62065[(2)]);
var state_62065__$1 = (function (){var statearr_62075 = state_62065;
(statearr_62075[(10)] = inst_62058);

return statearr_62075;
})();
var statearr_62076_62186 = state_62065__$1;
(statearr_62076_62186[(2)] = null);

(statearr_62076_62186[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___62180,jobs,results,process,async))
;
return ((function (switch__41805__auto__,c__41822__auto___62180,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0 = (function (){
var statearr_62080 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_62080[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__);

(statearr_62080[(1)] = (1));

return statearr_62080;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1 = (function (state_62065){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_62065);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e62081){if((e62081 instanceof Object)){
var ex__41809__auto__ = e62081;
var statearr_62082_62187 = state_62065;
(statearr_62082_62187[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62065);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62081;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62188 = state_62065;
state_62065 = G__62188;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = function(state_62065){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1.call(this,state_62065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___62180,jobs,results,process,async))
})();
var state__41824__auto__ = (function (){var statearr_62083 = f__41823__auto__.call(null);
(statearr_62083[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___62180);

return statearr_62083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___62180,jobs,results,process,async))
);


var c__41822__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto__,jobs,results,process,async){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto__,jobs,results,process,async){
return (function (state_62121){
var state_val_62122 = (state_62121[(1)]);
if((state_val_62122 === (7))){
var inst_62117 = (state_62121[(2)]);
var state_62121__$1 = state_62121;
var statearr_62123_62189 = state_62121__$1;
(statearr_62123_62189[(2)] = inst_62117);

(statearr_62123_62189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62122 === (20))){
var state_62121__$1 = state_62121;
var statearr_62124_62190 = state_62121__$1;
(statearr_62124_62190[(2)] = null);

(statearr_62124_62190[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62122 === (1))){
var state_62121__$1 = state_62121;
var statearr_62125_62191 = state_62121__$1;
(statearr_62125_62191[(2)] = null);

(statearr_62125_62191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62122 === (4))){
var inst_62086 = (state_62121[(7)]);
var inst_62086__$1 = (state_62121[(2)]);
var inst_62087 = (inst_62086__$1 == null);
var state_62121__$1 = (function (){var statearr_62126 = state_62121;
(statearr_62126[(7)] = inst_62086__$1);

return statearr_62126;
})();
if(cljs.core.truth_(inst_62087)){
var statearr_62127_62192 = state_62121__$1;
(statearr_62127_62192[(1)] = (5));

} else {
var statearr_62128_62193 = state_62121__$1;
(statearr_62128_62193[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62122 === (15))){
var inst_62099 = (state_62121[(8)]);
var state_62121__$1 = state_62121;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_62121__$1,(18),to,inst_62099);
} else {
if((state_val_62122 === (21))){
var inst_62112 = (state_62121[(2)]);
var state_62121__$1 = state_62121;
var statearr_62129_62194 = state_62121__$1;
(statearr_62129_62194[(2)] = inst_62112);

(statearr_62129_62194[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62122 === (13))){
var inst_62114 = (state_62121[(2)]);
var state_62121__$1 = (function (){var statearr_62130 = state_62121;
(statearr_62130[(9)] = inst_62114);

return statearr_62130;
})();
var statearr_62131_62195 = state_62121__$1;
(statearr_62131_62195[(2)] = null);

(statearr_62131_62195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62122 === (6))){
var inst_62086 = (state_62121[(7)]);
var state_62121__$1 = state_62121;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62121__$1,(11),inst_62086);
} else {
if((state_val_62122 === (17))){
var inst_62107 = (state_62121[(2)]);
var state_62121__$1 = state_62121;
if(cljs.core.truth_(inst_62107)){
var statearr_62132_62196 = state_62121__$1;
(statearr_62132_62196[(1)] = (19));

} else {
var statearr_62133_62197 = state_62121__$1;
(statearr_62133_62197[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62122 === (3))){
var inst_62119 = (state_62121[(2)]);
var state_62121__$1 = state_62121;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62121__$1,inst_62119);
} else {
if((state_val_62122 === (12))){
var inst_62096 = (state_62121[(10)]);
var state_62121__$1 = state_62121;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62121__$1,(14),inst_62096);
} else {
if((state_val_62122 === (2))){
var state_62121__$1 = state_62121;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62121__$1,(4),results);
} else {
if((state_val_62122 === (19))){
var state_62121__$1 = state_62121;
var statearr_62134_62198 = state_62121__$1;
(statearr_62134_62198[(2)] = null);

(statearr_62134_62198[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62122 === (11))){
var inst_62096 = (state_62121[(2)]);
var state_62121__$1 = (function (){var statearr_62135 = state_62121;
(statearr_62135[(10)] = inst_62096);

return statearr_62135;
})();
var statearr_62136_62199 = state_62121__$1;
(statearr_62136_62199[(2)] = null);

(statearr_62136_62199[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62122 === (9))){
var state_62121__$1 = state_62121;
var statearr_62137_62200 = state_62121__$1;
(statearr_62137_62200[(2)] = null);

(statearr_62137_62200[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62122 === (5))){
var state_62121__$1 = state_62121;
if(cljs.core.truth_(close_QMARK_)){
var statearr_62138_62201 = state_62121__$1;
(statearr_62138_62201[(1)] = (8));

} else {
var statearr_62139_62202 = state_62121__$1;
(statearr_62139_62202[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62122 === (14))){
var inst_62099 = (state_62121[(8)]);
var inst_62101 = (state_62121[(11)]);
var inst_62099__$1 = (state_62121[(2)]);
var inst_62100 = (inst_62099__$1 == null);
var inst_62101__$1 = cljs.core.not.call(null,inst_62100);
var state_62121__$1 = (function (){var statearr_62140 = state_62121;
(statearr_62140[(8)] = inst_62099__$1);

(statearr_62140[(11)] = inst_62101__$1);

return statearr_62140;
})();
if(inst_62101__$1){
var statearr_62141_62203 = state_62121__$1;
(statearr_62141_62203[(1)] = (15));

} else {
var statearr_62142_62204 = state_62121__$1;
(statearr_62142_62204[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62122 === (16))){
var inst_62101 = (state_62121[(11)]);
var state_62121__$1 = state_62121;
var statearr_62143_62205 = state_62121__$1;
(statearr_62143_62205[(2)] = inst_62101);

(statearr_62143_62205[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62122 === (10))){
var inst_62093 = (state_62121[(2)]);
var state_62121__$1 = state_62121;
var statearr_62144_62206 = state_62121__$1;
(statearr_62144_62206[(2)] = inst_62093);

(statearr_62144_62206[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62122 === (18))){
var inst_62104 = (state_62121[(2)]);
var state_62121__$1 = state_62121;
var statearr_62145_62207 = state_62121__$1;
(statearr_62145_62207[(2)] = inst_62104);

(statearr_62145_62207[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62122 === (8))){
var inst_62090 = cljs.core.async.close_BANG_.call(null,to);
var state_62121__$1 = state_62121;
var statearr_62146_62208 = state_62121__$1;
(statearr_62146_62208[(2)] = inst_62090);

(statearr_62146_62208[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto__,jobs,results,process,async))
;
return ((function (switch__41805__auto__,c__41822__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0 = (function (){
var statearr_62150 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62150[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__);

(statearr_62150[(1)] = (1));

return statearr_62150;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1 = (function (state_62121){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_62121);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e62151){if((e62151 instanceof Object)){
var ex__41809__auto__ = e62151;
var statearr_62152_62209 = state_62121;
(statearr_62152_62209[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62121);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62151;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62210 = state_62121;
state_62121 = G__62210;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__ = function(state_62121){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1.call(this,state_62121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41806__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto__,jobs,results,process,async))
})();
var state__41824__auto__ = (function (){var statearr_62153 = f__41823__auto__.call(null);
(statearr_62153[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto__);

return statearr_62153;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto__,jobs,results,process,async))
);

return c__41822__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args62211 = [];
var len__28496__auto___62214 = arguments.length;
var i__28497__auto___62215 = (0);
while(true){
if((i__28497__auto___62215 < len__28496__auto___62214)){
args62211.push((arguments[i__28497__auto___62215]));

var G__62216 = (i__28497__auto___62215 + (1));
i__28497__auto___62215 = G__62216;
continue;
} else {
}
break;
}

var G__62213 = args62211.length;
switch (G__62213) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args62211.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args62218 = [];
var len__28496__auto___62221 = arguments.length;
var i__28497__auto___62222 = (0);
while(true){
if((i__28497__auto___62222 < len__28496__auto___62221)){
args62218.push((arguments[i__28497__auto___62222]));

var G__62223 = (i__28497__auto___62222 + (1));
i__28497__auto___62222 = G__62223;
continue;
} else {
}
break;
}

var G__62220 = args62218.length;
switch (G__62220) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args62218.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args62225 = [];
var len__28496__auto___62278 = arguments.length;
var i__28497__auto___62279 = (0);
while(true){
if((i__28497__auto___62279 < len__28496__auto___62278)){
args62225.push((arguments[i__28497__auto___62279]));

var G__62280 = (i__28497__auto___62279 + (1));
i__28497__auto___62279 = G__62280;
continue;
} else {
}
break;
}

var G__62227 = args62225.length;
switch (G__62227) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args62225.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__41822__auto___62282 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___62282,tc,fc){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___62282,tc,fc){
return (function (state_62253){
var state_val_62254 = (state_62253[(1)]);
if((state_val_62254 === (7))){
var inst_62249 = (state_62253[(2)]);
var state_62253__$1 = state_62253;
var statearr_62255_62283 = state_62253__$1;
(statearr_62255_62283[(2)] = inst_62249);

(statearr_62255_62283[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (1))){
var state_62253__$1 = state_62253;
var statearr_62256_62284 = state_62253__$1;
(statearr_62256_62284[(2)] = null);

(statearr_62256_62284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (4))){
var inst_62230 = (state_62253[(7)]);
var inst_62230__$1 = (state_62253[(2)]);
var inst_62231 = (inst_62230__$1 == null);
var state_62253__$1 = (function (){var statearr_62257 = state_62253;
(statearr_62257[(7)] = inst_62230__$1);

return statearr_62257;
})();
if(cljs.core.truth_(inst_62231)){
var statearr_62258_62285 = state_62253__$1;
(statearr_62258_62285[(1)] = (5));

} else {
var statearr_62259_62286 = state_62253__$1;
(statearr_62259_62286[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (13))){
var state_62253__$1 = state_62253;
var statearr_62260_62287 = state_62253__$1;
(statearr_62260_62287[(2)] = null);

(statearr_62260_62287[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (6))){
var inst_62230 = (state_62253[(7)]);
var inst_62236 = p.call(null,inst_62230);
var state_62253__$1 = state_62253;
if(cljs.core.truth_(inst_62236)){
var statearr_62261_62288 = state_62253__$1;
(statearr_62261_62288[(1)] = (9));

} else {
var statearr_62262_62289 = state_62253__$1;
(statearr_62262_62289[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (3))){
var inst_62251 = (state_62253[(2)]);
var state_62253__$1 = state_62253;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62253__$1,inst_62251);
} else {
if((state_val_62254 === (12))){
var state_62253__$1 = state_62253;
var statearr_62263_62290 = state_62253__$1;
(statearr_62263_62290[(2)] = null);

(statearr_62263_62290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (2))){
var state_62253__$1 = state_62253;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62253__$1,(4),ch);
} else {
if((state_val_62254 === (11))){
var inst_62230 = (state_62253[(7)]);
var inst_62240 = (state_62253[(2)]);
var state_62253__$1 = state_62253;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_62253__$1,(8),inst_62240,inst_62230);
} else {
if((state_val_62254 === (9))){
var state_62253__$1 = state_62253;
var statearr_62264_62291 = state_62253__$1;
(statearr_62264_62291[(2)] = tc);

(statearr_62264_62291[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (5))){
var inst_62233 = cljs.core.async.close_BANG_.call(null,tc);
var inst_62234 = cljs.core.async.close_BANG_.call(null,fc);
var state_62253__$1 = (function (){var statearr_62265 = state_62253;
(statearr_62265[(8)] = inst_62233);

return statearr_62265;
})();
var statearr_62266_62292 = state_62253__$1;
(statearr_62266_62292[(2)] = inst_62234);

(statearr_62266_62292[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (14))){
var inst_62247 = (state_62253[(2)]);
var state_62253__$1 = state_62253;
var statearr_62267_62293 = state_62253__$1;
(statearr_62267_62293[(2)] = inst_62247);

(statearr_62267_62293[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (10))){
var state_62253__$1 = state_62253;
var statearr_62268_62294 = state_62253__$1;
(statearr_62268_62294[(2)] = fc);

(statearr_62268_62294[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62254 === (8))){
var inst_62242 = (state_62253[(2)]);
var state_62253__$1 = state_62253;
if(cljs.core.truth_(inst_62242)){
var statearr_62269_62295 = state_62253__$1;
(statearr_62269_62295[(1)] = (12));

} else {
var statearr_62270_62296 = state_62253__$1;
(statearr_62270_62296[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___62282,tc,fc))
;
return ((function (switch__41805__auto__,c__41822__auto___62282,tc,fc){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_62274 = [null,null,null,null,null,null,null,null,null];
(statearr_62274[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_62274[(1)] = (1));

return statearr_62274;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_62253){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_62253);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e62275){if((e62275 instanceof Object)){
var ex__41809__auto__ = e62275;
var statearr_62276_62297 = state_62253;
(statearr_62276_62297[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62253);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62275;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62298 = state_62253;
state_62253 = G__62298;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_62253){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_62253);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___62282,tc,fc))
})();
var state__41824__auto__ = (function (){var statearr_62277 = f__41823__auto__.call(null);
(statearr_62277[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___62282);

return statearr_62277;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___62282,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__41822__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto__){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto__){
return (function (state_62362){
var state_val_62363 = (state_62362[(1)]);
if((state_val_62363 === (7))){
var inst_62358 = (state_62362[(2)]);
var state_62362__$1 = state_62362;
var statearr_62364_62385 = state_62362__$1;
(statearr_62364_62385[(2)] = inst_62358);

(statearr_62364_62385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62363 === (1))){
var inst_62342 = init;
var state_62362__$1 = (function (){var statearr_62365 = state_62362;
(statearr_62365[(7)] = inst_62342);

return statearr_62365;
})();
var statearr_62366_62386 = state_62362__$1;
(statearr_62366_62386[(2)] = null);

(statearr_62366_62386[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62363 === (4))){
var inst_62345 = (state_62362[(8)]);
var inst_62345__$1 = (state_62362[(2)]);
var inst_62346 = (inst_62345__$1 == null);
var state_62362__$1 = (function (){var statearr_62367 = state_62362;
(statearr_62367[(8)] = inst_62345__$1);

return statearr_62367;
})();
if(cljs.core.truth_(inst_62346)){
var statearr_62368_62388 = state_62362__$1;
(statearr_62368_62388[(1)] = (5));

} else {
var statearr_62369_62389 = state_62362__$1;
(statearr_62369_62389[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62363 === (6))){
var inst_62345 = (state_62362[(8)]);
var inst_62342 = (state_62362[(7)]);
var inst_62349 = (state_62362[(9)]);
var inst_62349__$1 = f.call(null,inst_62342,inst_62345);
var inst_62350 = cljs.core.reduced_QMARK_.call(null,inst_62349__$1);
var state_62362__$1 = (function (){var statearr_62370 = state_62362;
(statearr_62370[(9)] = inst_62349__$1);

return statearr_62370;
})();
if(inst_62350){
var statearr_62371_62390 = state_62362__$1;
(statearr_62371_62390[(1)] = (8));

} else {
var statearr_62372_62391 = state_62362__$1;
(statearr_62372_62391[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62363 === (3))){
var inst_62360 = (state_62362[(2)]);
var state_62362__$1 = state_62362;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62362__$1,inst_62360);
} else {
if((state_val_62363 === (2))){
var state_62362__$1 = state_62362;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62362__$1,(4),ch);
} else {
if((state_val_62363 === (9))){
var inst_62349 = (state_62362[(9)]);
var inst_62342 = inst_62349;
var state_62362__$1 = (function (){var statearr_62373 = state_62362;
(statearr_62373[(7)] = inst_62342);

return statearr_62373;
})();
var statearr_62374_62392 = state_62362__$1;
(statearr_62374_62392[(2)] = null);

(statearr_62374_62392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62363 === (5))){
var inst_62342 = (state_62362[(7)]);
var state_62362__$1 = state_62362;
var statearr_62375_62393 = state_62362__$1;
(statearr_62375_62393[(2)] = inst_62342);

(statearr_62375_62393[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62363 === (10))){
var inst_62356 = (state_62362[(2)]);
var state_62362__$1 = state_62362;
var statearr_62376_62394 = state_62362__$1;
(statearr_62376_62394[(2)] = inst_62356);

(statearr_62376_62394[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62363 === (8))){
var inst_62349 = (state_62362[(9)]);
var inst_62352 = cljs.core.deref.call(null,inst_62349);
var state_62362__$1 = state_62362;
var statearr_62377_62395 = state_62362__$1;
(statearr_62377_62395[(2)] = inst_62352);

(statearr_62377_62395[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto__))
;
return ((function (switch__41805__auto__,c__41822__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__41806__auto__ = null;
var cljs$core$async$reduce_$_state_machine__41806__auto____0 = (function (){
var statearr_62381 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62381[(0)] = cljs$core$async$reduce_$_state_machine__41806__auto__);

(statearr_62381[(1)] = (1));

return statearr_62381;
});
var cljs$core$async$reduce_$_state_machine__41806__auto____1 = (function (state_62362){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_62362);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e62382){if((e62382 instanceof Object)){
var ex__41809__auto__ = e62382;
var statearr_62383_62396 = state_62362;
(statearr_62383_62396[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62362);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62382;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62397 = state_62362;
state_62362 = G__62397;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__41806__auto__ = function(state_62362){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__41806__auto____1.call(this,state_62362);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__41806__auto____0;
cljs$core$async$reduce_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__41806__auto____1;
return cljs$core$async$reduce_$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto__))
})();
var state__41824__auto__ = (function (){var statearr_62384 = f__41823__auto__.call(null);
(statearr_62384[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto__);

return statearr_62384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto__))
);

return c__41822__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args62398 = [];
var len__28496__auto___62450 = arguments.length;
var i__28497__auto___62451 = (0);
while(true){
if((i__28497__auto___62451 < len__28496__auto___62450)){
args62398.push((arguments[i__28497__auto___62451]));

var G__62452 = (i__28497__auto___62451 + (1));
i__28497__auto___62451 = G__62452;
continue;
} else {
}
break;
}

var G__62400 = args62398.length;
switch (G__62400) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args62398.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__41822__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto__){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto__){
return (function (state_62425){
var state_val_62426 = (state_62425[(1)]);
if((state_val_62426 === (7))){
var inst_62407 = (state_62425[(2)]);
var state_62425__$1 = state_62425;
var statearr_62427_62454 = state_62425__$1;
(statearr_62427_62454[(2)] = inst_62407);

(statearr_62427_62454[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62426 === (1))){
var inst_62401 = cljs.core.seq.call(null,coll);
var inst_62402 = inst_62401;
var state_62425__$1 = (function (){var statearr_62428 = state_62425;
(statearr_62428[(7)] = inst_62402);

return statearr_62428;
})();
var statearr_62429_62455 = state_62425__$1;
(statearr_62429_62455[(2)] = null);

(statearr_62429_62455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62426 === (4))){
var inst_62402 = (state_62425[(7)]);
var inst_62405 = cljs.core.first.call(null,inst_62402);
var state_62425__$1 = state_62425;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_62425__$1,(7),ch,inst_62405);
} else {
if((state_val_62426 === (13))){
var inst_62419 = (state_62425[(2)]);
var state_62425__$1 = state_62425;
var statearr_62430_62456 = state_62425__$1;
(statearr_62430_62456[(2)] = inst_62419);

(statearr_62430_62456[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62426 === (6))){
var inst_62410 = (state_62425[(2)]);
var state_62425__$1 = state_62425;
if(cljs.core.truth_(inst_62410)){
var statearr_62431_62457 = state_62425__$1;
(statearr_62431_62457[(1)] = (8));

} else {
var statearr_62432_62458 = state_62425__$1;
(statearr_62432_62458[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62426 === (3))){
var inst_62423 = (state_62425[(2)]);
var state_62425__$1 = state_62425;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62425__$1,inst_62423);
} else {
if((state_val_62426 === (12))){
var state_62425__$1 = state_62425;
var statearr_62433_62459 = state_62425__$1;
(statearr_62433_62459[(2)] = null);

(statearr_62433_62459[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62426 === (2))){
var inst_62402 = (state_62425[(7)]);
var state_62425__$1 = state_62425;
if(cljs.core.truth_(inst_62402)){
var statearr_62434_62460 = state_62425__$1;
(statearr_62434_62460[(1)] = (4));

} else {
var statearr_62435_62461 = state_62425__$1;
(statearr_62435_62461[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62426 === (11))){
var inst_62416 = cljs.core.async.close_BANG_.call(null,ch);
var state_62425__$1 = state_62425;
var statearr_62436_62462 = state_62425__$1;
(statearr_62436_62462[(2)] = inst_62416);

(statearr_62436_62462[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62426 === (9))){
var state_62425__$1 = state_62425;
if(cljs.core.truth_(close_QMARK_)){
var statearr_62437_62463 = state_62425__$1;
(statearr_62437_62463[(1)] = (11));

} else {
var statearr_62438_62464 = state_62425__$1;
(statearr_62438_62464[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62426 === (5))){
var inst_62402 = (state_62425[(7)]);
var state_62425__$1 = state_62425;
var statearr_62439_62465 = state_62425__$1;
(statearr_62439_62465[(2)] = inst_62402);

(statearr_62439_62465[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62426 === (10))){
var inst_62421 = (state_62425[(2)]);
var state_62425__$1 = state_62425;
var statearr_62440_62466 = state_62425__$1;
(statearr_62440_62466[(2)] = inst_62421);

(statearr_62440_62466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62426 === (8))){
var inst_62402 = (state_62425[(7)]);
var inst_62412 = cljs.core.next.call(null,inst_62402);
var inst_62402__$1 = inst_62412;
var state_62425__$1 = (function (){var statearr_62441 = state_62425;
(statearr_62441[(7)] = inst_62402__$1);

return statearr_62441;
})();
var statearr_62442_62467 = state_62425__$1;
(statearr_62442_62467[(2)] = null);

(statearr_62442_62467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto__))
;
return ((function (switch__41805__auto__,c__41822__auto__){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_62446 = [null,null,null,null,null,null,null,null];
(statearr_62446[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_62446[(1)] = (1));

return statearr_62446;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_62425){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_62425);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e62447){if((e62447 instanceof Object)){
var ex__41809__auto__ = e62447;
var statearr_62448_62468 = state_62425;
(statearr_62448_62468[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62425);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62447;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62469 = state_62425;
state_62425 = G__62469;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_62425){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_62425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto__))
})();
var state__41824__auto__ = (function (){var statearr_62449 = f__41823__auto__.call(null);
(statearr_62449[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto__);

return statearr_62449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto__))
);

return c__41822__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__27993__auto__ = (((_ == null))?null:_);
var m__27994__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,_);
} else {
var m__27994__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__27994__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m,ch);
} else {
var m__27994__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m);
} else {
var m__27994__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async62695 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async62695 = (function (ch,cs,meta62696){
this.ch = ch;
this.cs = cs;
this.meta62696 = meta62696;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async62695.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_62697,meta62696__$1){
var self__ = this;
var _62697__$1 = this;
return (new cljs.core.async.t_cljs$core$async62695(self__.ch,self__.cs,meta62696__$1));
});})(cs))
;


cljs.core.async.t_cljs$core$async62695.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_62697){
var self__ = this;
var _62697__$1 = this;
return self__.meta62696;
});})(cs))
;


cljs.core.async.t_cljs$core$async62695.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async62695.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;


cljs.core.async.t_cljs$core$async62695.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async62695.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async62695.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async62695.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async62695.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta62696","meta62696",1263437182,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async62695.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async62695.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async62695";

cljs.core.async.t_cljs$core$async62695.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async62695");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async62695 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async62695(ch__$1,cs__$1,meta62696){
return (new cljs.core.async.t_cljs$core$async62695(ch__$1,cs__$1,meta62696));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async62695(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__41822__auto___62920 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___62920,cs,m,dchan,dctr,done){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___62920,cs,m,dchan,dctr,done){
return (function (state_62832){
var state_val_62833 = (state_62832[(1)]);
if((state_val_62833 === (7))){
var inst_62828 = (state_62832[(2)]);
var state_62832__$1 = state_62832;
var statearr_62834_62921 = state_62832__$1;
(statearr_62834_62921[(2)] = inst_62828);

(statearr_62834_62921[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (20))){
var inst_62731 = (state_62832[(7)]);
var inst_62743 = cljs.core.first.call(null,inst_62731);
var inst_62744 = cljs.core.nth.call(null,inst_62743,(0),null);
var inst_62745 = cljs.core.nth.call(null,inst_62743,(1),null);
var state_62832__$1 = (function (){var statearr_62835 = state_62832;
(statearr_62835[(8)] = inst_62744);

return statearr_62835;
})();
if(cljs.core.truth_(inst_62745)){
var statearr_62836_62922 = state_62832__$1;
(statearr_62836_62922[(1)] = (22));

} else {
var statearr_62837_62923 = state_62832__$1;
(statearr_62837_62923[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (27))){
var inst_62700 = (state_62832[(9)]);
var inst_62775 = (state_62832[(10)]);
var inst_62773 = (state_62832[(11)]);
var inst_62780 = (state_62832[(12)]);
var inst_62780__$1 = cljs.core._nth.call(null,inst_62773,inst_62775);
var inst_62781 = cljs.core.async.put_BANG_.call(null,inst_62780__$1,inst_62700,done);
var state_62832__$1 = (function (){var statearr_62838 = state_62832;
(statearr_62838[(12)] = inst_62780__$1);

return statearr_62838;
})();
if(cljs.core.truth_(inst_62781)){
var statearr_62839_62924 = state_62832__$1;
(statearr_62839_62924[(1)] = (30));

} else {
var statearr_62840_62925 = state_62832__$1;
(statearr_62840_62925[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (1))){
var state_62832__$1 = state_62832;
var statearr_62841_62926 = state_62832__$1;
(statearr_62841_62926[(2)] = null);

(statearr_62841_62926[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (24))){
var inst_62731 = (state_62832[(7)]);
var inst_62750 = (state_62832[(2)]);
var inst_62751 = cljs.core.next.call(null,inst_62731);
var inst_62709 = inst_62751;
var inst_62710 = null;
var inst_62711 = (0);
var inst_62712 = (0);
var state_62832__$1 = (function (){var statearr_62842 = state_62832;
(statearr_62842[(13)] = inst_62712);

(statearr_62842[(14)] = inst_62710);

(statearr_62842[(15)] = inst_62750);

(statearr_62842[(16)] = inst_62711);

(statearr_62842[(17)] = inst_62709);

return statearr_62842;
})();
var statearr_62843_62927 = state_62832__$1;
(statearr_62843_62927[(2)] = null);

(statearr_62843_62927[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (39))){
var state_62832__$1 = state_62832;
var statearr_62847_62928 = state_62832__$1;
(statearr_62847_62928[(2)] = null);

(statearr_62847_62928[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (4))){
var inst_62700 = (state_62832[(9)]);
var inst_62700__$1 = (state_62832[(2)]);
var inst_62701 = (inst_62700__$1 == null);
var state_62832__$1 = (function (){var statearr_62848 = state_62832;
(statearr_62848[(9)] = inst_62700__$1);

return statearr_62848;
})();
if(cljs.core.truth_(inst_62701)){
var statearr_62849_62929 = state_62832__$1;
(statearr_62849_62929[(1)] = (5));

} else {
var statearr_62850_62930 = state_62832__$1;
(statearr_62850_62930[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (15))){
var inst_62712 = (state_62832[(13)]);
var inst_62710 = (state_62832[(14)]);
var inst_62711 = (state_62832[(16)]);
var inst_62709 = (state_62832[(17)]);
var inst_62727 = (state_62832[(2)]);
var inst_62728 = (inst_62712 + (1));
var tmp62844 = inst_62710;
var tmp62845 = inst_62711;
var tmp62846 = inst_62709;
var inst_62709__$1 = tmp62846;
var inst_62710__$1 = tmp62844;
var inst_62711__$1 = tmp62845;
var inst_62712__$1 = inst_62728;
var state_62832__$1 = (function (){var statearr_62851 = state_62832;
(statearr_62851[(13)] = inst_62712__$1);

(statearr_62851[(14)] = inst_62710__$1);

(statearr_62851[(16)] = inst_62711__$1);

(statearr_62851[(18)] = inst_62727);

(statearr_62851[(17)] = inst_62709__$1);

return statearr_62851;
})();
var statearr_62852_62931 = state_62832__$1;
(statearr_62852_62931[(2)] = null);

(statearr_62852_62931[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (21))){
var inst_62754 = (state_62832[(2)]);
var state_62832__$1 = state_62832;
var statearr_62856_62932 = state_62832__$1;
(statearr_62856_62932[(2)] = inst_62754);

(statearr_62856_62932[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (31))){
var inst_62780 = (state_62832[(12)]);
var inst_62784 = done.call(null,null);
var inst_62785 = cljs.core.async.untap_STAR_.call(null,m,inst_62780);
var state_62832__$1 = (function (){var statearr_62857 = state_62832;
(statearr_62857[(19)] = inst_62784);

return statearr_62857;
})();
var statearr_62858_62933 = state_62832__$1;
(statearr_62858_62933[(2)] = inst_62785);

(statearr_62858_62933[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (32))){
var inst_62775 = (state_62832[(10)]);
var inst_62774 = (state_62832[(20)]);
var inst_62773 = (state_62832[(11)]);
var inst_62772 = (state_62832[(21)]);
var inst_62787 = (state_62832[(2)]);
var inst_62788 = (inst_62775 + (1));
var tmp62853 = inst_62774;
var tmp62854 = inst_62773;
var tmp62855 = inst_62772;
var inst_62772__$1 = tmp62855;
var inst_62773__$1 = tmp62854;
var inst_62774__$1 = tmp62853;
var inst_62775__$1 = inst_62788;
var state_62832__$1 = (function (){var statearr_62859 = state_62832;
(statearr_62859[(10)] = inst_62775__$1);

(statearr_62859[(22)] = inst_62787);

(statearr_62859[(20)] = inst_62774__$1);

(statearr_62859[(11)] = inst_62773__$1);

(statearr_62859[(21)] = inst_62772__$1);

return statearr_62859;
})();
var statearr_62860_62934 = state_62832__$1;
(statearr_62860_62934[(2)] = null);

(statearr_62860_62934[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (40))){
var inst_62800 = (state_62832[(23)]);
var inst_62804 = done.call(null,null);
var inst_62805 = cljs.core.async.untap_STAR_.call(null,m,inst_62800);
var state_62832__$1 = (function (){var statearr_62861 = state_62832;
(statearr_62861[(24)] = inst_62804);

return statearr_62861;
})();
var statearr_62862_62935 = state_62832__$1;
(statearr_62862_62935[(2)] = inst_62805);

(statearr_62862_62935[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (33))){
var inst_62791 = (state_62832[(25)]);
var inst_62793 = cljs.core.chunked_seq_QMARK_.call(null,inst_62791);
var state_62832__$1 = state_62832;
if(inst_62793){
var statearr_62863_62936 = state_62832__$1;
(statearr_62863_62936[(1)] = (36));

} else {
var statearr_62864_62937 = state_62832__$1;
(statearr_62864_62937[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (13))){
var inst_62721 = (state_62832[(26)]);
var inst_62724 = cljs.core.async.close_BANG_.call(null,inst_62721);
var state_62832__$1 = state_62832;
var statearr_62865_62938 = state_62832__$1;
(statearr_62865_62938[(2)] = inst_62724);

(statearr_62865_62938[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (22))){
var inst_62744 = (state_62832[(8)]);
var inst_62747 = cljs.core.async.close_BANG_.call(null,inst_62744);
var state_62832__$1 = state_62832;
var statearr_62866_62939 = state_62832__$1;
(statearr_62866_62939[(2)] = inst_62747);

(statearr_62866_62939[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (36))){
var inst_62791 = (state_62832[(25)]);
var inst_62795 = cljs.core.chunk_first.call(null,inst_62791);
var inst_62796 = cljs.core.chunk_rest.call(null,inst_62791);
var inst_62797 = cljs.core.count.call(null,inst_62795);
var inst_62772 = inst_62796;
var inst_62773 = inst_62795;
var inst_62774 = inst_62797;
var inst_62775 = (0);
var state_62832__$1 = (function (){var statearr_62867 = state_62832;
(statearr_62867[(10)] = inst_62775);

(statearr_62867[(20)] = inst_62774);

(statearr_62867[(11)] = inst_62773);

(statearr_62867[(21)] = inst_62772);

return statearr_62867;
})();
var statearr_62868_62940 = state_62832__$1;
(statearr_62868_62940[(2)] = null);

(statearr_62868_62940[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (41))){
var inst_62791 = (state_62832[(25)]);
var inst_62807 = (state_62832[(2)]);
var inst_62808 = cljs.core.next.call(null,inst_62791);
var inst_62772 = inst_62808;
var inst_62773 = null;
var inst_62774 = (0);
var inst_62775 = (0);
var state_62832__$1 = (function (){var statearr_62869 = state_62832;
(statearr_62869[(10)] = inst_62775);

(statearr_62869[(20)] = inst_62774);

(statearr_62869[(11)] = inst_62773);

(statearr_62869[(21)] = inst_62772);

(statearr_62869[(27)] = inst_62807);

return statearr_62869;
})();
var statearr_62870_62941 = state_62832__$1;
(statearr_62870_62941[(2)] = null);

(statearr_62870_62941[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (43))){
var state_62832__$1 = state_62832;
var statearr_62871_62942 = state_62832__$1;
(statearr_62871_62942[(2)] = null);

(statearr_62871_62942[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (29))){
var inst_62816 = (state_62832[(2)]);
var state_62832__$1 = state_62832;
var statearr_62872_62943 = state_62832__$1;
(statearr_62872_62943[(2)] = inst_62816);

(statearr_62872_62943[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (44))){
var inst_62825 = (state_62832[(2)]);
var state_62832__$1 = (function (){var statearr_62873 = state_62832;
(statearr_62873[(28)] = inst_62825);

return statearr_62873;
})();
var statearr_62874_62944 = state_62832__$1;
(statearr_62874_62944[(2)] = null);

(statearr_62874_62944[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (6))){
var inst_62764 = (state_62832[(29)]);
var inst_62763 = cljs.core.deref.call(null,cs);
var inst_62764__$1 = cljs.core.keys.call(null,inst_62763);
var inst_62765 = cljs.core.count.call(null,inst_62764__$1);
var inst_62766 = cljs.core.reset_BANG_.call(null,dctr,inst_62765);
var inst_62771 = cljs.core.seq.call(null,inst_62764__$1);
var inst_62772 = inst_62771;
var inst_62773 = null;
var inst_62774 = (0);
var inst_62775 = (0);
var state_62832__$1 = (function (){var statearr_62875 = state_62832;
(statearr_62875[(10)] = inst_62775);

(statearr_62875[(20)] = inst_62774);

(statearr_62875[(11)] = inst_62773);

(statearr_62875[(21)] = inst_62772);

(statearr_62875[(30)] = inst_62766);

(statearr_62875[(29)] = inst_62764__$1);

return statearr_62875;
})();
var statearr_62876_62945 = state_62832__$1;
(statearr_62876_62945[(2)] = null);

(statearr_62876_62945[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (28))){
var inst_62772 = (state_62832[(21)]);
var inst_62791 = (state_62832[(25)]);
var inst_62791__$1 = cljs.core.seq.call(null,inst_62772);
var state_62832__$1 = (function (){var statearr_62877 = state_62832;
(statearr_62877[(25)] = inst_62791__$1);

return statearr_62877;
})();
if(inst_62791__$1){
var statearr_62878_62946 = state_62832__$1;
(statearr_62878_62946[(1)] = (33));

} else {
var statearr_62879_62947 = state_62832__$1;
(statearr_62879_62947[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (25))){
var inst_62775 = (state_62832[(10)]);
var inst_62774 = (state_62832[(20)]);
var inst_62777 = (inst_62775 < inst_62774);
var inst_62778 = inst_62777;
var state_62832__$1 = state_62832;
if(cljs.core.truth_(inst_62778)){
var statearr_62880_62948 = state_62832__$1;
(statearr_62880_62948[(1)] = (27));

} else {
var statearr_62881_62949 = state_62832__$1;
(statearr_62881_62949[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (34))){
var state_62832__$1 = state_62832;
var statearr_62882_62950 = state_62832__$1;
(statearr_62882_62950[(2)] = null);

(statearr_62882_62950[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (17))){
var state_62832__$1 = state_62832;
var statearr_62883_62951 = state_62832__$1;
(statearr_62883_62951[(2)] = null);

(statearr_62883_62951[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (3))){
var inst_62830 = (state_62832[(2)]);
var state_62832__$1 = state_62832;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62832__$1,inst_62830);
} else {
if((state_val_62833 === (12))){
var inst_62759 = (state_62832[(2)]);
var state_62832__$1 = state_62832;
var statearr_62884_62952 = state_62832__$1;
(statearr_62884_62952[(2)] = inst_62759);

(statearr_62884_62952[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (2))){
var state_62832__$1 = state_62832;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62832__$1,(4),ch);
} else {
if((state_val_62833 === (23))){
var state_62832__$1 = state_62832;
var statearr_62885_62953 = state_62832__$1;
(statearr_62885_62953[(2)] = null);

(statearr_62885_62953[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (35))){
var inst_62814 = (state_62832[(2)]);
var state_62832__$1 = state_62832;
var statearr_62886_62954 = state_62832__$1;
(statearr_62886_62954[(2)] = inst_62814);

(statearr_62886_62954[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (19))){
var inst_62731 = (state_62832[(7)]);
var inst_62735 = cljs.core.chunk_first.call(null,inst_62731);
var inst_62736 = cljs.core.chunk_rest.call(null,inst_62731);
var inst_62737 = cljs.core.count.call(null,inst_62735);
var inst_62709 = inst_62736;
var inst_62710 = inst_62735;
var inst_62711 = inst_62737;
var inst_62712 = (0);
var state_62832__$1 = (function (){var statearr_62887 = state_62832;
(statearr_62887[(13)] = inst_62712);

(statearr_62887[(14)] = inst_62710);

(statearr_62887[(16)] = inst_62711);

(statearr_62887[(17)] = inst_62709);

return statearr_62887;
})();
var statearr_62888_62955 = state_62832__$1;
(statearr_62888_62955[(2)] = null);

(statearr_62888_62955[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (11))){
var inst_62731 = (state_62832[(7)]);
var inst_62709 = (state_62832[(17)]);
var inst_62731__$1 = cljs.core.seq.call(null,inst_62709);
var state_62832__$1 = (function (){var statearr_62889 = state_62832;
(statearr_62889[(7)] = inst_62731__$1);

return statearr_62889;
})();
if(inst_62731__$1){
var statearr_62890_62956 = state_62832__$1;
(statearr_62890_62956[(1)] = (16));

} else {
var statearr_62891_62957 = state_62832__$1;
(statearr_62891_62957[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (9))){
var inst_62761 = (state_62832[(2)]);
var state_62832__$1 = state_62832;
var statearr_62892_62958 = state_62832__$1;
(statearr_62892_62958[(2)] = inst_62761);

(statearr_62892_62958[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (5))){
var inst_62707 = cljs.core.deref.call(null,cs);
var inst_62708 = cljs.core.seq.call(null,inst_62707);
var inst_62709 = inst_62708;
var inst_62710 = null;
var inst_62711 = (0);
var inst_62712 = (0);
var state_62832__$1 = (function (){var statearr_62893 = state_62832;
(statearr_62893[(13)] = inst_62712);

(statearr_62893[(14)] = inst_62710);

(statearr_62893[(16)] = inst_62711);

(statearr_62893[(17)] = inst_62709);

return statearr_62893;
})();
var statearr_62894_62959 = state_62832__$1;
(statearr_62894_62959[(2)] = null);

(statearr_62894_62959[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (14))){
var state_62832__$1 = state_62832;
var statearr_62895_62960 = state_62832__$1;
(statearr_62895_62960[(2)] = null);

(statearr_62895_62960[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (45))){
var inst_62822 = (state_62832[(2)]);
var state_62832__$1 = state_62832;
var statearr_62896_62961 = state_62832__$1;
(statearr_62896_62961[(2)] = inst_62822);

(statearr_62896_62961[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (26))){
var inst_62764 = (state_62832[(29)]);
var inst_62818 = (state_62832[(2)]);
var inst_62819 = cljs.core.seq.call(null,inst_62764);
var state_62832__$1 = (function (){var statearr_62897 = state_62832;
(statearr_62897[(31)] = inst_62818);

return statearr_62897;
})();
if(inst_62819){
var statearr_62898_62962 = state_62832__$1;
(statearr_62898_62962[(1)] = (42));

} else {
var statearr_62899_62963 = state_62832__$1;
(statearr_62899_62963[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (16))){
var inst_62731 = (state_62832[(7)]);
var inst_62733 = cljs.core.chunked_seq_QMARK_.call(null,inst_62731);
var state_62832__$1 = state_62832;
if(inst_62733){
var statearr_62900_62964 = state_62832__$1;
(statearr_62900_62964[(1)] = (19));

} else {
var statearr_62901_62965 = state_62832__$1;
(statearr_62901_62965[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (38))){
var inst_62811 = (state_62832[(2)]);
var state_62832__$1 = state_62832;
var statearr_62902_62966 = state_62832__$1;
(statearr_62902_62966[(2)] = inst_62811);

(statearr_62902_62966[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (30))){
var state_62832__$1 = state_62832;
var statearr_62903_62967 = state_62832__$1;
(statearr_62903_62967[(2)] = null);

(statearr_62903_62967[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (10))){
var inst_62712 = (state_62832[(13)]);
var inst_62710 = (state_62832[(14)]);
var inst_62720 = cljs.core._nth.call(null,inst_62710,inst_62712);
var inst_62721 = cljs.core.nth.call(null,inst_62720,(0),null);
var inst_62722 = cljs.core.nth.call(null,inst_62720,(1),null);
var state_62832__$1 = (function (){var statearr_62904 = state_62832;
(statearr_62904[(26)] = inst_62721);

return statearr_62904;
})();
if(cljs.core.truth_(inst_62722)){
var statearr_62905_62968 = state_62832__$1;
(statearr_62905_62968[(1)] = (13));

} else {
var statearr_62906_62969 = state_62832__$1;
(statearr_62906_62969[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (18))){
var inst_62757 = (state_62832[(2)]);
var state_62832__$1 = state_62832;
var statearr_62907_62970 = state_62832__$1;
(statearr_62907_62970[(2)] = inst_62757);

(statearr_62907_62970[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (42))){
var state_62832__$1 = state_62832;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62832__$1,(45),dchan);
} else {
if((state_val_62833 === (37))){
var inst_62700 = (state_62832[(9)]);
var inst_62800 = (state_62832[(23)]);
var inst_62791 = (state_62832[(25)]);
var inst_62800__$1 = cljs.core.first.call(null,inst_62791);
var inst_62801 = cljs.core.async.put_BANG_.call(null,inst_62800__$1,inst_62700,done);
var state_62832__$1 = (function (){var statearr_62908 = state_62832;
(statearr_62908[(23)] = inst_62800__$1);

return statearr_62908;
})();
if(cljs.core.truth_(inst_62801)){
var statearr_62909_62971 = state_62832__$1;
(statearr_62909_62971[(1)] = (39));

} else {
var statearr_62910_62972 = state_62832__$1;
(statearr_62910_62972[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62833 === (8))){
var inst_62712 = (state_62832[(13)]);
var inst_62711 = (state_62832[(16)]);
var inst_62714 = (inst_62712 < inst_62711);
var inst_62715 = inst_62714;
var state_62832__$1 = state_62832;
if(cljs.core.truth_(inst_62715)){
var statearr_62911_62973 = state_62832__$1;
(statearr_62911_62973[(1)] = (10));

} else {
var statearr_62912_62974 = state_62832__$1;
(statearr_62912_62974[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___62920,cs,m,dchan,dctr,done))
;
return ((function (switch__41805__auto__,c__41822__auto___62920,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__41806__auto__ = null;
var cljs$core$async$mult_$_state_machine__41806__auto____0 = (function (){
var statearr_62916 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62916[(0)] = cljs$core$async$mult_$_state_machine__41806__auto__);

(statearr_62916[(1)] = (1));

return statearr_62916;
});
var cljs$core$async$mult_$_state_machine__41806__auto____1 = (function (state_62832){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_62832);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e62917){if((e62917 instanceof Object)){
var ex__41809__auto__ = e62917;
var statearr_62918_62975 = state_62832;
(statearr_62918_62975[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_62832);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e62917;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62976 = state_62832;
state_62832 = G__62976;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__41806__auto__ = function(state_62832){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__41806__auto____1.call(this,state_62832);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__41806__auto____0;
cljs$core$async$mult_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__41806__auto____1;
return cljs$core$async$mult_$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___62920,cs,m,dchan,dctr,done))
})();
var state__41824__auto__ = (function (){var statearr_62919 = f__41823__auto__.call(null);
(statearr_62919[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___62920);

return statearr_62919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___62920,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args62977 = [];
var len__28496__auto___62980 = arguments.length;
var i__28497__auto___62981 = (0);
while(true){
if((i__28497__auto___62981 < len__28496__auto___62980)){
args62977.push((arguments[i__28497__auto___62981]));

var G__62982 = (i__28497__auto___62981 + (1));
i__28497__auto___62981 = G__62982;
continue;
} else {
}
break;
}

var G__62979 = args62977.length;
switch (G__62979) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args62977.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m,ch);
} else {
var m__27994__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m,ch);
} else {
var m__27994__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m);
} else {
var m__27994__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m,state_map);
} else {
var m__27994__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m,mode);
} else {
var m__27994__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__28503__auto__ = [];
var len__28496__auto___62994 = arguments.length;
var i__28497__auto___62995 = (0);
while(true){
if((i__28497__auto___62995 < len__28496__auto___62994)){
args__28503__auto__.push((arguments[i__28497__auto___62995]));

var G__62996 = (i__28497__auto___62995 + (1));
i__28497__auto___62995 = G__62996;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((3) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__28504__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__62988){
var map__62989 = p__62988;
var map__62989__$1 = ((((!((map__62989 == null)))?((((map__62989.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__62989.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__62989):map__62989);
var opts = map__62989__$1;
var statearr_62991_62997 = state;
(statearr_62991_62997[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6753__auto__ = cljs.core.async.do_alts.call(null,((function (map__62989,map__62989__$1,opts){
return (function (val){
var statearr_62992_62998 = state;
(statearr_62992_62998[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__62989,map__62989__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6753__auto__)){
var cb = temp__6753__auto__;
var statearr_62993_62999 = state;
(statearr_62993_62999[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq62984){
var G__62985 = cljs.core.first.call(null,seq62984);
var seq62984__$1 = cljs.core.next.call(null,seq62984);
var G__62986 = cljs.core.first.call(null,seq62984__$1);
var seq62984__$2 = cljs.core.next.call(null,seq62984__$1);
var G__62987 = cljs.core.first.call(null,seq62984__$2);
var seq62984__$3 = cljs.core.next.call(null,seq62984__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__62985,G__62986,G__62987,seq62984__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async63167 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async63167 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta63168){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta63168 = meta63168;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async63167.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_63169,meta63168__$1){
var self__ = this;
var _63169__$1 = this;
return (new cljs.core.async.t_cljs$core$async63167(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta63168__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async63167.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_63169){
var self__ = this;
var _63169__$1 = this;
return self__.meta63168;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async63167.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63167.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async63167.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63167.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async63167.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async63167.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async63167.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async63167.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async63167.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta63168","meta63168",-1577015559,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async63167.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async63167.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async63167";

cljs.core.async.t_cljs$core$async63167.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async63167");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async63167 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async63167(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta63168){
return (new cljs.core.async.t_cljs$core$async63167(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta63168));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async63167(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__41822__auto___63334 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___63334,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___63334,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_63271){
var state_val_63272 = (state_63271[(1)]);
if((state_val_63272 === (7))){
var inst_63186 = (state_63271[(2)]);
var state_63271__$1 = state_63271;
var statearr_63273_63335 = state_63271__$1;
(statearr_63273_63335[(2)] = inst_63186);

(statearr_63273_63335[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (20))){
var inst_63198 = (state_63271[(7)]);
var state_63271__$1 = state_63271;
var statearr_63274_63336 = state_63271__$1;
(statearr_63274_63336[(2)] = inst_63198);

(statearr_63274_63336[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (27))){
var state_63271__$1 = state_63271;
var statearr_63275_63337 = state_63271__$1;
(statearr_63275_63337[(2)] = null);

(statearr_63275_63337[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (1))){
var inst_63173 = (state_63271[(8)]);
var inst_63173__$1 = calc_state.call(null);
var inst_63175 = (inst_63173__$1 == null);
var inst_63176 = cljs.core.not.call(null,inst_63175);
var state_63271__$1 = (function (){var statearr_63276 = state_63271;
(statearr_63276[(8)] = inst_63173__$1);

return statearr_63276;
})();
if(inst_63176){
var statearr_63277_63338 = state_63271__$1;
(statearr_63277_63338[(1)] = (2));

} else {
var statearr_63278_63339 = state_63271__$1;
(statearr_63278_63339[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (24))){
var inst_63245 = (state_63271[(9)]);
var inst_63222 = (state_63271[(10)]);
var inst_63231 = (state_63271[(11)]);
var inst_63245__$1 = inst_63222.call(null,inst_63231);
var state_63271__$1 = (function (){var statearr_63279 = state_63271;
(statearr_63279[(9)] = inst_63245__$1);

return statearr_63279;
})();
if(cljs.core.truth_(inst_63245__$1)){
var statearr_63280_63340 = state_63271__$1;
(statearr_63280_63340[(1)] = (29));

} else {
var statearr_63281_63341 = state_63271__$1;
(statearr_63281_63341[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (4))){
var inst_63189 = (state_63271[(2)]);
var state_63271__$1 = state_63271;
if(cljs.core.truth_(inst_63189)){
var statearr_63282_63342 = state_63271__$1;
(statearr_63282_63342[(1)] = (8));

} else {
var statearr_63283_63343 = state_63271__$1;
(statearr_63283_63343[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (15))){
var inst_63216 = (state_63271[(2)]);
var state_63271__$1 = state_63271;
if(cljs.core.truth_(inst_63216)){
var statearr_63284_63344 = state_63271__$1;
(statearr_63284_63344[(1)] = (19));

} else {
var statearr_63285_63345 = state_63271__$1;
(statearr_63285_63345[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (21))){
var inst_63221 = (state_63271[(12)]);
var inst_63221__$1 = (state_63271[(2)]);
var inst_63222 = cljs.core.get.call(null,inst_63221__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_63223 = cljs.core.get.call(null,inst_63221__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_63224 = cljs.core.get.call(null,inst_63221__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_63271__$1 = (function (){var statearr_63286 = state_63271;
(statearr_63286[(13)] = inst_63223);

(statearr_63286[(10)] = inst_63222);

(statearr_63286[(12)] = inst_63221__$1);

return statearr_63286;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_63271__$1,(22),inst_63224);
} else {
if((state_val_63272 === (31))){
var inst_63253 = (state_63271[(2)]);
var state_63271__$1 = state_63271;
if(cljs.core.truth_(inst_63253)){
var statearr_63287_63346 = state_63271__$1;
(statearr_63287_63346[(1)] = (32));

} else {
var statearr_63288_63347 = state_63271__$1;
(statearr_63288_63347[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (32))){
var inst_63230 = (state_63271[(14)]);
var state_63271__$1 = state_63271;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_63271__$1,(35),out,inst_63230);
} else {
if((state_val_63272 === (33))){
var inst_63221 = (state_63271[(12)]);
var inst_63198 = inst_63221;
var state_63271__$1 = (function (){var statearr_63289 = state_63271;
(statearr_63289[(7)] = inst_63198);

return statearr_63289;
})();
var statearr_63290_63348 = state_63271__$1;
(statearr_63290_63348[(2)] = null);

(statearr_63290_63348[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (13))){
var inst_63198 = (state_63271[(7)]);
var inst_63205 = inst_63198.cljs$lang$protocol_mask$partition0$;
var inst_63206 = (inst_63205 & (64));
var inst_63207 = inst_63198.cljs$core$ISeq$;
var inst_63208 = (cljs.core.PROTOCOL_SENTINEL === inst_63207);
var inst_63209 = (inst_63206) || (inst_63208);
var state_63271__$1 = state_63271;
if(cljs.core.truth_(inst_63209)){
var statearr_63291_63349 = state_63271__$1;
(statearr_63291_63349[(1)] = (16));

} else {
var statearr_63292_63350 = state_63271__$1;
(statearr_63292_63350[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (22))){
var inst_63231 = (state_63271[(11)]);
var inst_63230 = (state_63271[(14)]);
var inst_63229 = (state_63271[(2)]);
var inst_63230__$1 = cljs.core.nth.call(null,inst_63229,(0),null);
var inst_63231__$1 = cljs.core.nth.call(null,inst_63229,(1),null);
var inst_63232 = (inst_63230__$1 == null);
var inst_63233 = cljs.core._EQ_.call(null,inst_63231__$1,change);
var inst_63234 = (inst_63232) || (inst_63233);
var state_63271__$1 = (function (){var statearr_63293 = state_63271;
(statearr_63293[(11)] = inst_63231__$1);

(statearr_63293[(14)] = inst_63230__$1);

return statearr_63293;
})();
if(cljs.core.truth_(inst_63234)){
var statearr_63294_63351 = state_63271__$1;
(statearr_63294_63351[(1)] = (23));

} else {
var statearr_63295_63352 = state_63271__$1;
(statearr_63295_63352[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (36))){
var inst_63221 = (state_63271[(12)]);
var inst_63198 = inst_63221;
var state_63271__$1 = (function (){var statearr_63296 = state_63271;
(statearr_63296[(7)] = inst_63198);

return statearr_63296;
})();
var statearr_63297_63353 = state_63271__$1;
(statearr_63297_63353[(2)] = null);

(statearr_63297_63353[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (29))){
var inst_63245 = (state_63271[(9)]);
var state_63271__$1 = state_63271;
var statearr_63298_63354 = state_63271__$1;
(statearr_63298_63354[(2)] = inst_63245);

(statearr_63298_63354[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (6))){
var state_63271__$1 = state_63271;
var statearr_63299_63355 = state_63271__$1;
(statearr_63299_63355[(2)] = false);

(statearr_63299_63355[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (28))){
var inst_63241 = (state_63271[(2)]);
var inst_63242 = calc_state.call(null);
var inst_63198 = inst_63242;
var state_63271__$1 = (function (){var statearr_63300 = state_63271;
(statearr_63300[(7)] = inst_63198);

(statearr_63300[(15)] = inst_63241);

return statearr_63300;
})();
var statearr_63301_63356 = state_63271__$1;
(statearr_63301_63356[(2)] = null);

(statearr_63301_63356[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (25))){
var inst_63267 = (state_63271[(2)]);
var state_63271__$1 = state_63271;
var statearr_63302_63357 = state_63271__$1;
(statearr_63302_63357[(2)] = inst_63267);

(statearr_63302_63357[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (34))){
var inst_63265 = (state_63271[(2)]);
var state_63271__$1 = state_63271;
var statearr_63303_63358 = state_63271__$1;
(statearr_63303_63358[(2)] = inst_63265);

(statearr_63303_63358[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (17))){
var state_63271__$1 = state_63271;
var statearr_63304_63359 = state_63271__$1;
(statearr_63304_63359[(2)] = false);

(statearr_63304_63359[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (3))){
var state_63271__$1 = state_63271;
var statearr_63305_63360 = state_63271__$1;
(statearr_63305_63360[(2)] = false);

(statearr_63305_63360[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (12))){
var inst_63269 = (state_63271[(2)]);
var state_63271__$1 = state_63271;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63271__$1,inst_63269);
} else {
if((state_val_63272 === (2))){
var inst_63173 = (state_63271[(8)]);
var inst_63178 = inst_63173.cljs$lang$protocol_mask$partition0$;
var inst_63179 = (inst_63178 & (64));
var inst_63180 = inst_63173.cljs$core$ISeq$;
var inst_63181 = (cljs.core.PROTOCOL_SENTINEL === inst_63180);
var inst_63182 = (inst_63179) || (inst_63181);
var state_63271__$1 = state_63271;
if(cljs.core.truth_(inst_63182)){
var statearr_63306_63361 = state_63271__$1;
(statearr_63306_63361[(1)] = (5));

} else {
var statearr_63307_63362 = state_63271__$1;
(statearr_63307_63362[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (23))){
var inst_63230 = (state_63271[(14)]);
var inst_63236 = (inst_63230 == null);
var state_63271__$1 = state_63271;
if(cljs.core.truth_(inst_63236)){
var statearr_63308_63363 = state_63271__$1;
(statearr_63308_63363[(1)] = (26));

} else {
var statearr_63309_63364 = state_63271__$1;
(statearr_63309_63364[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (35))){
var inst_63256 = (state_63271[(2)]);
var state_63271__$1 = state_63271;
if(cljs.core.truth_(inst_63256)){
var statearr_63310_63365 = state_63271__$1;
(statearr_63310_63365[(1)] = (36));

} else {
var statearr_63311_63366 = state_63271__$1;
(statearr_63311_63366[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (19))){
var inst_63198 = (state_63271[(7)]);
var inst_63218 = cljs.core.apply.call(null,cljs.core.hash_map,inst_63198);
var state_63271__$1 = state_63271;
var statearr_63312_63367 = state_63271__$1;
(statearr_63312_63367[(2)] = inst_63218);

(statearr_63312_63367[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (11))){
var inst_63198 = (state_63271[(7)]);
var inst_63202 = (inst_63198 == null);
var inst_63203 = cljs.core.not.call(null,inst_63202);
var state_63271__$1 = state_63271;
if(inst_63203){
var statearr_63313_63368 = state_63271__$1;
(statearr_63313_63368[(1)] = (13));

} else {
var statearr_63314_63369 = state_63271__$1;
(statearr_63314_63369[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (9))){
var inst_63173 = (state_63271[(8)]);
var state_63271__$1 = state_63271;
var statearr_63315_63370 = state_63271__$1;
(statearr_63315_63370[(2)] = inst_63173);

(statearr_63315_63370[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (5))){
var state_63271__$1 = state_63271;
var statearr_63316_63371 = state_63271__$1;
(statearr_63316_63371[(2)] = true);

(statearr_63316_63371[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (14))){
var state_63271__$1 = state_63271;
var statearr_63317_63372 = state_63271__$1;
(statearr_63317_63372[(2)] = false);

(statearr_63317_63372[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (26))){
var inst_63231 = (state_63271[(11)]);
var inst_63238 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_63231);
var state_63271__$1 = state_63271;
var statearr_63318_63373 = state_63271__$1;
(statearr_63318_63373[(2)] = inst_63238);

(statearr_63318_63373[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (16))){
var state_63271__$1 = state_63271;
var statearr_63319_63374 = state_63271__$1;
(statearr_63319_63374[(2)] = true);

(statearr_63319_63374[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (38))){
var inst_63261 = (state_63271[(2)]);
var state_63271__$1 = state_63271;
var statearr_63320_63375 = state_63271__$1;
(statearr_63320_63375[(2)] = inst_63261);

(statearr_63320_63375[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (30))){
var inst_63223 = (state_63271[(13)]);
var inst_63222 = (state_63271[(10)]);
var inst_63231 = (state_63271[(11)]);
var inst_63248 = cljs.core.empty_QMARK_.call(null,inst_63222);
var inst_63249 = inst_63223.call(null,inst_63231);
var inst_63250 = cljs.core.not.call(null,inst_63249);
var inst_63251 = (inst_63248) && (inst_63250);
var state_63271__$1 = state_63271;
var statearr_63321_63376 = state_63271__$1;
(statearr_63321_63376[(2)] = inst_63251);

(statearr_63321_63376[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (10))){
var inst_63173 = (state_63271[(8)]);
var inst_63194 = (state_63271[(2)]);
var inst_63195 = cljs.core.get.call(null,inst_63194,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_63196 = cljs.core.get.call(null,inst_63194,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_63197 = cljs.core.get.call(null,inst_63194,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_63198 = inst_63173;
var state_63271__$1 = (function (){var statearr_63322 = state_63271;
(statearr_63322[(16)] = inst_63197);

(statearr_63322[(17)] = inst_63195);

(statearr_63322[(7)] = inst_63198);

(statearr_63322[(18)] = inst_63196);

return statearr_63322;
})();
var statearr_63323_63377 = state_63271__$1;
(statearr_63323_63377[(2)] = null);

(statearr_63323_63377[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (18))){
var inst_63213 = (state_63271[(2)]);
var state_63271__$1 = state_63271;
var statearr_63324_63378 = state_63271__$1;
(statearr_63324_63378[(2)] = inst_63213);

(statearr_63324_63378[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (37))){
var state_63271__$1 = state_63271;
var statearr_63325_63379 = state_63271__$1;
(statearr_63325_63379[(2)] = null);

(statearr_63325_63379[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63272 === (8))){
var inst_63173 = (state_63271[(8)]);
var inst_63191 = cljs.core.apply.call(null,cljs.core.hash_map,inst_63173);
var state_63271__$1 = state_63271;
var statearr_63326_63380 = state_63271__$1;
(statearr_63326_63380[(2)] = inst_63191);

(statearr_63326_63380[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___63334,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__41805__auto__,c__41822__auto___63334,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__41806__auto__ = null;
var cljs$core$async$mix_$_state_machine__41806__auto____0 = (function (){
var statearr_63330 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63330[(0)] = cljs$core$async$mix_$_state_machine__41806__auto__);

(statearr_63330[(1)] = (1));

return statearr_63330;
});
var cljs$core$async$mix_$_state_machine__41806__auto____1 = (function (state_63271){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_63271);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e63331){if((e63331 instanceof Object)){
var ex__41809__auto__ = e63331;
var statearr_63332_63381 = state_63271;
(statearr_63332_63381[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63271);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63331;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63382 = state_63271;
state_63271 = G__63382;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__41806__auto__ = function(state_63271){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__41806__auto____1.call(this,state_63271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__41806__auto____0;
cljs$core$async$mix_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__41806__auto____1;
return cljs$core$async$mix_$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___63334,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__41824__auto__ = (function (){var statearr_63333 = f__41823__auto__.call(null);
(statearr_63333[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___63334);

return statearr_63333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___63334,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__27993__auto__ = (((p == null))?null:p);
var m__27994__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__27994__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__27993__auto__ = (((p == null))?null:p);
var m__27994__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,p,v,ch);
} else {
var m__27994__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args63383 = [];
var len__28496__auto___63386 = arguments.length;
var i__28497__auto___63387 = (0);
while(true){
if((i__28497__auto___63387 < len__28496__auto___63386)){
args63383.push((arguments[i__28497__auto___63387]));

var G__63388 = (i__28497__auto___63387 + (1));
i__28497__auto___63387 = G__63388;
continue;
} else {
}
break;
}

var G__63385 = args63383.length;
switch (G__63385) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args63383.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__27993__auto__ = (((p == null))?null:p);
var m__27994__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,p);
} else {
var m__27994__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__27993__auto__ = (((p == null))?null:p);
var m__27994__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,p,v);
} else {
var m__27994__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args63391 = [];
var len__28496__auto___63516 = arguments.length;
var i__28497__auto___63517 = (0);
while(true){
if((i__28497__auto___63517 < len__28496__auto___63516)){
args63391.push((arguments[i__28497__auto___63517]));

var G__63518 = (i__28497__auto___63517 + (1));
i__28497__auto___63517 = G__63518;
continue;
} else {
}
break;
}

var G__63393 = args63391.length;
switch (G__63393) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args63391.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__27280__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__27280__auto__,mults){
return (function (p1__63390_SHARP_){
if(cljs.core.truth_(p1__63390_SHARP_.call(null,topic))){
return p1__63390_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__63390_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__27280__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async63394 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async63394 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta63395){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta63395 = meta63395;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async63394.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_63396,meta63395__$1){
var self__ = this;
var _63396__$1 = this;
return (new cljs.core.async.t_cljs$core$async63394(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta63395__$1));
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async63394.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_63396){
var self__ = this;
var _63396__$1 = this;
return self__.meta63395;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async63394.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63394.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async63394.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63394.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async63394.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6753__auto__)){
var m = temp__6753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async63394.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async63394.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async63394.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta63395","meta63395",-316543406,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async63394.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async63394.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async63394";

cljs.core.async.t_cljs$core$async63394.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async63394");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async63394 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async63394(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta63395){
return (new cljs.core.async.t_cljs$core$async63394(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta63395));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async63394(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__41822__auto___63520 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___63520,mults,ensure_mult,p){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___63520,mults,ensure_mult,p){
return (function (state_63468){
var state_val_63469 = (state_63468[(1)]);
if((state_val_63469 === (7))){
var inst_63464 = (state_63468[(2)]);
var state_63468__$1 = state_63468;
var statearr_63470_63521 = state_63468__$1;
(statearr_63470_63521[(2)] = inst_63464);

(statearr_63470_63521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (20))){
var state_63468__$1 = state_63468;
var statearr_63471_63522 = state_63468__$1;
(statearr_63471_63522[(2)] = null);

(statearr_63471_63522[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (1))){
var state_63468__$1 = state_63468;
var statearr_63472_63523 = state_63468__$1;
(statearr_63472_63523[(2)] = null);

(statearr_63472_63523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (24))){
var inst_63447 = (state_63468[(7)]);
var inst_63456 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_63447);
var state_63468__$1 = state_63468;
var statearr_63473_63524 = state_63468__$1;
(statearr_63473_63524[(2)] = inst_63456);

(statearr_63473_63524[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (4))){
var inst_63399 = (state_63468[(8)]);
var inst_63399__$1 = (state_63468[(2)]);
var inst_63400 = (inst_63399__$1 == null);
var state_63468__$1 = (function (){var statearr_63474 = state_63468;
(statearr_63474[(8)] = inst_63399__$1);

return statearr_63474;
})();
if(cljs.core.truth_(inst_63400)){
var statearr_63475_63525 = state_63468__$1;
(statearr_63475_63525[(1)] = (5));

} else {
var statearr_63476_63526 = state_63468__$1;
(statearr_63476_63526[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (15))){
var inst_63441 = (state_63468[(2)]);
var state_63468__$1 = state_63468;
var statearr_63477_63527 = state_63468__$1;
(statearr_63477_63527[(2)] = inst_63441);

(statearr_63477_63527[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (21))){
var inst_63461 = (state_63468[(2)]);
var state_63468__$1 = (function (){var statearr_63478 = state_63468;
(statearr_63478[(9)] = inst_63461);

return statearr_63478;
})();
var statearr_63479_63528 = state_63468__$1;
(statearr_63479_63528[(2)] = null);

(statearr_63479_63528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (13))){
var inst_63423 = (state_63468[(10)]);
var inst_63425 = cljs.core.chunked_seq_QMARK_.call(null,inst_63423);
var state_63468__$1 = state_63468;
if(inst_63425){
var statearr_63480_63529 = state_63468__$1;
(statearr_63480_63529[(1)] = (16));

} else {
var statearr_63481_63530 = state_63468__$1;
(statearr_63481_63530[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (22))){
var inst_63453 = (state_63468[(2)]);
var state_63468__$1 = state_63468;
if(cljs.core.truth_(inst_63453)){
var statearr_63482_63531 = state_63468__$1;
(statearr_63482_63531[(1)] = (23));

} else {
var statearr_63483_63532 = state_63468__$1;
(statearr_63483_63532[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (6))){
var inst_63399 = (state_63468[(8)]);
var inst_63449 = (state_63468[(11)]);
var inst_63447 = (state_63468[(7)]);
var inst_63447__$1 = topic_fn.call(null,inst_63399);
var inst_63448 = cljs.core.deref.call(null,mults);
var inst_63449__$1 = cljs.core.get.call(null,inst_63448,inst_63447__$1);
var state_63468__$1 = (function (){var statearr_63484 = state_63468;
(statearr_63484[(11)] = inst_63449__$1);

(statearr_63484[(7)] = inst_63447__$1);

return statearr_63484;
})();
if(cljs.core.truth_(inst_63449__$1)){
var statearr_63485_63533 = state_63468__$1;
(statearr_63485_63533[(1)] = (19));

} else {
var statearr_63486_63534 = state_63468__$1;
(statearr_63486_63534[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (25))){
var inst_63458 = (state_63468[(2)]);
var state_63468__$1 = state_63468;
var statearr_63487_63535 = state_63468__$1;
(statearr_63487_63535[(2)] = inst_63458);

(statearr_63487_63535[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (17))){
var inst_63423 = (state_63468[(10)]);
var inst_63432 = cljs.core.first.call(null,inst_63423);
var inst_63433 = cljs.core.async.muxch_STAR_.call(null,inst_63432);
var inst_63434 = cljs.core.async.close_BANG_.call(null,inst_63433);
var inst_63435 = cljs.core.next.call(null,inst_63423);
var inst_63409 = inst_63435;
var inst_63410 = null;
var inst_63411 = (0);
var inst_63412 = (0);
var state_63468__$1 = (function (){var statearr_63488 = state_63468;
(statearr_63488[(12)] = inst_63411);

(statearr_63488[(13)] = inst_63410);

(statearr_63488[(14)] = inst_63412);

(statearr_63488[(15)] = inst_63409);

(statearr_63488[(16)] = inst_63434);

return statearr_63488;
})();
var statearr_63489_63536 = state_63468__$1;
(statearr_63489_63536[(2)] = null);

(statearr_63489_63536[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (3))){
var inst_63466 = (state_63468[(2)]);
var state_63468__$1 = state_63468;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63468__$1,inst_63466);
} else {
if((state_val_63469 === (12))){
var inst_63443 = (state_63468[(2)]);
var state_63468__$1 = state_63468;
var statearr_63490_63537 = state_63468__$1;
(statearr_63490_63537[(2)] = inst_63443);

(statearr_63490_63537[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (2))){
var state_63468__$1 = state_63468;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63468__$1,(4),ch);
} else {
if((state_val_63469 === (23))){
var state_63468__$1 = state_63468;
var statearr_63491_63538 = state_63468__$1;
(statearr_63491_63538[(2)] = null);

(statearr_63491_63538[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (19))){
var inst_63399 = (state_63468[(8)]);
var inst_63449 = (state_63468[(11)]);
var inst_63451 = cljs.core.async.muxch_STAR_.call(null,inst_63449);
var state_63468__$1 = state_63468;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_63468__$1,(22),inst_63451,inst_63399);
} else {
if((state_val_63469 === (11))){
var inst_63409 = (state_63468[(15)]);
var inst_63423 = (state_63468[(10)]);
var inst_63423__$1 = cljs.core.seq.call(null,inst_63409);
var state_63468__$1 = (function (){var statearr_63492 = state_63468;
(statearr_63492[(10)] = inst_63423__$1);

return statearr_63492;
})();
if(inst_63423__$1){
var statearr_63493_63539 = state_63468__$1;
(statearr_63493_63539[(1)] = (13));

} else {
var statearr_63494_63540 = state_63468__$1;
(statearr_63494_63540[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (9))){
var inst_63445 = (state_63468[(2)]);
var state_63468__$1 = state_63468;
var statearr_63495_63541 = state_63468__$1;
(statearr_63495_63541[(2)] = inst_63445);

(statearr_63495_63541[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (5))){
var inst_63406 = cljs.core.deref.call(null,mults);
var inst_63407 = cljs.core.vals.call(null,inst_63406);
var inst_63408 = cljs.core.seq.call(null,inst_63407);
var inst_63409 = inst_63408;
var inst_63410 = null;
var inst_63411 = (0);
var inst_63412 = (0);
var state_63468__$1 = (function (){var statearr_63496 = state_63468;
(statearr_63496[(12)] = inst_63411);

(statearr_63496[(13)] = inst_63410);

(statearr_63496[(14)] = inst_63412);

(statearr_63496[(15)] = inst_63409);

return statearr_63496;
})();
var statearr_63497_63542 = state_63468__$1;
(statearr_63497_63542[(2)] = null);

(statearr_63497_63542[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (14))){
var state_63468__$1 = state_63468;
var statearr_63501_63543 = state_63468__$1;
(statearr_63501_63543[(2)] = null);

(statearr_63501_63543[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (16))){
var inst_63423 = (state_63468[(10)]);
var inst_63427 = cljs.core.chunk_first.call(null,inst_63423);
var inst_63428 = cljs.core.chunk_rest.call(null,inst_63423);
var inst_63429 = cljs.core.count.call(null,inst_63427);
var inst_63409 = inst_63428;
var inst_63410 = inst_63427;
var inst_63411 = inst_63429;
var inst_63412 = (0);
var state_63468__$1 = (function (){var statearr_63502 = state_63468;
(statearr_63502[(12)] = inst_63411);

(statearr_63502[(13)] = inst_63410);

(statearr_63502[(14)] = inst_63412);

(statearr_63502[(15)] = inst_63409);

return statearr_63502;
})();
var statearr_63503_63544 = state_63468__$1;
(statearr_63503_63544[(2)] = null);

(statearr_63503_63544[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (10))){
var inst_63411 = (state_63468[(12)]);
var inst_63410 = (state_63468[(13)]);
var inst_63412 = (state_63468[(14)]);
var inst_63409 = (state_63468[(15)]);
var inst_63417 = cljs.core._nth.call(null,inst_63410,inst_63412);
var inst_63418 = cljs.core.async.muxch_STAR_.call(null,inst_63417);
var inst_63419 = cljs.core.async.close_BANG_.call(null,inst_63418);
var inst_63420 = (inst_63412 + (1));
var tmp63498 = inst_63411;
var tmp63499 = inst_63410;
var tmp63500 = inst_63409;
var inst_63409__$1 = tmp63500;
var inst_63410__$1 = tmp63499;
var inst_63411__$1 = tmp63498;
var inst_63412__$1 = inst_63420;
var state_63468__$1 = (function (){var statearr_63504 = state_63468;
(statearr_63504[(12)] = inst_63411__$1);

(statearr_63504[(13)] = inst_63410__$1);

(statearr_63504[(14)] = inst_63412__$1);

(statearr_63504[(15)] = inst_63409__$1);

(statearr_63504[(17)] = inst_63419);

return statearr_63504;
})();
var statearr_63505_63545 = state_63468__$1;
(statearr_63505_63545[(2)] = null);

(statearr_63505_63545[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (18))){
var inst_63438 = (state_63468[(2)]);
var state_63468__$1 = state_63468;
var statearr_63506_63546 = state_63468__$1;
(statearr_63506_63546[(2)] = inst_63438);

(statearr_63506_63546[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63469 === (8))){
var inst_63411 = (state_63468[(12)]);
var inst_63412 = (state_63468[(14)]);
var inst_63414 = (inst_63412 < inst_63411);
var inst_63415 = inst_63414;
var state_63468__$1 = state_63468;
if(cljs.core.truth_(inst_63415)){
var statearr_63507_63547 = state_63468__$1;
(statearr_63507_63547[(1)] = (10));

} else {
var statearr_63508_63548 = state_63468__$1;
(statearr_63508_63548[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___63520,mults,ensure_mult,p))
;
return ((function (switch__41805__auto__,c__41822__auto___63520,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_63512 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63512[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_63512[(1)] = (1));

return statearr_63512;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_63468){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_63468);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e63513){if((e63513 instanceof Object)){
var ex__41809__auto__ = e63513;
var statearr_63514_63549 = state_63468;
(statearr_63514_63549[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63468);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63513;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63550 = state_63468;
state_63468 = G__63550;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_63468){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_63468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___63520,mults,ensure_mult,p))
})();
var state__41824__auto__ = (function (){var statearr_63515 = f__41823__auto__.call(null);
(statearr_63515[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___63520);

return statearr_63515;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___63520,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args63551 = [];
var len__28496__auto___63554 = arguments.length;
var i__28497__auto___63555 = (0);
while(true){
if((i__28497__auto___63555 < len__28496__auto___63554)){
args63551.push((arguments[i__28497__auto___63555]));

var G__63556 = (i__28497__auto___63555 + (1));
i__28497__auto___63555 = G__63556;
continue;
} else {
}
break;
}

var G__63553 = args63551.length;
switch (G__63553) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args63551.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args63558 = [];
var len__28496__auto___63561 = arguments.length;
var i__28497__auto___63562 = (0);
while(true){
if((i__28497__auto___63562 < len__28496__auto___63561)){
args63558.push((arguments[i__28497__auto___63562]));

var G__63563 = (i__28497__auto___63562 + (1));
i__28497__auto___63562 = G__63563;
continue;
} else {
}
break;
}

var G__63560 = args63558.length;
switch (G__63560) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args63558.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args63565 = [];
var len__28496__auto___63636 = arguments.length;
var i__28497__auto___63637 = (0);
while(true){
if((i__28497__auto___63637 < len__28496__auto___63636)){
args63565.push((arguments[i__28497__auto___63637]));

var G__63638 = (i__28497__auto___63637 + (1));
i__28497__auto___63637 = G__63638;
continue;
} else {
}
break;
}

var G__63567 = args63565.length;
switch (G__63567) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args63565.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__41822__auto___63640 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___63640,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___63640,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_63606){
var state_val_63607 = (state_63606[(1)]);
if((state_val_63607 === (7))){
var state_63606__$1 = state_63606;
var statearr_63608_63641 = state_63606__$1;
(statearr_63608_63641[(2)] = null);

(statearr_63608_63641[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63607 === (1))){
var state_63606__$1 = state_63606;
var statearr_63609_63642 = state_63606__$1;
(statearr_63609_63642[(2)] = null);

(statearr_63609_63642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63607 === (4))){
var inst_63570 = (state_63606[(7)]);
var inst_63572 = (inst_63570 < cnt);
var state_63606__$1 = state_63606;
if(cljs.core.truth_(inst_63572)){
var statearr_63610_63643 = state_63606__$1;
(statearr_63610_63643[(1)] = (6));

} else {
var statearr_63611_63644 = state_63606__$1;
(statearr_63611_63644[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63607 === (15))){
var inst_63602 = (state_63606[(2)]);
var state_63606__$1 = state_63606;
var statearr_63612_63645 = state_63606__$1;
(statearr_63612_63645[(2)] = inst_63602);

(statearr_63612_63645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63607 === (13))){
var inst_63595 = cljs.core.async.close_BANG_.call(null,out);
var state_63606__$1 = state_63606;
var statearr_63613_63646 = state_63606__$1;
(statearr_63613_63646[(2)] = inst_63595);

(statearr_63613_63646[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63607 === (6))){
var state_63606__$1 = state_63606;
var statearr_63614_63647 = state_63606__$1;
(statearr_63614_63647[(2)] = null);

(statearr_63614_63647[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63607 === (3))){
var inst_63604 = (state_63606[(2)]);
var state_63606__$1 = state_63606;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63606__$1,inst_63604);
} else {
if((state_val_63607 === (12))){
var inst_63592 = (state_63606[(8)]);
var inst_63592__$1 = (state_63606[(2)]);
var inst_63593 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_63592__$1);
var state_63606__$1 = (function (){var statearr_63615 = state_63606;
(statearr_63615[(8)] = inst_63592__$1);

return statearr_63615;
})();
if(cljs.core.truth_(inst_63593)){
var statearr_63616_63648 = state_63606__$1;
(statearr_63616_63648[(1)] = (13));

} else {
var statearr_63617_63649 = state_63606__$1;
(statearr_63617_63649[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63607 === (2))){
var inst_63569 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_63570 = (0);
var state_63606__$1 = (function (){var statearr_63618 = state_63606;
(statearr_63618[(9)] = inst_63569);

(statearr_63618[(7)] = inst_63570);

return statearr_63618;
})();
var statearr_63619_63650 = state_63606__$1;
(statearr_63619_63650[(2)] = null);

(statearr_63619_63650[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63607 === (11))){
var inst_63570 = (state_63606[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_63606,(10),Object,null,(9));
var inst_63579 = chs__$1.call(null,inst_63570);
var inst_63580 = done.call(null,inst_63570);
var inst_63581 = cljs.core.async.take_BANG_.call(null,inst_63579,inst_63580);
var state_63606__$1 = state_63606;
var statearr_63620_63651 = state_63606__$1;
(statearr_63620_63651[(2)] = inst_63581);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63606__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63607 === (9))){
var inst_63570 = (state_63606[(7)]);
var inst_63583 = (state_63606[(2)]);
var inst_63584 = (inst_63570 + (1));
var inst_63570__$1 = inst_63584;
var state_63606__$1 = (function (){var statearr_63621 = state_63606;
(statearr_63621[(10)] = inst_63583);

(statearr_63621[(7)] = inst_63570__$1);

return statearr_63621;
})();
var statearr_63622_63652 = state_63606__$1;
(statearr_63622_63652[(2)] = null);

(statearr_63622_63652[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63607 === (5))){
var inst_63590 = (state_63606[(2)]);
var state_63606__$1 = (function (){var statearr_63623 = state_63606;
(statearr_63623[(11)] = inst_63590);

return statearr_63623;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63606__$1,(12),dchan);
} else {
if((state_val_63607 === (14))){
var inst_63592 = (state_63606[(8)]);
var inst_63597 = cljs.core.apply.call(null,f,inst_63592);
var state_63606__$1 = state_63606;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_63606__$1,(16),out,inst_63597);
} else {
if((state_val_63607 === (16))){
var inst_63599 = (state_63606[(2)]);
var state_63606__$1 = (function (){var statearr_63624 = state_63606;
(statearr_63624[(12)] = inst_63599);

return statearr_63624;
})();
var statearr_63625_63653 = state_63606__$1;
(statearr_63625_63653[(2)] = null);

(statearr_63625_63653[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63607 === (10))){
var inst_63574 = (state_63606[(2)]);
var inst_63575 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_63606__$1 = (function (){var statearr_63626 = state_63606;
(statearr_63626[(13)] = inst_63574);

return statearr_63626;
})();
var statearr_63627_63654 = state_63606__$1;
(statearr_63627_63654[(2)] = inst_63575);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63606__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63607 === (8))){
var inst_63588 = (state_63606[(2)]);
var state_63606__$1 = state_63606;
var statearr_63628_63655 = state_63606__$1;
(statearr_63628_63655[(2)] = inst_63588);

(statearr_63628_63655[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___63640,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__41805__auto__,c__41822__auto___63640,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_63632 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63632[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_63632[(1)] = (1));

return statearr_63632;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_63606){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_63606);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e63633){if((e63633 instanceof Object)){
var ex__41809__auto__ = e63633;
var statearr_63634_63656 = state_63606;
(statearr_63634_63656[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63606);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63633;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63657 = state_63606;
state_63606 = G__63657;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_63606){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_63606);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___63640,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__41824__auto__ = (function (){var statearr_63635 = f__41823__auto__.call(null);
(statearr_63635[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___63640);

return statearr_63635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___63640,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args63659 = [];
var len__28496__auto___63717 = arguments.length;
var i__28497__auto___63718 = (0);
while(true){
if((i__28497__auto___63718 < len__28496__auto___63717)){
args63659.push((arguments[i__28497__auto___63718]));

var G__63719 = (i__28497__auto___63718 + (1));
i__28497__auto___63718 = G__63719;
continue;
} else {
}
break;
}

var G__63661 = args63659.length;
switch (G__63661) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args63659.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__41822__auto___63721 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___63721,out){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___63721,out){
return (function (state_63693){
var state_val_63694 = (state_63693[(1)]);
if((state_val_63694 === (7))){
var inst_63672 = (state_63693[(7)]);
var inst_63673 = (state_63693[(8)]);
var inst_63672__$1 = (state_63693[(2)]);
var inst_63673__$1 = cljs.core.nth.call(null,inst_63672__$1,(0),null);
var inst_63674 = cljs.core.nth.call(null,inst_63672__$1,(1),null);
var inst_63675 = (inst_63673__$1 == null);
var state_63693__$1 = (function (){var statearr_63695 = state_63693;
(statearr_63695[(7)] = inst_63672__$1);

(statearr_63695[(9)] = inst_63674);

(statearr_63695[(8)] = inst_63673__$1);

return statearr_63695;
})();
if(cljs.core.truth_(inst_63675)){
var statearr_63696_63722 = state_63693__$1;
(statearr_63696_63722[(1)] = (8));

} else {
var statearr_63697_63723 = state_63693__$1;
(statearr_63697_63723[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63694 === (1))){
var inst_63662 = cljs.core.vec.call(null,chs);
var inst_63663 = inst_63662;
var state_63693__$1 = (function (){var statearr_63698 = state_63693;
(statearr_63698[(10)] = inst_63663);

return statearr_63698;
})();
var statearr_63699_63724 = state_63693__$1;
(statearr_63699_63724[(2)] = null);

(statearr_63699_63724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63694 === (4))){
var inst_63663 = (state_63693[(10)]);
var state_63693__$1 = state_63693;
return cljs.core.async.ioc_alts_BANG_.call(null,state_63693__$1,(7),inst_63663);
} else {
if((state_val_63694 === (6))){
var inst_63689 = (state_63693[(2)]);
var state_63693__$1 = state_63693;
var statearr_63700_63725 = state_63693__$1;
(statearr_63700_63725[(2)] = inst_63689);

(statearr_63700_63725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63694 === (3))){
var inst_63691 = (state_63693[(2)]);
var state_63693__$1 = state_63693;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63693__$1,inst_63691);
} else {
if((state_val_63694 === (2))){
var inst_63663 = (state_63693[(10)]);
var inst_63665 = cljs.core.count.call(null,inst_63663);
var inst_63666 = (inst_63665 > (0));
var state_63693__$1 = state_63693;
if(cljs.core.truth_(inst_63666)){
var statearr_63702_63726 = state_63693__$1;
(statearr_63702_63726[(1)] = (4));

} else {
var statearr_63703_63727 = state_63693__$1;
(statearr_63703_63727[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63694 === (11))){
var inst_63663 = (state_63693[(10)]);
var inst_63682 = (state_63693[(2)]);
var tmp63701 = inst_63663;
var inst_63663__$1 = tmp63701;
var state_63693__$1 = (function (){var statearr_63704 = state_63693;
(statearr_63704[(10)] = inst_63663__$1);

(statearr_63704[(11)] = inst_63682);

return statearr_63704;
})();
var statearr_63705_63728 = state_63693__$1;
(statearr_63705_63728[(2)] = null);

(statearr_63705_63728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63694 === (9))){
var inst_63673 = (state_63693[(8)]);
var state_63693__$1 = state_63693;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_63693__$1,(11),out,inst_63673);
} else {
if((state_val_63694 === (5))){
var inst_63687 = cljs.core.async.close_BANG_.call(null,out);
var state_63693__$1 = state_63693;
var statearr_63706_63729 = state_63693__$1;
(statearr_63706_63729[(2)] = inst_63687);

(statearr_63706_63729[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63694 === (10))){
var inst_63685 = (state_63693[(2)]);
var state_63693__$1 = state_63693;
var statearr_63707_63730 = state_63693__$1;
(statearr_63707_63730[(2)] = inst_63685);

(statearr_63707_63730[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63694 === (8))){
var inst_63672 = (state_63693[(7)]);
var inst_63674 = (state_63693[(9)]);
var inst_63673 = (state_63693[(8)]);
var inst_63663 = (state_63693[(10)]);
var inst_63677 = (function (){var cs = inst_63663;
var vec__63668 = inst_63672;
var v = inst_63673;
var c = inst_63674;
return ((function (cs,vec__63668,v,c,inst_63672,inst_63674,inst_63673,inst_63663,state_val_63694,c__41822__auto___63721,out){
return (function (p1__63658_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__63658_SHARP_);
});
;})(cs,vec__63668,v,c,inst_63672,inst_63674,inst_63673,inst_63663,state_val_63694,c__41822__auto___63721,out))
})();
var inst_63678 = cljs.core.filterv.call(null,inst_63677,inst_63663);
var inst_63663__$1 = inst_63678;
var state_63693__$1 = (function (){var statearr_63708 = state_63693;
(statearr_63708[(10)] = inst_63663__$1);

return statearr_63708;
})();
var statearr_63709_63731 = state_63693__$1;
(statearr_63709_63731[(2)] = null);

(statearr_63709_63731[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___63721,out))
;
return ((function (switch__41805__auto__,c__41822__auto___63721,out){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_63713 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63713[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_63713[(1)] = (1));

return statearr_63713;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_63693){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_63693);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e63714){if((e63714 instanceof Object)){
var ex__41809__auto__ = e63714;
var statearr_63715_63732 = state_63693;
(statearr_63715_63732[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63693);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63714;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63733 = state_63693;
state_63693 = G__63733;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_63693){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_63693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___63721,out))
})();
var state__41824__auto__ = (function (){var statearr_63716 = f__41823__auto__.call(null);
(statearr_63716[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___63721);

return statearr_63716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___63721,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args63734 = [];
var len__28496__auto___63783 = arguments.length;
var i__28497__auto___63784 = (0);
while(true){
if((i__28497__auto___63784 < len__28496__auto___63783)){
args63734.push((arguments[i__28497__auto___63784]));

var G__63785 = (i__28497__auto___63784 + (1));
i__28497__auto___63784 = G__63785;
continue;
} else {
}
break;
}

var G__63736 = args63734.length;
switch (G__63736) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args63734.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__41822__auto___63787 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___63787,out){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___63787,out){
return (function (state_63760){
var state_val_63761 = (state_63760[(1)]);
if((state_val_63761 === (7))){
var inst_63742 = (state_63760[(7)]);
var inst_63742__$1 = (state_63760[(2)]);
var inst_63743 = (inst_63742__$1 == null);
var inst_63744 = cljs.core.not.call(null,inst_63743);
var state_63760__$1 = (function (){var statearr_63762 = state_63760;
(statearr_63762[(7)] = inst_63742__$1);

return statearr_63762;
})();
if(inst_63744){
var statearr_63763_63788 = state_63760__$1;
(statearr_63763_63788[(1)] = (8));

} else {
var statearr_63764_63789 = state_63760__$1;
(statearr_63764_63789[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63761 === (1))){
var inst_63737 = (0);
var state_63760__$1 = (function (){var statearr_63765 = state_63760;
(statearr_63765[(8)] = inst_63737);

return statearr_63765;
})();
var statearr_63766_63790 = state_63760__$1;
(statearr_63766_63790[(2)] = null);

(statearr_63766_63790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63761 === (4))){
var state_63760__$1 = state_63760;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63760__$1,(7),ch);
} else {
if((state_val_63761 === (6))){
var inst_63755 = (state_63760[(2)]);
var state_63760__$1 = state_63760;
var statearr_63767_63791 = state_63760__$1;
(statearr_63767_63791[(2)] = inst_63755);

(statearr_63767_63791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63761 === (3))){
var inst_63757 = (state_63760[(2)]);
var inst_63758 = cljs.core.async.close_BANG_.call(null,out);
var state_63760__$1 = (function (){var statearr_63768 = state_63760;
(statearr_63768[(9)] = inst_63757);

return statearr_63768;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63760__$1,inst_63758);
} else {
if((state_val_63761 === (2))){
var inst_63737 = (state_63760[(8)]);
var inst_63739 = (inst_63737 < n);
var state_63760__$1 = state_63760;
if(cljs.core.truth_(inst_63739)){
var statearr_63769_63792 = state_63760__$1;
(statearr_63769_63792[(1)] = (4));

} else {
var statearr_63770_63793 = state_63760__$1;
(statearr_63770_63793[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63761 === (11))){
var inst_63737 = (state_63760[(8)]);
var inst_63747 = (state_63760[(2)]);
var inst_63748 = (inst_63737 + (1));
var inst_63737__$1 = inst_63748;
var state_63760__$1 = (function (){var statearr_63771 = state_63760;
(statearr_63771[(8)] = inst_63737__$1);

(statearr_63771[(10)] = inst_63747);

return statearr_63771;
})();
var statearr_63772_63794 = state_63760__$1;
(statearr_63772_63794[(2)] = null);

(statearr_63772_63794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63761 === (9))){
var state_63760__$1 = state_63760;
var statearr_63773_63795 = state_63760__$1;
(statearr_63773_63795[(2)] = null);

(statearr_63773_63795[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63761 === (5))){
var state_63760__$1 = state_63760;
var statearr_63774_63796 = state_63760__$1;
(statearr_63774_63796[(2)] = null);

(statearr_63774_63796[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63761 === (10))){
var inst_63752 = (state_63760[(2)]);
var state_63760__$1 = state_63760;
var statearr_63775_63797 = state_63760__$1;
(statearr_63775_63797[(2)] = inst_63752);

(statearr_63775_63797[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63761 === (8))){
var inst_63742 = (state_63760[(7)]);
var state_63760__$1 = state_63760;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_63760__$1,(11),out,inst_63742);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___63787,out))
;
return ((function (switch__41805__auto__,c__41822__auto___63787,out){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_63779 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_63779[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_63779[(1)] = (1));

return statearr_63779;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_63760){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_63760);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e63780){if((e63780 instanceof Object)){
var ex__41809__auto__ = e63780;
var statearr_63781_63798 = state_63760;
(statearr_63781_63798[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63760);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63780;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63799 = state_63760;
state_63760 = G__63799;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_63760){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_63760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___63787,out))
})();
var state__41824__auto__ = (function (){var statearr_63782 = f__41823__auto__.call(null);
(statearr_63782[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___63787);

return statearr_63782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___63787,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async63807 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async63807 = (function (f,ch,meta63808){
this.f = f;
this.ch = ch;
this.meta63808 = meta63808;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async63807.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_63809,meta63808__$1){
var self__ = this;
var _63809__$1 = this;
return (new cljs.core.async.t_cljs$core$async63807(self__.f,self__.ch,meta63808__$1));
});


cljs.core.async.t_cljs$core$async63807.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_63809){
var self__ = this;
var _63809__$1 = this;
return self__.meta63808;
});


cljs.core.async.t_cljs$core$async63807.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63807.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async63807.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async63807.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63807.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async63810 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async63810 = (function (f,ch,meta63808,_,fn1,meta63811){
this.f = f;
this.ch = ch;
this.meta63808 = meta63808;
this._ = _;
this.fn1 = fn1;
this.meta63811 = meta63811;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async63810.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_63812,meta63811__$1){
var self__ = this;
var _63812__$1 = this;
return (new cljs.core.async.t_cljs$core$async63810(self__.f,self__.ch,self__.meta63808,self__._,self__.fn1,meta63811__$1));
});})(___$1))
;


cljs.core.async.t_cljs$core$async63810.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_63812){
var self__ = this;
var _63812__$1 = this;
return self__.meta63811;
});})(___$1))
;


cljs.core.async.t_cljs$core$async63810.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63810.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;


cljs.core.async.t_cljs$core$async63810.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;


cljs.core.async.t_cljs$core$async63810.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__63800_SHARP_){
return f1.call(null,(((p1__63800_SHARP_ == null))?null:self__.f.call(null,p1__63800_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async63810.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta63808","meta63808",816332936,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async63807","cljs.core.async/t_cljs$core$async63807",1523254350,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta63811","meta63811",-1170757135,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async63810.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async63810.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async63810";

cljs.core.async.t_cljs$core$async63810.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async63810");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async63810 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async63810(f__$1,ch__$1,meta63808__$1,___$2,fn1__$1,meta63811){
return (new cljs.core.async.t_cljs$core$async63810(f__$1,ch__$1,meta63808__$1,___$2,fn1__$1,meta63811));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async63810(self__.f,self__.ch,self__.meta63808,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__27268__auto__ = ret;
if(cljs.core.truth_(and__27268__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__27268__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});


cljs.core.async.t_cljs$core$async63807.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63807.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async63807.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta63808","meta63808",816332936,null)], null);
});

cljs.core.async.t_cljs$core$async63807.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async63807.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async63807";

cljs.core.async.t_cljs$core$async63807.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async63807");
});

cljs.core.async.__GT_t_cljs$core$async63807 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async63807(f__$1,ch__$1,meta63808){
return (new cljs.core.async.t_cljs$core$async63807(f__$1,ch__$1,meta63808));
});

}

return (new cljs.core.async.t_cljs$core$async63807(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async63816 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async63816 = (function (f,ch,meta63817){
this.f = f;
this.ch = ch;
this.meta63817 = meta63817;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async63816.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_63818,meta63817__$1){
var self__ = this;
var _63818__$1 = this;
return (new cljs.core.async.t_cljs$core$async63816(self__.f,self__.ch,meta63817__$1));
});


cljs.core.async.t_cljs$core$async63816.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_63818){
var self__ = this;
var _63818__$1 = this;
return self__.meta63817;
});


cljs.core.async.t_cljs$core$async63816.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63816.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async63816.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63816.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async63816.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63816.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async63816.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta63817","meta63817",671340946,null)], null);
});

cljs.core.async.t_cljs$core$async63816.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async63816.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async63816";

cljs.core.async.t_cljs$core$async63816.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async63816");
});

cljs.core.async.__GT_t_cljs$core$async63816 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async63816(f__$1,ch__$1,meta63817){
return (new cljs.core.async.t_cljs$core$async63816(f__$1,ch__$1,meta63817));
});

}

return (new cljs.core.async.t_cljs$core$async63816(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async63822 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async63822 = (function (p,ch,meta63823){
this.p = p;
this.ch = ch;
this.meta63823 = meta63823;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async63822.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_63824,meta63823__$1){
var self__ = this;
var _63824__$1 = this;
return (new cljs.core.async.t_cljs$core$async63822(self__.p,self__.ch,meta63823__$1));
});


cljs.core.async.t_cljs$core$async63822.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_63824){
var self__ = this;
var _63824__$1 = this;
return self__.meta63823;
});


cljs.core.async.t_cljs$core$async63822.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63822.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async63822.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async63822.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63822.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async63822.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async63822.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async63822.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta63823","meta63823",-2005028206,null)], null);
});

cljs.core.async.t_cljs$core$async63822.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async63822.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async63822";

cljs.core.async.t_cljs$core$async63822.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async63822");
});

cljs.core.async.__GT_t_cljs$core$async63822 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async63822(p__$1,ch__$1,meta63823){
return (new cljs.core.async.t_cljs$core$async63822(p__$1,ch__$1,meta63823));
});

}

return (new cljs.core.async.t_cljs$core$async63822(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args63825 = [];
var len__28496__auto___63869 = arguments.length;
var i__28497__auto___63870 = (0);
while(true){
if((i__28497__auto___63870 < len__28496__auto___63869)){
args63825.push((arguments[i__28497__auto___63870]));

var G__63871 = (i__28497__auto___63870 + (1));
i__28497__auto___63870 = G__63871;
continue;
} else {
}
break;
}

var G__63827 = args63825.length;
switch (G__63827) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args63825.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__41822__auto___63873 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___63873,out){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___63873,out){
return (function (state_63848){
var state_val_63849 = (state_63848[(1)]);
if((state_val_63849 === (7))){
var inst_63844 = (state_63848[(2)]);
var state_63848__$1 = state_63848;
var statearr_63850_63874 = state_63848__$1;
(statearr_63850_63874[(2)] = inst_63844);

(statearr_63850_63874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63849 === (1))){
var state_63848__$1 = state_63848;
var statearr_63851_63875 = state_63848__$1;
(statearr_63851_63875[(2)] = null);

(statearr_63851_63875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63849 === (4))){
var inst_63830 = (state_63848[(7)]);
var inst_63830__$1 = (state_63848[(2)]);
var inst_63831 = (inst_63830__$1 == null);
var state_63848__$1 = (function (){var statearr_63852 = state_63848;
(statearr_63852[(7)] = inst_63830__$1);

return statearr_63852;
})();
if(cljs.core.truth_(inst_63831)){
var statearr_63853_63876 = state_63848__$1;
(statearr_63853_63876[(1)] = (5));

} else {
var statearr_63854_63877 = state_63848__$1;
(statearr_63854_63877[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63849 === (6))){
var inst_63830 = (state_63848[(7)]);
var inst_63835 = p.call(null,inst_63830);
var state_63848__$1 = state_63848;
if(cljs.core.truth_(inst_63835)){
var statearr_63855_63878 = state_63848__$1;
(statearr_63855_63878[(1)] = (8));

} else {
var statearr_63856_63879 = state_63848__$1;
(statearr_63856_63879[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63849 === (3))){
var inst_63846 = (state_63848[(2)]);
var state_63848__$1 = state_63848;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63848__$1,inst_63846);
} else {
if((state_val_63849 === (2))){
var state_63848__$1 = state_63848;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63848__$1,(4),ch);
} else {
if((state_val_63849 === (11))){
var inst_63838 = (state_63848[(2)]);
var state_63848__$1 = state_63848;
var statearr_63857_63880 = state_63848__$1;
(statearr_63857_63880[(2)] = inst_63838);

(statearr_63857_63880[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63849 === (9))){
var state_63848__$1 = state_63848;
var statearr_63858_63881 = state_63848__$1;
(statearr_63858_63881[(2)] = null);

(statearr_63858_63881[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63849 === (5))){
var inst_63833 = cljs.core.async.close_BANG_.call(null,out);
var state_63848__$1 = state_63848;
var statearr_63859_63882 = state_63848__$1;
(statearr_63859_63882[(2)] = inst_63833);

(statearr_63859_63882[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63849 === (10))){
var inst_63841 = (state_63848[(2)]);
var state_63848__$1 = (function (){var statearr_63860 = state_63848;
(statearr_63860[(8)] = inst_63841);

return statearr_63860;
})();
var statearr_63861_63883 = state_63848__$1;
(statearr_63861_63883[(2)] = null);

(statearr_63861_63883[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63849 === (8))){
var inst_63830 = (state_63848[(7)]);
var state_63848__$1 = state_63848;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_63848__$1,(11),out,inst_63830);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___63873,out))
;
return ((function (switch__41805__auto__,c__41822__auto___63873,out){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_63865 = [null,null,null,null,null,null,null,null,null];
(statearr_63865[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_63865[(1)] = (1));

return statearr_63865;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_63848){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_63848);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e63866){if((e63866 instanceof Object)){
var ex__41809__auto__ = e63866;
var statearr_63867_63884 = state_63848;
(statearr_63867_63884[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_63848);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e63866;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63885 = state_63848;
state_63848 = G__63885;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_63848){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_63848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___63873,out))
})();
var state__41824__auto__ = (function (){var statearr_63868 = f__41823__auto__.call(null);
(statearr_63868[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___63873);

return statearr_63868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___63873,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args63886 = [];
var len__28496__auto___63889 = arguments.length;
var i__28497__auto___63890 = (0);
while(true){
if((i__28497__auto___63890 < len__28496__auto___63889)){
args63886.push((arguments[i__28497__auto___63890]));

var G__63891 = (i__28497__auto___63890 + (1));
i__28497__auto___63890 = G__63891;
continue;
} else {
}
break;
}

var G__63888 = args63886.length;
switch (G__63888) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args63886.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__41822__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto__){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto__){
return (function (state_64058){
var state_val_64059 = (state_64058[(1)]);
if((state_val_64059 === (7))){
var inst_64054 = (state_64058[(2)]);
var state_64058__$1 = state_64058;
var statearr_64060_64101 = state_64058__$1;
(statearr_64060_64101[(2)] = inst_64054);

(statearr_64060_64101[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64059 === (20))){
var inst_64024 = (state_64058[(7)]);
var inst_64035 = (state_64058[(2)]);
var inst_64036 = cljs.core.next.call(null,inst_64024);
var inst_64010 = inst_64036;
var inst_64011 = null;
var inst_64012 = (0);
var inst_64013 = (0);
var state_64058__$1 = (function (){var statearr_64061 = state_64058;
(statearr_64061[(8)] = inst_64035);

(statearr_64061[(9)] = inst_64011);

(statearr_64061[(10)] = inst_64013);

(statearr_64061[(11)] = inst_64012);

(statearr_64061[(12)] = inst_64010);

return statearr_64061;
})();
var statearr_64062_64102 = state_64058__$1;
(statearr_64062_64102[(2)] = null);

(statearr_64062_64102[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64059 === (1))){
var state_64058__$1 = state_64058;
var statearr_64063_64103 = state_64058__$1;
(statearr_64063_64103[(2)] = null);

(statearr_64063_64103[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64059 === (4))){
var inst_63999 = (state_64058[(13)]);
var inst_63999__$1 = (state_64058[(2)]);
var inst_64000 = (inst_63999__$1 == null);
var state_64058__$1 = (function (){var statearr_64064 = state_64058;
(statearr_64064[(13)] = inst_63999__$1);

return statearr_64064;
})();
if(cljs.core.truth_(inst_64000)){
var statearr_64065_64104 = state_64058__$1;
(statearr_64065_64104[(1)] = (5));

} else {
var statearr_64066_64105 = state_64058__$1;
(statearr_64066_64105[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64059 === (15))){
var state_64058__$1 = state_64058;
var statearr_64070_64106 = state_64058__$1;
(statearr_64070_64106[(2)] = null);

(statearr_64070_64106[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64059 === (21))){
var state_64058__$1 = state_64058;
var statearr_64071_64107 = state_64058__$1;
(statearr_64071_64107[(2)] = null);

(statearr_64071_64107[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64059 === (13))){
var inst_64011 = (state_64058[(9)]);
var inst_64013 = (state_64058[(10)]);
var inst_64012 = (state_64058[(11)]);
var inst_64010 = (state_64058[(12)]);
var inst_64020 = (state_64058[(2)]);
var inst_64021 = (inst_64013 + (1));
var tmp64067 = inst_64011;
var tmp64068 = inst_64012;
var tmp64069 = inst_64010;
var inst_64010__$1 = tmp64069;
var inst_64011__$1 = tmp64067;
var inst_64012__$1 = tmp64068;
var inst_64013__$1 = inst_64021;
var state_64058__$1 = (function (){var statearr_64072 = state_64058;
(statearr_64072[(14)] = inst_64020);

(statearr_64072[(9)] = inst_64011__$1);

(statearr_64072[(10)] = inst_64013__$1);

(statearr_64072[(11)] = inst_64012__$1);

(statearr_64072[(12)] = inst_64010__$1);

return statearr_64072;
})();
var statearr_64073_64108 = state_64058__$1;
(statearr_64073_64108[(2)] = null);

(statearr_64073_64108[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64059 === (22))){
var state_64058__$1 = state_64058;
var statearr_64074_64109 = state_64058__$1;
(statearr_64074_64109[(2)] = null);

(statearr_64074_64109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64059 === (6))){
var inst_63999 = (state_64058[(13)]);
var inst_64008 = f.call(null,inst_63999);
var inst_64009 = cljs.core.seq.call(null,inst_64008);
var inst_64010 = inst_64009;
var inst_64011 = null;
var inst_64012 = (0);
var inst_64013 = (0);
var state_64058__$1 = (function (){var statearr_64075 = state_64058;
(statearr_64075[(9)] = inst_64011);

(statearr_64075[(10)] = inst_64013);

(statearr_64075[(11)] = inst_64012);

(statearr_64075[(12)] = inst_64010);

return statearr_64075;
})();
var statearr_64076_64110 = state_64058__$1;
(statearr_64076_64110[(2)] = null);

(statearr_64076_64110[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64059 === (17))){
var inst_64024 = (state_64058[(7)]);
var inst_64028 = cljs.core.chunk_first.call(null,inst_64024);
var inst_64029 = cljs.core.chunk_rest.call(null,inst_64024);
var inst_64030 = cljs.core.count.call(null,inst_64028);
var inst_64010 = inst_64029;
var inst_64011 = inst_64028;
var inst_64012 = inst_64030;
var inst_64013 = (0);
var state_64058__$1 = (function (){var statearr_64077 = state_64058;
(statearr_64077[(9)] = inst_64011);

(statearr_64077[(10)] = inst_64013);

(statearr_64077[(11)] = inst_64012);

(statearr_64077[(12)] = inst_64010);

return statearr_64077;
})();
var statearr_64078_64111 = state_64058__$1;
(statearr_64078_64111[(2)] = null);

(statearr_64078_64111[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64059 === (3))){
var inst_64056 = (state_64058[(2)]);
var state_64058__$1 = state_64058;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64058__$1,inst_64056);
} else {
if((state_val_64059 === (12))){
var inst_64044 = (state_64058[(2)]);
var state_64058__$1 = state_64058;
var statearr_64079_64112 = state_64058__$1;
(statearr_64079_64112[(2)] = inst_64044);

(statearr_64079_64112[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64059 === (2))){
var state_64058__$1 = state_64058;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64058__$1,(4),in$);
} else {
if((state_val_64059 === (23))){
var inst_64052 = (state_64058[(2)]);
var state_64058__$1 = state_64058;
var statearr_64080_64113 = state_64058__$1;
(statearr_64080_64113[(2)] = inst_64052);

(statearr_64080_64113[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64059 === (19))){
var inst_64039 = (state_64058[(2)]);
var state_64058__$1 = state_64058;
var statearr_64081_64114 = state_64058__$1;
(statearr_64081_64114[(2)] = inst_64039);

(statearr_64081_64114[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64059 === (11))){
var inst_64024 = (state_64058[(7)]);
var inst_64010 = (state_64058[(12)]);
var inst_64024__$1 = cljs.core.seq.call(null,inst_64010);
var state_64058__$1 = (function (){var statearr_64082 = state_64058;
(statearr_64082[(7)] = inst_64024__$1);

return statearr_64082;
})();
if(inst_64024__$1){
var statearr_64083_64115 = state_64058__$1;
(statearr_64083_64115[(1)] = (14));

} else {
var statearr_64084_64116 = state_64058__$1;
(statearr_64084_64116[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64059 === (9))){
var inst_64046 = (state_64058[(2)]);
var inst_64047 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_64058__$1 = (function (){var statearr_64085 = state_64058;
(statearr_64085[(15)] = inst_64046);

return statearr_64085;
})();
if(cljs.core.truth_(inst_64047)){
var statearr_64086_64117 = state_64058__$1;
(statearr_64086_64117[(1)] = (21));

} else {
var statearr_64087_64118 = state_64058__$1;
(statearr_64087_64118[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64059 === (5))){
var inst_64002 = cljs.core.async.close_BANG_.call(null,out);
var state_64058__$1 = state_64058;
var statearr_64088_64119 = state_64058__$1;
(statearr_64088_64119[(2)] = inst_64002);

(statearr_64088_64119[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64059 === (14))){
var inst_64024 = (state_64058[(7)]);
var inst_64026 = cljs.core.chunked_seq_QMARK_.call(null,inst_64024);
var state_64058__$1 = state_64058;
if(inst_64026){
var statearr_64089_64120 = state_64058__$1;
(statearr_64089_64120[(1)] = (17));

} else {
var statearr_64090_64121 = state_64058__$1;
(statearr_64090_64121[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64059 === (16))){
var inst_64042 = (state_64058[(2)]);
var state_64058__$1 = state_64058;
var statearr_64091_64122 = state_64058__$1;
(statearr_64091_64122[(2)] = inst_64042);

(statearr_64091_64122[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64059 === (10))){
var inst_64011 = (state_64058[(9)]);
var inst_64013 = (state_64058[(10)]);
var inst_64018 = cljs.core._nth.call(null,inst_64011,inst_64013);
var state_64058__$1 = state_64058;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_64058__$1,(13),out,inst_64018);
} else {
if((state_val_64059 === (18))){
var inst_64024 = (state_64058[(7)]);
var inst_64033 = cljs.core.first.call(null,inst_64024);
var state_64058__$1 = state_64058;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_64058__$1,(20),out,inst_64033);
} else {
if((state_val_64059 === (8))){
var inst_64013 = (state_64058[(10)]);
var inst_64012 = (state_64058[(11)]);
var inst_64015 = (inst_64013 < inst_64012);
var inst_64016 = inst_64015;
var state_64058__$1 = state_64058;
if(cljs.core.truth_(inst_64016)){
var statearr_64092_64123 = state_64058__$1;
(statearr_64092_64123[(1)] = (10));

} else {
var statearr_64093_64124 = state_64058__$1;
(statearr_64093_64124[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto__))
;
return ((function (switch__41805__auto__,c__41822__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__41806__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__41806__auto____0 = (function (){
var statearr_64097 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64097[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__41806__auto__);

(statearr_64097[(1)] = (1));

return statearr_64097;
});
var cljs$core$async$mapcat_STAR__$_state_machine__41806__auto____1 = (function (state_64058){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_64058);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e64098){if((e64098 instanceof Object)){
var ex__41809__auto__ = e64098;
var statearr_64099_64125 = state_64058;
(statearr_64099_64125[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_64058);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e64098;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64126 = state_64058;
state_64058 = G__64126;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__41806__auto__ = function(state_64058){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__41806__auto____1.call(this,state_64058);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__41806__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__41806__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto__))
})();
var state__41824__auto__ = (function (){var statearr_64100 = f__41823__auto__.call(null);
(statearr_64100[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto__);

return statearr_64100;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto__))
);

return c__41822__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args64127 = [];
var len__28496__auto___64130 = arguments.length;
var i__28497__auto___64131 = (0);
while(true){
if((i__28497__auto___64131 < len__28496__auto___64130)){
args64127.push((arguments[i__28497__auto___64131]));

var G__64132 = (i__28497__auto___64131 + (1));
i__28497__auto___64131 = G__64132;
continue;
} else {
}
break;
}

var G__64129 = args64127.length;
switch (G__64129) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args64127.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args64134 = [];
var len__28496__auto___64137 = arguments.length;
var i__28497__auto___64138 = (0);
while(true){
if((i__28497__auto___64138 < len__28496__auto___64137)){
args64134.push((arguments[i__28497__auto___64138]));

var G__64139 = (i__28497__auto___64138 + (1));
i__28497__auto___64138 = G__64139;
continue;
} else {
}
break;
}

var G__64136 = args64134.length;
switch (G__64136) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args64134.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args64141 = [];
var len__28496__auto___64192 = arguments.length;
var i__28497__auto___64193 = (0);
while(true){
if((i__28497__auto___64193 < len__28496__auto___64192)){
args64141.push((arguments[i__28497__auto___64193]));

var G__64194 = (i__28497__auto___64193 + (1));
i__28497__auto___64193 = G__64194;
continue;
} else {
}
break;
}

var G__64143 = args64141.length;
switch (G__64143) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args64141.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__41822__auto___64196 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___64196,out){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___64196,out){
return (function (state_64167){
var state_val_64168 = (state_64167[(1)]);
if((state_val_64168 === (7))){
var inst_64162 = (state_64167[(2)]);
var state_64167__$1 = state_64167;
var statearr_64169_64197 = state_64167__$1;
(statearr_64169_64197[(2)] = inst_64162);

(statearr_64169_64197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64168 === (1))){
var inst_64144 = null;
var state_64167__$1 = (function (){var statearr_64170 = state_64167;
(statearr_64170[(7)] = inst_64144);

return statearr_64170;
})();
var statearr_64171_64198 = state_64167__$1;
(statearr_64171_64198[(2)] = null);

(statearr_64171_64198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64168 === (4))){
var inst_64147 = (state_64167[(8)]);
var inst_64147__$1 = (state_64167[(2)]);
var inst_64148 = (inst_64147__$1 == null);
var inst_64149 = cljs.core.not.call(null,inst_64148);
var state_64167__$1 = (function (){var statearr_64172 = state_64167;
(statearr_64172[(8)] = inst_64147__$1);

return statearr_64172;
})();
if(inst_64149){
var statearr_64173_64199 = state_64167__$1;
(statearr_64173_64199[(1)] = (5));

} else {
var statearr_64174_64200 = state_64167__$1;
(statearr_64174_64200[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64168 === (6))){
var state_64167__$1 = state_64167;
var statearr_64175_64201 = state_64167__$1;
(statearr_64175_64201[(2)] = null);

(statearr_64175_64201[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64168 === (3))){
var inst_64164 = (state_64167[(2)]);
var inst_64165 = cljs.core.async.close_BANG_.call(null,out);
var state_64167__$1 = (function (){var statearr_64176 = state_64167;
(statearr_64176[(9)] = inst_64164);

return statearr_64176;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64167__$1,inst_64165);
} else {
if((state_val_64168 === (2))){
var state_64167__$1 = state_64167;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64167__$1,(4),ch);
} else {
if((state_val_64168 === (11))){
var inst_64147 = (state_64167[(8)]);
var inst_64156 = (state_64167[(2)]);
var inst_64144 = inst_64147;
var state_64167__$1 = (function (){var statearr_64177 = state_64167;
(statearr_64177[(7)] = inst_64144);

(statearr_64177[(10)] = inst_64156);

return statearr_64177;
})();
var statearr_64178_64202 = state_64167__$1;
(statearr_64178_64202[(2)] = null);

(statearr_64178_64202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64168 === (9))){
var inst_64147 = (state_64167[(8)]);
var state_64167__$1 = state_64167;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_64167__$1,(11),out,inst_64147);
} else {
if((state_val_64168 === (5))){
var inst_64147 = (state_64167[(8)]);
var inst_64144 = (state_64167[(7)]);
var inst_64151 = cljs.core._EQ_.call(null,inst_64147,inst_64144);
var state_64167__$1 = state_64167;
if(inst_64151){
var statearr_64180_64203 = state_64167__$1;
(statearr_64180_64203[(1)] = (8));

} else {
var statearr_64181_64204 = state_64167__$1;
(statearr_64181_64204[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64168 === (10))){
var inst_64159 = (state_64167[(2)]);
var state_64167__$1 = state_64167;
var statearr_64182_64205 = state_64167__$1;
(statearr_64182_64205[(2)] = inst_64159);

(statearr_64182_64205[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64168 === (8))){
var inst_64144 = (state_64167[(7)]);
var tmp64179 = inst_64144;
var inst_64144__$1 = tmp64179;
var state_64167__$1 = (function (){var statearr_64183 = state_64167;
(statearr_64183[(7)] = inst_64144__$1);

return statearr_64183;
})();
var statearr_64184_64206 = state_64167__$1;
(statearr_64184_64206[(2)] = null);

(statearr_64184_64206[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___64196,out))
;
return ((function (switch__41805__auto__,c__41822__auto___64196,out){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_64188 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_64188[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_64188[(1)] = (1));

return statearr_64188;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_64167){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_64167);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e64189){if((e64189 instanceof Object)){
var ex__41809__auto__ = e64189;
var statearr_64190_64207 = state_64167;
(statearr_64190_64207[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_64167);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e64189;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64208 = state_64167;
state_64167 = G__64208;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_64167){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_64167);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___64196,out))
})();
var state__41824__auto__ = (function (){var statearr_64191 = f__41823__auto__.call(null);
(statearr_64191[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___64196);

return statearr_64191;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___64196,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args64209 = [];
var len__28496__auto___64279 = arguments.length;
var i__28497__auto___64280 = (0);
while(true){
if((i__28497__auto___64280 < len__28496__auto___64279)){
args64209.push((arguments[i__28497__auto___64280]));

var G__64281 = (i__28497__auto___64280 + (1));
i__28497__auto___64280 = G__64281;
continue;
} else {
}
break;
}

var G__64211 = args64209.length;
switch (G__64211) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args64209.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__41822__auto___64283 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___64283,out){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___64283,out){
return (function (state_64249){
var state_val_64250 = (state_64249[(1)]);
if((state_val_64250 === (7))){
var inst_64245 = (state_64249[(2)]);
var state_64249__$1 = state_64249;
var statearr_64251_64284 = state_64249__$1;
(statearr_64251_64284[(2)] = inst_64245);

(statearr_64251_64284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64250 === (1))){
var inst_64212 = (new Array(n));
var inst_64213 = inst_64212;
var inst_64214 = (0);
var state_64249__$1 = (function (){var statearr_64252 = state_64249;
(statearr_64252[(7)] = inst_64213);

(statearr_64252[(8)] = inst_64214);

return statearr_64252;
})();
var statearr_64253_64285 = state_64249__$1;
(statearr_64253_64285[(2)] = null);

(statearr_64253_64285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64250 === (4))){
var inst_64217 = (state_64249[(9)]);
var inst_64217__$1 = (state_64249[(2)]);
var inst_64218 = (inst_64217__$1 == null);
var inst_64219 = cljs.core.not.call(null,inst_64218);
var state_64249__$1 = (function (){var statearr_64254 = state_64249;
(statearr_64254[(9)] = inst_64217__$1);

return statearr_64254;
})();
if(inst_64219){
var statearr_64255_64286 = state_64249__$1;
(statearr_64255_64286[(1)] = (5));

} else {
var statearr_64256_64287 = state_64249__$1;
(statearr_64256_64287[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64250 === (15))){
var inst_64239 = (state_64249[(2)]);
var state_64249__$1 = state_64249;
var statearr_64257_64288 = state_64249__$1;
(statearr_64257_64288[(2)] = inst_64239);

(statearr_64257_64288[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64250 === (13))){
var state_64249__$1 = state_64249;
var statearr_64258_64289 = state_64249__$1;
(statearr_64258_64289[(2)] = null);

(statearr_64258_64289[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64250 === (6))){
var inst_64214 = (state_64249[(8)]);
var inst_64235 = (inst_64214 > (0));
var state_64249__$1 = state_64249;
if(cljs.core.truth_(inst_64235)){
var statearr_64259_64290 = state_64249__$1;
(statearr_64259_64290[(1)] = (12));

} else {
var statearr_64260_64291 = state_64249__$1;
(statearr_64260_64291[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64250 === (3))){
var inst_64247 = (state_64249[(2)]);
var state_64249__$1 = state_64249;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64249__$1,inst_64247);
} else {
if((state_val_64250 === (12))){
var inst_64213 = (state_64249[(7)]);
var inst_64237 = cljs.core.vec.call(null,inst_64213);
var state_64249__$1 = state_64249;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_64249__$1,(15),out,inst_64237);
} else {
if((state_val_64250 === (2))){
var state_64249__$1 = state_64249;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64249__$1,(4),ch);
} else {
if((state_val_64250 === (11))){
var inst_64229 = (state_64249[(2)]);
var inst_64230 = (new Array(n));
var inst_64213 = inst_64230;
var inst_64214 = (0);
var state_64249__$1 = (function (){var statearr_64261 = state_64249;
(statearr_64261[(10)] = inst_64229);

(statearr_64261[(7)] = inst_64213);

(statearr_64261[(8)] = inst_64214);

return statearr_64261;
})();
var statearr_64262_64292 = state_64249__$1;
(statearr_64262_64292[(2)] = null);

(statearr_64262_64292[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64250 === (9))){
var inst_64213 = (state_64249[(7)]);
var inst_64227 = cljs.core.vec.call(null,inst_64213);
var state_64249__$1 = state_64249;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_64249__$1,(11),out,inst_64227);
} else {
if((state_val_64250 === (5))){
var inst_64213 = (state_64249[(7)]);
var inst_64217 = (state_64249[(9)]);
var inst_64222 = (state_64249[(11)]);
var inst_64214 = (state_64249[(8)]);
var inst_64221 = (inst_64213[inst_64214] = inst_64217);
var inst_64222__$1 = (inst_64214 + (1));
var inst_64223 = (inst_64222__$1 < n);
var state_64249__$1 = (function (){var statearr_64263 = state_64249;
(statearr_64263[(12)] = inst_64221);

(statearr_64263[(11)] = inst_64222__$1);

return statearr_64263;
})();
if(cljs.core.truth_(inst_64223)){
var statearr_64264_64293 = state_64249__$1;
(statearr_64264_64293[(1)] = (8));

} else {
var statearr_64265_64294 = state_64249__$1;
(statearr_64265_64294[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64250 === (14))){
var inst_64242 = (state_64249[(2)]);
var inst_64243 = cljs.core.async.close_BANG_.call(null,out);
var state_64249__$1 = (function (){var statearr_64267 = state_64249;
(statearr_64267[(13)] = inst_64242);

return statearr_64267;
})();
var statearr_64268_64295 = state_64249__$1;
(statearr_64268_64295[(2)] = inst_64243);

(statearr_64268_64295[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64250 === (10))){
var inst_64233 = (state_64249[(2)]);
var state_64249__$1 = state_64249;
var statearr_64269_64296 = state_64249__$1;
(statearr_64269_64296[(2)] = inst_64233);

(statearr_64269_64296[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64250 === (8))){
var inst_64213 = (state_64249[(7)]);
var inst_64222 = (state_64249[(11)]);
var tmp64266 = inst_64213;
var inst_64213__$1 = tmp64266;
var inst_64214 = inst_64222;
var state_64249__$1 = (function (){var statearr_64270 = state_64249;
(statearr_64270[(7)] = inst_64213__$1);

(statearr_64270[(8)] = inst_64214);

return statearr_64270;
})();
var statearr_64271_64297 = state_64249__$1;
(statearr_64271_64297[(2)] = null);

(statearr_64271_64297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___64283,out))
;
return ((function (switch__41805__auto__,c__41822__auto___64283,out){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_64275 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64275[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_64275[(1)] = (1));

return statearr_64275;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_64249){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_64249);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e64276){if((e64276 instanceof Object)){
var ex__41809__auto__ = e64276;
var statearr_64277_64298 = state_64249;
(statearr_64277_64298[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_64249);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e64276;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64299 = state_64249;
state_64249 = G__64299;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_64249){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_64249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___64283,out))
})();
var state__41824__auto__ = (function (){var statearr_64278 = f__41823__auto__.call(null);
(statearr_64278[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___64283);

return statearr_64278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___64283,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args64300 = [];
var len__28496__auto___64374 = arguments.length;
var i__28497__auto___64375 = (0);
while(true){
if((i__28497__auto___64375 < len__28496__auto___64374)){
args64300.push((arguments[i__28497__auto___64375]));

var G__64376 = (i__28497__auto___64375 + (1));
i__28497__auto___64375 = G__64376;
continue;
} else {
}
break;
}

var G__64302 = args64300.length;
switch (G__64302) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args64300.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__41822__auto___64378 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___64378,out){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___64378,out){
return (function (state_64344){
var state_val_64345 = (state_64344[(1)]);
if((state_val_64345 === (7))){
var inst_64340 = (state_64344[(2)]);
var state_64344__$1 = state_64344;
var statearr_64346_64379 = state_64344__$1;
(statearr_64346_64379[(2)] = inst_64340);

(statearr_64346_64379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64345 === (1))){
var inst_64303 = [];
var inst_64304 = inst_64303;
var inst_64305 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_64344__$1 = (function (){var statearr_64347 = state_64344;
(statearr_64347[(7)] = inst_64305);

(statearr_64347[(8)] = inst_64304);

return statearr_64347;
})();
var statearr_64348_64380 = state_64344__$1;
(statearr_64348_64380[(2)] = null);

(statearr_64348_64380[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64345 === (4))){
var inst_64308 = (state_64344[(9)]);
var inst_64308__$1 = (state_64344[(2)]);
var inst_64309 = (inst_64308__$1 == null);
var inst_64310 = cljs.core.not.call(null,inst_64309);
var state_64344__$1 = (function (){var statearr_64349 = state_64344;
(statearr_64349[(9)] = inst_64308__$1);

return statearr_64349;
})();
if(inst_64310){
var statearr_64350_64381 = state_64344__$1;
(statearr_64350_64381[(1)] = (5));

} else {
var statearr_64351_64382 = state_64344__$1;
(statearr_64351_64382[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64345 === (15))){
var inst_64334 = (state_64344[(2)]);
var state_64344__$1 = state_64344;
var statearr_64352_64383 = state_64344__$1;
(statearr_64352_64383[(2)] = inst_64334);

(statearr_64352_64383[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64345 === (13))){
var state_64344__$1 = state_64344;
var statearr_64353_64384 = state_64344__$1;
(statearr_64353_64384[(2)] = null);

(statearr_64353_64384[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64345 === (6))){
var inst_64304 = (state_64344[(8)]);
var inst_64329 = inst_64304.length;
var inst_64330 = (inst_64329 > (0));
var state_64344__$1 = state_64344;
if(cljs.core.truth_(inst_64330)){
var statearr_64354_64385 = state_64344__$1;
(statearr_64354_64385[(1)] = (12));

} else {
var statearr_64355_64386 = state_64344__$1;
(statearr_64355_64386[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64345 === (3))){
var inst_64342 = (state_64344[(2)]);
var state_64344__$1 = state_64344;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64344__$1,inst_64342);
} else {
if((state_val_64345 === (12))){
var inst_64304 = (state_64344[(8)]);
var inst_64332 = cljs.core.vec.call(null,inst_64304);
var state_64344__$1 = state_64344;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_64344__$1,(15),out,inst_64332);
} else {
if((state_val_64345 === (2))){
var state_64344__$1 = state_64344;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64344__$1,(4),ch);
} else {
if((state_val_64345 === (11))){
var inst_64312 = (state_64344[(10)]);
var inst_64308 = (state_64344[(9)]);
var inst_64322 = (state_64344[(2)]);
var inst_64323 = [];
var inst_64324 = inst_64323.push(inst_64308);
var inst_64304 = inst_64323;
var inst_64305 = inst_64312;
var state_64344__$1 = (function (){var statearr_64356 = state_64344;
(statearr_64356[(11)] = inst_64322);

(statearr_64356[(12)] = inst_64324);

(statearr_64356[(7)] = inst_64305);

(statearr_64356[(8)] = inst_64304);

return statearr_64356;
})();
var statearr_64357_64387 = state_64344__$1;
(statearr_64357_64387[(2)] = null);

(statearr_64357_64387[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64345 === (9))){
var inst_64304 = (state_64344[(8)]);
var inst_64320 = cljs.core.vec.call(null,inst_64304);
var state_64344__$1 = state_64344;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_64344__$1,(11),out,inst_64320);
} else {
if((state_val_64345 === (5))){
var inst_64312 = (state_64344[(10)]);
var inst_64305 = (state_64344[(7)]);
var inst_64308 = (state_64344[(9)]);
var inst_64312__$1 = f.call(null,inst_64308);
var inst_64313 = cljs.core._EQ_.call(null,inst_64312__$1,inst_64305);
var inst_64314 = cljs.core.keyword_identical_QMARK_.call(null,inst_64305,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_64315 = (inst_64313) || (inst_64314);
var state_64344__$1 = (function (){var statearr_64358 = state_64344;
(statearr_64358[(10)] = inst_64312__$1);

return statearr_64358;
})();
if(cljs.core.truth_(inst_64315)){
var statearr_64359_64388 = state_64344__$1;
(statearr_64359_64388[(1)] = (8));

} else {
var statearr_64360_64389 = state_64344__$1;
(statearr_64360_64389[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64345 === (14))){
var inst_64337 = (state_64344[(2)]);
var inst_64338 = cljs.core.async.close_BANG_.call(null,out);
var state_64344__$1 = (function (){var statearr_64362 = state_64344;
(statearr_64362[(13)] = inst_64337);

return statearr_64362;
})();
var statearr_64363_64390 = state_64344__$1;
(statearr_64363_64390[(2)] = inst_64338);

(statearr_64363_64390[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64345 === (10))){
var inst_64327 = (state_64344[(2)]);
var state_64344__$1 = state_64344;
var statearr_64364_64391 = state_64344__$1;
(statearr_64364_64391[(2)] = inst_64327);

(statearr_64364_64391[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64345 === (8))){
var inst_64312 = (state_64344[(10)]);
var inst_64308 = (state_64344[(9)]);
var inst_64304 = (state_64344[(8)]);
var inst_64317 = inst_64304.push(inst_64308);
var tmp64361 = inst_64304;
var inst_64304__$1 = tmp64361;
var inst_64305 = inst_64312;
var state_64344__$1 = (function (){var statearr_64365 = state_64344;
(statearr_64365[(14)] = inst_64317);

(statearr_64365[(7)] = inst_64305);

(statearr_64365[(8)] = inst_64304__$1);

return statearr_64365;
})();
var statearr_64366_64392 = state_64344__$1;
(statearr_64366_64392[(2)] = null);

(statearr_64366_64392[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto___64378,out))
;
return ((function (switch__41805__auto__,c__41822__auto___64378,out){
return (function() {
var cljs$core$async$state_machine__41806__auto__ = null;
var cljs$core$async$state_machine__41806__auto____0 = (function (){
var statearr_64370 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64370[(0)] = cljs$core$async$state_machine__41806__auto__);

(statearr_64370[(1)] = (1));

return statearr_64370;
});
var cljs$core$async$state_machine__41806__auto____1 = (function (state_64344){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_64344);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e64371){if((e64371 instanceof Object)){
var ex__41809__auto__ = e64371;
var statearr_64372_64393 = state_64344;
(statearr_64372_64393[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_64344);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e64371;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64394 = state_64344;
state_64344 = G__64394;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
cljs$core$async$state_machine__41806__auto__ = function(state_64344){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41806__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41806__auto____1.call(this,state_64344);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41806__auto____0;
cljs$core$async$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41806__auto____1;
return cljs$core$async$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___64378,out))
})();
var state__41824__auto__ = (function (){var statearr_64373 = f__41823__auto__.call(null);
(statearr_64373[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___64378);

return statearr_64373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___64378,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1479956912701