// Compiled by ClojureScript 1.9.293 {}
goog.provide('devtools.core');
goog.require('cljs.core');
goog.require('devtools.prefs');
goog.require('devtools.sanity_hints');
goog.require('devtools.dirac');
goog.require('devtools.custom_formatters');
goog.require('devtools.util');
goog.require('goog.userAgent');
devtools.core.known_features = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"custom-formatters","custom-formatters",-863243779),new cljs.core.Keyword(null,"install-custom-formatters","install-custom-formatters",-1653731327),new cljs.core.Keyword(null,"dirac","dirac",1785994033),new cljs.core.Keyword(null,"install-dirac-support","install-dirac-support",-949928649),new cljs.core.Keyword(null,"sanity-hints","sanity-hints",1201436858),new cljs.core.Keyword(null,"install-sanity-hints","install-sanity-hints",72546145)], null);
devtools.core.missing_feature_warning = (function devtools$core$missing_feature_warning(feature,known_features){
return [cljs.core.str("No such feature '"),cljs.core.str(feature),cljs.core.str("' is currently available in cljs-devtools. "),cljs.core.str("List of supported features:"),cljs.core.str(cljs.core.keys.call(null,known_features))].join('');
});
devtools.core.warn_feature_not_available = (function devtools$core$warn_feature_not_available(feature){
return console.warn([cljs.core.str("Feature '"),cljs.core.str(cljs.core.name.call(null,feature)),cljs.core.str("' cannot be installed. Unsupported browser "),cljs.core.str(goog.userAgent.getUserAgentString()),cljs.core.str(".")].join(''));
});
devtools.core.install_BANG_ = (function devtools$core$install_BANG_(){
devtools.util.display_banner.call(null,"Installing cljs-devtools:",devtools.core.known_features);

if(cljs.core.truth_(devtools.prefs.pref.call(null,new cljs.core.Keyword(null,"install-custom-formatters","install-custom-formatters",-1653731327)))){
if(cljs.core.truth_(devtools.custom_formatters.available_QMARK_.call(null))){
devtools.custom_formatters.install_BANG_.call(null);
} else {
devtools.core.warn_feature_not_available.call(null,new cljs.core.Keyword(null,"custom-formatters","custom-formatters",-863243779));
}
} else {
}

if(cljs.core.truth_(devtools.prefs.pref.call(null,new cljs.core.Keyword(null,"install-sanity-hints","install-sanity-hints",72546145)))){
if(cljs.core.truth_(devtools.sanity_hints.available_QMARK_.call(null))){
devtools.sanity_hints.install_BANG_.call(null);
} else {
devtools.core.warn_feature_not_available.call(null,new cljs.core.Keyword(null,"sanity-hints","sanity-hints",1201436858));
}
} else {
}

if(cljs.core.truth_(devtools.prefs.pref.call(null,new cljs.core.Keyword(null,"install-dirac-support","install-dirac-support",-949928649)))){
if(cljs.core.truth_(devtools.dirac.available_QMARK_.call(null))){
return devtools.dirac.install_BANG_.call(null);
} else {
return devtools.core.warn_feature_not_available.call(null,new cljs.core.Keyword(null,"dirac","dirac",1785994033));
}
} else {
return null;
}
});
devtools.core.uninstall_BANG_ = (function devtools$core$uninstall_BANG_(){
devtools.custom_formatters.uninstall_BANG_.call(null);

devtools.sanity_hints.uninstall_BANG_.call(null);

return devtools.dirac.uninstall_BANG_.call(null);
});
devtools.core.set_prefs_BANG_ = (function devtools$core$set_prefs_BANG_(new_prefs){
return devtools.prefs.set_prefs_BANG_.call(null,new_prefs);
});
devtools.core.get_prefs = (function devtools$core$get_prefs(){
return devtools.prefs.get_prefs.call(null);
});
devtools.core.set_pref_BANG_ = (function devtools$core$set_pref_BANG_(pref,val){
return devtools.prefs.set_pref_BANG_.call(null,pref,val);
});
devtools.core.set_single_feature_BANG_ = (function devtools$core$set_single_feature_BANG_(feature,val){
var temp__6751__auto__ = feature.call(null,devtools.core.known_features);
if(cljs.core.truth_(temp__6751__auto__)){
var feature_installation_key = temp__6751__auto__;
return devtools.core.set_pref_BANG_.call(null,feature_installation_key,val);
} else {
return console.warn(devtools.core.missing_feature_warning.call(null,feature,devtools.core.known_features));
}
});
devtools.core.enable_single_feature_BANG_ = (function devtools$core$enable_single_feature_BANG_(feature){
return devtools.core.set_single_feature_BANG_.call(null,feature,true);
});
devtools.core.disable_single_feature_BANG_ = (function devtools$core$disable_single_feature_BANG_(feature){
return devtools.core.set_single_feature_BANG_.call(null,feature,false);
});
devtools.core.enable_feature_BANG_ = (function devtools$core$enable_feature_BANG_(var_args){
var args__28503__auto__ = [];
var len__28496__auto___67648 = arguments.length;
var i__28497__auto___67649 = (0);
while(true){
if((i__28497__auto___67649 < len__28496__auto___67648)){
args__28503__auto__.push((arguments[i__28497__auto___67649]));

var G__67650 = (i__28497__auto___67649 + (1));
i__28497__auto___67649 = G__67650;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((0) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((0)),(0),null)):null);
return devtools.core.enable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__28504__auto__);
});

devtools.core.enable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (features){
var seq__67644 = cljs.core.seq.call(null,features);
var chunk__67645 = null;
var count__67646 = (0);
var i__67647 = (0);
while(true){
if((i__67647 < count__67646)){
var feature = cljs.core._nth.call(null,chunk__67645,i__67647);
devtools.core.enable_single_feature_BANG_.call(null,feature);

var G__67651 = seq__67644;
var G__67652 = chunk__67645;
var G__67653 = count__67646;
var G__67654 = (i__67647 + (1));
seq__67644 = G__67651;
chunk__67645 = G__67652;
count__67646 = G__67653;
i__67647 = G__67654;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__67644);
if(temp__6753__auto__){
var seq__67644__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__67644__$1)){
var c__28186__auto__ = cljs.core.chunk_first.call(null,seq__67644__$1);
var G__67655 = cljs.core.chunk_rest.call(null,seq__67644__$1);
var G__67656 = c__28186__auto__;
var G__67657 = cljs.core.count.call(null,c__28186__auto__);
var G__67658 = (0);
seq__67644 = G__67655;
chunk__67645 = G__67656;
count__67646 = G__67657;
i__67647 = G__67658;
continue;
} else {
var feature = cljs.core.first.call(null,seq__67644__$1);
devtools.core.enable_single_feature_BANG_.call(null,feature);

var G__67659 = cljs.core.next.call(null,seq__67644__$1);
var G__67660 = null;
var G__67661 = (0);
var G__67662 = (0);
seq__67644 = G__67659;
chunk__67645 = G__67660;
count__67646 = G__67661;
i__67647 = G__67662;
continue;
}
} else {
return null;
}
}
break;
}
});

devtools.core.enable_feature_BANG_.cljs$lang$maxFixedArity = (0);

devtools.core.enable_feature_BANG_.cljs$lang$applyTo = (function (seq67643){
return devtools.core.enable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67643));
});

devtools.core.disable_feature_BANG_ = (function devtools$core$disable_feature_BANG_(var_args){
var args__28503__auto__ = [];
var len__28496__auto___67668 = arguments.length;
var i__28497__auto___67669 = (0);
while(true){
if((i__28497__auto___67669 < len__28496__auto___67668)){
args__28503__auto__.push((arguments[i__28497__auto___67669]));

var G__67670 = (i__28497__auto___67669 + (1));
i__28497__auto___67669 = G__67670;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((0) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((0)),(0),null)):null);
return devtools.core.disable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__28504__auto__);
});

devtools.core.disable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (features){
var seq__67664 = cljs.core.seq.call(null,features);
var chunk__67665 = null;
var count__67666 = (0);
var i__67667 = (0);
while(true){
if((i__67667 < count__67666)){
var feature = cljs.core._nth.call(null,chunk__67665,i__67667);
devtools.core.disable_single_feature_BANG_.call(null,feature);

var G__67671 = seq__67664;
var G__67672 = chunk__67665;
var G__67673 = count__67666;
var G__67674 = (i__67667 + (1));
seq__67664 = G__67671;
chunk__67665 = G__67672;
count__67666 = G__67673;
i__67667 = G__67674;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__67664);
if(temp__6753__auto__){
var seq__67664__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__67664__$1)){
var c__28186__auto__ = cljs.core.chunk_first.call(null,seq__67664__$1);
var G__67675 = cljs.core.chunk_rest.call(null,seq__67664__$1);
var G__67676 = c__28186__auto__;
var G__67677 = cljs.core.count.call(null,c__28186__auto__);
var G__67678 = (0);
seq__67664 = G__67675;
chunk__67665 = G__67676;
count__67666 = G__67677;
i__67667 = G__67678;
continue;
} else {
var feature = cljs.core.first.call(null,seq__67664__$1);
devtools.core.disable_single_feature_BANG_.call(null,feature);

var G__67679 = cljs.core.next.call(null,seq__67664__$1);
var G__67680 = null;
var G__67681 = (0);
var G__67682 = (0);
seq__67664 = G__67679;
chunk__67665 = G__67680;
count__67666 = G__67681;
i__67667 = G__67682;
continue;
}
} else {
return null;
}
}
break;
}
});

devtools.core.disable_feature_BANG_.cljs$lang$maxFixedArity = (0);

devtools.core.disable_feature_BANG_.cljs$lang$applyTo = (function (seq67663){
return devtools.core.disable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67663));
});

devtools.core.single_feature_available_QMARK_ = (function devtools$core$single_feature_available_QMARK_(feature){
var G__67684 = (((feature instanceof cljs.core.Keyword))?feature.fqn:null);
switch (G__67684) {
case "custom-formatters":
return devtools.custom_formatters.available_QMARK_.call(null);

break;
case "dirac":
return devtools.dirac.available_QMARK_.call(null);

break;
case "sanity-hints":
return devtools.sanity_hints.available_QMARK_.call(null);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(feature)].join('')));

}
});
devtools.core.feature_available_QMARK_ = (function devtools$core$feature_available_QMARK_(var_args){
var args__28503__auto__ = [];
var len__28496__auto___67687 = arguments.length;
var i__28497__auto___67688 = (0);
while(true){
if((i__28497__auto___67688 < len__28496__auto___67687)){
args__28503__auto__.push((arguments[i__28497__auto___67688]));

var G__67689 = (i__28497__auto___67688 + (1));
i__28497__auto___67688 = G__67689;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((0) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((0)),(0),null)):null);
return devtools.core.feature_available_QMARK_.cljs$core$IFn$_invoke$arity$variadic(argseq__28504__auto__);
});

devtools.core.feature_available_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (features){
return cljs.core.every_QMARK_.call(null,devtools.core.single_feature_available_QMARK_,features);
});

devtools.core.feature_available_QMARK_.cljs$lang$maxFixedArity = (0);

devtools.core.feature_available_QMARK_.cljs$lang$applyTo = (function (seq67686){
return devtools.core.feature_available_QMARK_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq67686));
});

devtools.core.enable_BANG_ = (function devtools$core$enable_BANG_(){
return console.warn([cljs.core.str("devtools.core/enable! was deprecated "),cljs.core.str("and has no effect in current version of cljs-devtools "),cljs.core.str("=> remove the call")].join(''));
});
devtools.core.disable_BANG_ = (function devtools$core$disable_BANG_(){
return console.warn([cljs.core.str("devtools.core/disable! was deprecated "),cljs.core.str("and has no effect in current version of cljs-devtools "),cljs.core.str("=> remove the call")].join(''));
});

//# sourceMappingURL=core.js.map?rel=1479956915516