// Compiled by ClojureScript 1.9.293 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__27280__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__27280__auto__){
return or__27280__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__27280__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__70116_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__70116_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__70121 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__70122 = null;
var count__70123 = (0);
var i__70124 = (0);
while(true){
if((i__70124 < count__70123)){
var n = cljs.core._nth.call(null,chunk__70122,i__70124);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__70125 = seq__70121;
var G__70126 = chunk__70122;
var G__70127 = count__70123;
var G__70128 = (i__70124 + (1));
seq__70121 = G__70125;
chunk__70122 = G__70126;
count__70123 = G__70127;
i__70124 = G__70128;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__70121);
if(temp__6753__auto__){
var seq__70121__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__70121__$1)){
var c__28186__auto__ = cljs.core.chunk_first.call(null,seq__70121__$1);
var G__70129 = cljs.core.chunk_rest.call(null,seq__70121__$1);
var G__70130 = c__28186__auto__;
var G__70131 = cljs.core.count.call(null,c__28186__auto__);
var G__70132 = (0);
seq__70121 = G__70129;
chunk__70122 = G__70130;
count__70123 = G__70131;
i__70124 = G__70132;
continue;
} else {
var n = cljs.core.first.call(null,seq__70121__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__70133 = cljs.core.next.call(null,seq__70121__$1);
var G__70134 = null;
var G__70135 = (0);
var G__70136 = (0);
seq__70121 = G__70133;
chunk__70122 = G__70134;
count__70123 = G__70135;
i__70124 = G__70136;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__70187_70198 = cljs.core.seq.call(null,deps);
var chunk__70188_70199 = null;
var count__70189_70200 = (0);
var i__70190_70201 = (0);
while(true){
if((i__70190_70201 < count__70189_70200)){
var dep_70202 = cljs.core._nth.call(null,chunk__70188_70199,i__70190_70201);
topo_sort_helper_STAR_.call(null,dep_70202,(depth + (1)),state);

var G__70203 = seq__70187_70198;
var G__70204 = chunk__70188_70199;
var G__70205 = count__70189_70200;
var G__70206 = (i__70190_70201 + (1));
seq__70187_70198 = G__70203;
chunk__70188_70199 = G__70204;
count__70189_70200 = G__70205;
i__70190_70201 = G__70206;
continue;
} else {
var temp__6753__auto___70207 = cljs.core.seq.call(null,seq__70187_70198);
if(temp__6753__auto___70207){
var seq__70187_70208__$1 = temp__6753__auto___70207;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__70187_70208__$1)){
var c__28186__auto___70209 = cljs.core.chunk_first.call(null,seq__70187_70208__$1);
var G__70210 = cljs.core.chunk_rest.call(null,seq__70187_70208__$1);
var G__70211 = c__28186__auto___70209;
var G__70212 = cljs.core.count.call(null,c__28186__auto___70209);
var G__70213 = (0);
seq__70187_70198 = G__70210;
chunk__70188_70199 = G__70211;
count__70189_70200 = G__70212;
i__70190_70201 = G__70213;
continue;
} else {
var dep_70214 = cljs.core.first.call(null,seq__70187_70208__$1);
topo_sort_helper_STAR_.call(null,dep_70214,(depth + (1)),state);

var G__70215 = cljs.core.next.call(null,seq__70187_70208__$1);
var G__70216 = null;
var G__70217 = (0);
var G__70218 = (0);
seq__70187_70198 = G__70215;
chunk__70188_70199 = G__70216;
count__70189_70200 = G__70217;
i__70190_70201 = G__70218;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__70191){
var vec__70195 = p__70191;
var seq__70196 = cljs.core.seq.call(null,vec__70195);
var first__70197 = cljs.core.first.call(null,seq__70196);
var seq__70196__$1 = cljs.core.next.call(null,seq__70196);
var x = first__70197;
var xs = seq__70196__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__70195,seq__70196,first__70197,seq__70196__$1,x,xs,get_deps__$1){
return (function (p1__70137_SHARP_){
return clojure.set.difference.call(null,p1__70137_SHARP_,x);
});})(vec__70195,seq__70196,first__70197,seq__70196__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__70231 = cljs.core.seq.call(null,provides);
var chunk__70232 = null;
var count__70233 = (0);
var i__70234 = (0);
while(true){
if((i__70234 < count__70233)){
var prov = cljs.core._nth.call(null,chunk__70232,i__70234);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__70235_70243 = cljs.core.seq.call(null,requires);
var chunk__70236_70244 = null;
var count__70237_70245 = (0);
var i__70238_70246 = (0);
while(true){
if((i__70238_70246 < count__70237_70245)){
var req_70247 = cljs.core._nth.call(null,chunk__70236_70244,i__70238_70246);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_70247,prov);

var G__70248 = seq__70235_70243;
var G__70249 = chunk__70236_70244;
var G__70250 = count__70237_70245;
var G__70251 = (i__70238_70246 + (1));
seq__70235_70243 = G__70248;
chunk__70236_70244 = G__70249;
count__70237_70245 = G__70250;
i__70238_70246 = G__70251;
continue;
} else {
var temp__6753__auto___70252 = cljs.core.seq.call(null,seq__70235_70243);
if(temp__6753__auto___70252){
var seq__70235_70253__$1 = temp__6753__auto___70252;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__70235_70253__$1)){
var c__28186__auto___70254 = cljs.core.chunk_first.call(null,seq__70235_70253__$1);
var G__70255 = cljs.core.chunk_rest.call(null,seq__70235_70253__$1);
var G__70256 = c__28186__auto___70254;
var G__70257 = cljs.core.count.call(null,c__28186__auto___70254);
var G__70258 = (0);
seq__70235_70243 = G__70255;
chunk__70236_70244 = G__70256;
count__70237_70245 = G__70257;
i__70238_70246 = G__70258;
continue;
} else {
var req_70259 = cljs.core.first.call(null,seq__70235_70253__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_70259,prov);

var G__70260 = cljs.core.next.call(null,seq__70235_70253__$1);
var G__70261 = null;
var G__70262 = (0);
var G__70263 = (0);
seq__70235_70243 = G__70260;
chunk__70236_70244 = G__70261;
count__70237_70245 = G__70262;
i__70238_70246 = G__70263;
continue;
}
} else {
}
}
break;
}

var G__70264 = seq__70231;
var G__70265 = chunk__70232;
var G__70266 = count__70233;
var G__70267 = (i__70234 + (1));
seq__70231 = G__70264;
chunk__70232 = G__70265;
count__70233 = G__70266;
i__70234 = G__70267;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__70231);
if(temp__6753__auto__){
var seq__70231__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__70231__$1)){
var c__28186__auto__ = cljs.core.chunk_first.call(null,seq__70231__$1);
var G__70268 = cljs.core.chunk_rest.call(null,seq__70231__$1);
var G__70269 = c__28186__auto__;
var G__70270 = cljs.core.count.call(null,c__28186__auto__);
var G__70271 = (0);
seq__70231 = G__70268;
chunk__70232 = G__70269;
count__70233 = G__70270;
i__70234 = G__70271;
continue;
} else {
var prov = cljs.core.first.call(null,seq__70231__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__70239_70272 = cljs.core.seq.call(null,requires);
var chunk__70240_70273 = null;
var count__70241_70274 = (0);
var i__70242_70275 = (0);
while(true){
if((i__70242_70275 < count__70241_70274)){
var req_70276 = cljs.core._nth.call(null,chunk__70240_70273,i__70242_70275);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_70276,prov);

var G__70277 = seq__70239_70272;
var G__70278 = chunk__70240_70273;
var G__70279 = count__70241_70274;
var G__70280 = (i__70242_70275 + (1));
seq__70239_70272 = G__70277;
chunk__70240_70273 = G__70278;
count__70241_70274 = G__70279;
i__70242_70275 = G__70280;
continue;
} else {
var temp__6753__auto___70281__$1 = cljs.core.seq.call(null,seq__70239_70272);
if(temp__6753__auto___70281__$1){
var seq__70239_70282__$1 = temp__6753__auto___70281__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__70239_70282__$1)){
var c__28186__auto___70283 = cljs.core.chunk_first.call(null,seq__70239_70282__$1);
var G__70284 = cljs.core.chunk_rest.call(null,seq__70239_70282__$1);
var G__70285 = c__28186__auto___70283;
var G__70286 = cljs.core.count.call(null,c__28186__auto___70283);
var G__70287 = (0);
seq__70239_70272 = G__70284;
chunk__70240_70273 = G__70285;
count__70241_70274 = G__70286;
i__70242_70275 = G__70287;
continue;
} else {
var req_70288 = cljs.core.first.call(null,seq__70239_70282__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_70288,prov);

var G__70289 = cljs.core.next.call(null,seq__70239_70282__$1);
var G__70290 = null;
var G__70291 = (0);
var G__70292 = (0);
seq__70239_70272 = G__70289;
chunk__70240_70273 = G__70290;
count__70241_70274 = G__70291;
i__70242_70275 = G__70292;
continue;
}
} else {
}
}
break;
}

var G__70293 = cljs.core.next.call(null,seq__70231__$1);
var G__70294 = null;
var G__70295 = (0);
var G__70296 = (0);
seq__70231 = G__70293;
chunk__70232 = G__70294;
count__70233 = G__70295;
i__70234 = G__70296;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__70301_70305 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__70302_70306 = null;
var count__70303_70307 = (0);
var i__70304_70308 = (0);
while(true){
if((i__70304_70308 < count__70303_70307)){
var ns_70309 = cljs.core._nth.call(null,chunk__70302_70306,i__70304_70308);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_70309);

var G__70310 = seq__70301_70305;
var G__70311 = chunk__70302_70306;
var G__70312 = count__70303_70307;
var G__70313 = (i__70304_70308 + (1));
seq__70301_70305 = G__70310;
chunk__70302_70306 = G__70311;
count__70303_70307 = G__70312;
i__70304_70308 = G__70313;
continue;
} else {
var temp__6753__auto___70314 = cljs.core.seq.call(null,seq__70301_70305);
if(temp__6753__auto___70314){
var seq__70301_70315__$1 = temp__6753__auto___70314;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__70301_70315__$1)){
var c__28186__auto___70316 = cljs.core.chunk_first.call(null,seq__70301_70315__$1);
var G__70317 = cljs.core.chunk_rest.call(null,seq__70301_70315__$1);
var G__70318 = c__28186__auto___70316;
var G__70319 = cljs.core.count.call(null,c__28186__auto___70316);
var G__70320 = (0);
seq__70301_70305 = G__70317;
chunk__70302_70306 = G__70318;
count__70303_70307 = G__70319;
i__70304_70308 = G__70320;
continue;
} else {
var ns_70321 = cljs.core.first.call(null,seq__70301_70315__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_70321);

var G__70322 = cljs.core.next.call(null,seq__70301_70315__$1);
var G__70323 = null;
var G__70324 = (0);
var G__70325 = (0);
seq__70301_70305 = G__70322;
chunk__70302_70306 = G__70323;
count__70303_70307 = G__70324;
i__70304_70308 = G__70325;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__27280__auto__ = goog.require__;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__70326__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__70326 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__70327__i = 0, G__70327__a = new Array(arguments.length -  0);
while (G__70327__i < G__70327__a.length) {G__70327__a[G__70327__i] = arguments[G__70327__i + 0]; ++G__70327__i;}
  args = new cljs.core.IndexedSeq(G__70327__a,0);
} 
return G__70326__delegate.call(this,args);};
G__70326.cljs$lang$maxFixedArity = 0;
G__70326.cljs$lang$applyTo = (function (arglist__70328){
var args = cljs.core.seq(arglist__70328);
return G__70326__delegate(args);
});
G__70326.cljs$core$IFn$_invoke$arity$variadic = G__70326__delegate;
return G__70326;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__70330 = cljs.core._EQ_;
var expr__70331 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__70330.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__70331))){
var path_parts = ((function (pred__70330,expr__70331){
return (function (p1__70329_SHARP_){
return clojure.string.split.call(null,p1__70329_SHARP_,/[\/\\]/);
});})(pred__70330,expr__70331))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__70330,expr__70331){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e70333){if((e70333 instanceof Error)){
var e = e70333;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e70333;

}
}})());
});
;})(path_parts,sep,root,pred__70330,expr__70331))
} else {
if(cljs.core.truth_(pred__70330.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__70331))){
return ((function (pred__70330,expr__70331){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
deferred.addCallback(((function (deferred,pred__70330,expr__70331){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__70330,expr__70331))
);

return deferred.addErrback(((function (deferred,pred__70330,expr__70331){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__70330,expr__70331))
);
});
;})(pred__70330,expr__70331))
} else {
return ((function (pred__70330,expr__70331){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__70330,expr__70331))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__70334,callback){
var map__70337 = p__70334;
var map__70337__$1 = ((((!((map__70337 == null)))?((((map__70337.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70337.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70337):map__70337);
var file_msg = map__70337__$1;
var request_url = cljs.core.get.call(null,map__70337__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__70337,map__70337__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__70337,map__70337__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__41822__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto__){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto__){
return (function (state_70361){
var state_val_70362 = (state_70361[(1)]);
if((state_val_70362 === (7))){
var inst_70357 = (state_70361[(2)]);
var state_70361__$1 = state_70361;
var statearr_70363_70383 = state_70361__$1;
(statearr_70363_70383[(2)] = inst_70357);

(statearr_70363_70383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70362 === (1))){
var state_70361__$1 = state_70361;
var statearr_70364_70384 = state_70361__$1;
(statearr_70364_70384[(2)] = null);

(statearr_70364_70384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70362 === (4))){
var inst_70341 = (state_70361[(7)]);
var inst_70341__$1 = (state_70361[(2)]);
var state_70361__$1 = (function (){var statearr_70365 = state_70361;
(statearr_70365[(7)] = inst_70341__$1);

return statearr_70365;
})();
if(cljs.core.truth_(inst_70341__$1)){
var statearr_70366_70385 = state_70361__$1;
(statearr_70366_70385[(1)] = (5));

} else {
var statearr_70367_70386 = state_70361__$1;
(statearr_70367_70386[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70362 === (6))){
var state_70361__$1 = state_70361;
var statearr_70368_70387 = state_70361__$1;
(statearr_70368_70387[(2)] = null);

(statearr_70368_70387[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70362 === (3))){
var inst_70359 = (state_70361[(2)]);
var state_70361__$1 = state_70361;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70361__$1,inst_70359);
} else {
if((state_val_70362 === (2))){
var state_70361__$1 = state_70361;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70361__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_70362 === (11))){
var inst_70353 = (state_70361[(2)]);
var state_70361__$1 = (function (){var statearr_70369 = state_70361;
(statearr_70369[(8)] = inst_70353);

return statearr_70369;
})();
var statearr_70370_70388 = state_70361__$1;
(statearr_70370_70388[(2)] = null);

(statearr_70370_70388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70362 === (9))){
var inst_70347 = (state_70361[(9)]);
var inst_70345 = (state_70361[(10)]);
var inst_70349 = inst_70347.call(null,inst_70345);
var state_70361__$1 = state_70361;
var statearr_70371_70389 = state_70361__$1;
(statearr_70371_70389[(2)] = inst_70349);

(statearr_70371_70389[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70362 === (5))){
var inst_70341 = (state_70361[(7)]);
var inst_70343 = figwheel.client.file_reloading.blocking_load.call(null,inst_70341);
var state_70361__$1 = state_70361;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70361__$1,(8),inst_70343);
} else {
if((state_val_70362 === (10))){
var inst_70345 = (state_70361[(10)]);
var inst_70351 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_70345);
var state_70361__$1 = state_70361;
var statearr_70372_70390 = state_70361__$1;
(statearr_70372_70390[(2)] = inst_70351);

(statearr_70372_70390[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70362 === (8))){
var inst_70341 = (state_70361[(7)]);
var inst_70347 = (state_70361[(9)]);
var inst_70345 = (state_70361[(2)]);
var inst_70346 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_70347__$1 = cljs.core.get.call(null,inst_70346,inst_70341);
var state_70361__$1 = (function (){var statearr_70373 = state_70361;
(statearr_70373[(9)] = inst_70347__$1);

(statearr_70373[(10)] = inst_70345);

return statearr_70373;
})();
if(cljs.core.truth_(inst_70347__$1)){
var statearr_70374_70391 = state_70361__$1;
(statearr_70374_70391[(1)] = (9));

} else {
var statearr_70375_70392 = state_70361__$1;
(statearr_70375_70392[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto__))
;
return ((function (switch__41805__auto__,c__41822__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__41806__auto__ = null;
var figwheel$client$file_reloading$state_machine__41806__auto____0 = (function (){
var statearr_70379 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_70379[(0)] = figwheel$client$file_reloading$state_machine__41806__auto__);

(statearr_70379[(1)] = (1));

return statearr_70379;
});
var figwheel$client$file_reloading$state_machine__41806__auto____1 = (function (state_70361){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_70361);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e70380){if((e70380 instanceof Object)){
var ex__41809__auto__ = e70380;
var statearr_70381_70393 = state_70361;
(statearr_70381_70393[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_70361);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e70380;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70394 = state_70361;
state_70361 = G__70394;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__41806__auto__ = function(state_70361){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__41806__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__41806__auto____1.call(this,state_70361);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__41806__auto____0;
figwheel$client$file_reloading$state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__41806__auto____1;
return figwheel$client$file_reloading$state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto__))
})();
var state__41824__auto__ = (function (){var statearr_70382 = f__41823__auto__.call(null);
(statearr_70382[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto__);

return statearr_70382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto__))
);

return c__41822__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__70395,callback){
var map__70398 = p__70395;
var map__70398__$1 = ((((!((map__70398 == null)))?((((map__70398.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70398.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70398):map__70398);
var file_msg = map__70398__$1;
var namespace = cljs.core.get.call(null,map__70398__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__70398,map__70398__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__70398,map__70398__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__70400){
var map__70403 = p__70400;
var map__70403__$1 = ((((!((map__70403 == null)))?((((map__70403.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70403.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70403):map__70403);
var file_msg = map__70403__$1;
var namespace = cljs.core.get.call(null,map__70403__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__27268__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__27268__auto__){
var or__27280__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
var or__27280__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__27280__auto____$1)){
return or__27280__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__27268__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__70405,callback){
var map__70408 = p__70405;
var map__70408__$1 = ((((!((map__70408 == null)))?((((map__70408.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70408.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70408):map__70408);
var file_msg = map__70408__$1;
var request_url = cljs.core.get.call(null,map__70408__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__70408__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__41822__auto___70512 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___70512,out){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___70512,out){
return (function (state_70494){
var state_val_70495 = (state_70494[(1)]);
if((state_val_70495 === (1))){
var inst_70468 = cljs.core.seq.call(null,files);
var inst_70469 = cljs.core.first.call(null,inst_70468);
var inst_70470 = cljs.core.next.call(null,inst_70468);
var inst_70471 = files;
var state_70494__$1 = (function (){var statearr_70496 = state_70494;
(statearr_70496[(7)] = inst_70469);

(statearr_70496[(8)] = inst_70470);

(statearr_70496[(9)] = inst_70471);

return statearr_70496;
})();
var statearr_70497_70513 = state_70494__$1;
(statearr_70497_70513[(2)] = null);

(statearr_70497_70513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70495 === (2))){
var inst_70477 = (state_70494[(10)]);
var inst_70471 = (state_70494[(9)]);
var inst_70476 = cljs.core.seq.call(null,inst_70471);
var inst_70477__$1 = cljs.core.first.call(null,inst_70476);
var inst_70478 = cljs.core.next.call(null,inst_70476);
var inst_70479 = (inst_70477__$1 == null);
var inst_70480 = cljs.core.not.call(null,inst_70479);
var state_70494__$1 = (function (){var statearr_70498 = state_70494;
(statearr_70498[(11)] = inst_70478);

(statearr_70498[(10)] = inst_70477__$1);

return statearr_70498;
})();
if(inst_70480){
var statearr_70499_70514 = state_70494__$1;
(statearr_70499_70514[(1)] = (4));

} else {
var statearr_70500_70515 = state_70494__$1;
(statearr_70500_70515[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70495 === (3))){
var inst_70492 = (state_70494[(2)]);
var state_70494__$1 = state_70494;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70494__$1,inst_70492);
} else {
if((state_val_70495 === (4))){
var inst_70477 = (state_70494[(10)]);
var inst_70482 = figwheel.client.file_reloading.reload_js_file.call(null,inst_70477);
var state_70494__$1 = state_70494;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70494__$1,(7),inst_70482);
} else {
if((state_val_70495 === (5))){
var inst_70488 = cljs.core.async.close_BANG_.call(null,out);
var state_70494__$1 = state_70494;
var statearr_70501_70516 = state_70494__$1;
(statearr_70501_70516[(2)] = inst_70488);

(statearr_70501_70516[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70495 === (6))){
var inst_70490 = (state_70494[(2)]);
var state_70494__$1 = state_70494;
var statearr_70502_70517 = state_70494__$1;
(statearr_70502_70517[(2)] = inst_70490);

(statearr_70502_70517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70495 === (7))){
var inst_70478 = (state_70494[(11)]);
var inst_70484 = (state_70494[(2)]);
var inst_70485 = cljs.core.async.put_BANG_.call(null,out,inst_70484);
var inst_70471 = inst_70478;
var state_70494__$1 = (function (){var statearr_70503 = state_70494;
(statearr_70503[(12)] = inst_70485);

(statearr_70503[(9)] = inst_70471);

return statearr_70503;
})();
var statearr_70504_70518 = state_70494__$1;
(statearr_70504_70518[(2)] = null);

(statearr_70504_70518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__41822__auto___70512,out))
;
return ((function (switch__41805__auto__,c__41822__auto___70512,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto____0 = (function (){
var statearr_70508 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70508[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto__);

(statearr_70508[(1)] = (1));

return statearr_70508;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto____1 = (function (state_70494){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_70494);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e70509){if((e70509 instanceof Object)){
var ex__41809__auto__ = e70509;
var statearr_70510_70519 = state_70494;
(statearr_70510_70519[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_70494);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e70509;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70520 = state_70494;
state_70494 = G__70520;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto__ = function(state_70494){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto____1.call(this,state_70494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___70512,out))
})();
var state__41824__auto__ = (function (){var statearr_70511 = f__41823__auto__.call(null);
(statearr_70511[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___70512);

return statearr_70511;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___70512,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__70521,opts){
var map__70525 = p__70521;
var map__70525__$1 = ((((!((map__70525 == null)))?((((map__70525.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70525.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70525):map__70525);
var eval_body = cljs.core.get.call(null,map__70525__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__70525__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__27268__auto__ = eval_body;
if(cljs.core.truth_(and__27268__auto__)){
return typeof eval_body === 'string';
} else {
return and__27268__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e70527){var e = e70527;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__6751__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__70528_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__70528_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__6751__auto__)){
var file_msg = temp__6751__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__70537){
var vec__70538 = p__70537;
var k = cljs.core.nth.call(null,vec__70538,(0),null);
var v = cljs.core.nth.call(null,vec__70538,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__70541){
var vec__70542 = p__70541;
var k = cljs.core.nth.call(null,vec__70542,(0),null);
var v = cljs.core.nth.call(null,vec__70542,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__70548,p__70549){
var map__70797 = p__70548;
var map__70797__$1 = ((((!((map__70797 == null)))?((((map__70797.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70797.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70797):map__70797);
var opts = map__70797__$1;
var before_jsload = cljs.core.get.call(null,map__70797__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__70797__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__70797__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__70798 = p__70549;
var map__70798__$1 = ((((!((map__70798 == null)))?((((map__70798.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70798.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70798):map__70798);
var msg = map__70798__$1;
var files = cljs.core.get.call(null,map__70798__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__70798__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__70798__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__41822__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_70952){
var state_val_70953 = (state_70952[(1)]);
if((state_val_70953 === (7))){
var inst_70813 = (state_70952[(7)]);
var inst_70814 = (state_70952[(8)]);
var inst_70812 = (state_70952[(9)]);
var inst_70815 = (state_70952[(10)]);
var inst_70820 = cljs.core._nth.call(null,inst_70813,inst_70815);
var inst_70821 = figwheel.client.file_reloading.eval_body.call(null,inst_70820,opts);
var inst_70822 = (inst_70815 + (1));
var tmp70954 = inst_70813;
var tmp70955 = inst_70814;
var tmp70956 = inst_70812;
var inst_70812__$1 = tmp70956;
var inst_70813__$1 = tmp70954;
var inst_70814__$1 = tmp70955;
var inst_70815__$1 = inst_70822;
var state_70952__$1 = (function (){var statearr_70957 = state_70952;
(statearr_70957[(7)] = inst_70813__$1);

(statearr_70957[(11)] = inst_70821);

(statearr_70957[(8)] = inst_70814__$1);

(statearr_70957[(9)] = inst_70812__$1);

(statearr_70957[(10)] = inst_70815__$1);

return statearr_70957;
})();
var statearr_70958_71044 = state_70952__$1;
(statearr_70958_71044[(2)] = null);

(statearr_70958_71044[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (20))){
var inst_70855 = (state_70952[(12)]);
var inst_70863 = figwheel.client.file_reloading.sort_files.call(null,inst_70855);
var state_70952__$1 = state_70952;
var statearr_70959_71045 = state_70952__$1;
(statearr_70959_71045[(2)] = inst_70863);

(statearr_70959_71045[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (27))){
var state_70952__$1 = state_70952;
var statearr_70960_71046 = state_70952__$1;
(statearr_70960_71046[(2)] = null);

(statearr_70960_71046[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (1))){
var inst_70804 = (state_70952[(13)]);
var inst_70801 = before_jsload.call(null,files);
var inst_70802 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_70803 = (function (){return ((function (inst_70804,inst_70801,inst_70802,state_val_70953,c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__70545_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__70545_SHARP_);
});
;})(inst_70804,inst_70801,inst_70802,state_val_70953,c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_70804__$1 = cljs.core.filter.call(null,inst_70803,files);
var inst_70805 = cljs.core.not_empty.call(null,inst_70804__$1);
var state_70952__$1 = (function (){var statearr_70961 = state_70952;
(statearr_70961[(14)] = inst_70801);

(statearr_70961[(13)] = inst_70804__$1);

(statearr_70961[(15)] = inst_70802);

return statearr_70961;
})();
if(cljs.core.truth_(inst_70805)){
var statearr_70962_71047 = state_70952__$1;
(statearr_70962_71047[(1)] = (2));

} else {
var statearr_70963_71048 = state_70952__$1;
(statearr_70963_71048[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (24))){
var state_70952__$1 = state_70952;
var statearr_70964_71049 = state_70952__$1;
(statearr_70964_71049[(2)] = null);

(statearr_70964_71049[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (39))){
var inst_70905 = (state_70952[(16)]);
var state_70952__$1 = state_70952;
var statearr_70965_71050 = state_70952__$1;
(statearr_70965_71050[(2)] = inst_70905);

(statearr_70965_71050[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (46))){
var inst_70947 = (state_70952[(2)]);
var state_70952__$1 = state_70952;
var statearr_70966_71051 = state_70952__$1;
(statearr_70966_71051[(2)] = inst_70947);

(statearr_70966_71051[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (4))){
var inst_70849 = (state_70952[(2)]);
var inst_70850 = cljs.core.List.EMPTY;
var inst_70851 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_70850);
var inst_70852 = (function (){return ((function (inst_70849,inst_70850,inst_70851,state_val_70953,c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__70546_SHARP_){
var and__27268__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__70546_SHARP_);
if(cljs.core.truth_(and__27268__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__70546_SHARP_));
} else {
return and__27268__auto__;
}
});
;})(inst_70849,inst_70850,inst_70851,state_val_70953,c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_70853 = cljs.core.filter.call(null,inst_70852,files);
var inst_70854 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_70855 = cljs.core.concat.call(null,inst_70853,inst_70854);
var state_70952__$1 = (function (){var statearr_70967 = state_70952;
(statearr_70967[(17)] = inst_70851);

(statearr_70967[(12)] = inst_70855);

(statearr_70967[(18)] = inst_70849);

return statearr_70967;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_70968_71052 = state_70952__$1;
(statearr_70968_71052[(1)] = (16));

} else {
var statearr_70969_71053 = state_70952__$1;
(statearr_70969_71053[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (15))){
var inst_70839 = (state_70952[(2)]);
var state_70952__$1 = state_70952;
var statearr_70970_71054 = state_70952__$1;
(statearr_70970_71054[(2)] = inst_70839);

(statearr_70970_71054[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (21))){
var inst_70865 = (state_70952[(19)]);
var inst_70865__$1 = (state_70952[(2)]);
var inst_70866 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_70865__$1);
var state_70952__$1 = (function (){var statearr_70971 = state_70952;
(statearr_70971[(19)] = inst_70865__$1);

return statearr_70971;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70952__$1,(22),inst_70866);
} else {
if((state_val_70953 === (31))){
var inst_70950 = (state_70952[(2)]);
var state_70952__$1 = state_70952;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70952__$1,inst_70950);
} else {
if((state_val_70953 === (32))){
var inst_70905 = (state_70952[(16)]);
var inst_70910 = inst_70905.cljs$lang$protocol_mask$partition0$;
var inst_70911 = (inst_70910 & (64));
var inst_70912 = inst_70905.cljs$core$ISeq$;
var inst_70913 = (cljs.core.PROTOCOL_SENTINEL === inst_70912);
var inst_70914 = (inst_70911) || (inst_70913);
var state_70952__$1 = state_70952;
if(cljs.core.truth_(inst_70914)){
var statearr_70972_71055 = state_70952__$1;
(statearr_70972_71055[(1)] = (35));

} else {
var statearr_70973_71056 = state_70952__$1;
(statearr_70973_71056[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (40))){
var inst_70927 = (state_70952[(20)]);
var inst_70926 = (state_70952[(2)]);
var inst_70927__$1 = cljs.core.get.call(null,inst_70926,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_70928 = cljs.core.get.call(null,inst_70926,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_70929 = cljs.core.not_empty.call(null,inst_70927__$1);
var state_70952__$1 = (function (){var statearr_70974 = state_70952;
(statearr_70974[(21)] = inst_70928);

(statearr_70974[(20)] = inst_70927__$1);

return statearr_70974;
})();
if(cljs.core.truth_(inst_70929)){
var statearr_70975_71057 = state_70952__$1;
(statearr_70975_71057[(1)] = (41));

} else {
var statearr_70976_71058 = state_70952__$1;
(statearr_70976_71058[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (33))){
var state_70952__$1 = state_70952;
var statearr_70977_71059 = state_70952__$1;
(statearr_70977_71059[(2)] = false);

(statearr_70977_71059[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (13))){
var inst_70825 = (state_70952[(22)]);
var inst_70829 = cljs.core.chunk_first.call(null,inst_70825);
var inst_70830 = cljs.core.chunk_rest.call(null,inst_70825);
var inst_70831 = cljs.core.count.call(null,inst_70829);
var inst_70812 = inst_70830;
var inst_70813 = inst_70829;
var inst_70814 = inst_70831;
var inst_70815 = (0);
var state_70952__$1 = (function (){var statearr_70978 = state_70952;
(statearr_70978[(7)] = inst_70813);

(statearr_70978[(8)] = inst_70814);

(statearr_70978[(9)] = inst_70812);

(statearr_70978[(10)] = inst_70815);

return statearr_70978;
})();
var statearr_70979_71060 = state_70952__$1;
(statearr_70979_71060[(2)] = null);

(statearr_70979_71060[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (22))){
var inst_70868 = (state_70952[(23)]);
var inst_70869 = (state_70952[(24)]);
var inst_70865 = (state_70952[(19)]);
var inst_70873 = (state_70952[(25)]);
var inst_70868__$1 = (state_70952[(2)]);
var inst_70869__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_70868__$1);
var inst_70870 = (function (){var all_files = inst_70865;
var res_SINGLEQUOTE_ = inst_70868__$1;
var res = inst_70869__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_70868,inst_70869,inst_70865,inst_70873,inst_70868__$1,inst_70869__$1,state_val_70953,c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__70547_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__70547_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_70868,inst_70869,inst_70865,inst_70873,inst_70868__$1,inst_70869__$1,state_val_70953,c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_70871 = cljs.core.filter.call(null,inst_70870,inst_70868__$1);
var inst_70872 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_70873__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_70872);
var inst_70874 = cljs.core.not_empty.call(null,inst_70873__$1);
var state_70952__$1 = (function (){var statearr_70980 = state_70952;
(statearr_70980[(23)] = inst_70868__$1);

(statearr_70980[(24)] = inst_70869__$1);

(statearr_70980[(25)] = inst_70873__$1);

(statearr_70980[(26)] = inst_70871);

return statearr_70980;
})();
if(cljs.core.truth_(inst_70874)){
var statearr_70981_71061 = state_70952__$1;
(statearr_70981_71061[(1)] = (23));

} else {
var statearr_70982_71062 = state_70952__$1;
(statearr_70982_71062[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (36))){
var state_70952__$1 = state_70952;
var statearr_70983_71063 = state_70952__$1;
(statearr_70983_71063[(2)] = false);

(statearr_70983_71063[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (41))){
var inst_70927 = (state_70952[(20)]);
var inst_70931 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_70932 = cljs.core.map.call(null,inst_70931,inst_70927);
var inst_70933 = cljs.core.pr_str.call(null,inst_70932);
var inst_70934 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_70933)].join('');
var inst_70935 = figwheel.client.utils.log.call(null,inst_70934);
var state_70952__$1 = state_70952;
var statearr_70984_71064 = state_70952__$1;
(statearr_70984_71064[(2)] = inst_70935);

(statearr_70984_71064[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (43))){
var inst_70928 = (state_70952[(21)]);
var inst_70938 = (state_70952[(2)]);
var inst_70939 = cljs.core.not_empty.call(null,inst_70928);
var state_70952__$1 = (function (){var statearr_70985 = state_70952;
(statearr_70985[(27)] = inst_70938);

return statearr_70985;
})();
if(cljs.core.truth_(inst_70939)){
var statearr_70986_71065 = state_70952__$1;
(statearr_70986_71065[(1)] = (44));

} else {
var statearr_70987_71066 = state_70952__$1;
(statearr_70987_71066[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (29))){
var inst_70905 = (state_70952[(16)]);
var inst_70868 = (state_70952[(23)]);
var inst_70869 = (state_70952[(24)]);
var inst_70865 = (state_70952[(19)]);
var inst_70873 = (state_70952[(25)]);
var inst_70871 = (state_70952[(26)]);
var inst_70901 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_70904 = (function (){var all_files = inst_70865;
var res_SINGLEQUOTE_ = inst_70868;
var res = inst_70869;
var files_not_loaded = inst_70871;
var dependencies_that_loaded = inst_70873;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_70905,inst_70868,inst_70869,inst_70865,inst_70873,inst_70871,inst_70901,state_val_70953,c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__70903){
var map__70988 = p__70903;
var map__70988__$1 = ((((!((map__70988 == null)))?((((map__70988.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__70988.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__70988):map__70988);
var namespace = cljs.core.get.call(null,map__70988__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_70905,inst_70868,inst_70869,inst_70865,inst_70873,inst_70871,inst_70901,state_val_70953,c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_70905__$1 = cljs.core.group_by.call(null,inst_70904,inst_70871);
var inst_70907 = (inst_70905__$1 == null);
var inst_70908 = cljs.core.not.call(null,inst_70907);
var state_70952__$1 = (function (){var statearr_70990 = state_70952;
(statearr_70990[(16)] = inst_70905__$1);

(statearr_70990[(28)] = inst_70901);

return statearr_70990;
})();
if(inst_70908){
var statearr_70991_71067 = state_70952__$1;
(statearr_70991_71067[(1)] = (32));

} else {
var statearr_70992_71068 = state_70952__$1;
(statearr_70992_71068[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (44))){
var inst_70928 = (state_70952[(21)]);
var inst_70941 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_70928);
var inst_70942 = cljs.core.pr_str.call(null,inst_70941);
var inst_70943 = [cljs.core.str("not required: "),cljs.core.str(inst_70942)].join('');
var inst_70944 = figwheel.client.utils.log.call(null,inst_70943);
var state_70952__$1 = state_70952;
var statearr_70993_71069 = state_70952__$1;
(statearr_70993_71069[(2)] = inst_70944);

(statearr_70993_71069[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (6))){
var inst_70846 = (state_70952[(2)]);
var state_70952__$1 = state_70952;
var statearr_70994_71070 = state_70952__$1;
(statearr_70994_71070[(2)] = inst_70846);

(statearr_70994_71070[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (28))){
var inst_70871 = (state_70952[(26)]);
var inst_70898 = (state_70952[(2)]);
var inst_70899 = cljs.core.not_empty.call(null,inst_70871);
var state_70952__$1 = (function (){var statearr_70995 = state_70952;
(statearr_70995[(29)] = inst_70898);

return statearr_70995;
})();
if(cljs.core.truth_(inst_70899)){
var statearr_70996_71071 = state_70952__$1;
(statearr_70996_71071[(1)] = (29));

} else {
var statearr_70997_71072 = state_70952__$1;
(statearr_70997_71072[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (25))){
var inst_70869 = (state_70952[(24)]);
var inst_70885 = (state_70952[(2)]);
var inst_70886 = cljs.core.not_empty.call(null,inst_70869);
var state_70952__$1 = (function (){var statearr_70998 = state_70952;
(statearr_70998[(30)] = inst_70885);

return statearr_70998;
})();
if(cljs.core.truth_(inst_70886)){
var statearr_70999_71073 = state_70952__$1;
(statearr_70999_71073[(1)] = (26));

} else {
var statearr_71000_71074 = state_70952__$1;
(statearr_71000_71074[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (34))){
var inst_70921 = (state_70952[(2)]);
var state_70952__$1 = state_70952;
if(cljs.core.truth_(inst_70921)){
var statearr_71001_71075 = state_70952__$1;
(statearr_71001_71075[(1)] = (38));

} else {
var statearr_71002_71076 = state_70952__$1;
(statearr_71002_71076[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (17))){
var state_70952__$1 = state_70952;
var statearr_71003_71077 = state_70952__$1;
(statearr_71003_71077[(2)] = recompile_dependents);

(statearr_71003_71077[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (3))){
var state_70952__$1 = state_70952;
var statearr_71004_71078 = state_70952__$1;
(statearr_71004_71078[(2)] = null);

(statearr_71004_71078[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (12))){
var inst_70842 = (state_70952[(2)]);
var state_70952__$1 = state_70952;
var statearr_71005_71079 = state_70952__$1;
(statearr_71005_71079[(2)] = inst_70842);

(statearr_71005_71079[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (2))){
var inst_70804 = (state_70952[(13)]);
var inst_70811 = cljs.core.seq.call(null,inst_70804);
var inst_70812 = inst_70811;
var inst_70813 = null;
var inst_70814 = (0);
var inst_70815 = (0);
var state_70952__$1 = (function (){var statearr_71006 = state_70952;
(statearr_71006[(7)] = inst_70813);

(statearr_71006[(8)] = inst_70814);

(statearr_71006[(9)] = inst_70812);

(statearr_71006[(10)] = inst_70815);

return statearr_71006;
})();
var statearr_71007_71080 = state_70952__$1;
(statearr_71007_71080[(2)] = null);

(statearr_71007_71080[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (23))){
var inst_70868 = (state_70952[(23)]);
var inst_70869 = (state_70952[(24)]);
var inst_70865 = (state_70952[(19)]);
var inst_70873 = (state_70952[(25)]);
var inst_70871 = (state_70952[(26)]);
var inst_70876 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_70878 = (function (){var all_files = inst_70865;
var res_SINGLEQUOTE_ = inst_70868;
var res = inst_70869;
var files_not_loaded = inst_70871;
var dependencies_that_loaded = inst_70873;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_70868,inst_70869,inst_70865,inst_70873,inst_70871,inst_70876,state_val_70953,c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__70877){
var map__71008 = p__70877;
var map__71008__$1 = ((((!((map__71008 == null)))?((((map__71008.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71008.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71008):map__71008);
var request_url = cljs.core.get.call(null,map__71008__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_70868,inst_70869,inst_70865,inst_70873,inst_70871,inst_70876,state_val_70953,c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_70879 = cljs.core.reverse.call(null,inst_70873);
var inst_70880 = cljs.core.map.call(null,inst_70878,inst_70879);
var inst_70881 = cljs.core.pr_str.call(null,inst_70880);
var inst_70882 = figwheel.client.utils.log.call(null,inst_70881);
var state_70952__$1 = (function (){var statearr_71010 = state_70952;
(statearr_71010[(31)] = inst_70876);

return statearr_71010;
})();
var statearr_71011_71081 = state_70952__$1;
(statearr_71011_71081[(2)] = inst_70882);

(statearr_71011_71081[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (35))){
var state_70952__$1 = state_70952;
var statearr_71012_71082 = state_70952__$1;
(statearr_71012_71082[(2)] = true);

(statearr_71012_71082[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (19))){
var inst_70855 = (state_70952[(12)]);
var inst_70861 = figwheel.client.file_reloading.expand_files.call(null,inst_70855);
var state_70952__$1 = state_70952;
var statearr_71013_71083 = state_70952__$1;
(statearr_71013_71083[(2)] = inst_70861);

(statearr_71013_71083[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (11))){
var state_70952__$1 = state_70952;
var statearr_71014_71084 = state_70952__$1;
(statearr_71014_71084[(2)] = null);

(statearr_71014_71084[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (9))){
var inst_70844 = (state_70952[(2)]);
var state_70952__$1 = state_70952;
var statearr_71015_71085 = state_70952__$1;
(statearr_71015_71085[(2)] = inst_70844);

(statearr_71015_71085[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (5))){
var inst_70814 = (state_70952[(8)]);
var inst_70815 = (state_70952[(10)]);
var inst_70817 = (inst_70815 < inst_70814);
var inst_70818 = inst_70817;
var state_70952__$1 = state_70952;
if(cljs.core.truth_(inst_70818)){
var statearr_71016_71086 = state_70952__$1;
(statearr_71016_71086[(1)] = (7));

} else {
var statearr_71017_71087 = state_70952__$1;
(statearr_71017_71087[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (14))){
var inst_70825 = (state_70952[(22)]);
var inst_70834 = cljs.core.first.call(null,inst_70825);
var inst_70835 = figwheel.client.file_reloading.eval_body.call(null,inst_70834,opts);
var inst_70836 = cljs.core.next.call(null,inst_70825);
var inst_70812 = inst_70836;
var inst_70813 = null;
var inst_70814 = (0);
var inst_70815 = (0);
var state_70952__$1 = (function (){var statearr_71018 = state_70952;
(statearr_71018[(7)] = inst_70813);

(statearr_71018[(8)] = inst_70814);

(statearr_71018[(9)] = inst_70812);

(statearr_71018[(10)] = inst_70815);

(statearr_71018[(32)] = inst_70835);

return statearr_71018;
})();
var statearr_71019_71088 = state_70952__$1;
(statearr_71019_71088[(2)] = null);

(statearr_71019_71088[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (45))){
var state_70952__$1 = state_70952;
var statearr_71020_71089 = state_70952__$1;
(statearr_71020_71089[(2)] = null);

(statearr_71020_71089[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (26))){
var inst_70868 = (state_70952[(23)]);
var inst_70869 = (state_70952[(24)]);
var inst_70865 = (state_70952[(19)]);
var inst_70873 = (state_70952[(25)]);
var inst_70871 = (state_70952[(26)]);
var inst_70888 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_70890 = (function (){var all_files = inst_70865;
var res_SINGLEQUOTE_ = inst_70868;
var res = inst_70869;
var files_not_loaded = inst_70871;
var dependencies_that_loaded = inst_70873;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_70868,inst_70869,inst_70865,inst_70873,inst_70871,inst_70888,state_val_70953,c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__70889){
var map__71021 = p__70889;
var map__71021__$1 = ((((!((map__71021 == null)))?((((map__71021.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71021.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71021):map__71021);
var namespace = cljs.core.get.call(null,map__71021__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__71021__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_70868,inst_70869,inst_70865,inst_70873,inst_70871,inst_70888,state_val_70953,c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_70891 = cljs.core.map.call(null,inst_70890,inst_70869);
var inst_70892 = cljs.core.pr_str.call(null,inst_70891);
var inst_70893 = figwheel.client.utils.log.call(null,inst_70892);
var inst_70894 = (function (){var all_files = inst_70865;
var res_SINGLEQUOTE_ = inst_70868;
var res = inst_70869;
var files_not_loaded = inst_70871;
var dependencies_that_loaded = inst_70873;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_70868,inst_70869,inst_70865,inst_70873,inst_70871,inst_70888,inst_70890,inst_70891,inst_70892,inst_70893,state_val_70953,c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_70868,inst_70869,inst_70865,inst_70873,inst_70871,inst_70888,inst_70890,inst_70891,inst_70892,inst_70893,state_val_70953,c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_70895 = setTimeout(inst_70894,(10));
var state_70952__$1 = (function (){var statearr_71023 = state_70952;
(statearr_71023[(33)] = inst_70893);

(statearr_71023[(34)] = inst_70888);

return statearr_71023;
})();
var statearr_71024_71090 = state_70952__$1;
(statearr_71024_71090[(2)] = inst_70895);

(statearr_71024_71090[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (16))){
var state_70952__$1 = state_70952;
var statearr_71025_71091 = state_70952__$1;
(statearr_71025_71091[(2)] = reload_dependents);

(statearr_71025_71091[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (38))){
var inst_70905 = (state_70952[(16)]);
var inst_70923 = cljs.core.apply.call(null,cljs.core.hash_map,inst_70905);
var state_70952__$1 = state_70952;
var statearr_71026_71092 = state_70952__$1;
(statearr_71026_71092[(2)] = inst_70923);

(statearr_71026_71092[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (30))){
var state_70952__$1 = state_70952;
var statearr_71027_71093 = state_70952__$1;
(statearr_71027_71093[(2)] = null);

(statearr_71027_71093[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (10))){
var inst_70825 = (state_70952[(22)]);
var inst_70827 = cljs.core.chunked_seq_QMARK_.call(null,inst_70825);
var state_70952__$1 = state_70952;
if(inst_70827){
var statearr_71028_71094 = state_70952__$1;
(statearr_71028_71094[(1)] = (13));

} else {
var statearr_71029_71095 = state_70952__$1;
(statearr_71029_71095[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (18))){
var inst_70859 = (state_70952[(2)]);
var state_70952__$1 = state_70952;
if(cljs.core.truth_(inst_70859)){
var statearr_71030_71096 = state_70952__$1;
(statearr_71030_71096[(1)] = (19));

} else {
var statearr_71031_71097 = state_70952__$1;
(statearr_71031_71097[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (42))){
var state_70952__$1 = state_70952;
var statearr_71032_71098 = state_70952__$1;
(statearr_71032_71098[(2)] = null);

(statearr_71032_71098[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (37))){
var inst_70918 = (state_70952[(2)]);
var state_70952__$1 = state_70952;
var statearr_71033_71099 = state_70952__$1;
(statearr_71033_71099[(2)] = inst_70918);

(statearr_71033_71099[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70953 === (8))){
var inst_70825 = (state_70952[(22)]);
var inst_70812 = (state_70952[(9)]);
var inst_70825__$1 = cljs.core.seq.call(null,inst_70812);
var state_70952__$1 = (function (){var statearr_71034 = state_70952;
(statearr_71034[(22)] = inst_70825__$1);

return statearr_71034;
})();
if(inst_70825__$1){
var statearr_71035_71100 = state_70952__$1;
(statearr_71035_71100[(1)] = (10));

} else {
var statearr_71036_71101 = state_70952__$1;
(statearr_71036_71101[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__41805__auto__,c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto____0 = (function (){
var statearr_71040 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71040[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto__);

(statearr_71040[(1)] = (1));

return statearr_71040;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto____1 = (function (state_70952){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_70952);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e71041){if((e71041 instanceof Object)){
var ex__41809__auto__ = e71041;
var statearr_71042_71102 = state_70952;
(statearr_71042_71102[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_70952);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71041;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71103 = state_70952;
state_70952 = G__71103;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto__ = function(state_70952){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto____1.call(this,state_70952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__41824__auto__ = (function (){var statearr_71043 = f__41823__auto__.call(null);
(statearr_71043[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto__);

return statearr_71043;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto__,map__70797,map__70797__$1,opts,before_jsload,on_jsload,reload_dependents,map__70798,map__70798__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__41822__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__71106,link){
var map__71109 = p__71106;
var map__71109__$1 = ((((!((map__71109 == null)))?((((map__71109.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71109.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71109):map__71109);
var file = cljs.core.get.call(null,map__71109__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = link.href;
if(cljs.core.truth_(temp__6753__auto__)){
var link_href = temp__6753__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__6753__auto__,map__71109,map__71109__$1,file){
return (function (p1__71104_SHARP_,p2__71105_SHARP_){
if(cljs.core._EQ_.call(null,p1__71104_SHARP_,p2__71105_SHARP_)){
return p1__71104_SHARP_;
} else {
return false;
}
});})(link_href,temp__6753__auto__,map__71109,map__71109__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__6753__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__71115){
var map__71116 = p__71115;
var map__71116__$1 = ((((!((map__71116 == null)))?((((map__71116.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71116.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71116):map__71116);
var match_length = cljs.core.get.call(null,map__71116__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__71116__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__71111_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__71111_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__6753__auto__)){
var res = temp__6753__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args71118 = [];
var len__28496__auto___71121 = arguments.length;
var i__28497__auto___71122 = (0);
while(true){
if((i__28497__auto___71122 < len__28496__auto___71121)){
args71118.push((arguments[i__28497__auto___71122]));

var G__71123 = (i__28497__auto___71122 + (1));
i__28497__auto___71122 = G__71123;
continue;
} else {
}
break;
}

var G__71120 = args71118.length;
switch (G__71120) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args71118.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__71125_SHARP_,p2__71126_SHARP_){
return cljs.core.assoc.call(null,p1__71125_SHARP_,cljs.core.get.call(null,p2__71126_SHARP_,key),p2__71126_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__71127){
var map__71130 = p__71127;
var map__71130__$1 = ((((!((map__71130 == null)))?((((map__71130.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71130.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71130):map__71130);
var f_data = map__71130__$1;
var file = cljs.core.get.call(null,map__71130__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__6753__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__6753__auto__)){
var link = temp__6753__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__71132,p__71133){
var map__71142 = p__71132;
var map__71142__$1 = ((((!((map__71142 == null)))?((((map__71142.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71142.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71142):map__71142);
var opts = map__71142__$1;
var on_cssload = cljs.core.get.call(null,map__71142__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__71143 = p__71133;
var map__71143__$1 = ((((!((map__71143 == null)))?((((map__71143.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71143.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71143):map__71143);
var files_msg = map__71143__$1;
var files = cljs.core.get.call(null,map__71143__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__71146_71150 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
var chunk__71147_71151 = null;
var count__71148_71152 = (0);
var i__71149_71153 = (0);
while(true){
if((i__71149_71153 < count__71148_71152)){
var f_71154 = cljs.core._nth.call(null,chunk__71147_71151,i__71149_71153);
figwheel.client.file_reloading.reload_css_file.call(null,f_71154);

var G__71155 = seq__71146_71150;
var G__71156 = chunk__71147_71151;
var G__71157 = count__71148_71152;
var G__71158 = (i__71149_71153 + (1));
seq__71146_71150 = G__71155;
chunk__71147_71151 = G__71156;
count__71148_71152 = G__71157;
i__71149_71153 = G__71158;
continue;
} else {
var temp__6753__auto___71159 = cljs.core.seq.call(null,seq__71146_71150);
if(temp__6753__auto___71159){
var seq__71146_71160__$1 = temp__6753__auto___71159;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__71146_71160__$1)){
var c__28186__auto___71161 = cljs.core.chunk_first.call(null,seq__71146_71160__$1);
var G__71162 = cljs.core.chunk_rest.call(null,seq__71146_71160__$1);
var G__71163 = c__28186__auto___71161;
var G__71164 = cljs.core.count.call(null,c__28186__auto___71161);
var G__71165 = (0);
seq__71146_71150 = G__71162;
chunk__71147_71151 = G__71163;
count__71148_71152 = G__71164;
i__71149_71153 = G__71165;
continue;
} else {
var f_71166 = cljs.core.first.call(null,seq__71146_71160__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_71166);

var G__71167 = cljs.core.next.call(null,seq__71146_71160__$1);
var G__71168 = null;
var G__71169 = (0);
var G__71170 = (0);
seq__71146_71150 = G__71167;
chunk__71147_71151 = G__71168;
count__71148_71152 = G__71169;
i__71149_71153 = G__71170;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__71142,map__71142__$1,opts,on_cssload,map__71143,map__71143__$1,files_msg,files){
return (function (){
figwheel.client.file_reloading.on_cssload_custom_event.call(null,files);

return on_cssload.call(null,files);
});})(map__71142,map__71142__$1,opts,on_cssload,map__71143,map__71143__$1,files_msg,files))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1479956919065