// Compiled by ClojureScript 1.9.293 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('cljsjs.react');
goog.require('cljsjs.react.dom');
goog.require('clojure.string');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__65706__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__65703 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__65704 = cljs.core.seq.call(null,vec__65703);
var first__65705 = cljs.core.first.call(null,seq__65704);
var seq__65704__$1 = cljs.core.next.call(null,seq__65704);
var tag = first__65705;
var body = seq__65704__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__65706 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__65707__i = 0, G__65707__a = new Array(arguments.length -  0);
while (G__65707__i < G__65707__a.length) {G__65707__a[G__65707__i] = arguments[G__65707__i + 0]; ++G__65707__i;}
  args = new cljs.core.IndexedSeq(G__65707__a,0);
} 
return G__65706__delegate.call(this,args);};
G__65706.cljs$lang$maxFixedArity = 0;
G__65706.cljs$lang$applyTo = (function (arglist__65708){
var args = cljs.core.seq(arglist__65708);
return G__65706__delegate(args);
});
G__65706.cljs$core$IFn$_invoke$arity$variadic = G__65706__delegate;
return G__65706;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__28137__auto__ = (function sablono$core$update_arglists_$_iter__65713(s__65714){
return (new cljs.core.LazySeq(null,(function (){
var s__65714__$1 = s__65714;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__65714__$1);
if(temp__6753__auto__){
var s__65714__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__65714__$2)){
var c__28135__auto__ = cljs.core.chunk_first.call(null,s__65714__$2);
var size__28136__auto__ = cljs.core.count.call(null,c__28135__auto__);
var b__65716 = cljs.core.chunk_buffer.call(null,size__28136__auto__);
if((function (){var i__65715 = (0);
while(true){
if((i__65715 < size__28136__auto__)){
var args = cljs.core._nth.call(null,c__28135__auto__,i__65715);
cljs.core.chunk_append.call(null,b__65716,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__65717 = (i__65715 + (1));
i__65715 = G__65717;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65716),sablono$core$update_arglists_$_iter__65713.call(null,cljs.core.chunk_rest.call(null,s__65714__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65716),null);
}
} else {
var args = cljs.core.first.call(null,s__65714__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__65713.call(null,cljs.core.rest.call(null,s__65714__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28137__auto__.call(null,arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__28503__auto__ = [];
var len__28496__auto___65723 = arguments.length;
var i__28497__auto___65724 = (0);
while(true){
if((i__28497__auto___65724 < len__28496__auto___65723)){
args__28503__auto__.push((arguments[i__28497__auto___65724]));

var G__65725 = (i__28497__auto___65724 + (1));
i__28497__auto___65724 = G__65725;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((0) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__28504__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__28137__auto__ = (function sablono$core$iter__65719(s__65720){
return (new cljs.core.LazySeq(null,(function (){
var s__65720__$1 = s__65720;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__65720__$1);
if(temp__6753__auto__){
var s__65720__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__65720__$2)){
var c__28135__auto__ = cljs.core.chunk_first.call(null,s__65720__$2);
var size__28136__auto__ = cljs.core.count.call(null,c__28135__auto__);
var b__65722 = cljs.core.chunk_buffer.call(null,size__28136__auto__);
if((function (){var i__65721 = (0);
while(true){
if((i__65721 < size__28136__auto__)){
var style = cljs.core._nth.call(null,c__28135__auto__,i__65721);
cljs.core.chunk_append.call(null,b__65722,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__65726 = (i__65721 + (1));
i__65721 = G__65726;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65722),sablono$core$iter__65719.call(null,cljs.core.chunk_rest.call(null,s__65720__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65722),null);
}
} else {
var style = cljs.core.first.call(null,s__65720__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__65719.call(null,cljs.core.rest.call(null,s__65720__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28137__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq65718){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq65718));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to65727 = (function sablono$core$link_to65727(var_args){
var args__28503__auto__ = [];
var len__28496__auto___65730 = arguments.length;
var i__28497__auto___65731 = (0);
while(true){
if((i__28497__auto___65731 < len__28496__auto___65730)){
args__28503__auto__.push((arguments[i__28497__auto___65731]));

var G__65732 = (i__28497__auto___65731 + (1));
i__28497__auto___65731 = G__65732;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((1) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to65727.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28504__auto__);
});

sablono.core.link_to65727.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to65727.cljs$lang$maxFixedArity = (1);

sablono.core.link_to65727.cljs$lang$applyTo = (function (seq65728){
var G__65729 = cljs.core.first.call(null,seq65728);
var seq65728__$1 = cljs.core.next.call(null,seq65728);
return sablono.core.link_to65727.cljs$core$IFn$_invoke$arity$variadic(G__65729,seq65728__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to65727);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to65733 = (function sablono$core$mail_to65733(var_args){
var args__28503__auto__ = [];
var len__28496__auto___65740 = arguments.length;
var i__28497__auto___65741 = (0);
while(true){
if((i__28497__auto___65741 < len__28496__auto___65740)){
args__28503__auto__.push((arguments[i__28497__auto___65741]));

var G__65742 = (i__28497__auto___65741 + (1));
i__28497__auto___65741 = G__65742;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((1) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to65733.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28504__auto__);
});

sablono.core.mail_to65733.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__65736){
var vec__65737 = p__65736;
var content = cljs.core.nth.call(null,vec__65737,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__27280__auto__ = content;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to65733.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to65733.cljs$lang$applyTo = (function (seq65734){
var G__65735 = cljs.core.first.call(null,seq65734);
var seq65734__$1 = cljs.core.next.call(null,seq65734);
return sablono.core.mail_to65733.cljs$core$IFn$_invoke$arity$variadic(G__65735,seq65734__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to65733);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list65743 = (function sablono$core$unordered_list65743(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__28137__auto__ = (function sablono$core$unordered_list65743_$_iter__65748(s__65749){
return (new cljs.core.LazySeq(null,(function (){
var s__65749__$1 = s__65749;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__65749__$1);
if(temp__6753__auto__){
var s__65749__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__65749__$2)){
var c__28135__auto__ = cljs.core.chunk_first.call(null,s__65749__$2);
var size__28136__auto__ = cljs.core.count.call(null,c__28135__auto__);
var b__65751 = cljs.core.chunk_buffer.call(null,size__28136__auto__);
if((function (){var i__65750 = (0);
while(true){
if((i__65750 < size__28136__auto__)){
var x = cljs.core._nth.call(null,c__28135__auto__,i__65750);
cljs.core.chunk_append.call(null,b__65751,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__65752 = (i__65750 + (1));
i__65750 = G__65752;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65751),sablono$core$unordered_list65743_$_iter__65748.call(null,cljs.core.chunk_rest.call(null,s__65749__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65751),null);
}
} else {
var x = cljs.core.first.call(null,s__65749__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list65743_$_iter__65748.call(null,cljs.core.rest.call(null,s__65749__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28137__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list65743);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list65753 = (function sablono$core$ordered_list65753(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__28137__auto__ = (function sablono$core$ordered_list65753_$_iter__65758(s__65759){
return (new cljs.core.LazySeq(null,(function (){
var s__65759__$1 = s__65759;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__65759__$1);
if(temp__6753__auto__){
var s__65759__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__65759__$2)){
var c__28135__auto__ = cljs.core.chunk_first.call(null,s__65759__$2);
var size__28136__auto__ = cljs.core.count.call(null,c__28135__auto__);
var b__65761 = cljs.core.chunk_buffer.call(null,size__28136__auto__);
if((function (){var i__65760 = (0);
while(true){
if((i__65760 < size__28136__auto__)){
var x = cljs.core._nth.call(null,c__28135__auto__,i__65760);
cljs.core.chunk_append.call(null,b__65761,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__65762 = (i__65760 + (1));
i__65760 = G__65762;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65761),sablono$core$ordered_list65753_$_iter__65758.call(null,cljs.core.chunk_rest.call(null,s__65759__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65761),null);
}
} else {
var x = cljs.core.first.call(null,s__65759__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list65753_$_iter__65758.call(null,cljs.core.rest.call(null,s__65759__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28137__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list65753);
/**
 * Create an image element.
 */
sablono.core.image65763 = (function sablono$core$image65763(var_args){
var args65764 = [];
var len__28496__auto___65767 = arguments.length;
var i__28497__auto___65768 = (0);
while(true){
if((i__28497__auto___65768 < len__28496__auto___65767)){
args65764.push((arguments[i__28497__auto___65768]));

var G__65769 = (i__28497__auto___65768 + (1));
i__28497__auto___65768 = G__65769;
continue;
} else {
}
break;
}

var G__65766 = args65764.length;
switch (G__65766) {
case 1:
return sablono.core.image65763.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image65763.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65764.length)].join('')));

}
});

sablono.core.image65763.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image65763.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image65763.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image65763);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__65771_SHARP_,p2__65772_SHARP_){
return [cljs.core.str(p1__65771_SHARP_),cljs.core.str("["),cljs.core.str(p2__65772_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__65773_SHARP_,p2__65774_SHARP_){
return [cljs.core.str(p1__65773_SHARP_),cljs.core.str("-"),cljs.core.str(p2__65774_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__27280__auto__ = value;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return undefined;
}
})()], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field65775 = (function sablono$core$color_field65775(var_args){
var args65776 = [];
var len__28496__auto___65843 = arguments.length;
var i__28497__auto___65844 = (0);
while(true){
if((i__28497__auto___65844 < len__28496__auto___65843)){
args65776.push((arguments[i__28497__auto___65844]));

var G__65845 = (i__28497__auto___65844 + (1));
i__28497__auto___65844 = G__65845;
continue;
} else {
}
break;
}

var G__65778 = args65776.length;
switch (G__65778) {
case 1:
return sablono.core.color_field65775.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field65775.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65776.length)].join('')));

}
});

sablono.core.color_field65775.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.color_field65775.call(null,name__46586__auto__,null);
});

sablono.core.color_field65775.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.color_field65775.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field65775);

/**
 * Creates a date input field.
 */
sablono.core.date_field65779 = (function sablono$core$date_field65779(var_args){
var args65780 = [];
var len__28496__auto___65847 = arguments.length;
var i__28497__auto___65848 = (0);
while(true){
if((i__28497__auto___65848 < len__28496__auto___65847)){
args65780.push((arguments[i__28497__auto___65848]));

var G__65849 = (i__28497__auto___65848 + (1));
i__28497__auto___65848 = G__65849;
continue;
} else {
}
break;
}

var G__65782 = args65780.length;
switch (G__65782) {
case 1:
return sablono.core.date_field65779.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field65779.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65780.length)].join('')));

}
});

sablono.core.date_field65779.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.date_field65779.call(null,name__46586__auto__,null);
});

sablono.core.date_field65779.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.date_field65779.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field65779);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field65783 = (function sablono$core$datetime_field65783(var_args){
var args65784 = [];
var len__28496__auto___65851 = arguments.length;
var i__28497__auto___65852 = (0);
while(true){
if((i__28497__auto___65852 < len__28496__auto___65851)){
args65784.push((arguments[i__28497__auto___65852]));

var G__65853 = (i__28497__auto___65852 + (1));
i__28497__auto___65852 = G__65853;
continue;
} else {
}
break;
}

var G__65786 = args65784.length;
switch (G__65786) {
case 1:
return sablono.core.datetime_field65783.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field65783.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65784.length)].join('')));

}
});

sablono.core.datetime_field65783.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.datetime_field65783.call(null,name__46586__auto__,null);
});

sablono.core.datetime_field65783.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.datetime_field65783.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field65783);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field65787 = (function sablono$core$datetime_local_field65787(var_args){
var args65788 = [];
var len__28496__auto___65855 = arguments.length;
var i__28497__auto___65856 = (0);
while(true){
if((i__28497__auto___65856 < len__28496__auto___65855)){
args65788.push((arguments[i__28497__auto___65856]));

var G__65857 = (i__28497__auto___65856 + (1));
i__28497__auto___65856 = G__65857;
continue;
} else {
}
break;
}

var G__65790 = args65788.length;
switch (G__65790) {
case 1:
return sablono.core.datetime_local_field65787.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field65787.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65788.length)].join('')));

}
});

sablono.core.datetime_local_field65787.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.datetime_local_field65787.call(null,name__46586__auto__,null);
});

sablono.core.datetime_local_field65787.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.datetime_local_field65787.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field65787);

/**
 * Creates a email input field.
 */
sablono.core.email_field65791 = (function sablono$core$email_field65791(var_args){
var args65792 = [];
var len__28496__auto___65859 = arguments.length;
var i__28497__auto___65860 = (0);
while(true){
if((i__28497__auto___65860 < len__28496__auto___65859)){
args65792.push((arguments[i__28497__auto___65860]));

var G__65861 = (i__28497__auto___65860 + (1));
i__28497__auto___65860 = G__65861;
continue;
} else {
}
break;
}

var G__65794 = args65792.length;
switch (G__65794) {
case 1:
return sablono.core.email_field65791.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field65791.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65792.length)].join('')));

}
});

sablono.core.email_field65791.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.email_field65791.call(null,name__46586__auto__,null);
});

sablono.core.email_field65791.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.email_field65791.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field65791);

/**
 * Creates a file input field.
 */
sablono.core.file_field65795 = (function sablono$core$file_field65795(var_args){
var args65796 = [];
var len__28496__auto___65863 = arguments.length;
var i__28497__auto___65864 = (0);
while(true){
if((i__28497__auto___65864 < len__28496__auto___65863)){
args65796.push((arguments[i__28497__auto___65864]));

var G__65865 = (i__28497__auto___65864 + (1));
i__28497__auto___65864 = G__65865;
continue;
} else {
}
break;
}

var G__65798 = args65796.length;
switch (G__65798) {
case 1:
return sablono.core.file_field65795.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field65795.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65796.length)].join('')));

}
});

sablono.core.file_field65795.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.file_field65795.call(null,name__46586__auto__,null);
});

sablono.core.file_field65795.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.file_field65795.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field65795);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field65799 = (function sablono$core$hidden_field65799(var_args){
var args65800 = [];
var len__28496__auto___65867 = arguments.length;
var i__28497__auto___65868 = (0);
while(true){
if((i__28497__auto___65868 < len__28496__auto___65867)){
args65800.push((arguments[i__28497__auto___65868]));

var G__65869 = (i__28497__auto___65868 + (1));
i__28497__auto___65868 = G__65869;
continue;
} else {
}
break;
}

var G__65802 = args65800.length;
switch (G__65802) {
case 1:
return sablono.core.hidden_field65799.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field65799.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65800.length)].join('')));

}
});

sablono.core.hidden_field65799.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.hidden_field65799.call(null,name__46586__auto__,null);
});

sablono.core.hidden_field65799.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.hidden_field65799.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field65799);

/**
 * Creates a month input field.
 */
sablono.core.month_field65803 = (function sablono$core$month_field65803(var_args){
var args65804 = [];
var len__28496__auto___65871 = arguments.length;
var i__28497__auto___65872 = (0);
while(true){
if((i__28497__auto___65872 < len__28496__auto___65871)){
args65804.push((arguments[i__28497__auto___65872]));

var G__65873 = (i__28497__auto___65872 + (1));
i__28497__auto___65872 = G__65873;
continue;
} else {
}
break;
}

var G__65806 = args65804.length;
switch (G__65806) {
case 1:
return sablono.core.month_field65803.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field65803.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65804.length)].join('')));

}
});

sablono.core.month_field65803.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.month_field65803.call(null,name__46586__auto__,null);
});

sablono.core.month_field65803.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.month_field65803.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field65803);

/**
 * Creates a number input field.
 */
sablono.core.number_field65807 = (function sablono$core$number_field65807(var_args){
var args65808 = [];
var len__28496__auto___65875 = arguments.length;
var i__28497__auto___65876 = (0);
while(true){
if((i__28497__auto___65876 < len__28496__auto___65875)){
args65808.push((arguments[i__28497__auto___65876]));

var G__65877 = (i__28497__auto___65876 + (1));
i__28497__auto___65876 = G__65877;
continue;
} else {
}
break;
}

var G__65810 = args65808.length;
switch (G__65810) {
case 1:
return sablono.core.number_field65807.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field65807.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65808.length)].join('')));

}
});

sablono.core.number_field65807.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.number_field65807.call(null,name__46586__auto__,null);
});

sablono.core.number_field65807.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.number_field65807.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field65807);

/**
 * Creates a password input field.
 */
sablono.core.password_field65811 = (function sablono$core$password_field65811(var_args){
var args65812 = [];
var len__28496__auto___65879 = arguments.length;
var i__28497__auto___65880 = (0);
while(true){
if((i__28497__auto___65880 < len__28496__auto___65879)){
args65812.push((arguments[i__28497__auto___65880]));

var G__65881 = (i__28497__auto___65880 + (1));
i__28497__auto___65880 = G__65881;
continue;
} else {
}
break;
}

var G__65814 = args65812.length;
switch (G__65814) {
case 1:
return sablono.core.password_field65811.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field65811.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65812.length)].join('')));

}
});

sablono.core.password_field65811.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.password_field65811.call(null,name__46586__auto__,null);
});

sablono.core.password_field65811.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.password_field65811.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field65811);

/**
 * Creates a range input field.
 */
sablono.core.range_field65815 = (function sablono$core$range_field65815(var_args){
var args65816 = [];
var len__28496__auto___65883 = arguments.length;
var i__28497__auto___65884 = (0);
while(true){
if((i__28497__auto___65884 < len__28496__auto___65883)){
args65816.push((arguments[i__28497__auto___65884]));

var G__65885 = (i__28497__auto___65884 + (1));
i__28497__auto___65884 = G__65885;
continue;
} else {
}
break;
}

var G__65818 = args65816.length;
switch (G__65818) {
case 1:
return sablono.core.range_field65815.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field65815.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65816.length)].join('')));

}
});

sablono.core.range_field65815.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.range_field65815.call(null,name__46586__auto__,null);
});

sablono.core.range_field65815.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.range_field65815.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field65815);

/**
 * Creates a search input field.
 */
sablono.core.search_field65819 = (function sablono$core$search_field65819(var_args){
var args65820 = [];
var len__28496__auto___65887 = arguments.length;
var i__28497__auto___65888 = (0);
while(true){
if((i__28497__auto___65888 < len__28496__auto___65887)){
args65820.push((arguments[i__28497__auto___65888]));

var G__65889 = (i__28497__auto___65888 + (1));
i__28497__auto___65888 = G__65889;
continue;
} else {
}
break;
}

var G__65822 = args65820.length;
switch (G__65822) {
case 1:
return sablono.core.search_field65819.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field65819.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65820.length)].join('')));

}
});

sablono.core.search_field65819.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.search_field65819.call(null,name__46586__auto__,null);
});

sablono.core.search_field65819.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.search_field65819.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field65819);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field65823 = (function sablono$core$tel_field65823(var_args){
var args65824 = [];
var len__28496__auto___65891 = arguments.length;
var i__28497__auto___65892 = (0);
while(true){
if((i__28497__auto___65892 < len__28496__auto___65891)){
args65824.push((arguments[i__28497__auto___65892]));

var G__65893 = (i__28497__auto___65892 + (1));
i__28497__auto___65892 = G__65893;
continue;
} else {
}
break;
}

var G__65826 = args65824.length;
switch (G__65826) {
case 1:
return sablono.core.tel_field65823.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field65823.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65824.length)].join('')));

}
});

sablono.core.tel_field65823.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.tel_field65823.call(null,name__46586__auto__,null);
});

sablono.core.tel_field65823.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.tel_field65823.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field65823);

/**
 * Creates a text input field.
 */
sablono.core.text_field65827 = (function sablono$core$text_field65827(var_args){
var args65828 = [];
var len__28496__auto___65895 = arguments.length;
var i__28497__auto___65896 = (0);
while(true){
if((i__28497__auto___65896 < len__28496__auto___65895)){
args65828.push((arguments[i__28497__auto___65896]));

var G__65897 = (i__28497__auto___65896 + (1));
i__28497__auto___65896 = G__65897;
continue;
} else {
}
break;
}

var G__65830 = args65828.length;
switch (G__65830) {
case 1:
return sablono.core.text_field65827.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field65827.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65828.length)].join('')));

}
});

sablono.core.text_field65827.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.text_field65827.call(null,name__46586__auto__,null);
});

sablono.core.text_field65827.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.text_field65827.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field65827);

/**
 * Creates a time input field.
 */
sablono.core.time_field65831 = (function sablono$core$time_field65831(var_args){
var args65832 = [];
var len__28496__auto___65899 = arguments.length;
var i__28497__auto___65900 = (0);
while(true){
if((i__28497__auto___65900 < len__28496__auto___65899)){
args65832.push((arguments[i__28497__auto___65900]));

var G__65901 = (i__28497__auto___65900 + (1));
i__28497__auto___65900 = G__65901;
continue;
} else {
}
break;
}

var G__65834 = args65832.length;
switch (G__65834) {
case 1:
return sablono.core.time_field65831.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field65831.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65832.length)].join('')));

}
});

sablono.core.time_field65831.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.time_field65831.call(null,name__46586__auto__,null);
});

sablono.core.time_field65831.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.time_field65831.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field65831);

/**
 * Creates a url input field.
 */
sablono.core.url_field65835 = (function sablono$core$url_field65835(var_args){
var args65836 = [];
var len__28496__auto___65903 = arguments.length;
var i__28497__auto___65904 = (0);
while(true){
if((i__28497__auto___65904 < len__28496__auto___65903)){
args65836.push((arguments[i__28497__auto___65904]));

var G__65905 = (i__28497__auto___65904 + (1));
i__28497__auto___65904 = G__65905;
continue;
} else {
}
break;
}

var G__65838 = args65836.length;
switch (G__65838) {
case 1:
return sablono.core.url_field65835.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field65835.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65836.length)].join('')));

}
});

sablono.core.url_field65835.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.url_field65835.call(null,name__46586__auto__,null);
});

sablono.core.url_field65835.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.url_field65835.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field65835);

/**
 * Creates a week input field.
 */
sablono.core.week_field65839 = (function sablono$core$week_field65839(var_args){
var args65840 = [];
var len__28496__auto___65907 = arguments.length;
var i__28497__auto___65908 = (0);
while(true){
if((i__28497__auto___65908 < len__28496__auto___65907)){
args65840.push((arguments[i__28497__auto___65908]));

var G__65909 = (i__28497__auto___65908 + (1));
i__28497__auto___65908 = G__65909;
continue;
} else {
}
break;
}

var G__65842 = args65840.length;
switch (G__65842) {
case 1:
return sablono.core.week_field65839.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field65839.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65840.length)].join('')));

}
});

sablono.core.week_field65839.cljs$core$IFn$_invoke$arity$1 = (function (name__46586__auto__){
return sablono.core.week_field65839.call(null,name__46586__auto__,null);
});

sablono.core.week_field65839.cljs$core$IFn$_invoke$arity$2 = (function (name__46586__auto__,value__46587__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__46586__auto__,value__46587__auto__);
});

sablono.core.week_field65839.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field65839);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box65911 = (function sablono$core$check_box65911(var_args){
var args65912 = [];
var len__28496__auto___65915 = arguments.length;
var i__28497__auto___65916 = (0);
while(true){
if((i__28497__auto___65916 < len__28496__auto___65915)){
args65912.push((arguments[i__28497__auto___65916]));

var G__65917 = (i__28497__auto___65916 + (1));
i__28497__auto___65916 = G__65917;
continue;
} else {
}
break;
}

var G__65914 = args65912.length;
switch (G__65914) {
case 1:
return sablono.core.check_box65911.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box65911.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box65911.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65912.length)].join('')));

}
});

sablono.core.check_box65911.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box65911.call(null,name,null);
});

sablono.core.check_box65911.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box65911.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box65911.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__27280__auto__ = value;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box65911.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box65911);
/**
 * Creates a radio button.
 */
sablono.core.radio_button65919 = (function sablono$core$radio_button65919(var_args){
var args65920 = [];
var len__28496__auto___65923 = arguments.length;
var i__28497__auto___65924 = (0);
while(true){
if((i__28497__auto___65924 < len__28496__auto___65923)){
args65920.push((arguments[i__28497__auto___65924]));

var G__65925 = (i__28497__auto___65924 + (1));
i__28497__auto___65924 = G__65925;
continue;
} else {
}
break;
}

var G__65922 = args65920.length;
switch (G__65922) {
case 1:
return sablono.core.radio_button65919.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button65919.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button65919.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65920.length)].join('')));

}
});

sablono.core.radio_button65919.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button65919.call(null,group,null);
});

sablono.core.radio_button65919.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button65919.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button65919.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__27280__auto__ = value;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button65919.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button65919);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options65927 = (function sablono$core$select_options65927(coll){
var iter__28137__auto__ = (function sablono$core$select_options65927_$_iter__65944(s__65945){
return (new cljs.core.LazySeq(null,(function (){
var s__65945__$1 = s__65945;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__65945__$1);
if(temp__6753__auto__){
var s__65945__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__65945__$2)){
var c__28135__auto__ = cljs.core.chunk_first.call(null,s__65945__$2);
var size__28136__auto__ = cljs.core.count.call(null,c__28135__auto__);
var b__65947 = cljs.core.chunk_buffer.call(null,size__28136__auto__);
if((function (){var i__65946 = (0);
while(true){
if((i__65946 < size__28136__auto__)){
var x = cljs.core._nth.call(null,c__28135__auto__,i__65946);
cljs.core.chunk_append.call(null,b__65947,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__65954 = x;
var text = cljs.core.nth.call(null,vec__65954,(0),null);
var val = cljs.core.nth.call(null,vec__65954,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__65954,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options65927.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__65960 = (i__65946 + (1));
i__65946 = G__65960;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65947),sablono$core$select_options65927_$_iter__65944.call(null,cljs.core.chunk_rest.call(null,s__65945__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__65947),null);
}
} else {
var x = cljs.core.first.call(null,s__65945__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__65957 = x;
var text = cljs.core.nth.call(null,vec__65957,(0),null);
var val = cljs.core.nth.call(null,vec__65957,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__65957,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options65927.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options65927_$_iter__65944.call(null,cljs.core.rest.call(null,s__65945__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28137__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options65927);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down65961 = (function sablono$core$drop_down65961(var_args){
var args65962 = [];
var len__28496__auto___65965 = arguments.length;
var i__28497__auto___65966 = (0);
while(true){
if((i__28497__auto___65966 < len__28496__auto___65965)){
args65962.push((arguments[i__28497__auto___65966]));

var G__65967 = (i__28497__auto___65966 + (1));
i__28497__auto___65966 = G__65967;
continue;
} else {
}
break;
}

var G__65964 = args65962.length;
switch (G__65964) {
case 2:
return sablono.core.drop_down65961.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down65961.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65962.length)].join('')));

}
});

sablono.core.drop_down65961.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down65961.call(null,name,options,null);
});

sablono.core.drop_down65961.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down65961.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down65961);
/**
 * Creates a text area element.
 */
sablono.core.text_area65969 = (function sablono$core$text_area65969(var_args){
var args65970 = [];
var len__28496__auto___65973 = arguments.length;
var i__28497__auto___65974 = (0);
while(true){
if((i__28497__auto___65974 < len__28496__auto___65973)){
args65970.push((arguments[i__28497__auto___65974]));

var G__65975 = (i__28497__auto___65974 + (1));
i__28497__auto___65974 = G__65975;
continue;
} else {
}
break;
}

var G__65972 = args65970.length;
switch (G__65972) {
case 1:
return sablono.core.text_area65969.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area65969.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args65970.length)].join('')));

}
});

sablono.core.text_area65969.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area65969.call(null,name,null);
});

sablono.core.text_area65969.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__27280__auto__ = value;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.text_area65969.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area65969);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label65977 = (function sablono$core$label65977(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label65977);
/**
 * Creates a submit button.
 */
sablono.core.submit_button65978 = (function sablono$core$submit_button65978(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button65978);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button65979 = (function sablono$core$reset_button65979(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button65979);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to65980 = (function sablono$core$form_to65980(var_args){
var args__28503__auto__ = [];
var len__28496__auto___65987 = arguments.length;
var i__28497__auto___65988 = (0);
while(true){
if((i__28497__auto___65988 < len__28496__auto___65987)){
args__28503__auto__.push((arguments[i__28497__auto___65988]));

var G__65989 = (i__28497__auto___65988 + (1));
i__28497__auto___65988 = G__65989;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((1) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to65980.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28504__auto__);
});

sablono.core.form_to65980.cljs$core$IFn$_invoke$arity$variadic = (function (p__65983,body){
var vec__65984 = p__65983;
var method = cljs.core.nth.call(null,vec__65984,(0),null);
var action = cljs.core.nth.call(null,vec__65984,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to65980.cljs$lang$maxFixedArity = (1);

sablono.core.form_to65980.cljs$lang$applyTo = (function (seq65981){
var G__65982 = cljs.core.first.call(null,seq65981);
var seq65981__$1 = cljs.core.next.call(null,seq65981);
return sablono.core.form_to65980.cljs$core$IFn$_invoke$arity$variadic(G__65982,seq65981__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to65980);

//# sourceMappingURL=core.js.map?rel=1479956914006