// Compiled by ClojureScript 1.9.293 {}
goog.provide('untangled.client.impl.application');
goog.require('cljs.core');
goog.require('untangled.client.logging');
goog.require('untangled.i18n.core');
goog.require('untangled.client.impl.network');
goog.require('untangled.client.impl.om_plumbing');
goog.require('cljs.core.async');
goog.require('untangled.client.impl.data_fetch');
goog.require('om.next');
/**
 * This internal function is responsible for generating and returning a function that can accomplish calling the fallbacks that
 *   appear in an incoming Om transaction, which is in turn used by the error-handling logic of the plumbing.
 */
untangled.client.impl.application.fallback_handler = (function untangled$client$impl$application$fallback_handler(p__64763,query){
var map__64766 = p__64763;
var map__64766__$1 = ((((!((map__64766 == null)))?((((map__64766.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64766.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64766):map__64766);
var reconciler = cljs.core.get.call(null,map__64766__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
return ((function (map__64766,map__64766__$1,reconciler){
return (function (error){
cljs.core.swap_BANG_.call(null,om.next.app_state.call(null,reconciler),cljs.core.assoc,new cljs.core.Keyword("untangled","server-error","untangled/server-error",1542377811),error);

var temp__6751__auto__ = untangled.client.impl.om_plumbing.fallback_query.call(null,query,error);
if(cljs.core.truth_(temp__6751__auto__)){
var q = temp__6751__auto__;
untangled.client.logging.warn.call(null,untangled.client.logging.value_message.call(null,"Transaction failed. Running fallback.",q));

return om.next.transact_BANG_.call(null,reconciler,q);
} else {
return untangled.client.logging.warn.call(null,"Fallback triggered, but no fallbacks were defined.");
}
});
;})(map__64766,map__64766__$1,reconciler))
});
/**
 * Enqueue a send to the network queue. This is a standalone function because we cannot mock core async functions.
 */
untangled.client.impl.application.enqueue = (function untangled$client$impl$application$enqueue(q,v){
var c__41822__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto__){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto__){
return (function (state_64783){
var state_val_64784 = (state_64783[(1)]);
if((state_val_64784 === (1))){
var state_64783__$1 = state_64783;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_64783__$1,(2),q,v);
} else {
if((state_val_64784 === (2))){
var inst_64781 = (state_64783[(2)]);
var state_64783__$1 = state_64783;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64783__$1,inst_64781);
} else {
return null;
}
}
});})(c__41822__auto__))
;
return ((function (switch__41805__auto__,c__41822__auto__){
return (function() {
var untangled$client$impl$application$enqueue_$_state_machine__41806__auto__ = null;
var untangled$client$impl$application$enqueue_$_state_machine__41806__auto____0 = (function (){
var statearr_64788 = [null,null,null,null,null,null,null];
(statearr_64788[(0)] = untangled$client$impl$application$enqueue_$_state_machine__41806__auto__);

(statearr_64788[(1)] = (1));

return statearr_64788;
});
var untangled$client$impl$application$enqueue_$_state_machine__41806__auto____1 = (function (state_64783){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_64783);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e64789){if((e64789 instanceof Object)){
var ex__41809__auto__ = e64789;
var statearr_64790_64792 = state_64783;
(statearr_64790_64792[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_64783);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e64789;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64793 = state_64783;
state_64783 = G__64793;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
untangled$client$impl$application$enqueue_$_state_machine__41806__auto__ = function(state_64783){
switch(arguments.length){
case 0:
return untangled$client$impl$application$enqueue_$_state_machine__41806__auto____0.call(this);
case 1:
return untangled$client$impl$application$enqueue_$_state_machine__41806__auto____1.call(this,state_64783);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$enqueue_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$enqueue_$_state_machine__41806__auto____0;
untangled$client$impl$application$enqueue_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$enqueue_$_state_machine__41806__auto____1;
return untangled$client$impl$application$enqueue_$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto__))
})();
var state__41824__auto__ = (function (){var statearr_64791 = f__41823__auto__.call(null);
(statearr_64791[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto__);

return statearr_64791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto__))
);

return c__41822__auto__;
});
/**
 * Do a properly-plumbed network send. This function recursively strips ui attributes from the tx and pushes the tx over
 *   the network. It installs the given on-load and on-error handlers to deal with the network response.
 */
untangled.client.impl.application.real_send = (function untangled$client$impl$application$real_send(net,tx,on_load,on_error){
return untangled.client.impl.network.send.call(null,net,untangled.client.impl.om_plumbing.strip_ui.call(null,tx),on_load,on_error);
});
/**
 * Splits out the (remote) mutations and fallbacks in a transaction, creates an error handler that can
 * trigger fallbacks, and enqueues the remote mutations on the network queue.
 */
untangled.client.impl.application.enqueue_mutations = (function untangled$client$impl$application$enqueue_mutations(p__64795,remote_tx_map,cb){
var map__64798 = p__64795;
var map__64798__$1 = ((((!((map__64798 == null)))?((((map__64798.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64798.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64798):map__64798);
var app = map__64798__$1;
var queue = cljs.core.get.call(null,map__64798__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var full_remote_transaction = new cljs.core.Keyword(null,"remote","remote",-1593576576).cljs$core$IFn$_invoke$arity$1(remote_tx_map);
var fallback = untangled.client.impl.application.fallback_handler.call(null,app,full_remote_transaction);
var desired_remote_mutations = untangled.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,full_remote_transaction);
var has_mutations_QMARK_ = (cljs.core.count.call(null,desired_remote_mutations) > (0));
var payload = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"query","query",-1288509510),desired_remote_mutations,new cljs.core.Keyword(null,"on-load","on-load",1415151594),cb,new cljs.core.Keyword(null,"on-error","on-error",1728533530),((function (full_remote_transaction,fallback,desired_remote_mutations,has_mutations_QMARK_,map__64798,map__64798__$1,app,queue){
return (function (p1__64794_SHARP_){
return fallback.call(null,p1__64794_SHARP_);
});})(full_remote_transaction,fallback,desired_remote_mutations,has_mutations_QMARK_,map__64798,map__64798__$1,app,queue))
], null);
if(has_mutations_QMARK_){
return untangled.client.impl.application.enqueue.call(null,queue,payload);
} else {
return null;
}
});
/**
 * Finds any loads marked `parallel` and triggers real network requests immediately. Remaining loads
 *   are pulled into a single fetch payload (combined into one query) and enqueued behind any prior mutations/reads that
 *   were already requested in a prior UI/event cycle. Thus non-parallel reads are processed in clusters grouped due to UI
 *   events (a single event might trigger many reads which will all go to the server as a single combined request).
 *   Further UI events that trigger remote interaction will end up waiting until prior network request(s) are complete.
 * 
 *   This ensures that default reasoning is simple and sequential in the face of optimistic UI updates (real network
 *   traffic characteristics could cause out of order processing, and you would not want
 *   a 'create list' to be processed on the server *after* an 'add an item to the list'). 
 */
untangled.client.impl.application.enqueue_reads = (function untangled$client$impl$application$enqueue_reads(p__64802){
var map__64813 = p__64802;
var map__64813__$1 = ((((!((map__64813 == null)))?((((map__64813.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64813.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64813):map__64813);
var queue = cljs.core.get.call(null,map__64813__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var reconciler = cljs.core.get.call(null,map__64813__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var networking = cljs.core.get.call(null,map__64813__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var parallel_payload = untangled.client.impl.data_fetch.mark_parallel_loading.call(null,reconciler);
var seq__64815_64823 = cljs.core.seq.call(null,parallel_payload);
var chunk__64816_64824 = null;
var count__64817_64825 = (0);
var i__64818_64826 = (0);
while(true){
if((i__64818_64826 < count__64817_64825)){
var map__64819_64827 = cljs.core._nth.call(null,chunk__64816_64824,i__64818_64826);
var map__64819_64828__$1 = ((((!((map__64819_64827 == null)))?((((map__64819_64827.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64819_64827.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64819_64827):map__64819_64827);
var query_64829 = cljs.core.get.call(null,map__64819_64828__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_64830 = cljs.core.get.call(null,map__64819_64828__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_64831 = cljs.core.get.call(null,map__64819_64828__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var callback_args_64832 = cljs.core.get.call(null,map__64819_64828__$1,new cljs.core.Keyword(null,"callback-args","callback-args",1117743591));
var on_load_SINGLEQUOTE__64833 = ((function (seq__64815_64823,chunk__64816_64824,count__64817_64825,i__64818_64826,map__64819_64827,map__64819_64828__$1,query_64829,on_load_64830,on_error_64831,callback_args_64832,parallel_payload,map__64813,map__64813__$1,queue,reconciler,networking){
return (function (p1__64800_SHARP_){
return on_load_64830.call(null,p1__64800_SHARP_,callback_args_64832);
});})(seq__64815_64823,chunk__64816_64824,count__64817_64825,i__64818_64826,map__64819_64827,map__64819_64828__$1,query_64829,on_load_64830,on_error_64831,callback_args_64832,parallel_payload,map__64813,map__64813__$1,queue,reconciler,networking))
;
var on_error_SINGLEQUOTE__64834 = ((function (seq__64815_64823,chunk__64816_64824,count__64817_64825,i__64818_64826,on_load_SINGLEQUOTE__64833,map__64819_64827,map__64819_64828__$1,query_64829,on_load_64830,on_error_64831,callback_args_64832,parallel_payload,map__64813,map__64813__$1,queue,reconciler,networking){
return (function (p1__64801_SHARP_){
return on_error_64831.call(null,p1__64801_SHARP_,callback_args_64832);
});})(seq__64815_64823,chunk__64816_64824,count__64817_64825,i__64818_64826,on_load_SINGLEQUOTE__64833,map__64819_64827,map__64819_64828__$1,query_64829,on_load_64830,on_error_64831,callback_args_64832,parallel_payload,map__64813,map__64813__$1,queue,reconciler,networking))
;
untangled.client.impl.application.real_send.call(null,networking,query_64829,on_load_SINGLEQUOTE__64833,on_error_SINGLEQUOTE__64834);

var G__64835 = seq__64815_64823;
var G__64836 = chunk__64816_64824;
var G__64837 = count__64817_64825;
var G__64838 = (i__64818_64826 + (1));
seq__64815_64823 = G__64835;
chunk__64816_64824 = G__64836;
count__64817_64825 = G__64837;
i__64818_64826 = G__64838;
continue;
} else {
var temp__6753__auto___64839 = cljs.core.seq.call(null,seq__64815_64823);
if(temp__6753__auto___64839){
var seq__64815_64840__$1 = temp__6753__auto___64839;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__64815_64840__$1)){
var c__28186__auto___64841 = cljs.core.chunk_first.call(null,seq__64815_64840__$1);
var G__64842 = cljs.core.chunk_rest.call(null,seq__64815_64840__$1);
var G__64843 = c__28186__auto___64841;
var G__64844 = cljs.core.count.call(null,c__28186__auto___64841);
var G__64845 = (0);
seq__64815_64823 = G__64842;
chunk__64816_64824 = G__64843;
count__64817_64825 = G__64844;
i__64818_64826 = G__64845;
continue;
} else {
var map__64821_64846 = cljs.core.first.call(null,seq__64815_64840__$1);
var map__64821_64847__$1 = ((((!((map__64821_64846 == null)))?((((map__64821_64846.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64821_64846.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64821_64846):map__64821_64846);
var query_64848 = cljs.core.get.call(null,map__64821_64847__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_64849 = cljs.core.get.call(null,map__64821_64847__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_64850 = cljs.core.get.call(null,map__64821_64847__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var callback_args_64851 = cljs.core.get.call(null,map__64821_64847__$1,new cljs.core.Keyword(null,"callback-args","callback-args",1117743591));
var on_load_SINGLEQUOTE__64852 = ((function (seq__64815_64823,chunk__64816_64824,count__64817_64825,i__64818_64826,map__64821_64846,map__64821_64847__$1,query_64848,on_load_64849,on_error_64850,callback_args_64851,seq__64815_64840__$1,temp__6753__auto___64839,parallel_payload,map__64813,map__64813__$1,queue,reconciler,networking){
return (function (p1__64800_SHARP_){
return on_load_64849.call(null,p1__64800_SHARP_,callback_args_64851);
});})(seq__64815_64823,chunk__64816_64824,count__64817_64825,i__64818_64826,map__64821_64846,map__64821_64847__$1,query_64848,on_load_64849,on_error_64850,callback_args_64851,seq__64815_64840__$1,temp__6753__auto___64839,parallel_payload,map__64813,map__64813__$1,queue,reconciler,networking))
;
var on_error_SINGLEQUOTE__64853 = ((function (seq__64815_64823,chunk__64816_64824,count__64817_64825,i__64818_64826,on_load_SINGLEQUOTE__64852,map__64821_64846,map__64821_64847__$1,query_64848,on_load_64849,on_error_64850,callback_args_64851,seq__64815_64840__$1,temp__6753__auto___64839,parallel_payload,map__64813,map__64813__$1,queue,reconciler,networking){
return (function (p1__64801_SHARP_){
return on_error_64850.call(null,p1__64801_SHARP_,callback_args_64851);
});})(seq__64815_64823,chunk__64816_64824,count__64817_64825,i__64818_64826,on_load_SINGLEQUOTE__64852,map__64821_64846,map__64821_64847__$1,query_64848,on_load_64849,on_error_64850,callback_args_64851,seq__64815_64840__$1,temp__6753__auto___64839,parallel_payload,map__64813,map__64813__$1,queue,reconciler,networking))
;
untangled.client.impl.application.real_send.call(null,networking,query_64848,on_load_SINGLEQUOTE__64852,on_error_SINGLEQUOTE__64853);

var G__64854 = cljs.core.next.call(null,seq__64815_64840__$1);
var G__64855 = null;
var G__64856 = (0);
var G__64857 = (0);
seq__64815_64823 = G__64854;
chunk__64816_64824 = G__64855;
count__64817_64825 = G__64856;
i__64818_64826 = G__64857;
continue;
}
} else {
}
}
break;
}

var fetch_payload = untangled.client.impl.data_fetch.mark_loading.call(null,reconciler);
while(true){
if(cljs.core.truth_(fetch_payload)){
untangled.client.impl.application.enqueue.call(null,queue,cljs.core.assoc.call(null,fetch_payload,new cljs.core.Keyword(null,"networking","networking",586110628),networking));

var G__64858 = untangled.client.impl.data_fetch.mark_loading.call(null,reconciler);
fetch_payload = G__64858;
continue;
} else {
return null;
}
break;
}
});
/**
 * Puts queries/mutations (and their corresponding callbacks) onto the send queue. The networking code will pull these
 *   off one at a time and send them through the real networking layer. Reads are guaranteed to *follow* writes.
 */
untangled.client.impl.application.server_send = (function untangled$client$impl$application$server_send(app,remote_tx_map,cb){
untangled.client.impl.application.enqueue_mutations.call(null,app,remote_tx_map,cb);

return untangled.client.impl.application.enqueue_reads.call(null,app);
});
/**
 * Starts a async go loop that sends network requests on a networking object's request queue. Must be called once and only
 *   once for each active networking object on the UI. Each iteration of the loop pulls off a
 *   single request, sends it, waits for the response, and then repeats. Gives the appearance of a separate networking
 *   'thread' using core async.
 */
untangled.client.impl.application.start_network_sequential_processing = (function untangled$client$impl$application$start_network_sequential_processing(p__64859){
var map__64978 = p__64859;
var map__64978__$1 = ((((!((map__64978 == null)))?((((map__64978.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64978.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__64978):map__64978);
var networking = cljs.core.get.call(null,map__64978__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var queue = cljs.core.get.call(null,map__64978__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var response_channel = cljs.core.get.call(null,map__64978__$1,new cljs.core.Keyword(null,"response-channel","response-channel",1395191493));
var make_process_response = ((function (map__64978,map__64978__$1,networking,queue,response_channel){
return (function untangled$client$impl$application$start_network_sequential_processing_$_make_process_response(action,callback_args){
return ((function (map__64978,map__64978__$1,networking,queue,response_channel){
return (function (resp){
try{return action.call(null,resp,callback_args);
}finally {var c__41822__auto___65096 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto___65096,map__64978,map__64978__$1,networking,queue,response_channel){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto___65096,map__64978,map__64978__$1,networking,queue,response_channel){
return (function (state_65019){
var state_val_65020 = (state_65019[(1)]);
if((state_val_65020 === (1))){
var state_65019__$1 = state_65019;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_65019__$1,(2),response_channel,new cljs.core.Keyword(null,"complete","complete",-500388775));
} else {
if((state_val_65020 === (2))){
var inst_65017 = (state_65019[(2)]);
var state_65019__$1 = state_65019;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65019__$1,inst_65017);
} else {
return null;
}
}
});})(c__41822__auto___65096,map__64978,map__64978__$1,networking,queue,response_channel))
;
return ((function (switch__41805__auto__,c__41822__auto___65096,map__64978,map__64978__$1,networking,queue,response_channel){
return (function() {
var untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41806__auto__ = null;
var untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41806__auto____0 = (function (){
var statearr_65024 = [null,null,null,null,null,null,null];
(statearr_65024[(0)] = untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41806__auto__);

(statearr_65024[(1)] = (1));

return statearr_65024;
});
var untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41806__auto____1 = (function (state_65019){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_65019);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e65025){if((e65025 instanceof Object)){
var ex__41809__auto__ = e65025;
var statearr_65026_65097 = state_65019;
(statearr_65026_65097[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_65019);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e65025;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65098 = state_65019;
state_65019 = G__65098;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41806__auto__ = function(state_65019){
switch(arguments.length){
case 0:
return untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41806__auto____0.call(this);
case 1:
return untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41806__auto____1.call(this,state_65019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41806__auto____0;
untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41806__auto____1;
return untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto___65096,map__64978,map__64978__$1,networking,queue,response_channel))
})();
var state__41824__auto__ = (function (){var statearr_65027 = f__41823__auto__.call(null);
(statearr_65027[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto___65096);

return statearr_65027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto___65096,map__64978,map__64978__$1,networking,queue,response_channel))
);

}});
;})(map__64978,map__64978__$1,networking,queue,response_channel))
});})(map__64978,map__64978__$1,networking,queue,response_channel))
;
var c__41822__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41822__auto__,map__64978,map__64978__$1,networking,queue,response_channel){
return (function (){
var f__41823__auto__ = (function (){var switch__41805__auto__ = ((function (c__41822__auto__,map__64978,map__64978__$1,networking,queue,response_channel){
return (function (state_65069){
var state_val_65070 = (state_65069[(1)]);
if((state_val_65070 === (7))){
var inst_65048 = (state_65069[(2)]);
var state_65069__$1 = state_65069;
if(cljs.core.truth_(inst_65048)){
var statearr_65071_65099 = state_65069__$1;
(statearr_65071_65099[(1)] = (11));

} else {
var statearr_65072_65100 = state_65069__$1;
(statearr_65072_65100[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65070 === (1))){
var state_65069__$1 = state_65069;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65069__$1,(2),queue);
} else {
if((state_val_65070 === (4))){
var inst_65067 = (state_65069[(2)]);
var state_65069__$1 = state_65069;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65069__$1,inst_65067);
} else {
if((state_val_65070 === (15))){
var inst_65064 = (state_65069[(2)]);
var inst_65030 = inst_65064;
var state_65069__$1 = (function (){var statearr_65073 = state_65069;
(statearr_65073[(7)] = inst_65030);

return statearr_65073;
})();
var statearr_65074_65101 = state_65069__$1;
(statearr_65074_65101[(2)] = null);

(statearr_65074_65101[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65070 === (13))){
var inst_65053 = (state_65069[(2)]);
var inst_65054 = cljs.core.get.call(null,inst_65053,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_65055 = cljs.core.get.call(null,inst_65053,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var inst_65056 = cljs.core.get.call(null,inst_65053,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var inst_65057 = cljs.core.get.call(null,inst_65053,new cljs.core.Keyword(null,"callback-args","callback-args",1117743591));
var inst_65058 = make_process_response.call(null,inst_65055,inst_65057);
var inst_65059 = make_process_response.call(null,inst_65056,inst_65057);
var inst_65060 = untangled.client.impl.application.real_send.call(null,networking,inst_65054,inst_65058,inst_65059);
var state_65069__$1 = (function (){var statearr_65075 = state_65069;
(statearr_65075[(8)] = inst_65060);

return statearr_65075;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65069__$1,(14),response_channel);
} else {
if((state_val_65070 === (6))){
var state_65069__$1 = state_65069;
var statearr_65076_65102 = state_65069__$1;
(statearr_65076_65102[(2)] = false);

(statearr_65076_65102[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65070 === (3))){
var inst_65030 = (state_65069[(7)]);
var inst_65034 = (inst_65030 == null);
var inst_65035 = cljs.core.not.call(null,inst_65034);
var state_65069__$1 = state_65069;
if(inst_65035){
var statearr_65077_65103 = state_65069__$1;
(statearr_65077_65103[(1)] = (5));

} else {
var statearr_65078_65104 = state_65069__$1;
(statearr_65078_65104[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65070 === (12))){
var inst_65030 = (state_65069[(7)]);
var state_65069__$1 = state_65069;
var statearr_65079_65105 = state_65069__$1;
(statearr_65079_65105[(2)] = inst_65030);

(statearr_65079_65105[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65070 === (2))){
var inst_65029 = (state_65069[(2)]);
var inst_65030 = inst_65029;
var state_65069__$1 = (function (){var statearr_65080 = state_65069;
(statearr_65080[(7)] = inst_65030);

return statearr_65080;
})();
var statearr_65081_65106 = state_65069__$1;
(statearr_65081_65106[(2)] = null);

(statearr_65081_65106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65070 === (11))){
var inst_65030 = (state_65069[(7)]);
var inst_65050 = cljs.core.apply.call(null,cljs.core.hash_map,inst_65030);
var state_65069__$1 = state_65069;
var statearr_65082_65107 = state_65069__$1;
(statearr_65082_65107[(2)] = inst_65050);

(statearr_65082_65107[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65070 === (9))){
var state_65069__$1 = state_65069;
var statearr_65083_65108 = state_65069__$1;
(statearr_65083_65108[(2)] = false);

(statearr_65083_65108[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65070 === (5))){
var inst_65030 = (state_65069[(7)]);
var inst_65037 = inst_65030.cljs$lang$protocol_mask$partition0$;
var inst_65038 = (inst_65037 & (64));
var inst_65039 = inst_65030.cljs$core$ISeq$;
var inst_65040 = (cljs.core.PROTOCOL_SENTINEL === inst_65039);
var inst_65041 = (inst_65038) || (inst_65040);
var state_65069__$1 = state_65069;
if(cljs.core.truth_(inst_65041)){
var statearr_65084_65109 = state_65069__$1;
(statearr_65084_65109[(1)] = (8));

} else {
var statearr_65085_65110 = state_65069__$1;
(statearr_65085_65110[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65070 === (14))){
var inst_65062 = (state_65069[(2)]);
var state_65069__$1 = (function (){var statearr_65086 = state_65069;
(statearr_65086[(9)] = inst_65062);

return statearr_65086;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65069__$1,(15),queue);
} else {
if((state_val_65070 === (10))){
var inst_65045 = (state_65069[(2)]);
var state_65069__$1 = state_65069;
var statearr_65087_65111 = state_65069__$1;
(statearr_65087_65111[(2)] = inst_65045);

(statearr_65087_65111[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65070 === (8))){
var state_65069__$1 = state_65069;
var statearr_65088_65112 = state_65069__$1;
(statearr_65088_65112[(2)] = true);

(statearr_65088_65112[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41822__auto__,map__64978,map__64978__$1,networking,queue,response_channel))
;
return ((function (switch__41805__auto__,c__41822__auto__,map__64978,map__64978__$1,networking,queue,response_channel){
return (function() {
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41806__auto__ = null;
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41806__auto____0 = (function (){
var statearr_65092 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65092[(0)] = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41806__auto__);

(statearr_65092[(1)] = (1));

return statearr_65092;
});
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41806__auto____1 = (function (state_65069){
while(true){
var ret_value__41807__auto__ = (function (){try{while(true){
var result__41808__auto__ = switch__41805__auto__.call(null,state_65069);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41808__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41808__auto__;
}
break;
}
}catch (e65093){if((e65093 instanceof Object)){
var ex__41809__auto__ = e65093;
var statearr_65094_65113 = state_65069;
(statearr_65094_65113[(5)] = ex__41809__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_65069);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e65093;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65114 = state_65069;
state_65069 = G__65114;
continue;
} else {
return ret_value__41807__auto__;
}
break;
}
});
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41806__auto__ = function(state_65069){
switch(arguments.length){
case 0:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41806__auto____0.call(this);
case 1:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41806__auto____1.call(this,state_65069);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41806__auto____0;
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41806__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41806__auto____1;
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__41806__auto__;
})()
;})(switch__41805__auto__,c__41822__auto__,map__64978,map__64978__$1,networking,queue,response_channel))
})();
var state__41824__auto__ = (function (){var statearr_65095 = f__41823__auto__.call(null);
(statearr_65095[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41822__auto__);

return statearr_65095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41824__auto__);
});})(c__41822__auto__,map__64978,map__64978__$1,networking,queue,response_channel))
);

return c__41822__auto__;
});
/**
 * Configure a re-render when the locale changes. During startup this function will be called once for each
 *   reconciler that is running on a page.
 */
untangled.client.impl.application.initialize_internationalization = (function untangled$client$impl$application$initialize_internationalization(reconciler){
cljs.core.remove_watch.call(null,untangled.i18n.core._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697));

return cljs.core.add_watch.call(null,untangled.i18n.core._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697),(function (k,r,o,n){
if(om.next.mounted_QMARK_.call(null,om.next.app_root.call(null,reconciler))){
return om.next.force_root_render_BANG_.call(null,reconciler);
} else {
return null;
}
}));
});
/**
 * Remove not-found keys from m (non-recursive)
 */
untangled.client.impl.application.sweep_one = (function untangled$client$impl$application$sweep_one(m){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__65119){
var vec__65120 = p__65119;
var k = cljs.core.nth.call(null,vec__65120,(0),null);
var v = cljs.core.nth.call(null,vec__65120,(1),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494),v)){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,v);
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,untangled.client.impl.application.sweep_one,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
});
/**
 * Remove all of the not-found keys (recursively) from v, stopping at marked leaves (if present)
 */
untangled.client.impl.application.sweep = (function untangled$client$impl$application$sweep(m){
if(cljs.core.truth_(untangled.client.impl.om_plumbing.leaf_QMARK_.call(null,m))){
return untangled.client.impl.application.sweep_one.call(null,m);
} else {
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__65127){
var vec__65128 = p__65127;
var k = cljs.core.nth.call(null,vec__65128,(0),null);
var v = cljs.core.nth.call(null,vec__65128,(1),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494),v)){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep.call(null,v));
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,untangled.client.impl.application.sweep,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
}
});
/**
 * Do a recursive merge of source into target, but remove any target data that is marked as missing in the response. The
 *   missing marker is generated in the source when something has been asked for in the query, but had no value in the
 *   response. This allows us to correctly remove 'empty' data from the database without accidentally removing something
 *   that may still exist on the server (in truth we don't know its status, since it wasn't asked for, but we leave
 *   it as our 'best guess')
 */
untangled.client.impl.application.sweep_merge = (function untangled$client$impl$application$sweep_merge(target,source){
return cljs.core.reduce.call(null,(function (acc,p__65135){
var vec__65136 = p__65135;
var k = cljs.core.nth.call(null,vec__65136,(0),null);
var v = cljs.core.nth.call(null,vec__65136,(1),null);
if(cljs.core._EQ_.call(null,v,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494))){
return cljs.core.dissoc.call(null,acc,k);
} else {
if(cljs.core.truth_(untangled.client.impl.om_plumbing.leaf_QMARK_.call(null,v))){
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep_one.call(null,v));
} else {
if((cljs.core.map_QMARK_.call(null,cljs.core.get.call(null,acc,k))) && (cljs.core.map_QMARK_.call(null,v))){
return cljs.core.update.call(null,acc,k,untangled.client.impl.application.sweep_merge,v);
} else {
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep.call(null,v));

}
}
}
}),target,source);
});
untangled.client.impl.application.merge_handler = (function untangled$client$impl$application$merge_handler(mutation_merge,target,source){
var source_to_merge = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,(function (p__65147){
var vec__65148 = p__65147;
var k = cljs.core.nth.call(null,vec__65148,(0),null);
var _ = cljs.core.nth.call(null,vec__65148,(1),null);
return !((k instanceof cljs.core.Symbol));
}),source));
var merged_state = untangled.client.impl.application.sweep_merge.call(null,target,source_to_merge);
return cljs.core.reduce.call(null,((function (source_to_merge,merged_state){
return (function (acc,p__65151){
var vec__65152 = p__65151;
var k = cljs.core.nth.call(null,vec__65152,(0),null);
var v = cljs.core.nth.call(null,vec__65152,(1),null);
if(cljs.core.truth_((function (){var and__27268__auto__ = mutation_merge;
if(cljs.core.truth_(and__27268__auto__)){
return (k instanceof cljs.core.Symbol);
} else {
return and__27268__auto__;
}
})())){
var temp__6751__auto__ = mutation_merge.call(null,acc,k,cljs.core.dissoc.call(null,v,new cljs.core.Keyword(null,"tempids","tempids",1767509089)));
if(cljs.core.truth_(temp__6751__auto__)){
var updated_state = temp__6751__auto__;
return updated_state;
} else {
untangled.client.logging.info.call(null,"Return value handler for",k,"returned nil. Ignored.");

return acc;
}
} else {
return acc;
}
});})(source_to_merge,merged_state))
,merged_state,source);
});
/**
 * The reconciler's send method calls UntangledApplication/server-send, which itself requires a reconciler with a
 *   send method already defined. This creates a catch-22 / circular dependency on the reconciler and :send field within
 *   the reconciler.
 * 
 *   To resolve the issue, we def an atom pointing to the reconciler that the send method will deref each time it is
 *   called. This allows us to define the reconciler with a send method that, at the time of initialization, has an app
 *   that points to a nil reconciler. By the end of this function, the app's reconciler reference has been properly set.
 */
untangled.client.impl.application.generate_reconciler = (function untangled$client$impl$application$generate_reconciler(p__65155,initial_state,parser,p__65156){
var map__65161 = p__65155;
var map__65161__$1 = ((((!((map__65161 == null)))?((((map__65161.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65161.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65161):map__65161);
var app = map__65161__$1;
var queue = cljs.core.get.call(null,map__65161__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var mutation_merge = cljs.core.get.call(null,map__65161__$1,new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322));
var map__65162 = p__65156;
var map__65162__$1 = ((((!((map__65162 == null)))?((((map__65162.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65162.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__65162):map__65162);
var pathopt = cljs.core.get.call(null,map__65162__$1,new cljs.core.Keyword(null,"pathopt","pathopt",-61073149),true);
var migrate = cljs.core.get.call(null,map__65162__$1,new cljs.core.Keyword(null,"migrate","migrate",-207110743),null);
var shared = cljs.core.get.call(null,map__65162__$1,new cljs.core.Keyword(null,"shared","shared",-384145993),null);
var rec_atom = cljs.core.atom.call(null,null);
var state_migrate = (function (){var or__27280__auto__ = migrate;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return untangled.client.impl.om_plumbing.resolve_tempids;
}
})();
var tempid_migrate = ((function (rec_atom,state_migrate,map__65161,map__65161__$1,app,queue,mutation_merge,map__65162,map__65162__$1,pathopt,migrate,shared){
return (function (pure,_,tempids,___$1){
untangled.client.impl.om_plumbing.rewrite_tempids_in_request_queue.call(null,queue,tempids);

return state_migrate.call(null,pure,tempids);
});})(rec_atom,state_migrate,map__65161,map__65161__$1,app,queue,mutation_merge,map__65162,map__65162__$1,pathopt,migrate,shared))
;
var initial_state_with_locale = ((cljs.core._EQ_.call(null,cljs.core.Atom,cljs.core.type.call(null,initial_state)))?(function (){
cljs.core.swap_BANG_.call(null,initial_state,cljs.core.assoc,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),"en-US");

return initial_state;
})()
:cljs.core.assoc.call(null,initial_state,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),"en-US"));
var config = new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"state","state",-1988618099),initial_state_with_locale,new cljs.core.Keyword(null,"send","send",-652151114),((function (rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__65161,map__65161__$1,app,queue,mutation_merge,map__65162,map__65162__$1,pathopt,migrate,shared){
return (function (tx,cb){
return untangled.client.impl.application.server_send.call(null,cljs.core.assoc.call(null,app,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),cljs.core.deref.call(null,rec_atom)),tx,cb);
});})(rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__65161,map__65161__$1,app,queue,mutation_merge,map__65162,map__65162__$1,pathopt,migrate,shared))
,new cljs.core.Keyword(null,"migrate","migrate",-207110743),(function (){var or__27280__auto__ = migrate;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return tempid_migrate;
}
})(),new cljs.core.Keyword(null,"normalize","normalize",-1904390051),true,new cljs.core.Keyword(null,"pathopt","pathopt",-61073149),pathopt,new cljs.core.Keyword(null,"merge-tree","merge-tree",-127861161),((function (rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__65161,map__65161__$1,app,queue,mutation_merge,map__65162,map__65162__$1,pathopt,migrate,shared){
return (function (target,source){
return untangled.client.impl.application.merge_handler.call(null,mutation_merge,target,source);
});})(rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__65161,map__65161__$1,app,queue,mutation_merge,map__65162,map__65162__$1,pathopt,migrate,shared))
,new cljs.core.Keyword(null,"parser","parser",-1543495310),parser,new cljs.core.Keyword(null,"shared","shared",-384145993),shared], null);
var rec = om.next.reconciler.call(null,config);
cljs.core.reset_BANG_.call(null,rec_atom,rec);

return rec;
});
untangled.client.impl.application.initialize_global_error_callback = (function untangled$client$impl$application$initialize_global_error_callback(app){
var cb_atom = cljs.core.get_in.call(null,app,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networking","networking",586110628),new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631)], null));
if(cljs.core._EQ_.call(null,cljs.core.Atom,cljs.core.type.call(null,cb_atom))){
return cljs.core.swap_BANG_.call(null,cb_atom,((function (cb_atom){
return (function (p1__65165_SHARP_){
if(cljs.core.fn_QMARK_.call(null,p1__65165_SHARP_)){
return cljs.core.partial.call(null,p1__65165_SHARP_,om.next.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)));
} else {
throw cljs.core.ex_info.call(null,"Networking error callback must be a function.",cljs.core.PersistentArrayMap.EMPTY);
}
});})(cb_atom))
);
} else {
return null;
}
});

//# sourceMappingURL=application.js.map?rel=1479956913263