// Compiled by ClojureScript 1.9.293 {}
goog.provide('untangled.client.impl.protocol_support');
goog.require('cljs.core');
goog.require('om.dom');
goog.require('untangled_spec.core');
goog.require('cljs.test');
goog.require('untangled.client.core');
goog.require('clojure.walk');
goog.require('om.next');
/**
 * Is the given keyword a seed data tempid keyword (namespaced to `tempid`)?
 */
untangled.client.impl.protocol_support.tempid_QMARK_ = (function untangled$client$impl$protocol_support$tempid_QMARK_(kw){
return ((kw instanceof cljs.core.Keyword)) && (cljs.core._EQ_.call(null,"om.tempid",cljs.core.namespace.call(null,kw)));
});
/**
 * Rewrite tempid keywords in the given state using the tid->rid map. Leaves the keyword alone if the map
 * does not contain an entry for it.
 */
untangled.client.impl.protocol_support.rewrite_tempids = (function untangled$client$impl$protocol_support$rewrite_tempids(var_args){
var args__28503__auto__ = [];
var len__28496__auto___65496 = arguments.length;
var i__28497__auto___65497 = (0);
while(true){
if((i__28497__auto___65497 < len__28496__auto___65496)){
args__28503__auto__.push((arguments[i__28497__auto___65497]));

var G__65498 = (i__28497__auto___65497 + (1));
i__28497__auto___65497 = G__65498;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((2) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((2)),(0),null)):null);
return untangled.client.impl.protocol_support.rewrite_tempids.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__28504__auto__);
});

untangled.client.impl.protocol_support.rewrite_tempids.cljs$core$IFn$_invoke$arity$variadic = (function (state,tid__GT_rid,p__65492){
var vec__65493 = p__65492;
var pred = cljs.core.nth.call(null,vec__65493,(0),null);
return clojure.walk.prewalk.call(null,((function (vec__65493,pred){
return (function (p1__65488_SHARP_){
if(cljs.core.truth_((function (){var or__27280__auto__ = pred;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return untangled.client.impl.protocol_support.tempid_QMARK_;
}
})().call(null,p1__65488_SHARP_))){
return cljs.core.get.call(null,tid__GT_rid,p1__65488_SHARP_,p1__65488_SHARP_);
} else {
return p1__65488_SHARP_;
}
});})(vec__65493,pred))
,state);
});

untangled.client.impl.protocol_support.rewrite_tempids.cljs$lang$maxFixedArity = (2);

untangled.client.impl.protocol_support.rewrite_tempids.cljs$lang$applyTo = (function (seq65489){
var G__65490 = cljs.core.first.call(null,seq65489);
var seq65489__$1 = cljs.core.next.call(null,seq65489);
var G__65491 = cljs.core.first.call(null,seq65489__$1);
var seq65489__$2 = cljs.core.next.call(null,seq65489__$1);
return untangled.client.impl.protocol_support.rewrite_tempids.cljs$core$IFn$_invoke$arity$variadic(G__65490,G__65491,seq65489__$2);
});

/**
 * Checks that `new-state` includes the `delta`, where `delta` is a map keyed by data path (as in get-in). The
 * values of `delta` are literal values to verify at that path (nil means the path should be missing).
 */
untangled.client.impl.protocol_support.check_delta = (function untangled$client$impl$protocol_support$check_delta(new_state,delta){
if(cljs.core.empty_QMARK_.call(null,delta)){
throw cljs.core.ex_info.call(null,"Cannot have empty :merge-delta",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"new-state","new-state",-490349212),new_state], null));
} else {
var seq__65513 = cljs.core.seq.call(null,delta);
var chunk__65514 = null;
var count__65515 = (0);
var i__65516 = (0);
while(true){
if((i__65516 < count__65515)){
var vec__65517 = cljs.core._nth.call(null,chunk__65514,i__65516);
var key_path = cljs.core.nth.call(null,vec__65517,(0),null);
var value = cljs.core.nth.call(null,vec__65517,(1),null);
var behavior_string_65527 = new cljs.core.Keyword("cps","behavior","cps/behavior",1202490882).cljs$core$IFn$_invoke$arity$1(value);
var value_65528__$1 = (function (){var or__27280__auto__ = new cljs.core.Keyword("cps","value","cps/value",307453219).cljs$core$IFn$_invoke$arity$1(value);
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return value;
}
})();
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,behavior_string_65527);

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_65527], null));

if((value_65528__$1 instanceof RegExp)){
try{var values__32343__auto___65529 = (function (){var x__28209__auto__ = value_65528__$1;
return cljs.core._conj.call(null,(function (){var x__28209__auto____$1 = cljs.core.get_in.call(null,new_state,key_path);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28209__auto____$1);
})(),x__28209__auto__);
})();
var result__32344__auto___65530 = cljs.core.apply.call(null,cljs.core.re_matches,values__32343__auto___65529);
if(cljs.core.truth_(result__32344__auto___65530)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core.re_matches,values__32343__auto___65529),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core._conj.call(null,(function (){var x__28209__auto__ = cljs.core.cons.call(null,new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),values__32343__auto___65529);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28209__auto__);
})(),new cljs.core.Symbol(null,"not","not",1044554643,null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e65520){var t__32381__auto___65531 = e65520;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__32381__auto___65531,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}} else {
try{cljs.test.do_report.call(null,(function (){var act__38292__auto__ = cljs.core.get_in.call(null,new_state,key_path);
var exp__38293__auto__ = value_65528__$1;
var result__38294__auto__ = cljs.core._EQ_.call(null,exp__38293__auto__,act__38292__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__38294__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__38293__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__38292__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),null], null);
})());
}catch (e65521){var t__32381__auto___65532 = e65521;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__32381__auto___65532,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_65527], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
var G__65533 = seq__65513;
var G__65534 = chunk__65514;
var G__65535 = count__65515;
var G__65536 = (i__65516 + (1));
seq__65513 = G__65533;
chunk__65514 = G__65534;
count__65515 = G__65535;
i__65516 = G__65536;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__65513);
if(temp__6753__auto__){
var seq__65513__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__65513__$1)){
var c__28186__auto__ = cljs.core.chunk_first.call(null,seq__65513__$1);
var G__65537 = cljs.core.chunk_rest.call(null,seq__65513__$1);
var G__65538 = c__28186__auto__;
var G__65539 = cljs.core.count.call(null,c__28186__auto__);
var G__65540 = (0);
seq__65513 = G__65537;
chunk__65514 = G__65538;
count__65515 = G__65539;
i__65516 = G__65540;
continue;
} else {
var vec__65522 = cljs.core.first.call(null,seq__65513__$1);
var key_path = cljs.core.nth.call(null,vec__65522,(0),null);
var value = cljs.core.nth.call(null,vec__65522,(1),null);
var behavior_string_65541 = new cljs.core.Keyword("cps","behavior","cps/behavior",1202490882).cljs$core$IFn$_invoke$arity$1(value);
var value_65542__$1 = (function (){var or__27280__auto__ = new cljs.core.Keyword("cps","value","cps/value",307453219).cljs$core$IFn$_invoke$arity$1(value);
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return value;
}
})();
cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.conj,behavior_string_65541);

try{cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-behavior","begin-behavior",531955294),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_65541], null));

if((value_65542__$1 instanceof RegExp)){
try{var values__32343__auto___65543 = (function (){var x__28209__auto__ = value_65542__$1;
return cljs.core._conj.call(null,(function (){var x__28209__auto____$1 = cljs.core.get_in.call(null,new_state,key_path);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28209__auto____$1);
})(),x__28209__auto__);
})();
var result__32344__auto___65544 = cljs.core.apply.call(null,cljs.core.re_matches,values__32343__auto___65543);
if(cljs.core.truth_(result__32344__auto___65544)){
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"pass","pass",1574159993),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core.cons.call(null,cljs.core.re_matches,values__32343__auto___65543),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
} else {
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"fail","fail",1706214930),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),cljs.core._conj.call(null,(function (){var x__28209__auto__ = cljs.core.cons.call(null,new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),values__32343__auto___65543);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__28209__auto__);
})(),new cljs.core.Symbol(null,"not","not",1044554643,null)),new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}

}catch (e65525){var t__32381__auto___65545 = e65525;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__32381__auto___65545,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}} else {
try{cljs.test.do_report.call(null,(function (){var act__38292__auto__ = cljs.core.get_in.call(null,new_state,key_path);
var exp__38293__auto__ = value_65542__$1;
var result__38294__auto__ = cljs.core._EQ_.call(null,exp__38293__auto__,act__38292__auto__);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),((result__38294__auto__)?new cljs.core.Keyword(null,"pass","pass",1574159993):new cljs.core.Keyword(null,"fail","fail",1706214930)),new cljs.core.Keyword(null,"expected","expected",1583670997),exp__38293__auto__,new cljs.core.Keyword(null,"actual","actual",107306363),act__38292__auto__,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052),new cljs.core.Symbol(null,"eq","eq",1021992460,null),new cljs.core.Keyword(null,"message","message",-406056002),null], null);
})());
}catch (e65526){var t__32381__auto___65546 = e65526;
cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"expected","expected",1583670997),cljs.core.list(new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"value","value",1946509744,null),cljs.core.list(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.Symbol(null,"new-state","new-state",1150182315,null),new cljs.core.Symbol(null,"key-path","key-path",-1775962461,null))),new cljs.core.Keyword(null,"actual","actual",107306363),t__32381__auto___65546,new cljs.core.Keyword(null,"message","message",-406056002),null], null));
}}

cljs.test.do_report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-behavior","end-behavior",727768360),new cljs.core.Keyword(null,"string","string",-1989541586),behavior_string_65541], null));
}finally {cljs.test.update_current_env_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"testing-contexts","testing-contexts",-1485646523)], null),cljs.core.rest);
}
var G__65547 = cljs.core.next.call(null,seq__65513__$1);
var G__65548 = null;
var G__65549 = (0);
var G__65550 = (0);
seq__65513 = G__65547;
chunk__65514 = G__65548;
count__65515 = G__65549;
i__65516 = G__65550;
continue;
}
} else {
return null;
}
}
break;
}
}
});
untangled.client.impl.protocol_support.with_behavior = (function untangled$client$impl$protocol_support$with_behavior(behavior_string,value){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("cps","value","cps/value",307453219),value,new cljs.core.Keyword("cps","behavior","cps/behavior",1202490882),behavior_string], null);
});
untangled.client.impl.protocol_support.allocate_tempids = (function untangled$client$impl$protocol_support$allocate_tempids(tx){
var allocated_ids = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
clojure.walk.prewalk.call(null,((function (allocated_ids){
return (function (v){
if(cljs.core.truth_(untangled.client.impl.protocol_support.tempid_QMARK_.call(null,v))){
cljs.core.swap_BANG_.call(null,allocated_ids,cljs.core.conj,v);
} else {
}

return v;
});})(allocated_ids))
,tx);

return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (allocated_ids){
return (function (p1__65551_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__65551_SHARP_,om.next.tempid.call(null)],null));
});})(allocated_ids))
,cljs.core.deref.call(null,allocated_ids)));
});
/**
 * @constructor
 */
untangled.client.impl.protocol_support.Root = (function untangled$client$impl$protocol_support$Root(){
var this__35788__auto__ = this;
React.Component.apply(this__35788__auto__,arguments);

if(!((this__35788__auto__.initLocalState == null))){
this__35788__auto__.state = this__35788__auto__.initLocalState();
} else {
this__35788__auto__.state = {};
}

return this__35788__auto__;
});

untangled.client.impl.protocol_support.Root.prototype = goog.object.clone(React.Component.prototype);

var x65556_65566 = untangled.client.impl.protocol_support.Root.prototype;
x65556_65566.componentWillUpdate = ((function (x65556_65566){
return (function (next_props__35643__auto__,next_state__35644__auto__){
var this__35642__auto__ = this;
if(((!((this__35642__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__35642__auto__.om$next$Ident$)))?true:false):false)){
var ident__35646__auto___65567 = om.next.ident.call(null,this__35642__auto__,om.next.props.call(null,this__35642__auto__));
var next_ident__35647__auto___65568 = om.next.ident.call(null,this__35642__auto__,om.next._next_props.call(null,next_props__35643__auto__,this__35642__auto__));
if(cljs.core.not_EQ_.call(null,ident__35646__auto___65567,next_ident__35647__auto___65568)){
var idxr__35648__auto___65569 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35642__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__35648__auto___65569 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__35648__auto___65569),((function (idxr__35648__auto___65569,ident__35646__auto___65567,next_ident__35647__auto___65568,this__35642__auto__,x65556_65566){
return (function (indexes__35649__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__35649__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__35646__auto___65567], null),cljs.core.disj,this__35642__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__35647__auto___65568], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__35642__auto__);
});})(idxr__35648__auto___65569,ident__35646__auto___65567,next_ident__35647__auto___65568,this__35642__auto__,x65556_65566))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__35642__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__35642__auto__);
});})(x65556_65566))
;

x65556_65566.shouldComponentUpdate = ((function (x65556_65566){
return (function (next_props__35643__auto__,next_state__35644__auto__){
var this__35642__auto__ = this;
var next_children__35645__auto__ = next_props__35643__auto__.children;
var next_props__35643__auto____$1 = goog.object.get(next_props__35643__auto__,"omcljs$value");
var next_props__35643__auto____$2 = (function (){var G__65558 = next_props__35643__auto____$1;
if((next_props__35643__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__65558);
} else {
return G__65558;
}
})();
var or__27280__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__35642__auto__),next_props__35643__auto____$2);
if(or__27280__auto__){
return or__27280__auto__;
} else {
var or__27280__auto____$1 = (function (){var and__27268__auto__ = this__35642__auto__.state;
if(cljs.core.truth_(and__27268__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__35642__auto__.state,"omcljs$state"),goog.object.get(next_state__35644__auto__,"omcljs$state"));
} else {
return and__27268__auto__;
}
})();
if(cljs.core.truth_(or__27280__auto____$1)){
return or__27280__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__35642__auto__.props.children,next_children__35645__auto__);
}
}
});})(x65556_65566))
;

x65556_65566.componentWillUnmount = ((function (x65556_65566){
return (function (){
var this__35642__auto__ = this;
var r__35653__auto__ = om.next.get_reconciler.call(null,this__35642__auto__);
var cfg__35654__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__35653__auto__);
var st__35655__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__35654__auto__);
var indexer__35652__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__35654__auto__);
if(cljs.core.truth_((function (){var and__27268__auto__ = !((st__35655__auto__ == null));
if(and__27268__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__35655__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__35642__auto__], null));
} else {
return and__27268__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__35655__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__35642__auto__);
} else {
}

if((indexer__35652__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__35652__auto__,this__35642__auto__);
}
});})(x65556_65566))
;

x65556_65566.componentDidUpdate = ((function (x65556_65566){
return (function (prev_props__35650__auto__,prev_state__35651__auto__){
var this__35642__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__35642__auto__);
});})(x65556_65566))
;

x65556_65566.isMounted = ((function (x65556_65566){
return (function (){
var this__35642__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__35642__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x65556_65566))
;

x65556_65566.componentWillMount = ((function (x65556_65566){
return (function (){
var this__35642__auto__ = this;
var indexer__35652__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__35642__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__35652__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__35652__auto__,this__35642__auto__);
}
});})(x65556_65566))
;

x65556_65566.render = ((function (x65556_65566){
return (function (){
var this__35641__auto__ = this;
var this$ = this__35641__auto__;
var _STAR_reconciler_STAR_65559 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_65560 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_65561 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_65562 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_65563 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__35641__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__35641__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__35641__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__35641__auto__);

om.next._STAR_parent_STAR_ = this__35641__auto__;

try{return om.dom.div.call(null,null,"if you see this something is wrong");
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_65563;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_65562;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_65561;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_65560;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_65559;
}});})(x65556_65566))
;


untangled.client.impl.protocol_support.Root.prototype.constructor = untangled.client.impl.protocol_support.Root;

untangled.client.impl.protocol_support.Root.prototype.constructor.displayName = "untangled.client.impl.protocol-support/Root";

untangled.client.impl.protocol_support.Root.prototype.om$isComponent = true;

var x65564_65570 = untangled.client.impl.protocol_support.Root;
/** @nocollapse */
x65564_65570.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;

/** @nocollapse */
x65564_65570.om$next$IQuery$query$arity$1 = ((function (x65564_65570){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fake","fake",-904846741)], null);
});})(x65564_65570))
;


var x65565_65571 = untangled.client.impl.protocol_support.Root.prototype;

x65565_65571.om$next$IQuery$ = cljs.core.PROTOCOL_SENTINEL;


x65565_65571.om$next$IQuery$query$arity$1 = ((function (x65565_65571){
return (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fake","fake",-904846741)], null);
});})(x65565_65571))
;


untangled.client.impl.protocol_support.Root.cljs$lang$type = true;

untangled.client.impl.protocol_support.Root.cljs$lang$ctorStr = "untangled.client.impl.protocol-support/Root";

untangled.client.impl.protocol_support.Root.cljs$lang$ctorPrWriter = (function (this__35791__auto__,writer__35792__auto__,opt__35793__auto__){
return cljs.core._write.call(null,writer__35792__auto__,"untangled.client.impl.protocol-support/Root");
});
untangled.client.impl.protocol_support.init_testing = (function untangled$client$impl$protocol_support$init_testing(){
return untangled.client.core.mount.call(null,untangled.client.core.new_untangled_test_client.call(null),untangled.client.impl.protocol_support.Root,"invisible-specs");
});

//# sourceMappingURL=protocol_support.js.map?rel=1479956913625